/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bm.util.alert.Util;
import oracle.bm.util.log.CWLog;
import oracle.bm.util.ui.ObmCheckBoxMenuItem;
import oracle.bm.util.ui.ObmMenu;
import oracle.bm.util.ui.ObmMenuItem;

public class DebugMenu {
    private static ObmMenu m_debugOptions = null;
    private static JMenuItem[] m_debugMenuItems = null;
    private static JMenuItem m_mi_traceOFF = null;
    private static JMenuItem m_mi_traceALPHA = null;
    private static JMenuItem m_mi_traceBETA = null;
    private static JMenuItem m_mi_traceGAMMA = null;
    private static JMenuItem m_mi_traceDELTA = null;
    private static JMenuItem m_mi_traceEPSILON = null;
    private static JMenuItem m_mi_initStdOut = null;
    private static JMenuItem m_mi_initStdErr = null;
    private static JMenuItem m_mi_initFile = null;
    private static JMenuItem m_mi_initConfig = null;

    public static ObmMenu getDebugOptionsMenu(final Frame parent) {
        int level;
        if (m_debugOptions == null) {
            m_debugOptions = new ObmMenu("DebugOptions");
            m_debugOptions.addSeparator();
            m_mi_traceOFF = new ObmCheckBoxMenuItem("TraceOff");
            m_mi_traceALPHA = new ObmCheckBoxMenuItem("Trace1");
            m_mi_traceBETA = new ObmCheckBoxMenuItem("Trace2");
            m_mi_traceGAMMA = new ObmCheckBoxMenuItem("Trace3");
            m_mi_traceDELTA = new ObmCheckBoxMenuItem("Trace4");
            m_mi_traceEPSILON = new ObmCheckBoxMenuItem("Trace5");
            m_debugOptions.add(m_mi_traceOFF);
            m_debugOptions.add(m_mi_traceALPHA);
            m_debugOptions.add(m_mi_traceBETA);
            m_debugOptions.add(m_mi_traceGAMMA);
            m_debugOptions.add(m_mi_traceDELTA);
            m_debugOptions.add(m_mi_traceEPSILON);
            m_debugOptions.addSeparator();
            m_mi_initStdOut = new ObmMenuItem("InitStdOut");
            m_mi_initStdErr = new ObmMenuItem("InitStdErr");
            m_mi_initFile = new ObmMenuItem("InitFile");
            m_mi_initConfig = new ObmMenuItem("InitConfig");
            m_debugOptions.add(m_mi_initStdOut);
            m_debugOptions.add(m_mi_initStdErr);
            m_debugOptions.add(m_mi_initFile);
            m_debugOptions.add(m_mi_initConfig);
            m_mi_initStdOut.setEnabled(false);
            m_mi_initStdErr.setEnabled(false);
            m_mi_initFile.setEnabled(false);
            ActionListener levelListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == m_mi_traceOFF) {
                        CWLog.setTraceLevel(0);
                    } else if (e.getSource() == m_mi_traceALPHA) {
                        CWLog.setTraceLevel(1);
                    } else if (e.getSource() == m_mi_traceBETA) {
                        CWLog.setTraceLevel(2);
                    } else if (e.getSource() == m_mi_traceGAMMA) {
                        CWLog.setTraceLevel(3);
                    } else if (e.getSource() == m_mi_traceDELTA) {
                        CWLog.setTraceLevel(4);
                    } else if (e.getSource() == m_mi_traceEPSILON) {
                        CWLog.setTraceLevel(5);
                    }
                }
            };
            m_mi_traceOFF.addActionListener(levelListener);
            m_mi_traceALPHA.addActionListener(levelListener);
            m_mi_traceBETA.addActionListener(levelListener);
            m_mi_traceGAMMA.addActionListener(levelListener);
            m_mi_traceDELTA.addActionListener(levelListener);
            m_mi_traceEPSILON.addActionListener(levelListener);
            m_mi_initStdOut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int lev = CWLog.getTraceLevel();
                    CWLog.initialize(null, System.out);
                    CWLog.setTraceLevel(lev);
                }
            });
            m_mi_initStdErr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int lev = CWLog.getTraceLevel();
                    CWLog.initialize(null, System.err);
                    CWLog.setTraceLevel(lev);
                }
            });
            m_mi_initFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FileDialog saveDiag = new FileDialog(parent, "", 1);
                        saveDiag.setFile("log.txt");
                        saveDiag.pack();
                        saveDiag.setVisible(true);
                        File file = new File(saveDiag.getDirectory(), saveDiag.getFile());
                        int lev = CWLog.getTraceLevel();
                        CWLog.initialize(null, new PrintStream(new FileOutputStream(file)));
                        CWLog.setTraceLevel(lev);
                    }
                    catch (Exception ex) {
                        Util.returnException(ex).showAlert((Frame)SwingUtilities.windowForComponent(m_mi_initFile));
                    }
                }
            });
            m_mi_initConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FileDialog saveDiag = new FileDialog(parent, "", 0);
                        saveDiag.setFile("CWLog.properties");
                        saveDiag.pack();
                        saveDiag.setVisible(true);
                        File file = new File(saveDiag.getDirectory(), saveDiag.getFile());
                        Properties prop = new Properties();
                        prop.load(new FileInputStream(file));
                        int lev = CWLog.getTraceLevel();
                        CWLog.initialize(prop, System.out);
                        CWLog.setTraceLevel(lev);
                    }
                    catch (Exception ex) {
                        Util.returnException(ex).showAlert((Frame)SwingUtilities.windowForComponent(m_mi_initFile));
                    }
                }
            });
        }
        m_mi_traceOFF.setSelected((level = CWLog.getTraceLevel()) == 0);
        m_mi_traceALPHA.setSelected(level == 1);
        m_mi_traceBETA.setSelected(level == 2);
        m_mi_traceGAMMA.setSelected(level == 3);
        m_mi_traceDELTA.setSelected(level == 4);
        m_mi_traceEPSILON.setSelected(level == 5);
        return m_debugOptions;
    }
}

