/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.javatools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultivaluedMap<K, V> {
    private final Map<K, Collection<V>> m_map;
    private final Class<? extends Collection> m_colClass;
    private int m_size;

    public MultivaluedMap() {
        this(HashMap.class, ArrayList.class);
    }

    public MultivaluedMap(Class<? extends Map> mapClass, Class<? extends Collection> colClass) {
        if (mapClass == null || colClass == null) {
            throw new IllegalArgumentException("Missing class");
        }
        try {
            this.m_map = mapClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instantiate map", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate map", e);
        }
        this.m_colClass = colClass;
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public int size() {
        return this.m_size;
    }

    public boolean containsKey(K key) {
        return this.m_map.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (Collection<V> cv : this.m_map.values()) {
            if (!cv.contains(value)) continue;
            return true;
        }
        return false;
    }

    public Collection<Map.Entry<K, V>> entries() {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(this.size());
        for (Map.Entry<K, Collection<V>> e : this.m_map.entrySet()) {
            for (V v : e.getValue()) {
                list.add(new MMapEntry(e.getKey(), v));
            }
        }
        return list;
    }

    public Collection<V> get(K key) {
        Collection<V> c = this.m_map.get(key);
        if (c != null) {
            return Collections.unmodifiableCollection(c);
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof MultivaluedMap && ((Object)this.m_map).equals(((MultivaluedMap)o).m_map);
    }

    public int hashCode() {
        return ((Object)this.m_map).hashCode();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.m_map.keySet());
    }

    public boolean put(K key, V value) {
        Collection<V> c = this.m_map.get(key);
        if (c == null) {
            c = this.createCollection();
            this.m_map.put(key, c);
        }
        return this.addValue(c, value);
    }

    private Collection<V> createCollection() {
        try {
            return this.m_colClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot create collection", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot create collection", e);
        }
    }

    private boolean addValue(Collection<V> c, V value) {
        boolean result = c.add(value);
        if (result) {
            ++this.m_size;
        }
        return result;
    }

    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(MultivaluedMap<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entries()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.m_map.clear();
        this.m_size = 0;
    }

    public Collection<V> remove(K key) {
        Collection<V> c = this.m_map.remove(key);
        if (c != null) {
            this.m_size -= c.size();
        }
        return c;
    }

    public boolean remove(K key, V value) {
        Collection<V> c = this.m_map.get(key);
        if (c != null) {
            boolean result = c.remove(value);
            if (result) {
                --this.m_size;
                if (c.size() == 0) {
                    this.m_map.remove(key);
                }
            }
            return result;
        }
        return false;
    }

    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.size());
        for (Collection<V> value : this.m_map.values()) {
            values.addAll(value);
        }
        return Collections.unmodifiableList(values);
    }

    public int valueCount(K key) {
        Collection<V> c = this.m_map.get(key);
        return c == null ? 0 : c.size();
    }

    private class MMapEntry
    implements Map.Entry<K, V> {
        private final K m_key;
        private V m_value;

        public MMapEntry(K key, V value) {
            this.m_key = key;
            this.m_value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)o;
                return this.areEqual(this.getKey(), other.getKey()) && this.areEqual(this.getValue(), other.getValue());
            }
            return false;
        }

        @Override
        public K getKey() {
            return this.m_key;
        }

        @Override
        public V getValue() {
            return this.m_value;
        }

        @Override
        public int hashCode() {
            return this.m_key.hashCode();
        }

        @Override
        public V setValue(V value) {
            MultivaluedMap.this.remove(this.m_key, this.m_value);
            MultivaluedMap.this.put(this.m_key, value);
            Object oldValue = this.m_value;
            this.m_value = value;
            return oldValue;
        }

        private boolean areEqual(Object o1, Object o2) {
            return o1 == null && o2 == null || o1 != null && o1.equals(o2);
        }
    }
}

