/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.javatools.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiCollection<T>
extends AbstractCollection<T> {
    private Collection<Collection<T>> m_collections;

    public MultiCollection(Collection<Collection<T>> collections) {
        this.m_collections = collections;
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<T> c : this.m_collections) {
            size += c.size();
        }
        return size;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<T> c : this.m_collections) {
            if (!c.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        class MultiIterator
        implements Iterator<T> {
            private Iterator<Collection<T>> m_colIter;
            private Iterator<T> m_elements;

            MultiIterator() {
                this.m_colIter = MultiCollection.this.m_collections.iterator();
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.m_colIter != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object t = this.m_elements.next();
                    return t;
                }
                finally {
                    this.findNext();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void findNext() {
                while (this.m_elements == null || !this.m_elements.hasNext()) {
                    if (!this.m_colIter.hasNext()) {
                        this.m_colIter = null;
                        return;
                    }
                    this.m_elements = this.m_colIter.next().iterator();
                }
            }
        }
        return new MultiIterator();
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

