/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.javatools.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HashTransferable
implements Transferable {
    private final Map<DataFlavor, Object> _data = new HashMap<DataFlavor, Object>();

    public void addData(DataFlavor flavor, Object data) {
        if (this.isDataFlavorSupported(flavor)) {
            throw new IllegalArgumentException(flavor.getHumanPresentableName() + " is already present");
        }
        this._data.put(flavor, data);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        Set<DataFlavor> flavors = this._data.keySet();
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this._data.containsKey(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this._data.get(flavor);
    }
}

