/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.dialog.propertylayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import oracle.bm.dialog.propertylayout.PropertyPageLayoutConstraints;

public class PropertyPageLayout
implements LayoutManager2 {
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 500;
    protected int m_maxHeight;
    protected int m_maxWidth;
    protected Hashtable m_constraints;
    private final int BORDER_SIZE = 10;

    public PropertyPageLayout(int maxWidth, int maxHeight) {
        this.m_maxWidth = maxWidth;
        this.m_maxHeight = maxHeight;
        this.m_constraints = new Hashtable();
    }

    public PropertyPageLayout() {
        this(500, 500);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component c, Object constraints) {
        if (constraints != null) {
            this.m_constraints.put(c, constraints);
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        int curX = 0;
        int curY = 0;
        int biggestW = 0;
        Dimension parentSize = parent.getSize();
        int maxRowWidth = parentSize.width - 10;
        Component[] comps = parent.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            PropertyPageLayoutConstraints c = (PropertyPageLayoutConstraints)this.m_constraints.get(comps[i2]);
            if (c != null && c.isOnOwnColumn() && curY > 0) {
                curX += biggestW + 10;
                curY = 0;
                biggestW = 0;
            }
            comps[i2].setLocation(new Point(curX, curY));
            double weightX = 0.0;
            if (c != null) {
                weightX = c.getWeightX();
            }
            double weightY = 0.0;
            if (c != null) {
                weightY = c.getWeightY();
            }
            int curW = weightX > 0.0 ? (int)(weightX * (double)parentSize.width) : comps[i2].getPreferredSize().width;
            if (curX + (curW -= 10) > maxRowWidth) {
                curW = maxRowWidth - curX;
            }
            int curH = weightY > 0.0 ? (int)(weightY * (double)parentSize.height) : comps[i2].getPreferredSize().height;
            comps[i2].setSize(new Dimension(curW, curH));
            biggestW = Math.max(curW, biggestW);
            if (i2 >= comps.length - 1) continue;
            if (c != null && c.isKeptWithNextHorizontal()) {
                curX += biggestW + 10;
                curY = 0;
                biggestW = 0;
            } else if (c != null && c.isKeptWithNextVertical()) {
                this.m_maxHeight = Math.max(this.m_maxHeight, curY + curH);
                curY += curH;
            } else if (curH + curY >= this.m_maxHeight || c != null && c.isOnOwnColumn() || c != null && c.getWeightY() == 1.0) {
                curX += biggestW + 10;
                curY = 0;
                biggestW = 0;
            } else {
                curY += curH;
            }
            if (c == null || !c.isOnOwnRow()) continue;
            curX = 0;
            curY += curH;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int curX = 0;
        int curY = 0;
        int biggestW = 0;
        int totalW = 0;
        int columnH = 0;
        int totalH = 0;
        Component[] comps = parent.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            biggestW = Math.max(comps[i2].getPreferredSize().width, biggestW);
            columnH += comps[i2].getPreferredSize().height;
            if (i2 >= comps.length - 1 || comps[i2 + 1].getPreferredSize().height + (curY += comps[i2].getPreferredSize().height) <= this.m_maxHeight) continue;
            curX += biggestW + 10;
            curY = 0;
            totalW += biggestW;
            biggestW = 0;
            totalH = Math.max(columnH, totalH);
            columnH = 0;
        }
        totalH = Math.max(columnH, totalH);
        return new Dimension(totalW += biggestW, totalH);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public float getLayoutAlignmentX(Container c) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container c) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container c) {
    }

    @Override
    public Dimension maximumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    public static void main(String[] args) {
        JFrame test = new JFrame();
        Container c = test.getContentPane();
        PropertyPageLayoutConstraints one = new PropertyPageLayoutConstraints();
        PropertyPageLayoutConstraints two = new PropertyPageLayoutConstraints();
        PropertyPageLayoutConstraints three = new PropertyPageLayoutConstraints();
        one.setOnOwnColumn(true);
        one.setWeightY(1.0);
        one.setWeightX(0.5);
        two.setKeptWithNextVertical(true);
        two.setWeightY(0.5);
        two.setWeightX(0.5);
        three.setWeightY(0.5);
        three.setWeightX(0.5);
        c.setLayout(new PropertyPageLayout());
        JButton bone = new JButton("One");
        JButton btwo = new JButton("Two");
        JButton bthr = new JButton("Three");
        c.add((Component)bone, one);
        c.add((Component)btwo, two);
        c.add((Component)bthr, three);
        test.pack();
        test.setVisible(true);
    }
}

