/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.dialog.extension;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Vector;
import oracle.ide.Addin;

public class ExtensionPageLoader
implements Addin {
    protected static final String s_DEFAULT_PACKAGE = "oracle.bm.dialog.stereotype";
    protected static final String s_SEPARATOR = ".";
    protected static final String s_PAGE = "Page";
    protected static final String s_DEFAULT_PATH_SEPARATOR = File.separator;
    protected static final String s_PROPERTIES_FILE = "stereotypes.properties";
    private static Properties s_properties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final Properties getProperties() {
        if (s_properties != null) return s_properties;
        Class<ExtensionPageLoader> clazz = ExtensionPageLoader.class;
        synchronized (ExtensionPageLoader.class) {
            if (s_properties != null) return s_properties;
            s_properties = new Properties();
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_properties;
        }
    }

    static Object[] LoadExtensionPages(String elementType, String[] stereotypes) {
        return ExtensionPageLoader.LoadExtensionPages(elementType, stereotypes, null, null);
    }

    static Object[] LoadExtensionPages(String elementType, String[] stereotypes, Class[] sigConstruct, Object[] argConstruct) {
        return ExtensionPageLoader.LoadExtensionPages(s_DEFAULT_PACKAGE, elementType, stereotypes, sigConstruct, argConstruct);
    }

    static Object[] LoadExtensionPages(String basePackage, String elementType, String[] stereotypes, Class[] sigConstruct, Object[] argConstruct) {
        if (elementType == null || "".equals(elementType)) {
            return new Object[0];
        }
        elementType = elementType.toLowerCase();
        if (stereotypes == null) {
            return new Object[0];
        }
        Vector<Object> arrExtensions = new Vector<Object>();
        Properties properties = s_properties;
        for (int n = 0; n < stereotypes.length; ++n) {
            StringBuffer className = new StringBuffer();
            className.append(stereotypes[n].toLowerCase());
            className.append(s_SEPARATOR);
            className.append(elementType);
            className.append(s_SEPARATOR);
            className.append(s_PAGE);
            StringBuffer fullName = new StringBuffer(basePackage);
            fullName.append(className.toString());
            block1: for (int pass = 0; pass < (properties == null ? 1 : 2); ++pass) {
                int pageNo = 1;
                while (true) {
                    String name = null;
                    if (pass == 0) {
                        name = fullName.toString() + Integer.toString(pageNo);
                    } else if (pass == 1) {
                        name = className.toString() + Integer.toString(pageNo);
                        String temp = properties.getProperty(name, "");
                        if ("".equals(temp)) continue block1;
                        name = temp;
                    }
                    Object extension = ExtensionPageLoader.loadClassAndInstantiate(name, sigConstruct, argConstruct);
                    if (extension != null) {
                        arrExtensions.add(extension);
                    } else if (pass == 0) continue block1;
                    ++pageNo;
                }
            }
        }
        return arrExtensions.toArray();
    }

    public void initialize() {
        Properties props = ExtensionPageLoader.getProperties();
        try {
            StringBuffer file = new StringBuffer(System.getProperty("user.dir", s_SEPARATOR));
            file.append(System.getProperty("file.separator", s_DEFAULT_PATH_SEPARATOR));
            file.append(s_PROPERTIES_FILE);
            props.load(new BufferedInputStream(new FileInputStream(file.toString())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
    }

    protected static Object loadClassAndInstantiate(String name, Class[] sigConstruct, Object[] argConstruct) {
        try {
            Class<?> clazz = Class.forName(name);
            Object extension = null;
            if (sigConstruct == null) {
                extension = clazz.newInstance();
            } else if (argConstruct != null && sigConstruct.length == argConstruct.length) {
                try {
                    Constructor<?> constructor = clazz.getConstructor(sigConstruct);
                    if (constructor != null) {
                        extension = constructor.newInstance(argConstruct);
                    }
                }
                catch (NoSuchMethodException e) {
                    extension = clazz.newInstance();
                }
            }
            return extension;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

