/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.dialog;

import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.bm.dialog.transfer.Transfer;
import oracle.bm.util.ResourcePicker;
import oracle.bm.util.ui.HorizontalConstraints;

public abstract class ObmDialogPanel
extends JPanel
implements ResourcePicker.ResourceBase {
    public static final int s_DIALOG_CLEAN = 0;
    public static final int s_DIALOG_DIRTY = 1;
    public static final int s_STICKY_PAGE = 2;
    public static final int s_UN_STICKY_PAGE = 3;
    private URL m_helpContext;
    private String m_titleName = null;
    private ResourcePicker m_picker;
    private Icon m_icon = null;
    private boolean m_initialised = false;
    private Vector m_transferObjects = new Vector();
    private String m_Topic = null;

    public ObmDialogPanel(String title, ResourcePicker picker) {
        this.setName(title);
        this.m_picker = picker;
    }

    public ObmDialogPanel(String title, LayoutManager lm, ResourcePicker picker) {
        super(lm);
        this.setName(title);
        this.m_picker = picker;
    }

    public String getTitleName() {
        if (this.m_titleName == null) {
            this.m_titleName = this.getResourcePicker().getStringResource(this.getName(), "title");
            if (this.m_titleName == null) {
                this.m_titleName = this.getName();
            }
        }
        return this.m_titleName;
    }

    public ResourcePicker getResourcePicker() {
        return this.m_picker;
    }

    public Icon getImage() {
        return this.m_icon;
    }

    protected void setImage(Icon input) {
        this.m_icon = input;
    }

    public String getTopic() {
        return this.m_Topic;
    }

    public final void setTopic(String topic) {
        this.m_Topic = topic;
    }

    public void registerTransfer(Transfer trans) {
        this.m_transferObjects.addElement(trans);
    }

    public Component getHeader() {
        return null;
    }

    protected abstract void initPanel();

    public void copyUpPanel(Object input) {
        try {
            Enumeration enm = this.m_transferObjects.elements();
            while (enm.hasMoreElements()) {
                ((Transfer)enm.nextElement()).copyUp(input);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean contentsValid() {
        try {
            Enumeration enm = this.m_transferObjects.elements();
            while (enm.hasMoreElements()) {
                if (((Transfer)enm.nextElement()).validate()) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public Object copyDownPanel(Object input) {
        try {
            Enumeration enm = this.m_transferObjects.elements();
            while (enm.hasMoreElements()) {
                ((Transfer)enm.nextElement()).copyDown(input);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return input;
    }

    protected void addHorizontalGroup(JPanel p, Component[] components, int startx, int y) {
        for (int i2 = 0; i2 < components.length; ++i2) {
            p.add(components[i2], new HorizontalConstraints(startx + i2, y));
        }
    }

    protected void addVerticalGroup(JPanel p, Component[] components, int starty, int x) {
        for (int i2 = 0; i2 < components.length - 1; ++i2) {
            p.add(components[i2], new HorizontalConstraints(x, starty + i2));
        }
        p.add(components[components.length - 1], new HorizontalConstraints(x, starty + components.length - 1, 1, 1, 20));
    }

    protected void addComponentGrid(JPanel p, Component[][] components, int startx, int starty) {
        for (int i2 = 0; i2 < components.length; ++i2) {
            this.addHorizontalGroup(p, components[i2], startx, starty + i2);
        }
    }

    protected Component getInitialFocusComponent() {
        return null;
    }
}

