/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.browse;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bm.browse.ElementPicker;
import oracle.bm.util.ui.HintLabel;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.BundleLoader;

public class ModelBrowser {
    private static final ResourceBundle DEFAULT_RESOURCES = BundleLoader.getBundle((String)"oracle.bm.browse.res.ModelBrowserResources");
    private static final int TREE_HEIGHT = 200;
    private ElementPicker m_elementPicker;
    private JEWTDialog m_dialog;

    public ModelBrowser(Component parent, TreeModel[] models, boolean canMultiSelect, boolean canCreate, DataFlavor[] selectableFlavors, String nlsKey, String nlsBundle) {
        StringBuffer sb = new StringBuffer(nlsKey).append('.');
        int length = sb.length();
        String titleKey = sb.append("dialogtitle").toString();
        sb.setLength(length);
        String hintKey = sb.append("hinttext").toString();
        sb.setLength(length);
        String helpKey = sb.append("helptag").toString();
        int BUTTON_ALL = 7;
        ResourceBundle resources = null;
        if (nlsBundle != null && !nlsBundle.isEmpty()) {
            resources = BundleLoader.getBundle((String)nlsBundle);
        }
        if (resources == null) {
            resources = DEFAULT_RESOURCES;
        }
        String title = resources.getString(titleKey);
        while (parent != null) {
            if (parent instanceof Dialog) {
                this.m_dialog = new JEWTDialog((Dialog)parent, title, BUTTON_ALL);
                break;
            }
            if (parent instanceof Frame) {
                this.m_dialog = new JEWTDialog((Frame)parent, title, BUTTON_ALL);
                break;
            }
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        if (this.m_dialog == null) {
            throw new IllegalArgumentException("Component should have a dialog or frame as a parent");
        }
        this.m_dialog.setResizable(true);
        this.m_elementPicker = new ElementPicker(models, canMultiSelect, canCreate, selectableFlavors);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModelBrowser.this.m_dialog.setOKButtonEnabled(ModelBrowser.this.m_elementPicker.isItemSelected());
            }
        };
        this.m_elementPicker.addPropertyChangeListener(pcl);
        pcl.propertyChange(null);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        HintLabel hintLabel = new HintLabel(resources.getString(hintKey));
        hintLabel.setBorder(new EmptyBorder(0, 0, 15, 0));
        panel.add((Component)hintLabel, "North");
        JComponent comp = (JComponent)this.m_elementPicker.getComponent();
        comp.setPreferredSize(new Dimension(0, 225));
        panel.add((Component)comp, "Center");
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, resources.getString(helpKey));
        this.m_dialog.setContent((Component)panel);
        this.m_dialog.setPreferredSize(380, 360);
    }

    public ModelBrowser(Component parent, TreeModel[] models, boolean canMultiSelect, boolean canCreate, DataFlavor[] selectableFlavors, String nlsKey) {
        this(parent, models, canMultiSelect, canCreate, selectableFlavors, nlsKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean show() {
        try {
            boolean bl = this.m_dialog.runDialog();
            return bl;
        }
        finally {
            this.m_dialog.dispose();
        }
    }

    public Transferable[] getSelection() {
        return this.m_elementPicker.getSelectedItems();
    }

    public Object[] getSelection(DataFlavor flavor) {
        Transferable[] selection = this.getSelection();
        ArrayList<Object> items = new ArrayList<Object>(selection.length);
        for (int i2 = selection.length - 1; i2 >= 0; --i2) {
            try {
                Object item;
                if (!selection[i2].isDataFlavorSupported(flavor) || (item = selection[i2].getTransferData(flavor)) == null) continue;
                items.add(item);
                continue;
            }
            catch (IOException io) {
                io.printStackTrace();
                continue;
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
            }
        }
        return items.toArray((Object[])Array.newInstance(flavor.getRepresentationClass(), items.size()));
    }
}

