/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.status.AssistListener;
import oracle.ide.status.StalenessListener;
import oracle.ide.status.StatusManager;
import oracle.ide.status.editor.TransformFilter;
import oracle.ide.view.View;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.util.ArrayMap;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.StyleCategory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.audit.service.TransformAction;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.TransformerListener;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.util.Strings;

public class StatusEditorPlugin
implements EditorPlugin,
CEToolTipProvider,
CaretListener,
ChangeListener,
GutterColumnListener,
PopupMenuListener,
PropertyChangeListener,
TransformerListener,
StalenessListener,
AssistListener {
    public static final String CODE_ASSIST_COMMAND_NAME = "audit-assist";
    public static final String AUDIT_EDITOR_PLUGIN_KEY = StatusEditorPlugin.class.getName();
    public static final String ERRORS_CATEGORY_NAME = "audit-errors";
    public static final String WARNINGS_CATEGORY_NAME = "audit-warnings";
    private static int instanceCount = 0;
    private AuditPreferences preferences;
    private CodeEditor codeEditor;
    private String name;
    private TransformFilter transformFilter;
    private BasicEditorPane editor;
    private HighlightLayer highlights;
    private GutterColumn column;
    private Icon fixIcon = OracleIcons.getIcon((String)"fix.png");
    private Icon assistIcon = OracleIcons.getIcon((String)"assist.png");
    private Icon incompleteIcon = OracleIcons.getIcon((String)"incompletestatus.png");
    private ViolationList violations;
    private Collection<Issue> optionalAnalyses;
    private MarkList marks = new MarkList();
    private JPopupMenu popup;
    private static final Log LOG = new Log("editor", "editor-details");
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    private URL activeFile;
    private Project activeProject;
    private Workspace activeWorkspace;
    private static final Comparator<Violation> SEVERITY_COMPARATOR = new Comparator<Violation>(){

        @Override
        public int compare(Violation v1, Violation v2) {
            Severity s1 = v1.getRule().getSeverity();
            Severity s2 = v2.getRule().getSeverity();
            return s1.compareTo((Object)s2);
        }
    };
    private final Comparator<TransformAction> SUPPRESSED_COMPARATOR = new Comparator<TransformAction>(){

        @Override
        public int compare(TransformAction a1, TransformAction a2) {
            Transform t1 = a1.getTransform();
            int i1 = StatusEditorPlugin.this.transformFilter.isSuppressed(t1.id()) ? 1 : 0;
            Transform t2 = a2.getTransform();
            int i2 = StatusEditorPlugin.this.transformFilter.isSuppressed(t2.id()) ? 1 : 0;
            return i1 - i2;
        }
    };
    private GutterMark caretMark;
    private IdeAction lastSelectedAction;
    private long deselectionTime;
    private static Icon showIcon;
    private static Icon hideIcon;
    private static final Insets NO_INSETS;

    public StatusEditorPlugin(CodeEditor editor, AuditPreferences preferences, TransformFilter filter) {
        this.preferences = preferences;
        this.codeEditor = editor;
        this.name = this.codeEditor.getContext().getNode().getShortLabel() + "." + instanceCount++;
        this.transformFilter = filter;
    }

    public void install(BasicEditorPane editor) {
        LOG.trace("installing audit plugin for {0}", (Object)this);
        this.editor = editor;
        editor.putProperty(AUDIT_EDITOR_PLUGIN_KEY, (Object)this);
        this.preferences.addPropertyChangeListener((PropertyChangeListener)this);
        editor.getHighlightRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        assert (this.preferences.isAuditWhileEditing());
        this.highlights = this.editor.createHighlightLayer();
        LOG.trace("starting audit plugin for {0}", (Object)this);
        if (this.preferences.isShowCodeAssistanceInGutter()) {
            this.installGutter();
        }
        this.codeEditor.addCEToolTipProvider((CEToolTipProvider)this);
        Context context = this.codeEditor.getContext();
        this.addStalenessListener(context);
        if (editor.isShowing()) {
            this.addIssueListener(context);
        }
    }

    private void addStalenessListener(Context context) {
        if (context != null) {
            URL file = context.getNode().getURL();
            Project project = context.getProject();
            Workspace workspace = context.getWorkspace();
            if (file != null && workspace != null) {
                StatusManager.getStatusManager().addStalenessListener(file, project, workspace, this);
            }
        }
    }

    private void addIssueListener(Context context) {
        if (context != null) {
            URL file = context.getNode().getURL();
            Project project = context.getProject();
            Workspace workspace = context.getWorkspace();
            if (file != null && workspace != null) {
                IssueList issues = StatusManager.getStatusManager().addAssistListener(file, project, workspace, this, (View)this.codeEditor);
                this.activeFile = file;
                this.activeProject = project;
                this.activeWorkspace = workspace;
                this.setViolations(issues);
            }
        }
    }

    public void deinstall(BasicEditorPane editor) {
        LOG.trace("deinstalling audit plugin for {0}", (Object)this);
        LOG.trace("stopping audit plugin for {0}", (Object)this);
        Context context = this.codeEditor.getContext();
        this.removeIssueListener();
        this.removeStalenessListener(context);
        if (this.preferences.isShowCodeAssistanceInGutter()) {
            this.deinstallGutter();
        }
        this.codeEditor.removeCEToolTipProvider((CEToolTipProvider)this);
        editor.destroyHighlightLayer(this.highlights);
        this.clearOverviewMarks();
        this.clearOverviewAnalysis();
        editor.getHighlightRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.preferences.removePropertyChangeListener((PropertyChangeListener)this);
        editor.putProperty(AUDIT_EDITOR_PLUGIN_KEY, null);
        this.highlights = null;
        this.editor = null;
    }

    private void removeIssueListener() {
        if (this.activeFile != null && this.activeWorkspace != null) {
            StatusManager.getStatusManager().removeAssistListener(this.activeFile, this.activeProject, this.activeWorkspace, this);
        }
    }

    private void removeStalenessListener(Context context) {
        if (context != null) {
            URL file = context.getNode().getURL();
            Project project = context.getProject();
            Workspace workspace = context.getWorkspace();
            if (file != null && workspace != null) {
                StatusManager.getStatusManager().removeStalenessListener(file, project, workspace, this);
            }
        }
    }

    private void clearOverviewAnalysis() {
        FileOverviewMargin overview = FileOverviewMargin.getFileOverviewMargin((BasicEditorPane)this.editor);
        if (overview != null) {
            overview.clearAnalysis();
        }
    }

    private void startOverviewAnalysis(final Object id) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FileOverviewMargin overview = FileOverviewMargin.getFileOverviewMargin((BasicEditorPane)StatusEditorPlugin.this.editor);
                if (overview != null) {
                    overview.clearAnalysis();
                    overview.startAnalysis(id, BUNDLE.get("editor.start-analysis.label"));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void stopOverviewAnalysis(final Object id) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FileOverviewMargin overview = FileOverviewMargin.getFileOverviewMargin((BasicEditorPane)StatusEditorPlugin.this.editor);
                if (overview != null) {
                    overview.stopAnalysis(id);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void clearOverviewMarks() {
        FileOverviewMargin overview = FileOverviewMargin.getFileOverviewMargin((BasicEditorPane)this.editor);
        if (overview != null) {
            overview.clearMarks(ERRORS_CATEGORY_NAME);
            overview.clearMarks(WARNINGS_CATEGORY_NAME);
        }
    }

    private void installGutter() {
        CodeEditorGutter gutter = this.codeEditor.getGutter();
        this.column = gutter.createGutterColumn("lightbulb", (GutterColumnListener)this);
        int width = Math.max(Math.max(this.fixIcon.getIconWidth(), this.assistIcon.getIconWidth()), this.incompleteIcon.getIconWidth());
        this.column.setReservedWidth(width);
        this.editor.addCaretListener((CaretListener)this);
    }

    private void deinstallGutter() {
        this.editor.removeCaretListener((CaretListener)this);
        CodeEditorGutter gutter = this.codeEditor.getGutter();
        if (gutter != null) {
            gutter.removeGutterColumn(this.column);
        }
        this.column = null;
        this.caretMark = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setViolations(IssueList issues) {
        if (this.editor == null) {
            return;
        }
        if (issues.isStale()) {
            this.startOverviewAnalysis(this);
        }
        this.violations = new ViolationList();
        EditorViolation.State state = new EditorViolation.State();
        try {
            for (int i = 0; i < issues.size(); ++i) {
                EditorViolation violation = new EditorViolation((Violation)issues.getIssueAt(i), state);
                this.violations.addViolation(violation);
            }
        }
        finally {
            state.dispose();
        }
        this.optionalAnalyses = issues.getOptionalAnalyses();
        this.redecorate(true, true);
        if (!issues.isStale()) {
            this.stopOverviewAnalysis(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redecorate(boolean redecorateGutter, boolean redecorateTextArea) {
        block36: {
            LOG.trace("redecorating, gutter {0}, text area {1}", redecorateGutter, redecorateTextArea);
            if (this.editor == null) {
                return;
            }
            if (this.column == null) {
                redecorateGutter = false;
            }
            try {
                FileOverviewMargin overview = FileOverviewMargin.getFileOverviewMargin((BasicEditorPane)this.editor);
                if (overview == null) {
                    return;
                }
                if (redecorateTextArea) {
                    LOG.trace("clearing text area");
                    this.highlights.beginBlockUpdate();
                    this.highlights.removeAllHighlights();
                    this.clearOverviewMarks();
                    LOG.trace("completed clearing text area");
                }
                if (redecorateGutter) {
                    LOG.trace("clearing gutter");
                    this.marks.clear();
                    this.column.removeAllGutterMarks();
                    this.caretMark = null;
                    LOG.trace("completed clearing gutter");
                }
                if (this.violations == null) {
                    return;
                }
                if (redecorateTextArea) {
                    HighlightStyle errorStyle = this.lookupHighlightStyle(StyleCategory.ERROR);
                    if (errorStyle != null) {
                        FileOverviewMargin.setMarkColor((String)ERRORS_CATEGORY_NAME, (int)1, (HighlightStyle)errorStyle);
                    } else {
                        FileOverviewMargin.removeMarkColor((String)ERRORS_CATEGORY_NAME);
                    }
                    HighlightStyle warningStyle = this.lookupHighlightStyle(StyleCategory.WARNING);
                    if (warningStyle != null) {
                        FileOverviewMargin.setMarkColor((String)WARNINGS_CATEGORY_NAME, (int)2, (HighlightStyle)warningStyle);
                    } else {
                        FileOverviewMargin.removeMarkColor((String)WARNINGS_CATEGORY_NAME);
                    }
                    for (EditorViolation violation : this.violations) {
                        HighlightStyle highlight;
                        int offset = violation.getSelectionStart();
                        int endOffset = offset + violation.getSelectionLength();
                        int line = violation.getFocusLine() + 1;
                        Rule rule = violation.getRule();
                        Severity severity = rule.getSeverity();
                        if (Severity.ERROR.equals((Object)severity)) {
                            overview.addMark(ERRORS_CATEGORY_NAME, line, (FileOverviewMark)violation);
                        } else if (Severity.WARNING.equals((Object)severity) || Severity.INCOMPLETE.equals((Object)severity)) {
                            overview.addMark(WARNINGS_CATEGORY_NAME, line, (FileOverviewMark)violation);
                        }
                        if ((highlight = this.lookupHighlightStyle(rule.getStyle())) == null) continue;
                        this.highlights.addHighlight(highlight, offset, endOffset);
                    }
                }
                if (!redecorateGutter) break block36;
                byte[] lineStatus = new byte[this.editor.getLineCount()];
                boolean PRESENT = true;
                int ERROR = 3;
                int OPTIONAL = 5;
                for (ComparableViolation violation : this.violations.getTransformViolations()) {
                    if (!this.isMarkable(violation)) continue;
                    Severity severity = violation.getRule().getSeverity();
                    int mask = Severity.ERROR.equals((Object)severity) ? 3 : 1;
                    int markLine = Math.max(violation.getFocusLine(), 0);
                    int markLineEnd = Math.min(markLine + violation.getFocusLineCount(), lineStatus.length);
                    int i = markLine;
                    while (i < markLineEnd) {
                        int n = i++;
                        lineStatus[n] = (byte)(lineStatus[n] | mask);
                    }
                }
                if (lineStatus[0] == 0 && !this.optionalAnalyses.isEmpty()) {
                    lineStatus[0] = 5;
                }
                PerformanceLogger.get().startTiming("StatusEditorPlugin.addMarks");
                int count = 0;
                try {
                    this.column.beginBlockAdd();
                    try {
                        int caretLine = this.editor.getLineFromOffset(this.editor.getCaretPosition()) + 1;
                        for (int i = 0; i < lineStatus.length; ++i) {
                            boolean alwaysVisible;
                            Icon icon;
                            if (lineStatus[i] == 0) continue;
                            switch (lineStatus[i]) {
                                case 3: {
                                    icon = this.fixIcon;
                                    alwaysVisible = true;
                                    break;
                                }
                                case 5: {
                                    icon = this.incompleteIcon;
                                    alwaysVisible = true;
                                    break;
                                }
                                default: {
                                    icon = this.assistIcon;
                                    alwaysVisible = false;
                                }
                            }
                            int line = i + 1;
                            GutterMark mark = this.column.addGutterMark(line, icon, null, 6000, 65537);
                            this.marks.addMark(mark);
                            if (!alwaysVisible) {
                                if (line == caretLine) {
                                    this.caretMark = mark;
                                } else {
                                    mark.setVisible(false);
                                }
                            }
                            ++count;
                        }
                    }
                    finally {
                        this.column.endBlockAdd();
                    }
                }
                catch (Throwable throwable) {
                    PerformanceLogger.get().stopTiming("StatusEditorPlugin.addMarks", 20, "Marked {0} lines of {1}", new Object[]{count, this.name});
                    throw throwable;
                }
                PerformanceLogger.get().stopTiming("StatusEditorPlugin.addMarks", 20, "Marked {0} lines of {1}", new Object[]{count, this.name});
            }
            finally {
                this.highlights.endBlockUpdate();
            }
        }
        LOG.trace("completed redecorating");
    }

    private boolean isMarkable(Violation violation) {
        int count = violation.getTransformCount();
        for (int i = 0; i < count; ++i) {
            Transform transform = violation.getTransform(i);
            if (this.transformFilter.isSuppressed(transform.id())) continue;
            return true;
        }
        return false;
    }

    public List<TransformAction> getActions(List<? extends ComparableViolation> violations) {
        Transformer transformer = AuditManager.getAuditManager().createTransformer();
        violations = new ArrayList<ComparableViolation>(violations);
        Collections.sort(violations, SEVERITY_COMPARATOR);
        ArrayList<TransformAction> actions = new ArrayList<TransformAction>();
        actions.addAll(transformer.createTransformActions(violations, (TransformerListener)this, null));
        HashSet<String> labelSet = new HashSet<String>();
        Collections.sort(actions, this.SUPPRESSED_COMPARATOR);
        if (this.optionalAnalyses != null) {
            for (Issue issue : this.optionalAnalyses) {
                for (final Action action : issue.getTransforms()) {
                    final String label = (String)action.getValue("Name");
                    if (!labelSet.add(label)) continue;
                    TransformAction wrapperAction = new TransformAction(label, (Icon)action.getValue("SmallIcon"), null){

                        public void actionPerformed(ActionEvent e) {
                            action.actionPerformed(e);
                        }

                        public Throwable apply() {
                            action.actionPerformed(new ActionEvent((Object)this, 1001, label));
                            return null;
                        }
                    };
                    actions.add(wrapperAction);
                }
            }
        }
        return actions;
    }

    public void modelWritable(ModelAdapter model) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transformFailed(Throwable exception, Violation violation, Transform transform, String label) {
        String line;
        Location location = violation.getLocation();
        ModelAdapter model = location.getModel();
        model.beginRead();
        try {
            line = model.getLine(location.getOffset());
        }
        finally {
            model.endRead();
        }
        String url = URLFileSystem.getPlatformPathName((URL)model.getUrl());
        Log.error((String)"exception applying {0} to {1} at {2}: {3}", (Object)label, (Object)url, (Object)line, (Object)exception);
        MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
        dialog.setTitle(BUNDLE.get("results.fix.exception.title"));
        dialog.setContent((Object)Strings.toString((String)BUNDLE.get("results.fix.exception.message"), (Object[])new Object[]{label, exception}));
        dialog.show();
        return false;
    }

    public boolean saveFailed(Throwable exception, ModelAdapter model, String label) {
        return false;
    }

    public void modelSaved(ModelAdapter model) {
    }

    @Override
    public void statusChanged(URL file, Project project, Workspace workspace, final IssueList issues) {
        LOG.trace("status changed in {0} to {1}", (Object)this, (Object)issues);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LOG.trace("status changed in {0} to {1}", (Object)this, (Object)issues);
                try {
                    StatusEditorPlugin.this.setViolations(issues);
                    LOG.trace("finished status changed in {0}", (Object)this);
                }
                catch (ExpiredTextBufferException e) {
                    LOG.trace("finished status changed in {0}: {1}", (Object)this, (Object)e);
                }
                catch (CancellationException e) {
                    LOG.trace("finished status changed in {0}: {1}", (Object)this, (Object)e);
                }
            }
        });
    }

    @Override
    public void statusStale(URL file, Project project, Workspace workspace) {
        this.startOverviewAnalysis(this);
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
    }

    public String getMarkToolTip(GutterMark mark, MouseEvent event) {
        if (mark.getIcon() != this.incompleteIcon) {
            return BUNDLE.get("editor.mark.tip");
        }
        StringBuilder buffer = new StringBuilder("<html>");
        for (Issue issue : this.optionalAnalyses) {
            buffer.append(issue.getMessage());
            buffer.append("<br>");
        }
        buffer.append("<html>");
        return buffer.toString();
    }

    public String getToolTipText(CodeEditor editor, MouseEvent event, int offset) {
        if (this.violations == null) {
            return null;
        }
        ArrayList<? extends ComparableViolation> list = new ArrayList<ComparableViolation>(this.violations.getViolationsOn(offset, 0));
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, SEVERITY_COMPARATOR);
        HashSet<String> set = new HashSet<String>();
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        for (ComparableViolation comparableViolation : list) {
            String message;
            Rule rule = comparableViolation.getRule();
            HighlightStyle highlight = this.lookupHighlightStyle(rule.getStyle());
            if (highlight == null || (message = rule.message((Violation)comparableViolation)) == null || "".equals(message = message.trim()) || !set.add(message)) continue;
            if (count++ > 0) {
                buffer.append("\n");
            }
            buffer.append(message);
        }
        if (count == 0) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        GutterMark mark;
        int line = this.editor.getLineFromOffset(event.getDot());
        if (this.caretMark != null) {
            int oldLine = this.caretMark.getLine() - 1;
            if (line == oldLine) {
                return;
            }
            this.caretMark.setVisible(false);
            this.caretMark = null;
        }
        if ((mark = this.marks.getMark(line)) != null && mark.getIcon() == this.assistIcon) {
            mark.setVisible(true);
            this.caretMark = mark;
        }
    }

    public List<JMenuItem> getMenuItemsForLine(int line) {
        if (this.violations == null || line < 0) {
            return Collections.emptyList();
        }
        int offset = this.editor.getLineStartOffset(line);
        int length = this.editor.getLineEndOffset(line) - offset;
        List<? extends ComparableViolation> sublist = this.violations.getTransformViolationsIn(offset, length);
        LOG.trace("line {0} violations {1}", line, sublist);
        List<TransformAction> actions = this.getActions(sublist);
        if (actions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>(actions.size() + 1);
        boolean separated = false;
        for (TransformAction action : actions) {
            if (action.getTransform() != null) {
                items.add((JMenuItem)((Object)new FixMenuItem(action)));
                continue;
            }
            if (!separated && !items.isEmpty()) {
                items.add(null);
            }
            items.add(new JMenuItem((Action)action));
            separated = true;
        }
        return items;
    }

    public List<JMenuItem> getMenuItemsForPoint(Point point) {
        if (this.violations == null) {
            return Collections.emptyList();
        }
        int offset = this.pointToOffset(point);
        List<? extends ComparableViolation> sublist = this.violations.getTransformViolationsOn(offset, 0);
        LOG.trace("offset {0} violations {1}", offset, sublist);
        List<TransformAction> actions = this.getActions(sublist);
        if (actions.isEmpty()) {
            return this.getMenuItemsForLine(this.offsetToLine(offset));
        }
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>(actions.size() + 1);
        boolean separated = false;
        for (TransformAction action : actions) {
            if (action.getTransform() != null) {
                items.add((JMenuItem)((Object)new FixMenuItem(action)));
                continue;
            }
            if (!separated && !items.isEmpty()) {
                items.add(null);
            }
            items.add(new JMenuItem((Action)action));
            separated = true;
        }
        return items;
    }

    public boolean isCodeAssistPopupEnabled() {
        int length;
        if (this.violations == null) {
            return false;
        }
        if (!this.optionalAnalyses.isEmpty()) {
            return true;
        }
        int line = this.offsetToLine(this.editor.getCaretPosition());
        int offset = this.editor.getLineStartOffset(line);
        List<? extends ComparableViolation> list = this.violations.getTransformViolationsIn(offset, length = this.editor.getLineEndOffset(line) - offset);
        return !list.isEmpty();
    }

    public void showCodeAssistPopup(Context context) {
        int offset;
        Rectangle rectangle;
        List<JMenuItem> menuItems;
        if (this.popup != null) {
            ActionEvent event;
            long when;
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
                return;
            }
            if (context.getEvent() instanceof ActionEvent && (when = (event = (ActionEvent)context.getEvent()).getWhen()) != 0L && when <= this.deselectionTime) {
                if (this.lastSelectedAction != null) {
                    this.lastSelectedAction.actionPerformed(event);
                }
                this.lastSelectedAction = null;
                this.popup.setVisible(false);
                return;
            }
        }
        if ((menuItems = this.getMenuItemsForPoint((rectangle = this.offsetToRectangle(offset = this.editor.getCaretPosition())).getLocation())).isEmpty()) {
            return;
        }
        if (this.popup == null) {
            this.popup = new JPopupMenu(BUNDLE.get("editor.menu.label"));
            this.popup.addPopupMenuListener(this);
            this.popup.getSelectionModel().addChangeListener(this);
            this.popup.setLightWeightPopupEnabled(false);
        } else {
            this.popup.removeAll();
        }
        for (JMenuItem item : menuItems) {
            if (item != null) {
                this.popup.add(item);
                continue;
            }
            this.popup.addSeparator();
        }
        if (menuItems.size() > 0) {
            final MenuElement[] me = new MenuElement[]{this.popup, this.popup.getSubElements()[0]};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                }
            });
        }
        this.popup.show((Component)this.editor, rectangle.x, rectangle.y + rectangle.height);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.deselectionTime = System.currentTimeMillis();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.popup) {
            int selection = this.popup.getSelectionModel().getSelectedIndex();
            if (selection >= 0) {
                JMenuItem item = (JMenuItem)this.popup.getComponent(selection);
                this.lastSelectedAction = (IdeAction)item.getAction();
                LOG.trace("setting last selected action to {0}", (Object)this.lastSelectedAction);
            } else {
                this.lastSelectedAction = null;
                LOG.trace("clearing last selected action");
            }
        } else if (event.getSource() == this.transformFilter) {
            this.redecorate(true, false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object newValue = event.getNewValue();
        Object oldValue = event.getOldValue();
        LOG.trace("property {0} changed to {1} from {2} in {3}", (Object)name, newValue, oldValue, (Object)this);
        Object source = event.getSource();
        if (source == this.preferences) {
            if ("showCodeAssistanceInGutter".equals(name)) {
                if (Boolean.TRUE.equals(newValue)) {
                    this.installGutter();
                    this.redecorate(true, false);
                } else {
                    this.deinstallGutter();
                }
            }
        } else if (source == this.editor) {
            if ("ancestor".equals(name)) {
                if (event.getNewValue() != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StatusEditorPlugin.this.addIssueListener(StatusEditorPlugin.this.codeEditor.getContext());
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StatusEditorPlugin.this.removeIssueListener();
                        }
                    });
                }
            } else if ("editor-ide-context".equals(name)) {
                final Context context = (Context)newValue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusEditorPlugin.this.removeIssueListener();
                        StatusEditorPlugin.this.addIssueListener(context);
                    }
                });
            }
        } else if ("highlight-changed".equals(name)) {
            this.redecorate(false, true);
        }
    }

    public String toString() {
        return this.name + "@" + System.identityHashCode(this);
    }

    private int offsetToLine(int offset) {
        return this.editor.getLineFromOffset(offset);
    }

    private Rectangle offsetToRectangle(int offset) {
        try {
            return this.editor.getUI().modelToView((JTextComponent)this.editor, offset);
        }
        catch (BadLocationException e) {
            return this.editor.getBounds();
        }
    }

    private int pointToOffset(Point point) {
        return this.editor.getUI().viewToModel((JTextComponent)this.editor, point);
    }

    private HighlightStyle lookupHighlightStyle(StyleCategory category) {
        HighlightRegistry registry;
        HighlightStyle style;
        String highlightName = category.getHighlightStyleName();
        if (highlightName != null && this.editor != null && (style = (registry = this.editor.getHighlightRegistry()).lookupStyle(highlightName)) != null && style.getEnabled() && (style.getFontStyle() != 0 || style.getUseForegroundColor() || style.getUseBackgroundColor() || style.getUseUnderline())) {
            return style;
        }
        return null;
    }

    public static void ensureStylesCreated() {
    }

    static {
        NO_INSETS = new Insets(0, 0, 0, 0);
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry mainRegistry = properties.getHighlightRegistry();
        mainRegistry.createStyle("audit-error", BUNDLE.get("editor.style.error.label"), true, 60, 4, Color.red);
        mainRegistry.createStyle("audit-warning", BUNDLE.get("editor.style.warning.label"), true, 55, 4, new Color(247, 181, 0));
        mainRegistry.createStyle("audit-incomplete", BUNDLE.get("editor.style.incomplete.label"), false, 50, 0, Color.gray);
        mainRegistry.createStyle("audit-advisory", BUNDLE.get("editor.style.advisory.label"), false, 50, 0, Color.gray);
        mainRegistry.createStyle("audit-deprecated", BUNDLE.get("editor.style.deprecated.label"), true, 54, 10, Color.gray);
        mainRegistry.createStyle("audit-unused", BUNDLE.get("editor.style.unused.label"), true, 52, Color.gray, null);
        mainRegistry.createStyle("audit-constant", BUNDLE.get("editor.style.constant.label"), true, 49, new Color(75, 45, 255), null, 1, -1, null);
        mainRegistry.createStyle("audit-interface", BUNDLE.get("editor.style.interface.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-abstract-class", BUNDLE.get("editor.style.abstract-class.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-class", BUNDLE.get("editor.style.class.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-annotation", BUNDLE.get("editor.style.annotation.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-annotation-element", BUNDLE.get("editor.style.annotation-element.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-instance-method", BUNDLE.get("editor.style.instance-method.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-static-method", BUNDLE.get("editor.style.static-method.label"), true, 60, null, null, 2, -1, null);
        mainRegistry.createStyle("audit-instance-field", BUNDLE.get("editor.style.instance-field.label"), true, 60, null, null, 1, -1, null);
        mainRegistry.createStyle("audit-static-field", BUNDLE.get("editor.style.static-field.label"), true, 60, null, null, 3, -1, null);
        mainRegistry.createStyle("audit-constructor", BUNDLE.get("editor.style.constructor.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-parameter", BUNDLE.get("editor.style.parameter.label"), false, 60, null, null);
        mainRegistry.createStyle("audit-variable", BUNDLE.get("editor.style.variable.label"), false, 60, null, null);
    }

    private class FixMenuItem
    extends MenuItem
    implements ActionListener,
    ChangeListener {
        private String id;
        private FixMenuButton button;

        public FixMenuItem(TransformAction action) {
            super((ToggleAction)action);
            this.setLayout(null);
            Transform transform = action.getTransform();
            this.id = transform.id();
            this.button = new FixMenuButton(transform);
            this.button.addActionListener(this);
            this.add(this.button);
        }

        public void addNotify() {
            StatusEditorPlugin.this.transformFilter.addChangeListener(this);
            super.addNotify();
        }

        public void removeNotify() {
            super.removeNotify();
            StatusEditorPlugin.this.transformFilter.removeChangeListener(this);
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width += this.getIconTextGap() + this.button.getPreferredSize().width;
            return size;
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            Dimension size = this.button.getPreferredSize();
            int x = this.getWidth() - insets.right - size.width;
            int y = insets.top + (this.getHeight() - size.height - insets.top - insets.bottom) / 2;
            this.button.setBounds(x, y, size.width, size.height);
        }

        public boolean isOptimizedDrawingEnabled() {
            return super.isOptimizedDrawingEnabled();
        }

        public boolean isOpaque() {
            return super.isOpaque();
        }

        public void paint(Graphics g) {
            super.paint(g);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (StatusEditorPlugin.this.transformFilter.isSuppressed(this.id)) {
                StatusEditorPlugin.this.transformFilter.restore(this.id);
            } else {
                StatusEditorPlugin.this.transformFilter.suppress(this.id);
            }
            this.button.reset();
            StatusEditorPlugin.this.redecorate(true, false);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.button.reset();
        }
    }

    private class FixMenuButton
    extends JButton
    implements MouseListener {
        private Transform transform;
        private boolean suppressed;
        private ToolTipManager toolTipManager;
        private boolean defaultLightWeightPopupEnabled;

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doClick();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public FixMenuButton(Transform transform) {
            this.setContentAreaFilled(false);
            this.setMargin(NO_INSETS);
            this.setOpaque(false);
            this.setBorder(null);
            this.transform = transform;
            this.toolTipManager = ToolTipManager.sharedInstance();
            this.toolTipManager.registerComponent(this);
            this.reset();
        }

        public void reset() {
            this.suppressed = StatusEditorPlugin.this.transformFilter.isSuppressed(this.transform.id());
            this.setIcon(this.suppressed ? this.getShowIcon() : this.getHideIcon());
        }

        @Override
        public String getToolTipText() {
            String key = this.suppressed ? "editor.show-transform.tip" : "editor.hide-transform.tip";
            String label = this.transform.labelOrId().trim();
            return BUNDLE.get(key, new Object[]{label});
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            return new Point(0, 2 * this.getHeight());
        }

        private Icon getShowIcon() {
            if (showIcon == null) {
                showIcon = OracleIcons.getIcon((String)"add.png");
            }
            return showIcon;
        }

        private Icon getHideIcon() {
            if (hideIcon == null) {
                hideIcon = OracleIcons.getIcon((String)"delete.png");
            }
            return hideIcon;
        }

        @Override
        public void addMouseMotionListener(MouseMotionListener listener) {
            if (listener == this.toolTipManager) {
                this.defaultLightWeightPopupEnabled = this.toolTipManager.isLightWeightPopupEnabled();
                LOG.trace("tool tip lightweight {0}", this.defaultLightWeightPopupEnabled);
                this.toolTipManager.setLightWeightPopupEnabled(false);
            }
            super.addMouseMotionListener(listener);
        }

        @Override
        public void removeMouseMotionListener(MouseMotionListener listener) {
            if (listener == this.toolTipManager) {
                this.toolTipManager.setLightWeightPopupEnabled(this.defaultLightWeightPopupEnabled);
            }
            super.removeMouseMotionListener(listener);
        }
    }

    private static class MarkList
    implements Comparator<GutterMark> {
        private List<GutterMark> marks = new ArrayList<GutterMark>();
        private TransientMark transientMark = new TransientMark();

        private MarkList() {
        }

        private GutterMark mark(int index) {
            return this.marks.get(index);
        }

        public void addMark(GutterMark mark) {
            assert (this.marks.isEmpty() || this.mark(this.marks.size() - 1).getLine() < mark.getLine());
            this.marks.add(mark);
        }

        public GutterMark getMark(int line) {
            this.transientMark.setLine(line + 1);
            int index = Collections.binarySearch(this.marks, this.transientMark, this);
            if (index < 0) {
                return null;
            }
            return this.mark(index);
        }

        public boolean containsMark(int line) {
            this.transientMark.setLine(line + 1);
            return Collections.binarySearch(this.marks, this.transientMark, this) >= 0;
        }

        public void clear() {
            this.marks.clear();
        }

        public int size() {
            return this.marks.size();
        }

        @Override
        public int compare(GutterMark m1, GutterMark m2) {
            return m1.getLine() - m2.getLine();
        }

        private static class TransientMark
        implements GutterMark {
            private int line;

            private TransientMark() {
            }

            public void setLine(int line) {
                this.line = line;
            }

            public Gutter getGutter() {
                return null;
            }

            public HighlightStyle getHighlightStyle() {
                return null;
            }

            public Icon getIcon() {
                return null;
            }

            public void setIcon(Icon usericon) {
            }

            public int getLine() {
                return this.line;
            }

            public void setVisible(boolean isVisible) {
            }

            public boolean isVisible() {
                return true;
            }

            public GutterColumn getGutterColumn() {
                return null;
            }

            public int getOrder() {
                return 0;
            }

            public Object getUserData() {
                return null;
            }

            public void setUserData(Object userData) {
            }
        }
    }

    private static class ViolationList
    implements Iterable<EditorViolation>,
    Comparator<Comparable> {
        private List<EditorViolation> violations = new ArrayList<EditorViolation>();
        private List<ComparableViolation> transformViolations = new ArrayList<ComparableViolation>();

        private ViolationList() {
        }

        public void addViolation(EditorViolation violation) {
            int index = Collections.binarySearch(this.violations, violation);
            if (index < 0) {
                index = -index - 1;
            }
            this.violations.add(index, violation);
            for (ComparableViolation comparableViolation : violation.getTransformViolations()) {
                index = Collections.binarySearch(this.transformViolations, comparableViolation);
                if (index < 0) {
                    index = -index - 1;
                }
                this.transformViolations.add(index, comparableViolation);
            }
        }

        public List<ComparableViolation> getTransformViolations() {
            return this.transformViolations;
        }

        public void clear() {
            this.violations.clear();
        }

        public int size() {
            return this.violations.size();
        }

        public List<? extends ComparableViolation> getViolationsOn(int offset, int length) {
            return this.getViolationsOn(offset, length, this.violations);
        }

        public List<? extends ComparableViolation> getTransformViolationsOn(int offset, int length) {
            return this.getViolationsOn(offset, length, this.transformViolations);
        }

        private List<? extends ComparableViolation> getViolationsOn(int offset, int length, List<? extends ComparableViolation> violations) {
            ComparableViolation violation;
            Location violationLocation;
            Location location = this.getLocation(offset, length);
            if (location == null) {
                return Collections.emptyList();
            }
            ArrayList<ComparableViolation> list = new ArrayList<ComparableViolation>();
            int first = Collections.binarySearch(violations, location, this);
            if (first < 0) {
                first = -first - 1;
            }
            for (int last = first; last < violations.size() && (violationLocation = (violation = violations.get(last)).getFocusLocation()).contains(location); ++last) {
                list.add(violation);
            }
            --first;
            while (first >= 0) {
                ComparableViolation violation2 = violations.get(first);
                Location violationLocation2 = violation2.getFocusLocation();
                if (violationLocation2.contains(location)) {
                    list.add(violation2);
                } else if (first == 0 || !violations.get(first - 1).getFocusLocation().contains(violationLocation2)) break;
                --first;
            }
            return list;
        }

        public List<? extends ComparableViolation> getViolationsIn(int offset, int length) {
            return this.getViolationsIn(offset, length, this.violations);
        }

        public List<? extends ComparableViolation> getTransformViolationsIn(int offset, int length) {
            return this.getViolationsIn(offset, length, this.transformViolations);
        }

        private List<? extends ComparableViolation> getViolationsIn(int offset, int length, List<? extends ComparableViolation> violations) {
            int last;
            Location location = this.getLocation(offset, length);
            if (location == null) {
                return Collections.emptyList();
            }
            int first = Collections.binarySearch(violations, location, this);
            if (first < 0) {
                first = -first - 1;
            }
            for (last = first; last < violations.size() && violations.get(last).getFocusLocation().getOffset() < offset + length; ++last) {
            }
            while (first > 0 && violations.get(first - 1).getFocusLocation().getEndOffset() > offset) {
                --first;
            }
            return violations.subList(first, last);
        }

        private Location getLocation(int offset, int length) {
            if (this.violations.isEmpty()) {
                return null;
            }
            return this.violations.get(0).getLocation().getModel().getLocation(offset, length);
        }

        @Override
        public Iterator<EditorViolation> iterator() {
            return this.violations.iterator();
        }

        @Override
        public int compare(Comparable c1, Comparable c2) {
            Location l1 = c1 instanceof Location ? (Location)c1 : ((Violation)c1).getFocusLocation();
            Location l2 = c2 instanceof Location ? (Location)c2 : ((Violation)c2).getFocusLocation();
            return l1.compareTo(l2);
        }
    }

    public static class TransformViolation
    extends ComparableViolation {
        private Violation delegate;
        private Location focusLocation;
        private List<Transform> transforms = new ArrayList<Transform>();
        private Transform defaultTransform;
        private int focusLine;
        private int focusLineCount;

        public TransformViolation(EditorViolation delegate, Location location, int focusLine, int focusLineCount) {
            this.delegate = delegate;
            this.focusLocation = location;
            this.focusLine = focusLine;
            this.focusLineCount = focusLineCount;
        }

        public void addTransform(Transform transform) {
            this.transforms.add(transform);
            if (transform == this.delegate.getDefaultTransform()) {
                this.defaultTransform = transform;
            }
        }

        public Rule getRule() {
            return this.delegate.getRule();
        }

        public String getVariation() {
            return this.delegate.getVariation();
        }

        public Location getLocation() {
            return this.delegate.getLocation();
        }

        public Location getFocusLocation() {
            return this.focusLocation;
        }

        public int getParameterCount() {
            return this.delegate.getParameterCount();
        }

        public String getParameterName(int index) {
            return this.delegate.getParameterName(index);
        }

        public Object getParameterValue(int index) {
            return this.delegate.getParameterValue(index);
        }

        public Object getParameterValue(String name) {
            return this.delegate.getParameterValue(name);
        }

        public int getTransformCount() {
            return this.transforms.size();
        }

        public Transform getTransform(int index) {
            return this.transforms.get(index);
        }

        public Location getTransformFocusLocation(int index) {
            return null;
        }

        public Transform getDefaultTransform() {
            return this.defaultTransform;
        }

        public int getSerialNumber() {
            return this.delegate.getSerialNumber();
        }

        @Override
        public int getFocusLine() {
            return this.focusLine;
        }

        @Override
        public int getFocusLineCount() {
            return this.focusLineCount;
        }
    }

    public static class EditorViolation
    extends ComparableViolation
    implements FileOverviewMark {
        private final Rule rule;
        private final String variation;
        private final Location location;
        private Location focusLocation;
        private final int serialNumber;
        private static int lastSerialNumber;
        private Object[] objects;
        private final int parameterCount;
        private final int transformCount;
        private final int overriddenLocationCount;
        private int selectionStart;
        private int selectionLength;
        private int focusLine;
        private int focusLineCount;

        public EditorViolation(Violation violation, State state) {
            int i;
            this.rule = violation.getRule();
            this.variation = violation.getVariation();
            this.location = violation.getLocation();
            this.focusLocation = violation.getFocusLocation();
            if (this.focusLocation == null) {
                this.focusLocation = this.location;
            }
            this.serialNumber = ++lastSerialNumber;
            this.parameterCount = violation.getParameterCount();
            this.transformCount = violation.getTransformCount();
            int locationCount = 0;
            int overriddenLocationCount = 0;
            for (int i2 = 0; i2 < this.transformCount; ++i2) {
                if (violation.getTransformFocusLocation(i2) == null) continue;
                locationCount = i2 + 1;
                ++overriddenLocationCount;
            }
            this.overriddenLocationCount = overriddenLocationCount;
            this.objects = new Object[this.parameterCount * 2 + this.transformCount + locationCount];
            int o = 0;
            for (i = 0; i < this.parameterCount; ++i) {
                this.objects[o++] = violation.getParameterName(i);
                this.objects[o++] = violation.getParameterValue(i);
            }
            for (i = 0; i < this.transformCount; ++i) {
                this.objects[o++] = violation.getTransform(i);
            }
            for (i = 0; i < locationCount; ++i) {
                this.objects[o++] = violation.getTransformFocusLocation(i);
            }
            assert (this.parameterCount == this.getParameterCount());
            assert (this.transformCount == this.getTransformCount());
            ModelAdapter model = this.focusLocation.getModel();
            this.selectionStart = Math.max(0, this.focusLocation.getOffset());
            this.selectionLength = Math.max(1, this.focusLocation.getLength());
            this.focusLine = 0;
            this.focusLineCount = 1;
            if (model instanceof TextFileModelAdapter) {
                int lengthToEOL;
                if (model != state.readModel) {
                    if (state.readModel != null) {
                        state.readModel.endRead();
                    }
                    model.beginRead();
                    state.readModel = model;
                    state.buffer = ((TextFileModelAdapter)model).getTextBuffer();
                    state.bufferLength = state.buffer.getLength();
                }
                this.selectionStart = Math.min(this.selectionStart, state.bufferLength - 1);
                this.selectionLength = Math.min(this.selectionLength, state.bufferLength - this.selectionStart);
                int endOffset = this.selectionStart + this.selectionLength;
                LineMap map = state.buffer.getLineMap();
                this.focusLine = map.getLineFromOffset(this.selectionStart);
                int lineEndOffset = map.getLineEndOffset(this.focusLine);
                if (lineEndOffset < endOffset) {
                    int focusEndLine = map.getLineFromOffset(endOffset);
                    this.focusLineCount = focusEndLine - this.focusLine + 1;
                }
                if ((lengthToEOL = lineEndOffset - this.selectionStart) > 1 && lengthToEOL < this.selectionLength) {
                    this.selectionLength = lengthToEOL;
                }
            }
        }

        public Collection<? extends ComparableViolation> getTransformViolations() {
            if (this.transformCount == 0) {
                return Collections.emptyList();
            }
            if (this.overriddenLocationCount == 0) {
                return Collections.singletonList(this);
            }
            ArrayMap map = new ArrayMap();
            for (int i = 0; i < this.getTransformCount(); ++i) {
                int focusLineCount;
                int focusLine;
                Transform transform = this.getTransform(i);
                Location location = this.getTransformFocusLocation(i);
                if (location == null) {
                    location = this.getFocusLocation();
                    focusLine = this.getFocusLine();
                    focusLineCount = this.getFocusLineCount();
                } else {
                    ModelAdapter model = location.getModel();
                    focusLine = model.getLineOffset(location.getOffset());
                    focusLineCount = model.getLineOffset(location.getEndOffset()) - focusLine + 1;
                }
                TransformViolation violation = (TransformViolation)map.get(location);
                if (violation == null) {
                    violation = new TransformViolation(this, location, focusLine, focusLineCount);
                    map.put(location, violation);
                }
                violation.addTransform(transform);
            }
            return map.values();
        }

        public Location getLocation() {
            return this.location;
        }

        public Location getFocusLocation() {
            return this.focusLocation;
        }

        public Rule getRule() {
            return this.rule;
        }

        public String getVariation() {
            return this.variation;
        }

        public int getParameterCount() {
            return this.parameterCount;
        }

        public String getParameterName(int index) {
            return (String)this.objects[index *= 2];
        }

        public Object getParameterValue(int index) {
            index = index * 2 + 1;
            return this.objects[index];
        }

        public Object getParameterValue(String name) {
            int i = this.getParameterCount();
            while (i-- > 0) {
                if (!name.equals(this.getParameterName(i))) continue;
                return this.getParameterValue(i);
            }
            return null;
        }

        public Transform getDefaultTransform() {
            throw new UnsupportedOperationException("default transform not supported");
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("violation ");
            buffer.append(" ");
            buffer.append(this.rule.id());
            buffer.append('[');
            int count = this.getParameterCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.getParameterName(i));
                buffer.append('=');
                buffer.append(this.getParameterValue(i));
            }
            buffer.append(']');
            buffer.append(this.getFocusLocation());
            return buffer.toString();
        }

        public int getTransformCount() {
            return this.transformCount;
        }

        public Transform getTransform(int index) {
            int transformIndex = this.getParameterCount() * 2 + index;
            return (Transform)this.objects[transformIndex];
        }

        public Location getTransformFocusLocation(int index) {
            int locationIndex = this.getParameterCount() * 2 + this.getTransformCount() + index;
            if (index >= this.objects.length) {
                return null;
            }
            return (Location)this.objects[locationIndex];
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public int compareTo(Violation that) {
            int comparison = this.focusLocation.compareTo(that.getFocusLocation());
            if (comparison == 0) {
                comparison = this.serialNumber - that.getSerialNumber();
            }
            return comparison;
        }

        @Override
        public int getFocusLine() {
            return this.focusLine;
        }

        @Override
        public int getFocusLineCount() {
            return this.focusLineCount;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return this.rule.message((Violation)this);
        }

        public int getSelectionStart() {
            return this.selectionStart;
        }

        public int getSelectionLength() {
            return this.selectionLength;
        }

        public int getSeverity() {
            return this.rule.getSeverity().equals((Object)Severity.ERROR) ? 2 : 1;
        }

        public static class State {
            private ModelAdapter readModel;
            private TextBuffer buffer;
            private int bufferLength;

            public void dispose() {
                if (this.readModel != null) {
                    this.readModel.endRead();
                }
            }
        }
    }

    public static abstract class ComparableViolation
    implements Violation,
    Comparable<Violation> {
        @Override
        public int compareTo(Violation that) {
            int comparison = this.getFocusLocation().compareTo(that.getFocusLocation());
            if (comparison == 0) {
                comparison = this.getSerialNumber() - that.getSerialNumber();
            }
            return comparison;
        }

        public abstract int getFocusLine();

        public abstract int getFocusLineCount();
    }
}

