/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.status.StatusExecutor;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;

class MonitorContext
implements ChangeListener,
PropertyChangeListener {
    private final StatusExecutor executor;
    private final ChangeListener listener;
    private Auditor auditor;
    private long auditorTime = 0L;
    private volatile boolean profileValid;
    private final AtomicLong sequence = new AtomicLong(0L);

    MonitorContext(StatusExecutor executor, ChangeListener listener) {
        this.executor = executor;
        this.listener = listener;
    }

    long sequence() {
        return this.sequence.getAndIncrement();
    }

    StatusExecutor executor() {
        return this.executor;
    }

    Auditor auditor() {
        assert (StatusExecutor.isStatusThread());
        if (!this.profileValid) {
            AuditManager manager = AuditManager.getAuditManager();
            AuditPreferences preferences = manager.getPreferences();
            if (this.auditor == null) {
                preferences.addPropertyChangeListener("assistProfile", (PropertyChangeListener)this);
            } else {
                this.auditor.getProfile().removeChangeListener((ChangeListener)this);
            }
            ProfileRepository repository = ProfileRepository.getRepository();
            Profile profile = repository.getProfile(preferences.getAssistProfile(), "code-assist-rules");
            profile.addChangeListener((ChangeListener)this);
            this.auditor = manager.createAuditor();
            this.auditor.setProfile(profile);
            this.auditorTime = StatusExecutor.translatedNow();
            this.profileValid = true;
        }
        return this.auditor;
    }

    boolean auditorChanged(long time) {
        assert (StatusExecutor.isStatusThread());
        return this.auditorTime >= time || !this.profileValid;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.profileValid = false;
        this.listener.stateChanged(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("assistProfile".equals(name)) {
            this.stateChanged(null);
        }
    }
}

