/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.utils;

import com.adbs.utils.Helpers;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private String url;
    private Color unvisitedURL = Color.blue;
    private Color visitedURL = new Color(0, 0, 128);

    public LinkLabel() {
    }

    public LinkLabel(String text, String url) {
        super(text);
        this.setForeground(this.unvisitedURL);
        try {
            this.url = url;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    LinkLabel.this.setForeground(LinkLabel.this.visitedURL);
                    Helpers.openURL(LinkLabel.this.url);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkLabel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle r = g.getClipBounds();
        g.drawLine(0, r.height - this.getFontMetrics(this.getFont()).getDescent() + 1, this.getFontMetrics(this.getFont()).stringWidth(this.getText()), r.height - this.getFontMetrics(this.getFont()).getDescent() + 1);
    }
}

