/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstExtender;
import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNode;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLLimit;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.syntax.MySQLSelectIntoFile;
import com.adbs.syntax.MySQLSubQueryLockMode;
import com.adbs.syntax.MySQLSubQuerySelectOption;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MySQLSubQuerySelectExpressionExtender
extends AstExtender {
    public EnumSet<MySQLSubQuerySelectOption> options = EnumSet.noneOf(MySQLSubQuerySelectOption.class);
    public MySQLSelectIntoFile intoFile;
    public SQLLimit limit;
    public SQLExpressionItem proc;
    public MySQLSubQueryLockMode lock = MySQLSubQueryLockMode.None;

    public MySQLSubQuerySelectExpressionExtender(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(MySQLSubQuerySelectExpressionExtender.class.getField("intoFile"));
            l.add(MySQLSubQuerySelectExpressionExtender.class.getField("limit"));
            l.add(MySQLSubQuerySelectExpressionExtender.class.getField("proc"));
        }
        catch (Exception ex) {
            Logger.getLogger(MySQLSubQuerySelectExpressionExtender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof MySQLSubQuerySelectExpressionExtender) {
            this.options = ((MySQLSubQuerySelectExpressionExtender)source).options;
            this.lock = ((MySQLSubQuerySelectExpressionExtender)source).lock;
        }
    }

    @Override
    public void buildSQLForNode(AstNode n, SQLBuilder builder, SQLBuilderSelectFormat format) {
        SQLSubQuerySelectExpression q = (SQLSubQuerySelectExpression)n;
        builder.writeKeyword("Select");
        builder.addIndent(format.getIndentInPart());
        if (q.selectMode != null) {
            builder.space();
            q.selectMode.buildSQL(builder, format);
        }
        if (this.options.contains((Object)MySQLSubQuerySelectOption.HighPriority)) {
            builder.space();
            builder.writeKeyword("High_Priority");
        }
        if (this.options.contains((Object)MySQLSubQuerySelectOption.StraightJoin)) {
            builder.space();
            builder.writeKeyword("Straight_Join");
        }
        if (this.options.contains((Object)MySQLSubQuerySelectOption.SQLSmallResult)) {
            builder.space();
            builder.writeKeyword("SQL_Small_Result");
        }
        if (this.options.contains((Object)MySQLSubQuerySelectOption.SQLBigResult)) {
            builder.space();
            builder.writeKeyword("SQL_Big_Result");
        }
        if (this.options.contains((Object)MySQLSubQuerySelectOption.SQLBufferResult)) {
            builder.space();
            builder.writeKeyword("SQL_Buffer_Result");
        }
        if (this.options.contains((Object)MySQLSubQuerySelectOption.SQLCache)) {
            builder.space();
            builder.writeKeyword("SQL_Cache");
        }
        if (this.options.contains((Object)MySQLSubQuerySelectOption.SQLNoCache)) {
            builder.space();
            builder.writeKeyword("SQL_No_Cache");
        }
        if (this.options.contains((Object)MySQLSubQuerySelectOption.SQLCalcFoundRows)) {
            builder.space();
            builder.writeKeyword("SQL_Calc_Found_Rows");
        }
        if (format.getNewLineAfterPartKeywords()) {
            builder.newLine();
        }
        q.buildSelectListItems(builder, format);
        builder.endIndent();
        this.buildIntoFile(builder, format);
        q.buildFromClause(builder, format);
        q.buildWhereClause(builder, format);
        q.buildGroupByClause(builder, format);
        q.buildHavingClause(builder, format);
        q.buildOrderByClause(builder, format);
        this.buildLimit(builder, format);
        this.buildProc(builder, format);
        this.buildLock(builder, format);
    }

    public void buildLimit(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.limit != null) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine());
            this.limit.buildSQL(builder, format);
        }
    }

    public void buildIntoFile(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.intoFile != null) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine(), 1);
            this.intoFile.buildSQL(builder, format);
        }
    }

    public void buildProc(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.proc != null) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine());
            builder.writeKeyword("Procedure");
            builder.space();
            builder.addIndent(format.getIndentInPart());
            this.proc.buildSQL(builder, format);
            builder.endIndent();
        }
    }

    public void buildLock(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.lock != MySQLSubQueryLockMode.None) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine(), 1);
            builder.addIndent(format.getIndentInPart());
            if (this.lock == MySQLSubQueryLockMode.ForUpdate) {
                builder.writeKeyword("For");
                builder.space();
                builder.writeKeyword("Update");
            } else if (this.lock == MySQLSubQueryLockMode.LockInShare) {
                builder.writeKeyword("Lock");
                builder.space();
                builder.writeKeyword("In");
                builder.space();
                builder.writeKeyword("Share");
                builder.space();
                builder.writeKeyword("Mode");
            }
            builder.endIndent();
        }
    }
}

