/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLGroupByList;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.MSSQLExpressionItemExtender;
import com.adbs.syntax.MSSQLFromSourceExtender;
import com.adbs.syntax.MSSQLGroupByListExtender;
import com.adbs.syntax.MSSQLParser;
import com.adbs.syntax.MSSQLQueryPropertiesDialog;
import com.adbs.syntax.MSSQLScanner;
import com.adbs.syntax.MSSQLServerVersion;
import com.adbs.syntax.MSSQLSubQuerySelectExpressionExtender;
import com.adbs.syntax.MSSQLSubSelectStatementExtender;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MSSQLSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private MSSQLServerVersion serverVersion = MSSQLServerVersion.Auto;
    private SQLQualifiedName defaultDatabaseName = null;
    private boolean denyIntoClause = false;

    public MSSQLSyntaxProvider() {
        try {
            this.registerExtender(SQLExpressionItem.class, MSSQLExpressionItemExtender.class);
            this.registerExtender(SQLSubQuerySelectExpression.class, MSSQLSubQuerySelectExpressionExtender.class);
            this.registerExtender(SQLGroupByList.class, MSSQLGroupByListExtender.class);
            this.registerExtender(SQLSubSelectStatement.class, MSSQLSubSelectStatementExtender.class);
            this.registerExtender(SQLFromSource.class, MSSQLFromSourceExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(MSSQLSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void dispose() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
            this.defaultDatabaseName = null;
        }
        super.dispose();
    }

    @Override
    public BaseSyntaxProvider clone() {
        MSSQLSyntaxProvider result = (MSSQLSyntaxProvider)super.clone();
        result.serverVersion = this.serverVersion;
        return result;
    }

    public MSSQLServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(MSSQLServerVersion serverVersion) {
        if (this.serverVersion != serverVersion) {
            this.serverVersion = serverVersion;
            this.setDetectServerVersion(serverVersion == MSSQLServerVersion.Auto);
            this.sendNotifications();
        }
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.Insensitive;
    }

    @Override
    public void setIdentCaseSens(IdentCaseSensitivity value) {
    }

    @Override
    protected Class getParserClass() {
        return MSSQLParser.class;
    }

    @Override
    protected Class getScannerClass() {
        return MSSQLScanner.class;
    }

    @Override
    public String getDescription() {
        return "Microsoft SQL Server";
    }

    @Override
    protected void setParserParams(BaseParser parser) {
        super.setParserParams(parser);
        switch (this.serverVersion) {
            case MSSQL7: {
                parser.serverVersion = 7;
                break;
            }
            case MSSQL2000: {
                parser.serverVersion = 8;
                break;
            }
            case MSSQL2005: {
                parser.serverVersion = 9;
                break;
            }
            case MSSQL2008: {
                parser.serverVersion = 10;
                break;
            }
            default: {
                parser.serverVersion = 10;
            }
        }
    }

    @Override
    public void resetCachedDefaultDatabaseName() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
        }
        this.defaultDatabaseName = null;
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        if (this.defaultDatabaseName != null) {
            return this.defaultDatabaseName;
        }
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        this.defaultDatabaseName = LoadMetadataHelpers.getDefaultDatabaseNameMSSQL(sqlContext);
        if (this.defaultDatabaseName == null) {
            this.defaultDatabaseName = super.getDefaultDatabaseName(sqlContext);
        }
        return this.defaultDatabaseName;
    }

    @Override
    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getDefaultSchemaNamesMSSQL(sqlContext, defaultSchemaNames)) {
            super.getDefaultSchemaNames(sqlContext, defaultSchemaNames);
        }
        if (!defaultSchemaNames.containsSameIdStr("dbo")) {
            defaultSchemaNames.addIdentifier("dbo");
        }
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
        names.addIdentifier("Count_Big", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Count_Big", false);
        names.addIdentifier("Checksum_Agg", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
        names.addIdentifier("StDev", false);
        names.addIdentifier("StDevP", false);
        names.addIdentifier("Var", false);
        names.addIdentifier("VarP", false);
    }

    @Override
    public void getComparisonOperators(List<String> list) {
        list.clear();
        list.add("=");
        list.add("<");
        list.add("<=");
        list.add(">");
        list.add(">=");
        list.add("<>");
        list.add("!=");
        list.add("!>");
        list.add("!<");
    }

    @Override
    public String getQuoteBegin() {
        return "[";
    }

    @Override
    public String getQuoteEnd() {
        return "]";
    }

    @Override
    public boolean isSupportProcedures() {
        return true;
    }

    @Override
    public boolean isSupportSchemas() {
        return true;
    }

    @Override
    public boolean isSupportCTE() {
        return true;
    }

    @Override
    public void getUnionOperatorList(List<String> sl) {
        super.getUnionOperatorList(sl);
        if (this.serverVersion.compareTo(MSSQLServerVersion.MSSQL2005) >= 0) {
            sl.add("Except");
            sl.add("Intersect");
        }
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return MSSQLQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("Rank");
        names.addBuiltin("Dense_Rank");
        names.addBuiltin("NTile");
        names.addBuiltin("Row_Number");
        names.addBuiltin("DateAdd");
        names.addBuiltin("DateDiff");
        names.addBuiltin("DateName");
        names.addBuiltin("DatePart");
        names.addBuiltin("Day");
        names.addBuiltin("GetDate");
        names.addBuiltin("GetUTCDate");
        names.addBuiltin("Month");
        names.addBuiltin("Year");
        names.addBuiltin("Abs");
        names.addBuiltin("Degrees");
        names.addBuiltin("Rand");
        names.addBuiltin("ACos");
        names.addBuiltin("Exp");
        names.addBuiltin("Round");
        names.addBuiltin("ASin");
        names.addBuiltin("Floor");
        names.addBuiltin("Sign");
        names.addBuiltin("ATan");
        names.addBuiltin("Log");
        names.addBuiltin("Sin");
        names.addBuiltin("ATn2");
        names.addBuiltin("Log10");
        names.addBuiltin("SqRt");
        names.addBuiltin("Ceiling");
        names.addBuiltin("Pi");
        names.addBuiltin("Square");
        names.addBuiltin("Cos");
        names.addBuiltin("Power");
        names.addBuiltin("Tan");
        names.addBuiltin("Cot");
        names.addBuiltin("Radians");
        names.addBuiltin("Col_Length");
        names.addBuiltin("FullTextCatalogProperty");
        names.addBuiltin("Col_Name");
        names.addBuiltin("FullTextServiceProperty");
        names.addBuiltin("ColumnProperty");
        names.addBuiltin("Index_Col");
        names.addBuiltin("DatabaseProperty");
        names.addBuiltin("IndexKey_Property");
        names.addBuiltin("DatabasePropertyEx");
        names.addBuiltin("IndexProperty");
        names.addBuiltin("Db_Id");
        names.addBuiltin("Object_Id");
        names.addBuiltin("Db_Name");
        names.addBuiltin("Object_Name");
        names.addBuiltin("File_Id");
        names.addBuiltin("ObjectProperty");
        names.addBuiltin("File_IdEx");
        names.addBuiltin("ObjectPropertyEx");
        names.addBuiltin("File_Name");
        names.addBuiltin("SQL_Variant_Property");
        names.addBuiltin("FileGroup_Id");
        names.addBuiltin("Type_Id");
        names.addBuiltin("FileGroup_Name");
        names.addBuiltin("Type_Name");
        names.addBuiltin("FileGroupProperty");
        names.addBuiltin("TypeProperty");
        names.addBuiltin("FileProperty");
        names.addBuiltin("Has_Perms_By_Name");
        names.addBuiltin("Is_Member");
        names.addBuiltin("Is_SrvRoleMember");
        names.addBuiltin("Permissions");
        names.addBuiltin("Schema_Id");
        names.addBuiltin("Schema_Name");
        names.addBuiltin("SUser_Id");
        names.addBuiltin("SUser_SId");
        names.addBuiltin("SUser_SName");
        names.addBuiltin("SUser_Name");
        names.addBuiltin("User_Id");
        names.addBuiltin("User_Name");
        names.addBuiltin("ASCII");
        names.addBuiltin("NChar");
        names.addBuiltin("SoundEx");
        names.addBuiltin("Char");
        names.addBuiltin("PatIndex");
        names.addBuiltin("Space");
        names.addBuiltin("CharIndex");
        names.addBuiltin("QuoteName");
        names.addBuiltin("Str");
        names.addBuiltin("Difference");
        names.addBuiltin("Replace");
        names.addBuiltin("Stuff");
        names.addBuiltin("Left");
        names.addBuiltin("Replicate");
        names.addBuiltin("SubString");
        names.addBuiltin("Len");
        names.addBuiltin("Reverse");
        names.addBuiltin("Unicode");
        names.addBuiltin("Lower");
        names.addBuiltin("Right");
        names.addBuiltin("Upper");
        names.addBuiltin("LTrim");
        names.addBuiltin("RTrim");
        names.addBuiltin("App_Name");
        names.addBuiltin("Cast");
        names.addBuiltin("Convert");
        names.addBuiltin("Coalesce");
        names.addBuiltin("CollationProperty");
        names.addBuiltin("Columns_Updated");
        names.addBuiltin("DataLength");
        names.addBuiltin("Error_Line");
        names.addBuiltin("Error_Message");
        names.addBuiltin("Error_Number");
        names.addBuiltin("Error_Procedure");
        names.addBuiltin("Error_Severity");
        names.addBuiltin("Error_State");
        names.addBuiltin("FormatMessage");
        names.addBuiltin("GetANSINull");
        names.addBuiltin("Host_Id");
        names.addBuiltin("Host_Name");
        names.addBuiltin("Ident_Current");
        names.addBuiltin("IdntT_Incr");
        names.addBuiltin("Ident_Seed");
        names.addBuiltin("Identity");
        names.addBuiltin("IsDate");
        names.addBuiltin("IsNull");
        names.addBuiltin("IsNumeric");
        names.addBuiltin("NewId");
        names.addBuiltin("NullIf");
        names.addBuiltin("ParseName");
        names.addBuiltin("RowCount_Big");
        names.addBuiltin("Scope_Identity");
        names.addBuiltin("ServerProperty");
        names.addBuiltin("sessionProperty");
        names.addBuiltin("Stats_Date");
        names.addBuiltin("Update");
        names.addBuiltin("User_Name");
        names.addBuiltin("XAct_State");
        names.addBuiltin("Patindex");
        names.addBuiltin("TextValid");
        names.addBuiltin("TextPtr");
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select top 0 " + fieldExpression + " from " + objectExpression + " a where 0<>0";
    }

    @Override
    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        try {
            if (!LoadMetadataHelpers.getDatabaseListMSSQL(sqlContext, databaseList)) {
                super.getDatabaseList(sqlContext, databaseList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsMSSQL(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsMSSQL(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadMetadataCustomAggregateNames(BaseSQLContext sqlContext, MetadataContainer metadataContainer, SQLQualifiedName database) {
        block24: {
            String query = "SELECT u.name AS SCHEMA_NAME, o.name AS OBJECT_NAME, rs.name AS RETURN_TYPE_SCHEMA, rt.name AS RETURN_TYPE, r.max_length AS RETURN_TYPE_LENGTH, r.precision AS RETURN_TYPE_PRECISION, r.scale AS RETURN_TYPE_SCALE FROM %1$ssys.objects o INNER JOIN %1$ssys.schemas u ON u.schema_id = o.schema_id INNER JOIN %1$ssys.parameters r ON (r.object_id = o.object_id) AND (r.is_output = 1) INNER JOIN %1$ssys.types rt ON r.user_type_id = rt.user_type_id INNER JOIN %1$ssys.schemas rs ON rs.schema_id = rt.schema_id WHERE o.type = 'AF' ";
            ResultSet resultSet = null;
            if (this.isDetectServerVersion()) {
                this.doDetectServerVersion(sqlContext.getMetadataProvider());
            }
            if (this.serverVersion.compareTo(MSSQLServerVersion.MSSQL2000) < 0) {
                return;
            }
            if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
                try {
                    String dbDot;
                    if (Helpers.isQualifiedNameEmpty(database)) {
                        SQLQualifiedName currDB = this.getDefaultDatabaseName(sqlContext);
                        dbDot = currDB.getQualifiedNameForServer() + ".";
                    } else {
                        dbDot = database.getQualifiedNameForServer() + ".";
                    }
                    String formattedQuery = String.format("SELECT u.name AS SCHEMA_NAME, o.name AS OBJECT_NAME, rs.name AS RETURN_TYPE_SCHEMA, rt.name AS RETURN_TYPE, r.max_length AS RETURN_TYPE_LENGTH, r.precision AS RETURN_TYPE_PRECISION, r.scale AS RETURN_TYPE_SCALE FROM %1$ssys.objects o INNER JOIN %1$ssys.schemas u ON u.schema_id = o.schema_id INNER JOIN %1$ssys.parameters r ON (r.object_id = o.object_id) AND (r.is_output = 1) INNER JOIN %1$ssys.types rt ON r.user_type_id = rt.user_type_id INNER JOIN %1$ssys.schemas rs ON rs.schema_id = rt.schema_id WHERE o.type = 'AF' ", dbDot);
                    try {
                        resultSet = sqlContext.getMetadataProvider().execSQL(formattedQuery, false);
                        if (resultSet == null) break block24;
                        int schemaField = resultSet.findColumn("SCHEMA_NAME");
                        int nameField = resultSet.findColumn("OBJECT_NAME");
                        while (resultSet.next()) {
                            String name = dbDot + resultSet.getString(schemaField) + "." + resultSet.getString(nameField);
                            SQLQualifiedName parsedName = sqlContext.parseQualifiedNameQuoteIfNeed(name);
                            try {
                                if (parsedName == null || metadataContainer.getCustomAggregateFunctions().findByName(parsedName) != -1) continue;
                                metadataContainer.getCustomAggregateFunctions().add(parsedName);
                            }
                            finally {
                                if (parsedName == null) continue;
                                parsedName.dispose();
                            }
                        }
                    }
                    finally {
                        try {
                            if (resultSet != null) {
                                resultSet.getStatement().close();
                                resultSet.close();
                            }
                        }
                        catch (Exception ignore) {
                        }
                        finally {
                            resultSet = null;
                        }
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String db = metadataObject.getDatabase().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer()) + ".";
        if (this.serverVersion.compareTo(MSSQLServerVersion.MSSQL2005) >= 0 && sqlContext.isTableExists(db + "sys.tables") && sqlContext.isTableExists(db + "sys.indexes") && sqlContext.isTableExists(db + "sys.index_columns") && sqlContext.isTableExists(db + "sys.types") || sqlContext.isTableExists(db + "dbo.sysobjects") && sqlContext.isTableExists(db + "dbo.syscolumns") && sqlContext.isTableExists(db + "dbo.sysindexes") && sqlContext.isTableExists(db + "dbo.sysindexkeys") && sqlContext.isTableExists(db + "dbo.systypes")) {
            String q;
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            if (this.serverVersion.compareTo(MSSQLServerVersion.MSSQL2005) >= 0) {
                q = "SELECT clmns.name AS [Name], CAST(ISNULL(cik.index_column_id, 0) AS bit) AS [InPrimaryKey], CAST(ISNULL((select TOP 1 1 from " + db + "sys.foreign_key_columns AS colfk where colfk.parent_column_id = clmns.column_id and colfk.parent_object_id = clmns.object_id), 0) AS bit) AS [IsForeignKey], " + "usrt.name AS [DataType], " + "ISNULL(baset.name, N'') AS [SystemType], " + "CAST(CASE WHEN baset.name IN (N'nchar', N'nvarchar') AND clmns.max_length <> -1 THEN clmns.max_length/2 ELSE clmns.max_length END AS int) AS [Length], " + "CAST(clmns.precision AS int) AS [NumericPrecision], " + "CAST(clmns.scale AS int) AS [NumericScale], " + "clmns.is_nullable AS [Nullable], " + "clmns.is_computed AS [Computed], " + "CAST(xp.[value] AS nvarchar(4000)) AS [Description] ";
                q = q + "FROM " + db + "sys.tables AS tbl " + "INNER JOIN " + db + "sys.all_columns AS clmns ON clmns.object_id=tbl.object_id " + "LEFT OUTER JOIN " + db + "sys.indexes AS ik ON ik.object_id = clmns.object_id and 1=ik.is_primary_key " + "LEFT OUTER JOIN " + db + "sys.index_columns AS cik ON cik.index_id = ik.index_id and cik.column_id = clmns.column_id and cik.object_id = clmns.object_id and 0 = cik.is_included_column " + "LEFT OUTER JOIN " + db + "sys.types AS usrt ON usrt.user_type_id = clmns.user_type_id " + "LEFT OUTER JOIN " + db + "sys.types AS baset ON baset.user_type_id = clmns.system_type_id and baset.user_type_id = baset.system_type_id " + "LEFT OUTER JOIN " + db + "sys.extended_properties AS xp ON tbl.object_id=xp.major_id and clmns.column_id=xp.minor_id " + "WHERE " + "(tbl.name=N'" + objectName + "' and SCHEMA_NAME(tbl.schema_id)=N'" + objectSchema + "') " + "ORDER BY clmns.column_id ASC";
            } else {
                q = "SELECT clmns.name AS [Name], CAST(ISNULL(cik.colid, 0) AS bit) AS [InPrimaryKey], CAST(ISNULL((select top 1 1 from dbo.sysforeignkeys AS colfk where colfk.fkey = clmns.colid and colfk.fkeyid = clmns.id), 0) AS bit) AS [IsForeignKey], usrt.name AS [DataType], ISNULL(baset.name, N'') AS [SystemType], CAST(CASE WHEN baset.name IN (N'char', N'varchar', N'binary', N'varbinary', N'nchar', N'nvarchar') THEN clmns.prec ELSE clmns.length END AS int) AS [Length], CAST(clmns.xprec AS int) AS [NumericPrecision], CAST(clmns.xscale AS int) AS [NumericScale], CAST(clmns.isnullable AS bit) AS [Nullable], CAST(clmns.iscomputed AS bit) AS [Computed], Null AS [Description] ";
                q = q + "FROM " + db + "dbo.sysobjects AS tbl " + "INNER JOIN " + db + "dbo.sysusers AS stbl ON stbl.uid = tbl.uid " + "INNER JOIN " + db + "dbo.syscolumns AS clmns ON clmns.id=tbl.id " + "LEFT OUTER JOIN " + db + "dbo.sysindexes AS ik ON ik.id = clmns.id and 0 != ik.status & 0x0800 " + "LEFT OUTER JOIN " + db + "dbo.sysindexkeys AS cik ON cik.indid = ik.indid and cik.colid = clmns.colid and cik.id = clmns.id " + "LEFT OUTER JOIN " + db + "dbo.systypes AS usrt ON usrt.xusertype = clmns.xusertype " + "LEFT OUTER JOIN " + db + "dbo.systypes AS baset ON baset.xusertype = clmns.xtype and baset.xusertype = baset.xtype " + "WHERE ((tbl.type='U' or tbl.type='S'))and(tbl.name=N'" + objectName + "' and stbl.name=N'" + objectSchema + "') " + "ORDER BY CAST(clmns.colid AS int) ASC";
            }
            mff.setQuery(q);
            mff.setNameFieldName("Name");
            mff.setServerTypeFieldName("SystemType");
            mff.setSizeFieldName("Length");
            mff.setPrecisionFieldName("NumericPrecision");
            mff.setScaleFieldName("NumericScale");
            mff.setNullableFieldName("Nullable");
            mff.setNullableValue(1);
            mff.setPrimaryFieldName("InPrimaryKey");
            mff.setPrimaryValue(1);
            mff.setReadOnlyFieldName("Computed");
            mff.setReadOnlyValue(1);
            mff.setLongDescriptionFieldName("Description");
            mff.loadFields(metadataObject.getFields());
        }
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsMSSQL(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("nchar") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("nvarchar") != 0 && type.compareToIgnoreCase("binary") != 0 && type.compareToIgnoreCase("varbinary") != 0;
    }

    @Override
    public boolean isDenyIntoClause() {
        return this.denyIntoClause;
    }

    @Override
    public void setDenyIntoClause(boolean value) {
        this.denyIntoClause = value;
    }

    @Override
    public boolean isInnerKeywordInLinksMandatory() {
        return false;
    }

    @Override
    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getSchemaListMSSQL(sqlContext, schemaList, fromDatabase)) {
            super.getSchemaList(sqlContext, schemaList, fromDatabase);
        }
    }

    @Override
    public boolean isSupportTransactSQLJoins() {
        return this.serverVersion.compareTo(MSSQLServerVersion.MSSQL2000) <= 0 && this.serverVersion != MSSQLServerVersion.Auto;
    }

    @Override
    public boolean isDetectServerVersion() {
        return super.isDetectServerVersion();
    }

    @Override
    public void setDetectServerVersion(boolean detectServerVersion) {
        super.setDetectServerVersion(detectServerVersion);
        if (this.isDetectServerVersion()) {
            this.setServerVersion(MSSQLServerVersion.Auto);
        } else if (this.getServerVersion() == MSSQLServerVersion.Auto) {
            this.setServerVersion(MSSQLServerVersion.MSSQL2008);
        }
    }

    @Override
    public void doDetectServerVersion(BaseMetadataProvider metadataProvider) {
        super.doDetectServerVersion(metadataProvider);
        int version = LoadMetadataHelpers.calcServerVersionMSSQL(metadataProvider);
        switch (version) {
            case 10: {
                this.setServerVersion(MSSQLServerVersion.MSSQL2008);
                break;
            }
            case 9: {
                this.setServerVersion(MSSQLServerVersion.MSSQL2005);
                break;
            }
            case 8: {
                this.setServerVersion(MSSQLServerVersion.MSSQL2000);
                break;
            }
            case 7: {
                this.setServerVersion(MSSQLServerVersion.MSSQL7);
                break;
            }
            default: {
                this.setServerVersion(MSSQLServerVersion.MSSQL2008);
            }
        }
    }
}

