/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLFromFunction;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.DB2NamingConventions;
import com.adbs.syntax.DB2Parser;
import com.adbs.syntax.DB2QueryPropertiesDialog;
import com.adbs.syntax.DB2SQLFromFunctionExtender;
import com.adbs.syntax.DB2SQLFromObjectExtender;
import com.adbs.syntax.DB2SQLFromQueryExtender;
import com.adbs.syntax.DB2SQLSelectStatementExtender;
import com.adbs.syntax.DB2Scanner;
import com.adbs.syntax.DB2SubQuerySelectExpressionExtender;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DB2SyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private SQLQualifiedName defaultDatabaseName = null;
    private DB2NamingConventions namingConvention = DB2NamingConventions.SQL;

    public DB2SyntaxProvider() {
        try {
            this.registerExtender(SQLSubQuerySelectExpression.class, DB2SubQuerySelectExpressionExtender.class);
            this.registerExtender(SQLSelectStatement.class, DB2SQLSelectStatementExtender.class);
            this.registerExtender(SQLFromObject.class, DB2SQLFromObjectExtender.class);
            this.registerExtender(SQLFromQuery.class, DB2SQLFromQueryExtender.class);
            this.registerExtender(SQLFromFunction.class, DB2SQLFromFunctionExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(DB2SyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void dispose() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
            this.defaultDatabaseName = null;
        }
        super.dispose();
    }

    @Override
    protected Class getParserClass() {
        return DB2Parser.class;
    }

    @Override
    protected Class getScannerClass() {
        return DB2Scanner.class;
    }

    @Override
    public String getDescription() {
        return "IBM DB2";
    }

    public void getUnionOperatorList(List sl) {
        super.getUnionOperatorList(sl);
        sl.add("Except");
        sl.add("Except All");
        sl.add("Intersect");
        sl.add("Intersect All");
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
        names.addIdentifier("Count_Big", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Grouping", false);
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Count_Big", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("StdDev", false);
        names.addIdentifier("StdDev_Samp", false);
        names.addIdentifier("Sum", false);
        names.addIdentifier("Var", false);
        names.addIdentifier("Variance", false);
        names.addIdentifier("Variance_Samp", false);
    }

    @Override
    public boolean isSupportNullOrdering() {
        return true;
    }

    @Override
    public boolean isSupportCTE() {
        return true;
    }

    @Override
    public boolean isFromClauseMandatory() {
        return true;
    }

    @Override
    public String getSimpleEmptyFromSubquery() {
        return "(SELECT NULL FROM SYSIBM.SYSDUMMY1)";
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select " + fieldExpression + " from " + objectExpression + " a fetch first row only";
    }

    @Override
    public void resetCachedDefaultDatabaseName() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
        }
        this.defaultDatabaseName = null;
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        if (this.defaultDatabaseName != null) {
            return this.defaultDatabaseName;
        }
        this.defaultDatabaseName = LoadMetadataHelpers.getDefaultDatabaseNameDB2(sqlContext);
        if (this.defaultDatabaseName == null) {
            this.defaultDatabaseName = super.getDefaultDatabaseName(sqlContext);
        }
        return this.defaultDatabaseName;
    }

    @Override
    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) throws QueryBuilderException {
        if (!LoadMetadataHelpers.getDefaultSchemaNamesDB2(sqlContext, defaultSchemaNames)) {
            super.getDefaultSchemaNames(sqlContext, defaultSchemaNames);
        }
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return DB2QueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public String createWrapperForStoredProc(String storedProcCallExpression) {
        return "TABLE(" + storedProcCallExpression + ")";
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataObjectsDB2(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataRelationsDB2(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        if (sqlContext.isTableExists("sysibm.syscolumns")) {
            String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
            String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            mff.setQuery("select   colno, name, '\"' || trim(typeschema) || '\"' || '.' || '\"' || typename || '\"' as coltype,   length, scale, default, nulls, keyseq, identity, generated, remarks from sysibm.syscolumns where tbcreator='" + objectSchema + "' and" + " tbname='" + objectName + "' " + " and HIDDEN<>'S' and trim(typeschema)<>'SYSIBM' " + "union " + "select " + "  colno, name, typename as coltype, length, scale, default, nulls, keyseq, identity, " + "  generated, remarks " + "from sysibm.syscolumns " + "where tbcreator='" + objectSchema + "' and" + " tbname='" + objectName + "' " + " and HIDDEN<>'S' and trim(typeschema)='SYSIBM' " + "order by colno FOR FETCH ONLY");
            mff.setNameFieldName("NAME");
            mff.setServerTypeFieldName("COLTYPE");
            mff.setSizeFieldName("LENGTH");
            mff.setScaleFieldName("SCALE");
            mff.setDefaultValueFieldName("DEFAULT");
            mff.setNullableFieldName("NULLS");
            mff.setNullableValue("Y");
            mff.setPrimaryFieldName("KEYSEQ");
            mff.setNonPrimaryValue(null);
            mff.setReadOnlyFieldName("GENERATED");
            mff.setReadOnlyValue("A");
            mff.setLongDescriptionFieldName("REMARKS");
            mff.loadFields(metadataObject.getFields());
        }
        super.loadFieldsForObjectFromServer(sqlContext, metadataObject);
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsDB2(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("character") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("graphic") != 0 && type.compareToIgnoreCase("vargraphic") != 0;
    }

    @Override
    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        if (!LoadMetadataHelpers.getSchemaListDB2(sqlContext, schemaList, fromDatabase)) {
            super.getSchemaList(sqlContext, schemaList, fromDatabase);
        }
    }

    public DB2NamingConventions getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(DB2NamingConventions value) {
        if (this.namingConvention != value) {
            this.namingConvention = value;
            this.sendNotifications();
        }
    }

    @Override
    public String getObjectNameSeparator() {
        return this.namingConvention == DB2NamingConventions.SQL ? "." : "/";
    }

    @Override
    public void beginBuildWrapperForStoredProc(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeKeyword("Table");
        builder.writeSymbol("(");
    }

    @Override
    public void endBuildWrapperForStoredProc(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeSymbol(")");
    }
}

