/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstClassToExtenderEntry;
import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.BaseScanner;
import com.adbs.ast.Disposable;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLObjectColumn;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.ast.Token;
import com.adbs.ast.WayPoint;
import com.adbs.ast.WayPointList;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import com.adbs.utils.Wrapper;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public abstract class BaseSyntaxProvider
extends Component
implements Disposable {
    private ArrayList<AstClassToExtenderEntry> extenders = new ArrayList();
    static Icon unionImage;
    static Icon unionAllImage;
    static Icon exceptImage;
    static Icon exceptAllImage;
    static Icon intersectImage;
    static Icon intersectAllImage;
    protected ArrayList<ChangedEventListener> changedEventListenerList = new ArrayList();
    protected ArrayList<DestroyedEventListener> destroyedEventListenerList = new ArrayList();
    private boolean detectServerVersion = true;
    private boolean createWhereJoinsByDefault = false;
    private HashMap<Class, Class> findExtenderClassResultsCache = new HashMap();

    public BaseSyntaxProvider() {
        unionImage = Helpers.createImageIcon("images/union.png");
        unionAllImage = Helpers.createImageIcon("images/unionall.png");
        exceptImage = Helpers.createImageIcon("images/except.png");
        exceptAllImage = Helpers.createImageIcon("images/exceptall.png");
        intersectImage = Helpers.createImageIcon("images/intersect.png");
        intersectAllImage = Helpers.createImageIcon("images/intersectall.png");
    }

    @Override
    public void dispose() {
        this.fireDestroyedEvent(new DestroyedEvent(this));
    }

    public String getQuoteBegin() {
        return "\"";
    }

    public String getQuoteEnd() {
        return "\"";
    }

    public String getDescription() {
        return this.getClass().getName();
    }

    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.SensitiveUpperCase;
    }

    public void setIdentCaseSens(IdentCaseSensitivity value) {
    }

    public BaseSyntaxProvider clone() {
        BaseSyntaxProvider result = null;
        try {
            result = (BaseSyntaxProvider)this.getClass().newInstance();
            result.setIdentCaseSens(this.getIdentCaseSens());
            result.setDenyIntoClause(this.isDenyIntoClause());
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BaseSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BaseSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public void assign(Component source) {
        if (source instanceof BaseSyntaxProvider) {
            BaseSyntaxProvider bsp = (BaseSyntaxProvider)source;
            this.setIdentCaseSens(bsp.getIdentCaseSens());
            this.setDenyIntoClause(bsp.isDenyIntoClause());
            this.setDetectServerVersion(bsp.isDetectServerVersion());
            this.setCreateWhereJoinsByDefault(bsp.isCreateWhereJoinsByDefault());
        }
    }

    protected void registerExtender(Class nodeClass, Class extenderClass) throws QueryBuilderException {
        if (this.findExtenderClass(nodeClass, false) != null) {
            throw new QueryBuilderException("Extender for \"" + nodeClass.toString() + "\" already registered!");
        }
        AstClassToExtenderEntry ei = new AstClassToExtenderEntry();
        ei.nodeClass = nodeClass;
        ei.extenderClass = extenderClass;
        this.extenders.add(ei);
    }

    protected void registerExtender(Class[] nodeClasses, Class extenderClass) throws QueryBuilderException {
        for (int i = 0; i < nodeClasses.length; ++i) {
            this.registerExtender(nodeClasses[i], extenderClass);
        }
    }

    protected Class getScannerClass() {
        return null;
    }

    protected Class getParserClass() {
        return null;
    }

    protected void setScannerParams(BaseScanner scanner) {
    }

    protected void setParserParams(BaseParser parser) {
    }

    protected void sendNotifications() {
        this.fireChangedEvent(new ChangedEvent(this));
    }

    private int inheritanceLevel(Class childClass, Class parentClass) {
        int result = 0;
        while (childClass != null && childClass != parentClass) {
            ++result;
            childClass = childClass.getSuperclass();
        }
        return result;
    }

    public Class findExtenderClass(Class nodeClass, boolean fromParent) {
        Class result = null;
        if (fromParent && (result = this.findExtenderClassResultsCache.get(nodeClass)) != null) {
            return result;
        }
        int foundLevel = -1;
        for (int i = 0; i < this.extenders.size(); ++i) {
            AstClassToExtenderEntry ei = this.extenders.get(i);
            if (ei.nodeClass == nodeClass) {
                return ei.extenderClass;
            }
            if (!fromParent || nodeClass != ei.nodeClass && !ei.nodeClass.isAssignableFrom(nodeClass)) continue;
            int j = this.inheritanceLevel(nodeClass, ei.nodeClass);
            if (result != null && foundLevel <= j) continue;
            result = ei.extenderClass;
            foundLevel = j;
        }
        if (fromParent) {
            this.findExtenderClassResultsCache.put(nodeClass, result);
        }
        return result;
    }

    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
    }

    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
    }

    public void getComparisonOperators(List<String> sl) {
        sl.clear();
        sl.add("=");
        sl.add(">");
        sl.add(">=");
        sl.add("<");
        sl.add("<=");
        sl.add("<>");
    }

    public void getUnionOperatorList(List<String> sl) {
        sl.clear();
        sl.add("Union");
        sl.add("Union All");
    }

    public String normalizeUnionOperator(String unionOperator) {
        ArrayList<String> sl = new ArrayList<String>();
        this.getUnionOperatorList(sl);
        for (int i = 0; i < sl.size(); ++i) {
            if (!unionOperator.equalsIgnoreCase((String)sl.get(i))) continue;
            return (String)sl.get(i);
        }
        return unionOperator;
    }

    public Icon getUnionOperatorImage(String unionOperator) {
        if ((unionOperator = unionOperator.toUpperCase()).equals("UNION")) {
            return unionImage;
        }
        if (unionOperator.equals("UNION ALL")) {
            return unionAllImage;
        }
        if (unionOperator.equals("EXCEPT")) {
            return exceptImage;
        }
        if (unionOperator.equals("EXCEPT ALL")) {
            return exceptAllImage;
        }
        if (unionOperator.equals("INTERSECT")) {
            return intersectImage;
        }
        if (unionOperator.equals("INTERSECT ALL")) {
            return intersectAllImage;
        }
        if (unionOperator.equals("MINUS")) {
            return exceptImage;
        }
        return null;
    }

    public int findFieldInFieldList(SQLObjectColumn field, MetadataFieldList fieldList) {
        int i;
        for (i = 0; i < fieldList.getCount(); ++i) {
            if (!field.getSQLContext().isQualifiedNamesEqual(fieldList.get(i).getName(), field)) continue;
            return i;
        }
        if (field.getCount() == 1) {
            for (i = 0; i < fieldList.getCount(); ++i) {
                if (Str.IsNullOrEmpty(fieldList.get(i).getAltName()) || !fieldList.get(i).getAltName().equalsIgnoreCase(field.get(0).getToken())) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean isColumnStartsFrom(SQLObjectColumn column, ArrayList columnTokens, ArrayList objectTokens) {
        boolean result;
        boolean bl = result = columnTokens.size() > objectTokens.size();
        if (result) {
            for (int i = 0; i < objectTokens.size(); ++i) {
                boolean bl2 = result = column.getSQLContext().compareTokens((AstToken)columnTokens.get(i), (AstToken)objectTokens.get(i)) == 0;
                if (result) continue;
                return result;
            }
        }
        return result;
    }

    public int isColumnOfDBObject(SQLObjectColumn column, SQLDatabaseObject dbObject) {
        int result;
        assert (column != null);
        assert (dbObject != null);
        if (column.getCount() > 1) {
            ArrayList lo = new ArrayList();
            ArrayList lc = new ArrayList();
            ArrayList ldb = new ArrayList();
            ArrayList ltmp = new ArrayList();
            dbObject.getAllTokensToCompare(lo);
            column.getAllTokensToCompare(lc);
            if (this.isColumnStartsFrom(column, lc, lo)) {
                int result2 = lo.size();
                return result2;
            }
            column.getSQLContext().getMetadataContainer().getDefaultDatabaseName().getAllTokensToCompare(ldb);
            ltmp.addAll(ldb);
            ltmp.addAll(lc);
            if (this.isColumnStartsFrom(column, ltmp, lo)) {
                int result3 = lo.size() - ldb.size();
                return result3;
            }
            for (int i = 0; i < column.getSQLContext().getMetadataContainer().getDefaultSchemaNames().getCount(); ++i) {
                ltmp.clear();
                ltmp.addAll(ldb);
                ltmp.add(column.getSQLContext().getMetadataContainer().getDefaultSchemaNames().get(i));
                ltmp.addAll(lc);
                if (!this.isColumnStartsFrom(column, ltmp, lo)) continue;
                int result4 = lo.size() - ldb.size() - 1;
                return result4;
            }
            result = -1;
        } else {
            result = -1;
        }
        return result;
    }

    public void connectionChanged(BaseMetadataProvider metadataProvider) {
    }

    public boolean isIdentifiersCaseSensitive() {
        return this.getIdentCaseSens() == IdentCaseSensitivity.SensitiveUpperCase || this.getIdentCaseSens() == IdentCaseSensitivity.SensitiveLowerCase;
    }

    public boolean isNonQuotedIdentifiersToUpperCase() {
        return this.getIdentCaseSens() == IdentCaseSensitivity.SensitiveUpperCase;
    }

    public boolean isSupportANSIJoins() {
        return true;
    }

    public boolean isForceBinaryANSIJoins() {
        return false;
    }

    public boolean isSupportOracleJoins() {
        return false;
    }

    public boolean isSupportCrossJoin() {
        return true;
    }

    public boolean isSupportFullANSIJoin() {
        return true;
    }

    public boolean isUniversalExpressions() {
        return false;
    }

    public boolean isSupportAllTableFieldsSelection() {
        return true;
    }

    public boolean isSupportViews() {
        return true;
    }

    public boolean isSupportProcedures() {
        return false;
    }

    public boolean isSupportSynonyms() {
        return false;
    }

    public boolean isSupportUnions() {
        return true;
    }

    public boolean isSupportBracketsInUnions() {
        return true;
    }

    public boolean isSupportDerivedTables() {
        return true;
    }

    public boolean isSupportCTE() {
        return false;
    }

    public boolean isSupportRecursiveCTE() {
        return true;
    }

    public boolean isSupportSubQueryUnions() {
        return true;
    }

    public boolean isSupportSubQueryBracketsInUnions() {
        return true;
    }

    public boolean isSupportSubQueryDerivedTables() {
        return true;
    }

    public boolean isSupportSubQueryCTE() {
        return false;
    }

    public boolean isSupportDatabases() {
        return true;
    }

    public boolean isSupportSchemas() {
        return true;
    }

    public boolean isSupportEmptyBracketsInStoredProcs() {
        return true;
    }

    public boolean isSupportNullOrdering() {
        return false;
    }

    public Class getEditPropsFormClass(Object forObj) {
        return null;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        assert (sqlContext.getMetadataProvider() != null);
        sqlContext.getMetadataProvider().getDatabaseList(sqlContext, databaseList);
    }

    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        assert (sqlContext.getMetadataProvider() != null);
        sqlContext.getMetadataProvider().loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
    }

    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        assert (sqlContext.getMetadataProvider() != null);
        sqlContext.getMetadataProvider().loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
    }

    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        if (!this.isSupportDatabases()) {
            throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportDatabases", "The server does not support queries with objects from different databases."));
        }
        assert (sqlContext.getMetadataProvider() != null);
        return sqlContext.getMetadataProvider().getDefaultDatabaseName(sqlContext);
    }

    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) throws QueryBuilderException {
        if (!this.isSupportSchemas()) {
            throw new QueryBuilderException(Helpers.localizer.getString("strDialectDontSupportSchemas", "The server does not support schemas."));
        }
        assert (sqlContext.getMetadataProvider() != null);
        sqlContext.getMetadataProvider().getDefaultSchemaNames(sqlContext, defaultSchemaNames);
    }

    public String createWrapperForStoredProc(String storedProcCallExpression) {
        return storedProcCallExpression;
    }

    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select " + fieldExpression + " from " + objectExpression + " a where 0<>0";
    }

    public String getQueryToLoadFieldsForProcedure(String fieldName, String procedureExpression, String parameters) {
        if (!Str.IsNullOrEmpty(parameters) || this.isSupportEmptyBracketsInStoredProcs()) {
            return this.getQueryToLoadFieldsForObject(fieldName, this.createWrapperForStoredProc(procedureExpression + "(" + parameters + ")"));
        }
        return this.getQueryToLoadFieldsForObject(fieldName, this.createWrapperForStoredProc(procedureExpression));
    }

    public String getQueryToLoadFieldsForSynonym(String fieldName, String synonymName) {
        return this.getQueryToLoadFieldsForObject(fieldName, synonymName);
    }

    public String getQueryToLoadFieldsForTable(String fieldName, String tableName) {
        return this.getQueryToLoadFieldsForObject(fieldName, tableName);
    }

    public String getQueryToLoadFieldsForView(String fieldName, String viewName) {
        return this.getQueryToLoadFieldsForObject(fieldName, viewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateQuery(String sql, Wrapper<String> errorInfo) {
        boolean result = false;
        BaseScanner s = this.createScanner();
        s.init(sql);
        BaseSQLContext context = new BaseSQLContext(null);
        context.setSyntaxProvider(this);
        BaseParser p = this.createParser(s, context);
        WayPoint w = new WayPoint(null, 0);
        WayPointList l = new WayPointList();
        try {
            l.add(w);
            p.parseSelectWayCalc(l);
            p.expect(l, 0);
            if (l.size() != 0) {
                result = true;
            } else {
                result = false;
                Token t = p.getBadToken() != -1 ? s.getToken(p.getBadToken()) : null;
                if (errorInfo != null) {
                    errorInfo.value = String.format(Helpers.localizer.getString("strBadSelectStatement", "Invalid SELECT statement.") + "\n" + Helpers.localizer.getString("strUnexpectedTokenAt", "Unexpected token \"%1$s\" at line %2$s, pos %3$s"), t.val, t.pos.line, t.pos.col);
                }
            }
        }
        finally {
            l.clear();
        }
        return result;
    }

    public AstTokenIdentifier getEmptySchemaName(BaseSQLContext sqlContext) {
        return null;
    }

    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        return SyntaxSupportsConectedServer.Maybe;
    }

    public boolean isOuterKeywordInLinksMandatory() {
        return false;
    }

    public boolean isInnerKeywordInLinksMandatory() {
        return true;
    }

    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        names.clear();
    }

    public BaseParser createParser(BaseScanner scanner, BaseSQLContext sqlContext) {
        BaseParser result = null;
        try {
            Constructor c = this.getParserClass().getConstructor(BaseScanner.class, BaseSQLContext.class);
            result = (BaseParser)c.newInstance(scanner, sqlContext);
            this.setParserParams(result);
        }
        catch (Exception ex) {
            Logger.getLogger(BaseSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public BaseScanner createScanner() {
        BaseScanner result = null;
        try {
            result = (BaseScanner)this.getScannerClass().newInstance();
            this.setScannerParams(result);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadataForTable(BaseSQLContext sqlContext, MetadataTable metadataTable) throws QueryBuilderException {
        block15: {
            assert (sqlContext != null);
            assert (metadataTable != null);
            if (sqlContext.getMetadataProvider() != null) {
                if (sqlContext.getMetadataProvider().canExecSQL()) {
                    metadataTable.beginUpdate();
                    try {
                        metadataTable.getFields().beginUpdate();
                        try {
                            metadataTable.getFields().clear();
                            metadataTable.getFields().setLoaded(false);
                            try {
                                this.loadFieldsForTableFromServer(sqlContext, metadataTable);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                sqlContext.getMetadataProvider().loadFieldsForTableFromDriver(sqlContext, metadataTable);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            break block15;
                        }
                        finally {
                            metadataTable.getFields().endUpdate();
                        }
                    }
                    finally {
                        metadataTable.endUpdate();
                    }
                }
                sqlContext.getMetadataProvider().loadMetadataForTable(sqlContext, metadataTable);
            } else {
                throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadataForView(BaseSQLContext sqlContext, MetadataView metadataView) throws QueryBuilderException {
        block15: {
            assert (sqlContext != null);
            assert (metadataView != null);
            if (sqlContext.getMetadataProvider() != null) {
                if (sqlContext.getMetadataProvider().canExecSQL()) {
                    metadataView.beginUpdate();
                    try {
                        metadataView.getFields().beginUpdate();
                        try {
                            metadataView.getFields().clear();
                            metadataView.getFields().setLoaded(false);
                            try {
                                this.loadFieldsForViewFromServer(sqlContext, metadataView);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                sqlContext.getMetadataProvider().loadFieldsForViewFromDriver(sqlContext, metadataView);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            break block15;
                        }
                        finally {
                            metadataView.getFields().endUpdate();
                        }
                    }
                    finally {
                        metadataView.endUpdate();
                    }
                }
                sqlContext.getMetadataProvider().loadMetadataForView(sqlContext, metadataView);
            } else {
                throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadataForProcedure(BaseSQLContext sqlContext, MetadataProcedure metadataProcedure) throws QueryBuilderException {
        block23: {
            assert (sqlContext != null);
            assert (metadataProcedure != null);
            if (sqlContext.getMetadataProvider() != null) {
                if (sqlContext.getMetadataProvider().canExecSQL()) {
                    metadataProcedure.beginUpdate();
                    try {
                        metadataProcedure.getFields().beginUpdate();
                        try {
                            metadataProcedure.getFields().clear();
                            metadataProcedure.getFields().setLoaded(false);
                            try {
                                this.loadParamsForProcedureFromServer(sqlContext, metadataProcedure);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                sqlContext.getMetadataProvider().loadParamsForProcedureFromDriver(sqlContext, metadataProcedure);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        finally {
                            metadataProcedure.getFields().endUpdate();
                        }
                        metadataProcedure.getFields().beginUpdate();
                        try {
                            metadataProcedure.getFields().clear();
                            metadataProcedure.getFields().setLoaded(false);
                            try {
                                this.loadFieldsForProcedureFromServer(sqlContext, metadataProcedure);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                sqlContext.getMetadataProvider().loadFieldsForProcedureFromDriver(sqlContext, metadataProcedure);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            break block23;
                        }
                        finally {
                            metadataProcedure.getFields().endUpdate();
                        }
                    }
                    finally {
                        metadataProcedure.endUpdate();
                    }
                }
                sqlContext.getMetadataProvider().loadMetadataForProcedure(sqlContext, metadataProcedure);
            } else {
                throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
            }
        }
    }

    public void loadParamsForProcedureFromServer(BaseSQLContext sqlContext, MetadataProcedure metadataProcedure) {
    }

    public void loadFieldsForProcedureFromServer(BaseSQLContext sqlContext, MetadataProcedure metadataProcedure) throws QueryBuilderException {
        this.loadFieldsForObjectFromServer(sqlContext, metadataProcedure);
    }

    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadataForSynonym(BaseSQLContext sqlContext, MetadataSynonym metadataSynonym) throws QueryBuilderException {
        block15: {
            assert (sqlContext != null);
            assert (metadataSynonym != null);
            if (sqlContext.getMetadataProvider() != null) {
                if (sqlContext.getMetadataProvider().canExecSQL()) {
                    metadataSynonym.beginUpdate();
                    try {
                        metadataSynonym.getFields().beginUpdate();
                        try {
                            metadataSynonym.getFields().clear();
                            metadataSynonym.getFields().setLoaded(false);
                            try {
                                this.loadFieldsForSynonymFromServer(sqlContext, metadataSynonym);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                sqlContext.getMetadataProvider().loadFieldsForSynonymFromDriver(sqlContext, metadataSynonym);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            break block15;
                        }
                        finally {
                            metadataSynonym.getFields().endUpdate();
                        }
                    }
                    finally {
                        metadataSynonym.endUpdate();
                    }
                }
                sqlContext.getMetadataProvider().loadMetadataForSynonym(sqlContext, metadataSynonym);
            } else {
                throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
            }
        }
    }

    public void loadFieldsForTableFromServer(BaseSQLContext sqlContext, MetadataTable metadataTable) throws QueryBuilderException {
        this.loadFieldsForObjectFromServer(sqlContext, metadataTable);
    }

    public void loadFieldsForViewFromServer(BaseSQLContext sqlContext, MetadataView metadataView) throws QueryBuilderException {
        this.loadFieldsForObjectFromServer(sqlContext, metadataView);
    }

    public void loadFieldsForSynonymFromServer(BaseSQLContext sqlContext, MetadataSynonym metadataSynonym) throws QueryBuilderException {
        this.loadFieldsForObjectFromServer(sqlContext, metadataSynonym);
    }

    public void resetCachedDefaultDatabaseName() {
    }

    public void addChangedEventListener(ChangedEventListener listener) {
        this.changedEventListenerList.add(listener);
    }

    public void removeChangedEventListener(ChangedEventListener listener) {
        this.changedEventListenerList.remove(listener);
    }

    protected void fireChangedEvent(ChangedEvent evt) {
        Iterator<ChangedEventListener> listeners = this.changedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().changedEventOccurred(evt);
        }
    }

    public void addDestroyedEventListener(DestroyedEventListener listener) {
        this.destroyedEventListenerList.add(listener);
    }

    public void removeDestroyedEventListener(DestroyedEventListener listener) {
        this.destroyedEventListenerList.remove(listener);
    }

    protected void fireDestroyedEvent(DestroyedEvent evt) {
        Iterator<DestroyedEventListener> listeners = this.destroyedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().destroyedEventOccurred(evt);
        }
    }

    public boolean isFixedSizeType(String type) {
        return false;
    }

    public boolean isVariablePrecisionType(String typeName) {
        return typeName.compareToIgnoreCase("decimal") == 0 || typeName.compareToIgnoreCase("numeric") == 0;
    }

    public void loadFieldsForQuery(BaseSQLContext sqlContext, String query, MetadataFieldList fieldList) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (!Str.IsNullOrEmpty(query));
        assert (fieldList != null);
        if (sqlContext.getMetadataProvider() == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
        }
        sqlContext.getMetadataProvider().loadFieldsForQuery(sqlContext, query, fieldList);
    }

    public boolean isDenyIntoClause() {
        return false;
    }

    public void setDenyIntoClause(boolean value) {
    }

    public void loadMetadataCustomAggregateNames(BaseSQLContext sqlContext, MetadataContainer metadataContainer, SQLQualifiedName database) {
    }

    public boolean isAsKeywordInExpressionAliasMandatory() {
        return false;
    }

    public boolean isAsKeywordInObjectAliasMandatory() {
        return false;
    }

    public String getUpperCaseFunctionName() {
        return "upper";
    }

    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        assert (sqlContext.getMetadataProvider() != null);
        sqlContext.getMetadataProvider().getSchemaList(sqlContext, schemaList, fromDatabase);
    }

    public boolean isSupportTransactSQLJoins() {
        return false;
    }

    public boolean isSupportGroupByStar() {
        return false;
    }

    protected boolean isDetectServerVersion() {
        return this.detectServerVersion;
    }

    protected void setDetectServerVersion(boolean value) {
        this.detectServerVersion = value;
    }

    public boolean isCreateWhereJoinsByDefault() {
        return this.createWhereJoinsByDefault;
    }

    public void setCreateWhereJoinsByDefault(boolean value) {
        this.createWhereJoinsByDefault = value;
    }

    protected boolean isServerVersionStored() {
        return !this.isDetectServerVersion();
    }

    public void doDetectServerVersion(BaseMetadataProvider metadataProvider) {
        this.setDetectServerVersion(false);
    }

    public boolean isFromClauseMandatory() {
        return false;
    }

    public String getSimpleEmptyFromSubquery() {
        return "(SELECT NULL)";
    }

    public String getObjectNameSeparator() {
        return ".";
    }

    public void beginBuildWrapperForStoredProc(SQLBuilder builder, SQLBuilderSelectFormat format) {
    }

    public void endBuildWrapperForStoredProc(SQLBuilder builder, SQLBuilderSelectFormat format) {
    }

    public static interface DestroyedEventListener
    extends EventListener {
        public void destroyedEventOccurred(DestroyedEvent var1);
    }

    public class DestroyedEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public DestroyedEvent(Object source) {
            super(source);
        }
    }

    public static interface ChangedEventListener
    extends EventListener {
        public void changedEventOccurred(ChangedEvent var1);
    }

    public class ChangedEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public ChangedEvent(Object source) {
            super(source);
        }
    }
}

