/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataRelation;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLAliasObjectAlias;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderFast;
import com.adbs.ast.SQLExpressionColumn;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionOperatorBinary;
import com.adbs.ast.SQLFromClause;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLObjectColumn;
import com.adbs.ast.SQLOrderByClause;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLSelectItems;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SQLSubQuerySelectMode;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SQLWithClause;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.querybuilder.ConditionType;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.CriteriaItem;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceBase;
import com.adbs.querybuilder.DataSourceObject;
import com.adbs.querybuilder.DataSourceQuery;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.DiagramObjectAddedEvent;
import com.adbs.querybuilder.DiagramObjectAddingEvent;
import com.adbs.querybuilder.DiagramPane;
import com.adbs.querybuilder.GetProcedureParametersEvent;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkCreatedEvent;
import com.adbs.querybuilder.LinkCreatingEvent;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.MetadataPathSolver;
import com.adbs.querybuilder.ProcedureParamsDialog;
import com.adbs.querybuilder.Query;
import com.adbs.querybuilder.QueryBase;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.UnionButton;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionOperator;
import com.adbs.querybuilder.UnionSubQueryPanel;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import com.adbs.utils.Wrapper;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnionSubQuery
extends QueryBase
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private SQLSubQuerySelectMode selectMode;
    private CriteriaList criteriaList;
    private DatasourceGroup from;
    protected SQLSubQuerySelectExpression astQuery;

    public UnionSubQuery(ControlOwner owner, QueryBuilder qb) {
        super(owner, qb);
        this.from = new DatasourceGroup(this, qb);
        this.criteriaList = new CriteriaList(this, qb);
        if (this.getRootQuery().getActiveUnionSubquery() == null) {
            this.getRootQuery().setActiveUnionSubquery(this);
        }
        this.getRootQuery().registerUnionSubQuery(this);
    }

    @Override
    public void dispose() {
        this.setDisposing(true);
        SubQuery rootQuery = this.getRootQuery();
        if (this.getOwner() != null && !this.queryBuilder.isDisposing()) {
            if (rootQuery.plainUnionSubQueries.size() == 1) {
                rootQuery.setActiveUnionSubquery(null);
            } else {
                int i = rootQuery.plainUnionSubQueries.indexOf(this);
                if (i + 1 < rootQuery.plainUnionSubQueries.size()) {
                    rootQuery.setActiveUnionSubquery((UnionSubQuery)rootQuery.plainUnionSubQueries.get(i + 1));
                } else if (i > 0) {
                    rootQuery.setActiveUnionSubquery((UnionSubQuery)rootQuery.plainUnionSubQueries.get(i - 1));
                }
            }
            ((UnionGroup)this.getOwner()).items.remove(this);
        }
        rootQuery.unregisterUnionSubQuery(this);
        super.dispose();
    }

    UnionSubQueryPanel getUnionPage() {
        if (this.controls.size() >= 1) {
            return (UnionSubQueryPanel)this.controls.get(0);
        }
        return null;
    }

    DiagramPane getDiagramPane() {
        if (this.getUnionPage() != null) {
            return this.getUnionPage().getDiagramPane();
        }
        return null;
    }

    UnionButton getUnionButton() {
        if (this.controls.size() > 1) {
            return (UnionButton)this.controls.get(1);
        }
        return null;
    }

    public SQLSubQuerySelectMode getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(SQLSubQuerySelectMode value) {
        this.selectMode = value;
    }

    public CriteriaList getCriteriaList() {
        return this.criteriaList;
    }

    public DatasourceGroup getFromClause() {
        return this.from;
    }

    public SQLSubQuerySelectExpression getQueryAST() {
        return this.astQuery;
    }

    public SQLSubQuerySelectExpression getResultQueryAST() {
        return (SQLSubQuerySelectExpression)this.getResultAST();
    }

    public String getSelectListString() {
        if (this.getResultASTInternal() != null) {
            SQLSubQuerySelectExpression se = (SQLSubQuerySelectExpression)this.getResultASTInternal();
            if (se.selectItems != null) {
                return se.selectItems.getSimpleSQL(this.getSQLContext().getSQLBuilderExpression());
            }
            return "";
        }
        return "";
    }

    public String getFromClauseString() {
        if (this.getResultASTInternal() != null) {
            SQLSubQuerySelectExpression se = (SQLSubQuerySelectExpression)this.getResultASTInternal();
            if (se.from != null) {
                return se.from.getSimpleSQL(this.getSQLContext().getSQLBuilderExpression());
            }
            return "";
        }
        return "";
    }

    public String getWhereClauseString() {
        if (this.getResultASTInternal() != null) {
            SQLSubQuerySelectExpression se = (SQLSubQuerySelectExpression)this.getResultASTInternal();
            if (se.where != null) {
                return se.where.getSimpleSQL(this.getSQLContext().getSQLBuilderExpression());
            }
            return "";
        }
        return "";
    }

    public String getHavingClauseString() {
        if (this.getResultASTInternal() != null) {
            SQLSubQuerySelectExpression se = (SQLSubQuerySelectExpression)this.getResultASTInternal();
            if (se.having != null) {
                return se.having.getSimpleSQL(this.getSQLContext().getSQLBuilderExpression());
            }
            return "";
        }
        return "";
    }

    public String getGroupByClauseString() {
        if (this.getResultASTInternal() != null) {
            SQLSubQuerySelectExpression se = (SQLSubQuerySelectExpression)this.getResultASTInternal();
            if (se.groupBy != null) {
                return se.groupBy.getSimpleSQL(this.getSQLContext().getSQLBuilderExpression());
            }
            return "";
        }
        return "";
    }

    public String getOrderByClauseString() {
        SQLOrderByClause obc = this.criteriaList.getOrderByClause();
        if (obc != null) {
            return obc.getSimpleSQL(this.getSQLContext().getSQLBuilderExpression());
        }
        return "";
    }

    @Override
    public int getControlsCount() {
        return 3;
    }

    @Override
    protected Component createControlInternal(int i) {
        switch (i) {
            case 0: {
                UnionSubQueryPanel c = new UnionSubQueryPanel(this, this.getQueryBuilder());
                this.getRootQuery().getQueryPage().layeredPane.add((Component)c, "Center");
                this.controls.set(i, c);
                return c;
            }
            case 1: {
                UnionButton b = new UnionButton(this);
                b.setSelected(this.getUnionPage().getUnionSubQuery().getRootQuery().getActiveUnionSubquery() == this.getUnionPage().getUnionSubQuery());
                this.getRootQuery().getQueryPage().getUnionNavBar().add(b);
                this.controls.set(i, b);
                return b;
            }
            case 2: {
                UnionOperator o = new UnionOperator(this);
                this.getRootQuery().getQueryPage().getUnionNavBar().add(o);
                this.controls.set(i, o);
                return o;
            }
        }
        return null;
    }

    @Override
    protected void restoreControlParams(int i) {
        if (i == 0) {
            JSplitPane splitter = this.getUnionPage().getSplitter();
            if (this.queryBuilder.getCriteriaListOptions().isCriteriaListVisible()) {
                if (this.criteriaList.getCriteriaListControl() != null) {
                    splitter.setDividerSize(5);
                    if (splitter.getBottomComponent() == null) {
                        splitter.setBottomComponent(this.criteriaList.getCriteriaListControlScrollPane());
                    }
                }
            } else {
                splitter.setBottomComponent(null);
                splitter.setDividerSize(0);
                splitter.setDividerLocation(1.0);
            }
            if (this.queryBuilder.isDiagramPaneVisible()) {
                if (this.getDiagramPane() != null) {
                    splitter.setDividerSize(5);
                    if (splitter.getTopComponent() == null) {
                        splitter.setTopComponent(this.getUnionPage().getDiagramScrollPane());
                    }
                }
            } else {
                splitter.setTopComponent(null);
                splitter.setDividerSize(0);
                splitter.setDividerLocation(0.1);
            }
        } else if (i == 2) {
            this.updateUnionOperator();
        }
    }

    @Override
    protected void updateContolParams(int i) {
        super.updateContolParams(i);
        if (i == 0) {
            JSplitPane splitter = this.getUnionPage().getSplitter();
            if (this.queryBuilder.getCriteriaListOptions().isCriteriaListVisible()) {
                if (this.criteriaList.getCriteriaListControl() != null) {
                    splitter.setDividerSize(5);
                    if (splitter.getBottomComponent() == null) {
                        splitter.setBottomComponent(this.criteriaList.getCriteriaListControlScrollPane());
                    }
                    this.criteriaList.getCriteriaListControl().updateDropTarget();
                }
            } else {
                splitter.setBottomComponent(null);
                splitter.setDividerSize(0);
                splitter.setDividerLocation(1.0);
            }
            if (this.queryBuilder.isDiagramPaneVisible()) {
                if (this.getDiagramPane() != null) {
                    splitter.setDividerSize(5);
                    if (splitter.getTopComponent() == null) {
                        splitter.setTopComponent(this.getUnionPage().getDiagramScrollPane());
                    }
                    this.getDiagramPane().updateDropTarget();
                }
            } else {
                splitter.setTopComponent(null);
                splitter.setDividerSize(0);
                splitter.setDividerLocation(0.1);
            }
        }
    }

    @Override
    protected boolean makeVisible(int i) {
        return i != 0;
    }

    @Override
    UnionOperator getUnionOperatorControl() {
        if (this.controls.size() >= 3) {
            return (UnionOperator)this.controls.get(2);
        }
        return null;
    }

    public void saveLayout(Document document, Element subQuery, SQLBuilder sqlBuilder) {
        Element unionSubQuery = document.createElement("UnionSubQuery");
        subQuery.appendChild(unionSubQuery);
        if (this.getFromClause() != null) {
            this.getFromClause().saveLayout(document, unionSubQuery, sqlBuilder);
        }
        unionSubQuery = null;
    }

    public void loadLayout(Element unionSubQuery, SQLBuilder sqlBuilder) {
        if (this.getFromClause() != null) {
            this.getFromClause().loadLayout(unionSubQuery, sqlBuilder);
        }
    }

    @Override
    protected AstNode createResultAST() {
        SQLSubQuerySelectExpression se = (SQLSubQuerySelectExpression)this.astQuery.clone(this.getSQLContext());
        se.selectItems = (SQLSelectItems)this.criteriaList.getResultAST();
        assert (se.selectItems != null);
        se.from = (SQLFromClause)this.getFromClause().getResultAST();
        se.where = this.criteriaList.getConditionTree(EnumSet.of(ConditionType.Where));
        se.where = this.getFromClause().addWhereJoinConditions(se.where);
        se.groupBy = this.criteriaList.getGroupByTree();
        se.having = this.criteriaList.getConditionTree(EnumSet.of(ConditionType.Having));
        return se;
    }

    public void findTablesByDBName(SQLQualifiedName name, List ts) {
        this.from.findTablesByDBName(name, ts);
    }

    public Link findLink(DataSourceBase left, SQLQualifiedName leftField, DataSourceBase right, SQLQualifiedName rightField) {
        return this.from.findLink(left, leftField, right, rightField);
    }

    public DataSource addObject(String name, String alias) throws QueryBuilderException {
        return this.addObjectAt(name, new Point(0, 0), alias);
    }

    public DataSource addObject(String name) throws QueryBuilderException {
        return this.addObject(name, "");
    }

    public DataSource addObject(SQLQualifiedName name, AstTokenIdentifier alias) throws QueryBuilderException {
        return this.addObjectAt(name, new Point(0, 0), alias);
    }

    public DataSource addObject(SQLQualifiedName name) throws QueryBuilderException {
        return this.addObject(name, null);
    }

    public DataSource addObject(MetadataObject metadataObject, AstTokenIdentifier alias) throws QueryBuilderException {
        return this.addObjectAt(metadataObject, new Point(0, 0), alias);
    }

    public DataSource addObject(MetadataObject metadataObject) throws QueryBuilderException {
        return this.addObject(metadataObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource addObjectAt(String name, Point pos, String alias) throws QueryBuilderException {
        DataSource result = null;
        assert (this.getQueryBuilder() != null);
        if (this.getSQLContext().getSyntaxProvider() != null) {
            try {
                SQLQualifiedName parsedName = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
                try {
                    AstTokenIdentifier parsedAlias = null;
                    if (!Str.IsNullOrEmpty(alias)) {
                        parsedAlias = this.sqlContext.parseIdentifierQuoteIfNeed(alias);
                    }
                    result = this.addObjectAt(parsedName, pos, parsedAlias);
                }
                finally {
                    parsedName.dispose();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(UnionSubQuery.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        return result;
    }

    public DataSource addObjectAt(String name, Point pos) throws QueryBuilderException {
        return this.addObjectAt(name, pos, "");
    }

    public DataSource addObjectAt(SQLQualifiedName name, Point pos, AstTokenIdentifier alias) throws QueryBuilderException {
        assert (name != null);
        assert (this.getQueryBuilder() != null);
        MetadataObject mo = this.sqlContext.getMetadataContainer().findObjectByFullName(name);
        if (mo == null && name.getCount() == 1) {
            String altName = name.get(0).getToken();
            mo = this.sqlContext.getMetadataContainer().findObjectByAltName(altName);
        }
        if (mo != null) {
            return this.addObjectAt(mo, pos, alias);
        }
        return this.addDataSourceHelper(this.sqlContext.createSQLFromObject(name, alias), pos, DataSourceObject.class);
    }

    public DataSource addObjectAt(SQLQualifiedName name, Point pos) throws QueryBuilderException {
        return this.addObjectAt(name, pos, null);
    }

    public DataSource addObjectAt(MetadataObject metadataObject, Point pos, AstTokenIdentifier alias) throws QueryBuilderException {
        assert (metadataObject != null);
        assert (this.getQueryBuilder() != null);
        if (metadataObject instanceof MetadataProcedure) {
            DataSource result = null;
            Wrapper<Object> parameters = new Wrapper<Object>(null);
            Wrapper<String> aliasString = new Wrapper<String>("");
            if (alias != null) {
                aliasString.value = alias.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
                alias.dispose();
            }
            GetProcedureParametersEvent evt = new GetProcedureParametersEvent(this.queryBuilder, metadataObject.getFullNameStr(), parameters, aliasString);
            this.queryBuilder.fireGetProcedureParametersEvent(evt);
            if (evt.abort) {
                return null;
            }
            if (parameters.value != null) {
                String fromExpression = this.sqlContext.getSyntaxProvider().createWrapperForStoredProc(metadataObject.getFullNameStr() + "(" + parameters + ")");
                result = this.addFromExpression(fromExpression, (String)aliasString.value);
            } else {
                ProcedureParamsDialog dlg = new ProcedureParamsDialog(SwingUtilities.getWindowAncestor(this.getQueryBuilder()));
                if (dlg.showDialog(metadataObject.getFullNameStr())) {
                    String fromExpression = this.sqlContext.getSyntaxProvider().createWrapperForStoredProc(dlg.getResultExpression());
                    result = this.addFromExpression(fromExpression, (String)aliasString.value);
                }
            }
            return result;
        }
        return this.addDataSourceHelper(this.sqlContext.createSQLFromObject(metadataObject, alias), pos, DataSourceObject.class);
    }

    public DataSource addObjectAt(MetadataObject metadataObject, Point pos) throws QueryBuilderException {
        return this.addObjectAt(metadataObject, pos, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource addDataSourceHelper(SQLFromSource fromSource, Point pos, Class datasourceClass) throws QueryBuilderException {
        DataSource result = null;
        ArrayList lCTE = new ArrayList();
        ArrayList lFromObj = new ArrayList();
        assert (this.getQueryBuilder() != null);
        assert (fromSource != null);
        if (this.getQueryBuilder().getSyntaxProvider() != null) {
            fromSource.restoreColumnPrefixRecursive(true);
            this.gatherPrepareAndFixupContext(lCTE, lFromObj, false);
            fromSource.prepareAndFixupRecursive(lCTE, lFromObj);
            AstTokenIdentifier baseName = this.getFromSourceBaseName(fromSource);
            try {
                if (baseName == null || !this.isUniqueAlias(baseName)) {
                    String baseAlias = baseName != null ? (fromSource.getMetadataObject() != null && !Str.IsNullOrEmpty(fromSource.getMetadataObject().getAltName()) ? fromSource.getMetadataObject().getAltName() : baseName.getToken()) : "Object";
                    AstTokenIdentifier currentAlias = this.createUniqueAlias(baseAlias);
                    if (fromSource.alias != null) {
                        fromSource.alias.dispose();
                        fromSource.alias = null;
                    }
                    fromSource.alias = new SQLAliasObjectAlias(this.sqlContext);
                    fromSource.alias.alias = currentAlias;
                }
                try {
                    DiagramObjectAddingEvent e = new DiagramObjectAddingEvent(fromSource, pos);
                    this.getQueryBuilder().fireDiagramObjectAddingEvent(e);
                    if (!e.abort) {
                        lCTE = new ArrayList();
                        lFromObj = new ArrayList();
                        fromSource.restoreColumnPrefixRecursive(true);
                        this.gatherPrepareAndFixupContext(lCTE, lFromObj, false);
                        fromSource.prepareAndFixupRecursive(lCTE, lFromObj);
                    }
                    if (!e.abort) {
                        this.getFromClause().beginUpdate();
                        try {
                            try {
                                Constructor c = datasourceClass.getConstructor(DatasourceGroup.class, DatasourceGroup.class, QueryBuilder.class);
                                result = (DataSource)c.newInstance(this.getFromClause(), this.getFromClause(), this.getQueryBuilder());
                            }
                            catch (Exception ex) {
                                Logger.getLogger(UnionSubQuery.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            result.loadFromAST(fromSource);
                            fromSource = null;
                            if (pos.x == 0 && pos.y == 0) {
                                result.setLeft(0);
                                result.setTop(0);
                            } else {
                                Point clientPos = new Point(pos);
                                result.setLeft(clientPos.x);
                                result.setTop(clientPos.y);
                            }
                        }
                        finally {
                            this.getFromClause().endUpdate();
                        }
                        if (this.isControlsCreated() && result.canCreateControls()) {
                            result.createControls();
                        }
                        this.getQueryBuilder().fireDiagramObjectAddedEvent(new DiagramObjectAddedEvent(this, result));
                    }
                    result = null;
                }
                finally {
                    if (fromSource != null) {
                        fromSource.dispose();
                    }
                }
            }
            finally {
                baseName.dispose();
            }
        } else {
            throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUniqueAlias(AstTokenIdentifier alias) {
        boolean result = true;
        DatasourceGroup fromClause = this.getFromClause();
        if (fromClause != null && fromClause.getCount() > 0) {
            ArrayList lDatasources = new ArrayList();
            fromClause.getDatasourceByClass(DataSource.class, lDatasources);
            for (int i = 0; i < lDatasources.size(); ++i) {
                DataSource ds = (DataSource)lDatasources.get(i);
                AstTokenIdentifier baseName = this.getFromSourceBaseName(ds.getDatasourceAST());
                if (baseName != null) {
                    try {
                        result = this.sqlContext.compareIdentifiers(alias, baseName) != 0;
                    }
                    finally {
                        baseName.dispose();
                    }
                }
                if (!result) break;
            }
        }
        return result;
    }

    public AstTokenIdentifier createUniqueAlias(String prefix) {
        AstTokenIdentifier result = new AstTokenIdentifier(this.sqlContext);
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String tmp = i > 0 ? prefix + String.valueOf(i) : prefix;
            result.setToken(tmp);
            if (this.isUniqueAlias(result)) break;
        }
        return result;
    }

    public DataSource addStoredProc(String name, String alias) {
        return this.addStoredProcAt(name, new Point(0, 0), alias);
    }

    public DataSource addStoredProc(SQLQualifiedName name, AstTokenIdentifier alias) {
        return this.addStoredProcAt(name, new Point(0, 0), alias);
    }

    public DataSource addStoredProcAt(String name, Point pos, String alias) throws QueryBuilderException {
        DataSource result;
        assert (this.getQueryBuilder() != null);
        try {
            SQLQualifiedName n = this.getSQLContext().parseQualifiedNameQuoteIfNeed(name);
            if (n == null) {
                throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
            }
            AstTokenIdentifier a = !Str.IsNullOrEmpty(alias) ? this.getSQLContext().parseIdentifierQuoteIfNeed(alias) : null;
            result = this.addStoredProcAt(n, pos, a);
        }
        catch (ParsingException ex) {
            throw new QueryBuilderException("UninSubQuery.addStoredProcAt() failed.\n" + ex.getMessage(), ex);
        }
        return result;
    }

    public DataSource addStoredProcAt(SQLQualifiedName name, Point pos, AstTokenIdentifier alias) {
        DataSource result = null;
        Wrapper<Object> parameters = new Wrapper<Object>(null);
        Wrapper<String> aliasString = new Wrapper<String>("");
        if (alias != null) {
            aliasString.value = alias.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
            alias.dispose();
        }
        GetProcedureParametersEvent evt = new GetProcedureParametersEvent(this.queryBuilder, name.getQualifiedName(), parameters, aliasString);
        this.queryBuilder.fireGetProcedureParametersEvent(evt);
        if (evt.abort) {
            return null;
        }
        if (parameters != null) {
            String fromExpression = this.sqlContext.getSyntaxProvider().createWrapperForStoredProc(name.getQualifiedName() + "(" + parameters + ")");
            result = this.addFromExpression(fromExpression, (String)aliasString.value);
        } else {
            ProcedureParamsDialog dlg = new ProcedureParamsDialog(SwingUtilities.getWindowAncestor(this.getQueryBuilder()));
            if (dlg.showDialog(name.getQualifiedName())) {
                String fromExpression = this.sqlContext.getSyntaxProvider().createWrapperForStoredProc(dlg.getResultExpression());
                result = this.addFromExpression(fromExpression, (String)aliasString.value);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource addObjectWithFK(String name, String alias) throws QueryBuilderException {
        DataSource result = null;
        this.beginUpdate();
        try {
            result = this.addObject(name, alias);
            this.addFKLinksForObject(result);
            if (this.queryBuilder.getLinkOptions().isCreateLinksByIdenticalFieldNames()) {
                this.addIdenticalFieldsLinksForObject((DataSourceObject)result);
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource addObjectWithFK(SQLQualifiedName name, AstTokenIdentifier alias) throws QueryBuilderException {
        DataSource result;
        this.beginUpdate();
        try {
            result = this.addObject(name, alias);
            this.addFKLinksForObject(result);
            if (this.queryBuilder.getLinkOptions().isCreateLinksByIdenticalFieldNames()) {
                this.addIdenticalFieldsLinksForObject((DataSourceObject)result);
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource addObjectWithFKAt(String name, Point pos, String alias) throws QueryBuilderException {
        DataSource result;
        this.beginUpdate();
        try {
            result = this.addObjectAt(name, pos, alias);
            this.addFKLinksForObject(result);
            if (this.queryBuilder.getLinkOptions().isCreateLinksByIdenticalFieldNames()) {
                this.addIdenticalFieldsLinksForObject((DataSourceObject)result);
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource addObjectWithFKAt(SQLQualifiedName name, Point pos, AstTokenIdentifier alias) throws QueryBuilderException {
        DataSource result;
        this.beginUpdate();
        try {
            result = this.addObjectAt(name, pos, alias);
            this.addFKLinksForObject(result);
            if (this.queryBuilder.getLinkOptions().isCreateLinksByIdenticalFieldNames()) {
                this.addIdenticalFieldsLinksForObject((DataSourceObject)result);
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public DataSource addFromExpression(String expression, String alias) throws QueryBuilderException {
        return this.addFromExpressionAt(expression, new Point(0, 0), alias);
    }

    public DataSource addFromExpressionAt(String expression, Point pos, String alias) throws QueryBuilderException {
        DataSource result;
        assert (this.getQueryBuilder() != null);
        try {
            SQLFromSource fo = this.getSQLContext().parseDatasource(expression);
            if (fo == null) {
                throw new QueryBuilderException(Helpers.localizer.getString("strBadFromObjectExpression", "Invalid FROM object expression"));
            }
            AstTokenIdentifier a = !Str.IsNullOrEmpty(alias) ? this.getSQLContext().parseIdentifierQuoteIfNeed(alias) : null;
            result = this.addFromExpressionAt(fo, pos, a);
        }
        catch (ParsingException ex) {
            throw new QueryBuilderException("UninSubQuery.addFromExpressionAt() failed.\n" + ex.getMessage(), ex);
        }
        return result;
    }

    public DataSource addFromExpression(SQLFromSource fromSource, AstTokenIdentifier alias) throws QueryBuilderException {
        return this.addFromExpressionAt(fromSource, new Point(0, 0), alias);
    }

    public DataSource addFromExpressionAt(SQLFromSource fromSource, Point pos, AstTokenIdentifier alias) throws QueryBuilderException {
        DataSource result;
        if (this.getQueryBuilder() != null && this.getQueryBuilder().getSyntaxProvider() != null) {
            if (alias != null) {
                if (fromSource.alias == null) {
                    fromSource.alias = new SQLAliasObjectAlias(this.getSQLContext());
                }
                fromSource.alias.alias = alias.clone(this.getSQLContext());
            }
            result = fromSource instanceof SQLFromObject ? this.addDataSourceHelper(fromSource, pos, DataSourceObject.class) : (fromSource instanceof SQLFromQuery ? this.addDataSourceHelper(fromSource, pos, DataSourceQuery.class) : this.addDataSourceHelper(fromSource, pos, DataSource.class));
        } else {
            result = null;
        }
        return result;
    }

    private int addFKLinksInternal(DataSource key, DataSource child) {
        int result = 0;
        MetadataObject mk = key.getMetadataObject();
        if (mk == null) {
            return result;
        }
        for (int i = 0; i < mk.getRelations().getCount(); ++i) {
            int k;
            MetadataRelation fk = mk.getRelations().get(i);
            MetadataObject mc = child.getMetadataObject();
            if (mc == null || !this.getSQLContext().isQualifiedNamesEqual(mc.getFullName(), fk.getChildTable())) continue;
            ++result;
            ArrayList<SQLQualifiedName> keyFields = new ArrayList<SQLQualifiedName>();
            if (fk.getKeyFields().getCount() == 0) {
                for (k = 0; k < mk.getFields().getCount(); ++k) {
                    MetadataField field = mk.getFields().get(k);
                    if (!field.isPrimaryKey()) continue;
                    keyFields.add(field.getName());
                }
            } else {
                for (k = 0; k < fk.getKeyFields().getCount(); ++k) {
                    keyFields.add(fk.getKeyFields().get(k));
                }
            }
            int fieldsToProcess = keyFields.size();
            if (fk.getChildFields().getCount() < fieldsToProcess) {
                fieldsToProcess = fk.getChildFields().getCount();
            }
            for (int k2 = 0; k2 < fieldsToProcess; ++k2) {
                boolean abort = false;
                int ki = key.getFields().findFieldByName((SQLQualifiedName)keyFields.get(k2));
                int ci = child.getFields().findFieldByName(fk.getChildFields().get(k2));
                LinkCreatingEvent creatingEvent = new LinkCreatingEvent(this.queryBuilder, this, key, key.getFields().get(ki), child, child.getFields().get(ci), fk);
                this.queryBuilder.fireLinkCreatingEvent(creatingEvent);
                if (creatingEvent.abort) continue;
                Link link = this.addLink(key, (SQLQualifiedName)keyFields.get(k2), child, fk.getChildFields().get(k2));
                LinkCreatedEvent createdEvent = new LinkCreatedEvent(this.queryBuilder, link);
                this.queryBuilder.fireLinkCreatedEvent(createdEvent);
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFKLinksForObject(DataSource datasource) {
        int result;
        if (this.getQueryBuilder() != null) {
            datasource.beginUpdate();
            try {
                DataSourceObject t;
                int i;
                result = 0;
                ArrayList ts = new ArrayList();
                datasource.getQuery().getFromClause().getDatasourceByClass(DataSourceObject.class, ts);
                ts.remove(datasource);
                for (i = 0; i < ts.size(); ++i) {
                    t = (DataSourceObject)ts.get(i);
                    result += this.addFKLinksInternal(datasource, t);
                }
                for (i = 0; i < ts.size(); ++i) {
                    t = (DataSourceObject)ts.get(i);
                    result += this.addFKLinksInternal(t, datasource);
                }
            }
            finally {
                datasource.endUpdate();
            }
        } else {
            result = 0;
        }
        return result;
    }

    private SQLExpressionColumn createExpressionColumn(DataSource ds, SQLQualifiedName field) {
        int i;
        SQLExpressionColumn result = new SQLExpressionColumn(this.getSQLContext());
        result.column = new SQLObjectColumn(this.getSQLContext());
        result.column.assign(field);
        result.column.datasource = ds.astFromSource;
        if (result.column.datasource != null && (i = this.getSQLContext().getSyntaxProvider().findFieldInFieldList(result.column, result.column.datasource.getFieldList())) != -1) {
            result.column.assign(result.column.datasource.getFieldList().get(i).getName());
            result.column.setMetadataField(result.column.datasource.getFieldList().get(i));
        }
        return result;
    }

    public Link addLink(DataSource leftDatasource, String leftField, DataSource rightDatasource, String rightField) {
        return this.addLink(leftDatasource, leftField, rightDatasource, rightField, this.useANSIJoins() ? LinkPlace.From : LinkPlace.Where);
    }

    public Link addLink(DataSource leftDatasource, String leftField, DataSource rightDatasource, String rightField, LinkPlace place) {
        SQLQualifiedName left = this.getSQLContext().parseQualifiedNameQuoteIfNeed(leftField);
        if (left == null) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strBadFieldName", "Invalid field name: \"%1$s\""), leftField));
        }
        SQLQualifiedName right = this.getSQLContext().parseQualifiedNameQuoteIfNeed(rightField);
        if (right == null) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strBadFieldName", "Invalid field name: \"%1$s\""), rightField));
        }
        return this.addLink(leftDatasource, left, rightDatasource, right, place);
    }

    public Link addLink(DataSource leftDatasource, SQLQualifiedName leftField, DataSource rightDatasource, SQLQualifiedName rightField) {
        return this.addLink(leftDatasource, leftField, rightDatasource, rightField, this.useANSIJoins() ? LinkPlace.From : LinkPlace.Where);
    }

    public Link addLink(DataSource leftDatasource, SQLQualifiedName leftField, DataSource rightDatasource, SQLQualifiedName rightField, LinkPlace place) {
        SQLExpressionOperatorBinary eob = new SQLExpressionOperatorBinary(this.sqlContext, "=");
        eob.lExpression = this.createExpressionColumn(leftDatasource, leftField);
        eob.rExpression = this.createExpressionColumn(rightDatasource, rightField);
        return this.addLink(leftDatasource, rightDatasource, eob, place);
    }

    public Link addLink(DataSource leftDatasource, DataSource rightDatasource, String expression) {
        return this.addLink(leftDatasource, rightDatasource, expression, this.useANSIJoins() ? LinkPlace.From : LinkPlace.Where);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Link addLink(DataSource leftDatasource, DataSource rightDatasource, String expression, LinkPlace place) {
        this.beginUpdate();
        try {
            SQLExpressionItem newExpr = this.sqlContext.parseLogicalExpression(expression, true);
            Link link = this.addLink(leftDatasource, rightDatasource, newExpr, place);
            return link;
        }
        finally {
            this.endUpdate();
        }
    }

    public Link addLink(DataSource leftDatasource, DataSource rightDatasource, SQLExpressionItem parsedExpression) {
        return this.addLink(leftDatasource, rightDatasource, parsedExpression, this.useANSIJoins() ? LinkPlace.From : LinkPlace.Where);
    }

    public Link addLink(DataSource leftDatasource, DataSource rightDatasource, SQLExpressionItem parsedExpression, LinkPlace place) {
        assert (leftDatasource != null);
        assert (rightDatasource != null);
        assert (parsedExpression != null);
        ArrayList lCTE = new ArrayList();
        ArrayList lFromObj = new ArrayList();
        parsedExpression.restoreColumnPrefixRecursive(true);
        this.gatherPrepareAndFixupContext(lCTE, lFromObj, true);
        parsedExpression.prepareAndFixupRecursive(lCTE, lFromObj);
        Link result = this.getFromClause().addLinkAST(leftDatasource, rightDatasource, null, parsedExpression, place, true);
        if (this.isControlsCreated() && result.canCreateControls()) {
            result.createControls();
        }
        if (result.getLinkControl() != null) {
            result.getLinkControl().reAlign();
            this.getDiagramPane().invalidate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAST(SQLSubQuerySelectExpression subQuery) {
        Wrapper haveWhereJoins = new Wrapper();
        super.loadFromAST(subQuery);
        this.astQuery = subQuery;
        this.beginUpdate();
        try {
            if (this.astQuery.from != null) {
                this.from.loadFromAST(this.astQuery.from);
                this.astQuery.from = null;
                this.criteriaList.loadCriteriaListFromAST(this.astQuery.selectItems);
                this.criteriaList.startConditionsLoading();
                this.astQuery.selectItems = null;
                this.from.loadJoins();
                if (this.sqlContext.getSyntaxProvider() != null && this.queryBuilder.isLoadJoinsFromWhereClause()) {
                    this.astQuery.where = this.from.loadWhereJoins(this.astQuery.where);
                }
            } else {
                this.criteriaList.loadCriteriaListFromAST(this.astQuery.selectItems);
                this.criteriaList.startConditionsLoading();
                this.astQuery.selectItems = null;
            }
            this.criteriaList.loadGroupByListFromAST(this.astQuery.groupBy);
            this.astQuery.groupBy = null;
            if (this.astQuery.where != null) {
                this.criteriaList.loadConditionFromAST(this.astQuery.where, ConditionType.Where);
                this.astQuery.where = null;
            }
            if (this.astQuery.having != null) {
                this.criteriaList.loadConditionFromAST(this.astQuery.having, ConditionType.Having);
                this.astQuery.having = null;
            }
            this.criteriaList.finalizeLoading();
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        UnionGroup parentQuery = this.getParentQuery();
        boolean enabled = parentQuery.getParentQuery() != null || parentQuery.indexOf(this) > 0;
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strMoveBackward", "Move left"));
        item.setActionCommand("move backward");
        item.addActionListener(this);
        item.setEnabled(enabled);
        menu.add(item);
        enabled = parentQuery.getParentQuery() != null || parentQuery.indexOf(this) < parentQuery.getCount() - 1;
        item = new JMenuItem(Helpers.localizer.getString("strMoveForward", "Move right"));
        item.setActionCommand("move forward");
        item.addActionListener(this);
        item.setEnabled(enabled);
        menu.add(item);
        menu.addSeparator();
        for (JMenuItem mi : this.createUnionPopupMenu()) {
            menu.add(mi);
        }
        return menu;
    }

    public JPopupMenu getPopupMenuWA() {
        JMenu submenu;
        QueryBuilder qb = this.getQueryBuilder();
        BaseSyntaxProvider syntax = this.sqlContext.getSyntaxProvider();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strAddObject", "Add object"));
        item.setActionCommand("add object");
        item.addActionListener(this);
        menu.add(item);
        boolean enabled = syntax != null ? (this.getRootQuery().isMainQuery() ? syntax.isSupportDerivedTables() : syntax.isSupportSubQueryDerivedTables()) : false;
        item = new JMenuItem(Helpers.localizer.getString("strAddSubQuery", "Add derived table"));
        item.setActionCommand("add subquery");
        item.addActionListener(this);
        item.setEnabled(enabled);
        menu.add(item);
        enabled = syntax != null ? syntax.isSupportCTE() : false;
        if (enabled) {
            submenu = new JMenu(Helpers.localizer.getString("strAddCTE", "Add Common Table Expression"));
            menu.add(submenu);
            item = new JMenuItem(Helpers.localizer.getString("strAddNewCTE", "Add New Common Table Expression"));
            item.setActionCommand("add new cte");
            item.addActionListener(this);
            item.setEnabled(enabled);
            submenu.add(item);
            SQLWithClause withClause = this.getQueryBuilder().getQuery().getASTSubQuery().withClause;
            if (withClause != null) {
                int maxIndex = withClause.getCount() - 1;
                if (this.getRootQuery().isSubQueryCTE()) {
                    maxIndex = this.getRootQuery().getSubQueryCTEIndex();
                    if (!this.sqlContext.getSyntaxProvider().isSupportRecursiveCTE() || this == this.getRootQuery().firstSelect()) {
                        --maxIndex;
                    }
                }
                for (int i = 0; i <= maxIndex; ++i) {
                    SQLWithClauseItem withClauseItem = (SQLWithClauseItem)withClause.get(i);
                    String withClauseItemName = withClauseItem.name.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
                    item = new CustomMenuItem(withClauseItemName);
                    item.setActionCommand("add existing cte");
                    item.addActionListener(this);
                    item.setEnabled(enabled);
                    ((CustomMenuItem)item).tag = withClauseItem;
                    submenu.add(item);
                }
            }
        }
        submenu = new JMenu(Helpers.localizer.getString("strUnionSubMenu", "Union"));
        menu.add(submenu);
        for (JMenuItem mi : this.createUnionPopupMenu()) {
            submenu.add(mi);
        }
        boolean bl = enabled = syntax != null;
        if (enabled) {
            Class c = syntax.getEditPropsFormClass(this);
            enabled = c != null;
        }
        menu.addSeparator();
        item = new JMenuItem(Helpers.localizer.getString("strEdit", "Properties"));
        item.setActionCommand("edit");
        item.addActionListener(this);
        item.setEnabled(enabled);
        item.setFont(item.getFont().deriveFont(1));
        menu.add(item);
        return menu;
    }

    protected List<JMenuItem> createUnionPopupMenu() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        boolean enabled = this.getSQLContext().getSyntaxProvider() != null ? (this.getRootQuery().isSubQuery() ? this.getQueryBuilder().getSyntaxProvider().isSupportSubQueryUnions() : this.getQueryBuilder().getSyntaxProvider().isSupportUnions()) : false;
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strNewUnionSubQuery", "New union sub-query"));
        item.setActionCommand("new union subquery");
        item.addActionListener(this);
        item.setEnabled(enabled);
        items.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strCopyToNewUnionSubQuery", "Copy union sub-query"));
        item.setActionCommand("copy union subquery");
        item.addActionListener(this);
        item.setEnabled(enabled);
        items.add(item);
        enabled = this.getSQLContext().getSyntaxProvider() != null ? (this.getRootQuery().isSubQuery() ? this.getQueryBuilder().getSyntaxProvider().isSupportSubQueryBracketsInUnions() : this.getQueryBuilder().getSyntaxProvider().isSupportBracketsInUnions()) : false;
        item = new JMenuItem(Helpers.localizer.getString("strEncloseWithBrackets", "Enclose with brackets"));
        item.setActionCommand("enclose with brackets");
        item.addActionListener(this);
        item.setEnabled(enabled);
        items.add(item);
        enabled = this.getRootQuery().plainUnionSubQueries.size() > 1;
        item = new JMenuItem(Helpers.localizer.getString("strRemove", "Remove"));
        item.setActionCommand("remove");
        item.addActionListener(this);
        item.setEnabled(enabled);
        items.add(item);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("move backward")) {
            UnionGroup parentQuery = this.getParentQuery();
            int i = parentQuery.indexOf(this);
            if (i > 0) {
                if (parentQuery.get(i - 1) instanceof UnionGroup) {
                    UnionGroup ng = (UnionGroup)parentQuery.get(i - 1);
                    ng.addToEnd(this);
                } else {
                    parentQuery.beginUpdate();
                    try {
                        if (i - 1 == 0) {
                            this.getParentQuery().get(i - 1).setUnionOperatorFull(this.getUnionOperatorFull());
                        }
                        parentQuery.moveItem(i, i - 1);
                    }
                    finally {
                        parentQuery.endUpdate();
                    }
                    this.getRootQuery().updateUnionSubQueriesOrder();
                }
                this.getRootQuery().requestAlignUnionNavbar();
            } else if (parentQuery.getParentQuery() != null) {
                UnionGroup oldGroup = this.getParentQuery();
                this.setUnionOperatorFull(oldGroup.getUnionOperatorFull());
                parentQuery.removeFromBegin(this);
                if (oldGroup.getCount() == 0) {
                    oldGroup.dispose();
                }
                this.getRootQuery().requestAlignUnionNavbar();
            }
        } else if (action.equals("move forward")) {
            UnionGroup parentQuery = this.getParentQuery();
            int i = parentQuery.indexOf(this);
            if (i < parentQuery.getCount() - 1) {
                if (parentQuery.get(i + 1) instanceof UnionGroup) {
                    UnionGroup ng = (UnionGroup)parentQuery.get(i + 1);
                    if (ng.getCount() > 0) {
                        ng.get(0).setUnionOperatorFull(ng.getUnionOperatorFull());
                    }
                    ng.addToBegin(this);
                } else {
                    parentQuery.beginUpdate();
                    try {
                        if (i == 0) {
                            this.setUnionOperatorFull(this.getParentQuery().get(1).getUnionOperatorFull());
                        }
                        parentQuery.moveItem(i, i + 1);
                    }
                    finally {
                        parentQuery.endUpdate();
                    }
                    this.getRootQuery().updateUnionSubQueriesOrder();
                }
                this.getRootQuery().requestAlignUnionNavbar();
            } else if (parentQuery.getParentQuery() != null) {
                UnionGroup oldGroup = this.getParentQuery();
                parentQuery.removeFromEnd(this);
                if (oldGroup.getCount() == 0) {
                    oldGroup.dispose();
                }
                this.getRootQuery().requestAlignUnionNavbar();
            }
        } else if (action.equals("add object")) {
            this.getQueryBuilder().showAddObjectDialog();
        } else if (action.equals("add subquery")) {
            this.from.beginUpdate();
            try {
                SQLFromQuery sq = new SQLFromQuery(this.sqlContext);
                sq.alias = new SQLAliasObjectAlias(this.sqlContext);
                sq.alias.alias = this.queryBuilder.createUniqueQueryName();
                sq.subQuery = new SQLSubSelectStatement(this.sqlContext);
                SQLSubQuerySelectExpression sqs = new SQLSubQuerySelectExpression(this.sqlContext);
                sq.subQuery.add(sqs);
                sqs.selectItems = new SQLSelectItems(this.sqlContext);
                sqs.from = new SQLFromClause(this.sqlContext);
                try {
                    this.addDataSourceHelper(sq, new Point(0, 0), DataSourceQuery.class);
                }
                catch (QueryBuilderException ex) {
                    Logger.getLogger(UnionSubQuery.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            finally {
                this.from.endUpdate();
            }
        } else if (action.equals("edit")) {
            this.editProps(SwingUtilities.getWindowAncestor(this.getQueryBuilder()));
        } else if (action.equals("new union subquery")) {
            UnionGroup parentQuery = this.getParentQuery();
            parentQuery.beginUpdate();
            try {
                try {
                    UnionSubQuery usq = parentQuery.add();
                    this.getRootQuery().setActiveUnionSubquery(usq);
                }
                catch (QueryBuilderException ex) {
                    Logger.getLogger(UnionSubQuery.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            finally {
                parentQuery.endUpdate();
            }
            this.getDiagramPane().doLayout();
            this.getRootQuery().requestAlignUnionNavbar();
        } else if (action.equals("copy union subquery")) {
            this.getParentQuery().beginUpdate();
            try {
                UnionSubQuery usq = this.getParentQuery().add();
                SQLSubQuerySelectExpression usqAst = this.getResultQueryAST();
                usqAst.restoreColumnPrefixRecursive(true);
                ArrayList lCTE = new ArrayList();
                ArrayList lFromObj = new ArrayList();
                this.gatherPrepareAndFixupContext(lCTE, lFromObj, false);
                usqAst.prepareAndFixupRecursive(lCTE, lFromObj);
                usq.loadFromAST(usqAst);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document doc = parser.newDocument();
                Element root = doc.createElement("root");
                SQLBuilderFast tmpSQLBuilder = new SQLBuilderFast(null);
                try {
                    tmpSQLBuilder.assign(this.sqlContext.getSQLBuilderExpressionForServer());
                    tmpSQLBuilder.setExpandVirtualFields(false);
                    tmpSQLBuilder.setExpandVirtualObjects(false);
                    this.saveLayout(doc, root, tmpSQLBuilder);
                    Element unionSubQuery = (Element)root.getFirstChild();
                    usq.loadLayout(unionSubQuery, tmpSQLBuilder);
                }
                finally {
                    tmpSQLBuilder.dispose();
                }
                this.getRootQuery().setActiveUnionSubquery(usq);
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.getParentQuery().endUpdate();
            }
        } else if (action.equals("enclose with brackets")) {
            UnionGroup parentQuery = this.getParentQuery();
            this.beginUpdate();
            try {
                try {
                    UnionGroup ug = parentQuery.addGroup();
                    parentQuery.moveItem(parentQuery.indexOf(ug), parentQuery.indexOf(this));
                    this.setParentQuery(ug);
                    ug.setUnionOperator(this.getUnionOperatorFull());
                }
                catch (QueryBuilderException ex) {
                    Logger.getLogger(UnionSubQuery.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            finally {
                this.endUpdate();
            }
            this.getDiagramPane().doLayout();
            this.getRootQuery().requestAlignUnionNavbar();
        } else if (action.equals("remove")) {
            UnionGroup oldGroup = this.getParentQuery();
            this.dispose();
            if (oldGroup.getCount() == 0) {
                oldGroup.dispose();
            }
            this.getRootQuery().requestAlignUnionNavbar();
        } else if (action.equals("add new cte")) {
            Query targetSubQuery = this.getQueryBuilder().getQuery();
            SQLQualifiedName qn = new SQLQualifiedName(this.sqlContext);
            try {
                AstTokenIdentifier withClauseItemName = this.queryBuilder.createUniqueQueryName();
                qn.add(withClauseItemName);
                if (this.getRootQuery().isSubQueryCTE()) {
                    int index = this.getRootQuery().getSubQueryCTEIndex();
                    targetSubQuery.insertNewCTE(index, null, withClauseItemName);
                } else {
                    targetSubQuery.addNewCTE(null, withClauseItemName);
                }
                if (this.isUniqueAlias(withClauseItemName)) {
                    this.addObject(qn);
                }
                String withClauseItemNameStr = withClauseItemName.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
                AstTokenIdentifier alias = this.createUniqueAlias(withClauseItemNameStr);
                try {
                    this.addObject(qn, alias);
                }
                finally {
                    alias.dispose();
                }
            }
            finally {
                qn.dispose();
            }
        } else if (action.equals("add existing cte")) {
            SQLWithClauseItem withClauseItem = (SQLWithClauseItem)((CustomMenuItem)e.getSource()).tag;
            AstTokenIdentifier withClauseItemName = withClauseItem.name;
            SQLQualifiedName qn = new SQLQualifiedName(this.sqlContext);
            try {
                qn.add(withClauseItemName.clone(this.sqlContext));
                if (this.isUniqueAlias(withClauseItemName)) {
                    this.addObject(qn);
                } else {
                    String withClauseItemNameStr = withClauseItem.name.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
                    AstTokenIdentifier alias = this.createUniqueAlias(withClauseItemNameStr);
                    try {
                        this.addObject(qn, alias);
                    }
                    finally {
                        alias.dispose();
                    }
                }
                this.queryBuilder.updateVisibleSubQueries();
            }
            finally {
                qn.dispose();
            }
        }
    }

    private void loadDatasourceGroup(List fromSourceList, DatasourceGroup fromGroup) {
        for (int i = fromGroup.getCount() - 1; i >= 0; --i) {
            DataSourceBase ds = fromGroup.get(i);
            if (ds instanceof DatasourceGroup) {
                this.loadDatasourceGroup(fromSourceList, (DatasourceGroup)ds);
                continue;
            }
            fromSourceList.add(0, ds.astFromSource);
        }
    }

    @Override
    public void gatherPrepareAndFixupContext(List cteList, List fromSourceList, boolean inclParentQueryFromSources) {
        if (inclParentQueryFromSources && this.getFromClause() != null) {
            this.loadDatasourceGroup(fromSourceList, this.getFromClause());
        }
        super.gatherPrepareAndFixupContext(cteList, fromSourceList, true);
    }

    private AstTokenIdentifier getFromSourceBaseName(SQLFromSource fromSource) {
        assert (fromSource != null);
        AstTokenIdentifier result = new AstTokenIdentifier(this.sqlContext);
        if (fromSource.alias != null && fromSource.alias.alias != null) {
            result.assign(fromSource.alias.alias);
        } else if (fromSource.getMetadataObject() != null) {
            result.assign(fromSource.getMetadataObject().getName());
        } else if (fromSource instanceof SQLFromObject && ((SQLFromObject)fromSource).getCTEObject() != null && ((SQLFromObject)fromSource).getCTEObject().name != null) {
            result.assign(((SQLFromObject)fromSource).getCTEObject().name);
        } else if (fromSource instanceof SQLFromObject && !Helpers.isQualifiedNameEmpty(((SQLFromObject)fromSource).fromObj)) {
            result.assign(((SQLFromObject)fromSource).fromObj.get(0));
        } else {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSQL() {
        SQLSubQuerySelectExpression ast = this.getResultQueryAST();
        try {
            String string = ast.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
            return string;
        }
        finally {
            if (ast != null) {
                ((AstNode)ast).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSQL(String value) {
        block8: {
            SQLSubSelectStatement sqAst = this.sqlContext.parseSubQuery(value);
            try {
                if (sqAst.get(0) instanceof SQLSubQuerySelectExpression) {
                    SQLSubQuerySelectExpression usqAst = (SQLSubQuerySelectExpression)sqAst.get(0);
                    sqAst.extract(0);
                    ArrayList listFrom = new ArrayList();
                    ArrayList listCte = new ArrayList();
                    this.gatherPrepareAndFixupContext(listCte, listFrom, false);
                    usqAst.prepareAndFixupRecursive(listCte, listFrom);
                    usqAst.setUnionOperator(this.getUnionOperator());
                    usqAst.setAll(this.isUnionAllFlag());
                    this.beginUpdate();
                    try {
                        this.clear();
                        this.loadFromAST(usqAst);
                        this.notifySQLUpdatedRecursive();
                        break block8;
                    }
                    finally {
                        this.endUpdate();
                    }
                }
                throw new QueryBuilderException("SQL query must be simple SELECT clause");
            }
            finally {
                if (sqAst != null) {
                    sqAst.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            for (int i = this.getFromClause().getCount() - 1; i >= 0; --i) {
                this.getFromClause().delete(i);
            }
            SQLSubQuerySelectExpression usqAst = new SQLSubQuerySelectExpression(this.sqlContext);
            usqAst.setUnionOperator(this.astQuery.getUnionOperator());
            usqAst.setAll(this.astQuery.isAll());
            usqAst.from = new SQLFromClause(this.sqlContext);
            this.loadFromAST(usqAst);
            this.notifySQLUpdatedRecursive();
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    protected void notifyDatasourceReplacedInternal(DataSource datasourceFrom, DataSource datasourceTo) {
        this.astQuery.replaceReferencesToDatasourceRecursive(datasourceFrom.getFromSource(), datasourceTo.getFromSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceQuery convertDatasourceToDerivedTable(DataSource dataSource) {
        this.getFromClause().beginUpdate();
        try {
            SQLFromQuery sq = new SQLFromQuery(this.sqlContext);
            sq.alias = new SQLAliasObjectAlias(this.sqlContext);
            sq.alias.alias = this.getQueryBuilder().createUniqueQueryName();
            sq.subQuery = new SQLSubSelectStatement(this.sqlContext);
            SQLSubQuerySelectExpression sqs = new SQLSubQuerySelectExpression(this.sqlContext);
            sq.subQuery.add(sqs);
            sqs.selectItems = new SQLSelectItems(this.sqlContext);
            sqs.from = new SQLFromClause(this.sqlContext);
            SQLFromSource dsAst = (SQLFromSource)dataSource.getResultAST();
            if (dsAst.joinOn != null) {
                dsAst.joinOn.dispose();
                dsAst.joinOn = null;
            }
            ArrayList listFrom = new ArrayList();
            ArrayList listCte = new ArrayList();
            dataSource.gatherPrepareAndFixupContext(listCte, listFrom, true);
            dsAst.restoreColumnPrefixRecursive(true);
            dsAst.prepareAndFixupRecursive(listCte, listFrom);
            sqs.from.add(dsAst);
            DataSourceQuery result = (DataSourceQuery)this.addDataSourceHelper(sq, new Point(dataSource.getLeft(), dataSource.getTop()), DataSourceQuery.class);
            this.notifyDatasourceReplaced(dataSource, result);
            dataSource.dispose();
            this.notifySQLUpdatedRecursive();
            DataSourceQuery dataSourceQuery = result;
            return dataSourceQuery;
        }
        finally {
            this.getFromClause().endUpdate();
        }
    }

    public boolean haveAnsiJoins() {
        ArrayList links = new ArrayList();
        this.getFromClause().getLinksRecursive(links);
        for (int i = 0; i < links.size(); ++i) {
            if (((Link)links.get(i)).getPlace() != LinkPlace.From) continue;
            return true;
        }
        return false;
    }

    public boolean haveWhereJoins() {
        ArrayList links = new ArrayList();
        this.getFromClause().getLinksRecursive(links);
        for (int i = 0; i < links.size(); ++i) {
            if (((Link)links.get(i)).getPlace() != LinkPlace.Where) continue;
            return true;
        }
        return false;
    }

    public boolean useANSIJoins() {
        BaseSyntaxProvider syntaxProvider = this.sqlContext.getSyntaxProvider();
        if (syntaxProvider != null) {
            if (syntaxProvider.isSupportANSIJoins()) {
                if (this.haveAnsiJoins()) {
                    return true;
                }
                if (syntaxProvider.isSupportOracleJoins() || syntaxProvider.isSupportTransactSQLJoins()) {
                    if (this.haveWhereJoins()) {
                        return false;
                    }
                    return !syntaxProvider.isCreateWhereJoinsByDefault();
                }
                return !syntaxProvider.isCreateWhereJoinsByDefault();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinkedObjectsFor(DataSource datasource) {
        MetadataObject dst = datasource.getMetadataObject();
        if (dst != null) {
            MetadataObject mo;
            DataSource ds;
            int i;
            ArrayList<MetadataObject> srcs = new ArrayList<MetadataObject>();
            ArrayList datasources = new ArrayList();
            this.getFromClause().getDatasourceByClass(DataSource.class, datasources);
            for (i = 0; i < datasources.size(); ++i) {
                ds = (DataSource)datasources.get(i);
                mo = ds.getMetadataObject();
                if (mo == null || mo == dst) continue;
                srcs.add(mo);
            }
            if (!srcs.isEmpty()) {
                List path = MetadataPathSolver.findShortestPath(this.sqlContext.getMetadataContainer(), srcs, dst);
                try {
                    if (path != null && path.size() >= 3) {
                        for (i = 1; i < path.size() - 1; ++i) {
                            mo = (MetadataObject)path.get(i);
                            ds = this.addObject(mo);
                            this.addFKLinksForObject(ds);
                        }
                    }
                }
                finally {
                    if (path != null) {
                        path.clear();
                    }
                }
            }
        }
    }

    private void collectUsedFromsourcesForAstNode(AstNode node, List usedDataSourcesList) {
        if (node != null) {
            ArrayList l = new ArrayList();
            node.getReferencedDatasourcesRecursive(l);
            for (int i = 0; i < l.size(); ++i) {
                SQLFromSource fs = (SQLFromSource)l.get(i);
                if (usedDataSourcesList.indexOf(fs) != -1) continue;
                usedDataSourcesList.add(fs);
            }
        }
    }

    private void collectUsedFromsourcesForSelectitem(CriteriaItem criteriaItem, List list) {
        this.collectUsedFromsourcesForAstNode(criteriaItem.astExpression, list);
        for (int i = 0; i < criteriaItem.getConditionCount(); ++i) {
            this.collectUsedFromsourcesForAstNode(criteriaItem.getASTCondition(i), list);
        }
    }

    private void collectLinks(DatasourceGroup datasourceGroup, List links) {
        int i;
        for (i = 0; i < datasourceGroup.getLinkCount(); ++i) {
            links.add(datasourceGroup.links.get(i));
        }
        for (i = 0; i < datasourceGroup.getCount(); ++i) {
            DataSourceBase db = datasourceGroup.get(i);
            if (!(db instanceof DatasourceGroup)) continue;
            this.collectLinks((DatasourceGroup)db, links);
        }
    }

    private void getLinkedDatasources(DataSource dataSource, List links, List linkedDatasources) {
        linkedDatasources.clear();
        for (int i = 0; i < links.size(); ++i) {
            Link l = (Link)links.get(i);
            if (l.referencedDatasources.indexOf(dataSource) == -1) continue;
            for (int j = 0; j < l.referencedDatasources.size(); ++j) {
                DataSource ds = (DataSource)l.referencedDatasources.get(j);
                if (ds == dataSource || linkedDatasources.indexOf(ds) != -1) continue;
                linkedDatasources.add(ds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSQLUpdated() {
        if (this.queryBuilder.getLinkOptions().isDeleteUnusedObjects()) {
            int i;
            int j;
            DataSource ds;
            int i2;
            ArrayList dsl = new ArrayList();
            ArrayList links = new ArrayList();
            ArrayList usedFsl = new ArrayList();
            ArrayList<DataSource> usedDsl = new ArrayList<DataSource>();
            ArrayList markedDsl = new ArrayList();
            ArrayList tmpList = new ArrayList();
            ArrayList<DataSource> removeDsl = new ArrayList<DataSource>();
            this.getFromClause().getDatasourceByClass(DataSource.class, dsl);
            this.collectLinks(this.getFromClause(), links);
            for (i2 = 0; i2 < this.criteriaList.getCount(); ++i2) {
                this.collectUsedFromsourcesForSelectitem(this.criteriaList.get(i2), usedFsl);
            }
            for (i2 = 0; i2 < dsl.size(); ++i2) {
                DataSource ds2 = (DataSource)dsl.get(i2);
                if (usedFsl.indexOf(ds2.getFromSource()) == -1) continue;
                usedDsl.add(ds2);
            }
            for (i2 = 0; i2 < usedDsl.size(); ++i2) {
                markedDsl.add(usedDsl.get(i2));
            }
            boolean flag = true;
            while (flag) {
                flag = false;
                for (int i3 = markedDsl.size() - 1; i3 >= 0; --i3) {
                    ds = (DataSource)markedDsl.get(i3);
                    this.getLinkedDatasources(ds, links, tmpList);
                    for (j = 0; j < tmpList.size(); ++j) {
                        if (markedDsl.indexOf(tmpList.get(j)) != -1) continue;
                        flag = true;
                        markedDsl.add(tmpList.get(j));
                    }
                }
            }
            for (i = dsl.size() - 1; i >= 0; --i) {
                if (markedDsl.indexOf((DataSource)dsl.get(i)) != -1) continue;
                removeDsl.add((DataSource)dsl.get(i));
                dsl.remove(i);
            }
            flag = true;
            while (flag) {
                flag = false;
                for (i = dsl.size() - 1; i >= 0; --i) {
                    ds = (DataSource)dsl.get(i);
                    if (usedDsl.indexOf(ds) != -1) continue;
                    this.getLinkedDatasources(ds, links, tmpList);
                    for (j = 0; j < removeDsl.size(); ++j) {
                        tmpList.remove(removeDsl.get(j));
                    }
                    if (tmpList.size() > 1) continue;
                    flag = true;
                    removeDsl.add(ds);
                    dsl.remove(i);
                }
            }
            if (removeDsl.size() > 0) {
                this.beginUpdate();
                try {
                    for (i = 0; i < removeDsl.size(); ++i) {
                        ((DataSource)removeDsl.get(i)).dispose();
                    }
                }
                finally {
                    this.endUpdate();
                }
            }
        }
        super.doSQLUpdated();
    }

    private int addFKLinksByFieldNamesInternal(DataSourceObject key, DataSourceObject child) {
        int result = 0;
        MetadataFieldList fieldsKey = key.getFields();
        MetadataFieldList fieldsChild = child.getFields();
        for (int i = 0; i < fieldsKey.getCount(); ++i) {
            MetadataField fieldKey = fieldsKey.get(i);
            int fieldChildIndex = fieldsChild.findFieldByName(fieldKey.getName());
            if (fieldChildIndex == -1) continue;
            MetadataField fieldChild = fieldsChild.get(fieldChildIndex);
            Link link = this.findLink(key, fieldKey.getName(), child, fieldChild.getName());
            if (link == null) {
                link = this.findLink(child, fieldChild.getName(), key, fieldKey.getName());
            }
            if (link != null) continue;
            LinkCreatingEvent creatingEvent = new LinkCreatingEvent(this.queryBuilder, this, key, fieldKey, child, fieldChild, null);
            this.queryBuilder.fireLinkCreatingEvent(creatingEvent);
            if (creatingEvent.abort) continue;
            link = this.addLink((DataSource)key, fieldKey.getName(), (DataSource)child, fieldChild.getName());
            LinkCreatedEvent createdEvent = new LinkCreatedEvent(this.queryBuilder, link);
            this.queryBuilder.fireLinkCreatedEvent(createdEvent);
            ++result;
        }
        return result;
    }

    private MetadataObject calcRealMetadataObject(DataSource datasource) {
        int MaxResolutionTries = 20;
        MetadataObject result = datasource.getMetadataObject();
        for (int tryCounter = 20; tryCounter > 0 && result != null && result instanceof MetadataSynonym && ((MetadataSynonym)result).getReferencedObject() != null; --tryCounter) {
            result = ((MetadataSynonym)result).getReferencedObject();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addIdenticalFieldsLinksForObject(DataSourceObject dataSource) {
        int result = 0;
        if (this.queryBuilder != null) {
            MetadataObject metadataObject = this.calcRealMetadataObject(dataSource);
            dataSource.beginUpdate();
            try {
                ArrayList ts = new ArrayList();
                dataSource.getQuery().getFromClause().getDatasourceByClass(DataSourceObject.class, ts);
                ts.remove(dataSource);
                for (DataSourceObject t : ts) {
                    if (metadataObject != null && metadataObject == this.calcRealMetadataObject(t)) continue;
                    result += this.addFKLinksByFieldNamesInternal(t, dataSource);
                }
            }
            finally {
                dataSource.endUpdate();
            }
        }
        return result;
    }

    @Override
    protected boolean notifyDatasourceDestroyingInternal(DataSource datasource) {
        return !this.astQuery.removeReferencesToDatasource(datasource.getFromSource());
    }

    private List<DataSourceBase> collectDatasourcePath(DataSourceBase datasource) {
        ArrayList<DataSourceBase> result = new ArrayList<DataSourceBase>();
        while (datasource != null) {
            result.add(0, datasource);
            datasource = datasource.getGroup();
        }
        return result;
    }

    public List addLinksFromExpression(DataSource leftDatasource, DataSource rightDatasource, SQLExpressionItem parsedExpression) {
        assert (leftDatasource != null);
        assert (rightDatasource != null);
        assert (leftDatasource != rightDatasource);
        assert (parsedExpression != null);
        List<DataSourceBase> leftDatasourcePath = this.collectDatasourcePath(leftDatasource);
        assert (leftDatasourcePath.size() >= 2);
        List<DataSourceBase> rightDatasourcePath = this.collectDatasourcePath(rightDatasource);
        assert (rightDatasourcePath.size() >= 2);
        assert (leftDatasourcePath.get(0) == rightDatasourcePath.get(0));
        DatasourceGroup group = null;
        while (leftDatasourcePath.get(0) == rightDatasourcePath.get(0)) {
            group = (DatasourceGroup)leftDatasourcePath.get(0);
            leftDatasourcePath.remove(0);
            rightDatasourcePath.remove(0);
        }
        assert (leftDatasourcePath.size() > 0);
        assert (rightDatasourcePath.size() > 0);
        assert (group != null);
        DataSourceBase leftDatasourceBase = leftDatasourcePath.get(0);
        DataSourceBase rightDatasourceBase = rightDatasourcePath.get(0);
        int indexLeft = group.indexOf(leftDatasourceBase);
        int indexRight = group.indexOf(rightDatasourceBase);
        if (indexRight > indexLeft) {
            return rightDatasourceBase.addLinksFromExpression(parsedExpression);
        }
        return leftDatasourceBase.addLinksFromExpression(parsedExpression);
    }

    public List addLinksFromExpression(DataSource leftDatasource, DataSource rightDatasource, String expression) {
        assert (leftDatasource != null);
        assert (rightDatasource != null);
        assert (!Str.IsNullOrEmpty(expression));
        SQLExpressionItem parsedExpression = this.sqlContext.parseLogicalExpression(expression);
        if (parsedExpression == null) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strBadExpression", "\"%1$s\" is invalid expression."), expression));
        }
        ArrayList lCTE = new ArrayList();
        ArrayList lFROM = new ArrayList();
        rightDatasource.gatherPrepareAndFixupContext(lCTE, lFROM, true);
        parsedExpression.prepareAndFixupRecursive(lCTE, lFROM);
        return this.addLinksFromExpression(leftDatasource, rightDatasource, parsedExpression);
    }

    private void loadDatasourceGroup2(List<DataSource> dataSourceList, DatasourceGroup fromGroup) {
        for (int i = fromGroup.getCount() - 1; i >= 0; --i) {
            DataSourceBase ds = fromGroup.get(i);
            if (ds instanceof DatasourceGroup) {
                this.loadDatasourceGroup2(dataSourceList, (DatasourceGroup)ds);
                continue;
            }
            dataSourceList.add((DataSource)ds);
        }
    }

    @Override
    public void collectVisibleDataSources(List<DataSource> dataSourceList) {
        if (this.getFromClause() != null) {
            this.loadDatasourceGroup2(dataSourceList, this.getFromClause());
        }
        super.collectVisibleDataSources(dataSourceList);
    }

    private class CustomMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        public Object tag;

        private CustomMenuItem(String s) {
            super(s);
        }
    }
}

