/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLFromClause;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLOrderByClause;
import com.adbs.ast.SQLSelectItems;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SQLWithClause;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.CriteriaItem;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceObject;
import com.adbs.querybuilder.DataSourceQuery;
import com.adbs.querybuilder.Query;
import com.adbs.querybuilder.QueryBase;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.QueryTabSheet;
import com.adbs.querybuilder.SubQueryList;
import com.adbs.querybuilder.SubSelectStatementProxy;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionOperator;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import com.adbs.utils.Wrapper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubQuery
extends UnionGroup {
    private static final long serialVersionUID = 1L;
    private SubQuery ownerSubQuery;
    private SubQueryList subQueries = new SubQueryList();
    private UnionSubQuery activeUnionSubquery;
    ArrayList plainUnionSubQueries = new ArrayList();
    private MetadataFieldList fields;
    SQLWithClauseItem withClauseItem;
    DataSourceQuery derivedTable;
    CriteriaItem criteriaItem;
    private UpdatedEventListener fieldsUpdated = new UpdatedEventListener(){

        private boolean areFieldsEquals(MetadataField field1, MetadataField field2) {
            boolean result = field1.getNameStr().equals(field2.getNameStr());
            if (!result) {
                return false;
            }
            boolean bl = result = field1.getFieldType() == field2.getFieldType();
            if (!result) {
                return false;
            }
            result = field1.getFieldTypeName().equals(field2.getFieldTypeName());
            return result;
        }

        private boolean areFieldListsEquals(MetadataFieldList list1, MetadataFieldList list2) {
            boolean result;
            boolean bl = result = list1.getCount() == list2.getCount();
            if (!result) {
                return false;
            }
            for (int i = 0; i < list1.getCount(); ++i) {
                result = this.areFieldsEquals(list1.get(i), list2.get(i));
                if (result) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updatedEventOccurred(UpdatedEvent event) {
            MetadataFieldList targetFields;
            if (SubQuery.this.withClauseItem != null && (targetFields = SubQuery.this.withClauseItem.fieldList) != null && !this.areFieldListsEquals(targetFields, SubQuery.this.fields)) {
                targetFields.beginUpdate();
                try {
                    targetFields.assign(SubQuery.this.fields);
                    if (SubQuery.this.withClauseItem.columnNamesList != null) {
                        for (int i = 0; i < SubQuery.this.withClauseItem.columnNamesList.getCount(); ++i) {
                            MetadataField f = i < targetFields.getCount() ? targetFields.get(i) : targetFields.add();
                            f.setNameAlias(SubQuery.this.withClauseItem.columnNamesList.get(i));
                        }
                    }
                }
                finally {
                    targetFields.endUpdate();
                }
            }
        }
    };

    public SubQuery(ControlOwner owner, QueryBuilder queryBuilder) {
        super(owner, queryBuilder);
        this.fields = new MetadataFieldList(null, this.sqlContext);
        this.fields.addUpdatedEventListener(this.fieldsUpdated);
        this.ownerSubQuery = null;
        for (ControlOwner co = owner; co != null; co = co.getOwner()) {
            if (!(co instanceof SubQuery)) continue;
            this.ownerSubQuery = (SubQuery)co;
            break;
        }
        if (this.ownerSubQuery != null) {
            this.ownerSubQuery.registerSubQuery(this);
        }
        this.getQueryBuilder().registerSubQuery(this);
    }

    @Override
    public void dispose() {
        this.getQueryBuilder().unregisterSubQuery(this);
        if (this.ownerSubQuery != null) {
            this.ownerSubQuery.unregisterSubQuery(this);
        }
        this.fields.removeUpdatedEventListener(this.fieldsUpdated);
        this.fields.dispose();
        super.dispose();
        this.plainUnionSubQueries.clear();
        this.subQueries.dispose();
    }

    public SQLSubSelectStatement getASTSubQuery() {
        return (SQLSubSelectStatement)this.astUnionGroup;
    }

    public UnionSubQuery getActiveUnionSubquery() {
        return this.activeUnionSubquery;
    }

    public void setActiveUnionSubquery(UnionSubQuery value) {
        if (this.activeUnionSubquery != value) {
            if (value != null && this.isControlsCreated() && value.isControlsCreated()) {
                value.getUnionPage().setVisible(true);
            }
            if (this.activeUnionSubquery != null && this.activeUnionSubquery.isControlsCreated()) {
                this.activeUnionSubquery.getUnionPage().setVisible(false);
            }
            this.activeUnionSubquery = value;
            if (this.queryBuilder.getActiveSubquery() == this) {
                this.queryBuilder.notifyActiveUnionSubQueryChanged();
            }
            if (this.activeUnionSubquery != null) {
                this.updateActiveUnionSubQueryControls();
            }
        }
    }

    public SubQuery getOwnerSubQuery() {
        return this.ownerSubQuery;
    }

    public int getSubQueryCount() {
        return this.subQueries.size();
    }

    public boolean isSubQuery() {
        return true;
    }

    public boolean isMainQuery() {
        return !this.isSubQuery();
    }

    public String getCaption() {
        String result = this.isMainQuery() ? Helpers.localizer.getString("strMainQuery", "Main") : (this.isSubQueryCTE() ? this.withClauseItem.name.getToken() : (this.isSubQueryDerivedTable() && !Str.IsNullOrEmpty(this.derivedTable.getAlias()) ? this.derivedTable.getAlias() : (this.criteriaItem != null && this.criteriaItem.isSupportsAlias() && !Str.IsNullOrEmpty(this.criteriaItem.getAliasString()) ? this.criteriaItem.getAliasString() : Helpers.shortenQuery(this.getResultSQL(this.sqlContext.getSQLBuilderExpression())))));
        return result;
    }

    @Override
    public int getControlsCount() {
        return 1;
    }

    public SubQueryList getSubQueries() {
        return this.subQueries;
    }

    public SubQuery getSubQuery(int index) {
        return this.subQueries.get(index);
    }

    public MetadataFieldList getFields() {
        return this.fields;
    }

    @Override
    public boolean canCreateControls() {
        return this.getQueryBuilder().isControlsCreated() || super.canCreateControls();
    }

    @Override
    protected Component createControlInternal(int i) {
        if (i == 0) {
            QueryTabSheet c = new QueryTabSheet(this.getQueryBuilder(), this);
            c.setBorder(BorderFactory.createEmptyBorder());
            this.getQueryBuilder().tabs.addTab(Helpers.localizer.getString("strMainQuery", "Main"), c);
            this.controls.set(i, c);
            if (this.isSubQueryCTE()) {
                this.makeTabWithButton();
            }
            return c;
        }
        return null;
    }

    @Override
    protected boolean makeVisible(int i) {
        return false;
    }

    @Override
    protected void doAfterUpdated() {
        super.doAfterUpdated();
        if (!this.isDisposing()) {
            this.updateCaption();
        }
    }

    public QueryTabSheet getQueryPage() {
        if (this.controls.size() >= 1) {
            return (QueryTabSheet)this.controls.get(0);
        }
        return null;
    }

    public UnionSubQuery firstSelect() {
        UnionSubQuery result = null;
        QueryBase qb = this;
        while (qb != null && result == null) {
            if (qb instanceof UnionSubQuery) {
                result = (UnionSubQuery)qb;
                continue;
            }
            if (qb instanceof UnionGroup && ((UnionGroup)qb).getCount() > 0) {
                qb = ((UnionGroup)qb).get(0);
                continue;
            }
            qb = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAST(SQLSubSelectStatement subQuery) throws QueryBuilderException {
        this.beginUpdate();
        try {
            if (subQuery.withClause != null) {
                this.loadSubQueries(subQuery.withClause);
            }
            super.loadFromAST(subQuery);
            UnionSubQuery sel = this.firstSelect();
            if (sel != null) {
                if (subQuery.orderBy != null) {
                    if (sel.astQuery.orderBy == null) {
                        sel.getCriteriaList().loadOrderByListFromAST(subQuery.orderBy, false);
                        subQuery.orderBy = null;
                    } else {
                        sel.getCriteriaList().loadOrderByListFromAST(sel.astQuery.orderBy);
                    }
                } else if (sel.astQuery.orderBy != null) {
                    sel.getCriteriaList().loadOrderByListFromAST(sel.astQuery.orderBy);
                    sel.astQuery.orderBy = null;
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    protected void restoreControlParams(int i) {
        super.restoreControlParams(i);
        if (i == 0) {
            this.updateCaption();
        }
    }

    @Override
    protected void updateContolParams(int i) {
        super.updateContolParams(i);
        if (i == 0) {
            this.updateCaption();
            this.getQueryPage().getUnionNavBar().setVisible(this.getQueryBuilder().isUnionNavBarVisible());
            this.getQueryPage().getUnionNavBar().reAlign();
        }
    }

    @Override
    UnionOperator getUnionOperatorControl() {
        return null;
    }

    public void registerUnionSubQuery(UnionSubQuery usq) {
        this.plainUnionSubQueries.add(usq);
    }

    public void unregisterUnionSubQuery(UnionSubQuery usq) {
        this.plainUnionSubQueries.remove(usq);
    }

    private void loadUnionSubQueriesFromGroup(Wrapper<Integer> curIndex, UnionGroup g) {
        for (int i = 0; i < g.getCount(); ++i) {
            if (g.get(i) instanceof UnionGroup) {
                this.loadUnionSubQueriesFromGroup(curIndex, (UnionGroup)g.get(i));
                continue;
            }
            if (!(g.get(i) instanceof UnionSubQuery)) continue;
            UnionSubQuery usq = (UnionSubQuery)g.get(i);
            if (this.plainUnionSubQueries.get((Integer)curIndex.value) != usq) {
                int oldIndex = this.plainUnionSubQueries.indexOf(usq);
                Helpers.listMove(this.plainUnionSubQueries, oldIndex, (Integer)curIndex.value);
            }
            Wrapper<Integer> wrapper = curIndex;
            Object e = wrapper.value;
            wrapper.value = (Integer)wrapper.value + 1;
            Integer n = wrapper.value;
        }
    }

    public void updateUnionSubQueriesOrder() {
        Wrapper<Integer> curIndex = new Wrapper<Integer>(0);
        if (this.plainUnionSubQueries != null && this.getCount() > 0) {
            this.loadUnionSubQueriesFromGroup(curIndex, this);
        }
    }

    public void requestAlignUnionNavbar() {
        if (this.getQueryPage() != null && this.getQueryPage().getUnionNavBar() != null) {
            this.getQueryPage().doLayout();
        }
    }

    public void saveLayout(Document document, Element collection, SQLBuilder sqlBuilder) {
        Element subQuery = document.createElement("SubQuery");
        collection.appendChild(subQuery);
        subQuery.setAttribute("SQL", this.getResultSQL(sqlBuilder));
        for (int i = 0; i < this.getCount(); ++i) {
            ((UnionSubQuery)this.plainUnionSubQueries.get(i)).saveLayout(document, subQuery, sqlBuilder);
        }
        subQuery = null;
    }

    public void loadLayout(Element subQueries, SQLBuilder sqlBuilder) {
        Element subQuery = Helpers.findChildByNameAndAttribute("SubQuery", "SQL", this.getResultSQL(sqlBuilder), subQueries);
        if (subQuery != null) {
            int itemIndex = 0;
            for (int i = 0; i < this.getCount(); ++i) {
                NodeList childNodes = subQuery.getChildNodes();
                Node item = null;
                while (childNodes.getLength() > itemIndex) {
                    item = childNodes.item(itemIndex);
                    ++itemIndex;
                    if (!(item instanceof Element)) continue;
                }
                if (!(item instanceof Element)) continue;
                ((UnionSubQuery)this.plainUnionSubQueries.get(i)).loadLayout((Element)item, sqlBuilder);
            }
        }
    }

    @Override
    protected AstNode createResultAST() {
        SQLSubSelectStatement result = (SQLSubSelectStatement)super.createResultAST();
        if (result != null) {
            UnionSubQuery sel = this.firstSelect();
            if (sel != null) {
                SQLOrderByClause orderByClause = sel.getCriteriaList().getOrderByClause();
                if (result.getCount() == 1 && result.get(0) instanceof SQLSubQuerySelectExpression) {
                    SQLSubQuerySelectExpression expr = (SQLSubQuerySelectExpression)result.get(0);
                    if (expr.orderBy != null) {
                        expr.orderBy.dispose();
                    }
                    expr.orderBy = orderByClause;
                } else {
                    result.orderBy = sel.getCriteriaList().getOrderByClause();
                }
            }
            if (result.withClause != null && result.withClause.getCount() == 0) {
                result.withClause.dispose();
                result.withClause = null;
            }
        }
        return result;
    }

    public void updateActiveUnionSubQueryControls() {
        if (this.isControlsCreated() && this.activeUnionSubquery.isControlsCreated()) {
            this.activeUnionSubquery.getUnionButton().setSelected(true);
            this.activeUnionSubquery.getUnionPage().setVisible(true);
            this.getQueryPage().getUnionNavBar().reAlign();
            this.queryBuilder.updateTreePosition(this.activeUnionSubquery);
        }
    }

    protected void updateCaption() {
        if (this.getQueryPage() != null) {
            QueryTabSheet page = this.getQueryPage();
            JTabbedPane tabbedPane = (JTabbedPane)page.getParent();
            tabbedPane.setTitleAt(tabbedPane.indexOfComponent(page), this.getCaption());
        }
    }

    @Override
    public void gatherPrepareAndFixupContext(List cteList, List fromSourceList, boolean inclParentQueryFromSources) {
        if (((SQLSubSelectStatement)this.astUnionGroup).withClause != null) {
            for (int i = ((SQLSubSelectStatement)this.astUnionGroup).withClause.getCount() - 1; i >= 0; --i) {
                cteList.add(0, ((SQLSubSelectStatement)this.astUnionGroup).withClause.get(i));
            }
        }
        super.gatherPrepareAndFixupContext(cteList, fromSourceList, inclParentQueryFromSources);
    }

    @Override
    void languageChanged() {
        if (this.controls.size() >= 1) {
            this.updateCaption();
        }
        super.languageChanged();
    }

    public boolean isUniqueCTEName(AstTokenIdentifier name) {
        SQLWithClause withClause = this.getASTSubQuery().withClause;
        if (withClause == null) {
            return true;
        }
        for (int i = 0; i < withClause.getCount(); ++i) {
            SQLWithClauseItem _withClauseItem = (SQLWithClauseItem)withClause.get(i);
            if (this.sqlContext.compareTokens(name, _withClauseItem.name) != 0) continue;
            return false;
        }
        return true;
    }

    public AstTokenIdentifier createUniqueCTEName(String prefix) {
        AstTokenIdentifier result = new AstTokenIdentifier(this.sqlContext, prefix);
        for (int suffix = 0; suffix < 0x7FFFFFFE; ++suffix) {
            String tmp = prefix;
            if (suffix > 0) {
                tmp = tmp + String.valueOf(suffix);
            }
            result.setToken(tmp);
            if (this.isUniqueCTEName(result)) break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWithClauseItem addNewCTE(String subQuery, String alias) {
        assert (!Str.IsNullOrEmpty(subQuery));
        assert (!Str.IsNullOrEmpty(alias));
        SQLSubSelectStatement sq = this.sqlContext.parseSubQuery(subQuery);
        try {
            SQLWithClauseItem sQLWithClauseItem;
            AstTokenIdentifier id = this.sqlContext.parseIdentifierQuoteIfNeed(alias);
            try {
                sQLWithClauseItem = this.addNewCTE(sq, id);
            }
            catch (Throwable throwable) {
                id.dispose();
                throw throwable;
            }
            id.dispose();
            return sQLWithClauseItem;
        }
        finally {
            sq.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWithClauseItem addNewCTE(SQLSubSelectStatement subQuery, AstTokenIdentifier alias) {
        SQLWithClauseItem result;
        assert (alias != null);
        assert (!alias.isEmpty());
        this.beginUpdate();
        try {
            result = new SQLWithClauseItem(this.sqlContext);
            result.name = alias.clone(this.sqlContext);
            if (subQuery != null) {
                result.subQuery = (SQLSubSelectStatement)subQuery.clone(this.sqlContext);
            } else {
                SQLSubSelectStatement sq = new SQLSubSelectStatement(this.sqlContext);
                SQLSubQuerySelectExpression usq = new SQLSubQuerySelectExpression(this.sqlContext);
                sq.add(usq);
                usq.from = new SQLFromClause(this.sqlContext);
                usq.selectItems = new SQLSelectItems(this.sqlContext);
                result.subQuery = sq;
            }
            if (this.getASTSubQuery().withClause == null) {
                this.getASTSubQuery().withClause = new SQLWithClause(this.sqlContext);
            }
            this.getASTSubQuery().withClause.add(result);
            this.loadSubQueries(result);
            SubSelectStatementProxy proxy = (SubSelectStatementProxy)result.subQuery;
            proxy.subQuery.setWithClauseItem(result);
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public SQLWithClauseItem getWithClauseItem() {
        return this.withClauseItem;
    }

    public void setWithClauseItem(SQLWithClauseItem withClauseItem) {
        this.withClauseItem = withClauseItem;
    }

    private void makeTabWithButton() {
        int index = this.getQueryBuilder().tabs.indexOfComponent((Component)this.controls.get(0));
        ActionListener buttonActionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ae) {
                Query targetSubQuery = SubQuery.this.getQueryBuilder().getQuery();
                SQLWithClause withClause = targetSubQuery.getASTSubQuery().withClause;
                assert (withClause != null);
                assert (withClause.indexOf(SubQuery.this.withClauseItem) != -1);
                if (JOptionPane.showConfirmDialog(SubQuery.this.getQueryBuilder(), Helpers.localizer.getString("strConfirmCTERemoving", "Are you sure you want to remove this common table expression?"), Helpers.localizer.getString("strConfirmation", "Confirmation"), 0) == 0) {
                    SubQuery.this.queryBuilder.beginUpdate();
                    try {
                        withClause.remove(SubQuery.this.withClauseItem);
                        SubQuery.this.queryBuilder.getQuery().notifySQLUpdatedRecursive();
                    }
                    finally {
                        SubQuery.this.queryBuilder.endUpdate();
                    }
                }
            }
        };
        this.getQueryBuilder().tabs.makeTabWithButtonAt(index, buttonActionListener);
    }

    public boolean isSubQueryCTE() {
        return this.withClauseItem != null;
    }

    public int getSubQueryCTEIndex() {
        return this.getSubQueryCTEClauseAST().indexOf(this.getSubQueryCTEItemAST());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWithClauseItem insertNewCTE(int index, String subQuery, String alias) {
        assert (!Str.IsNullOrEmpty(subQuery));
        assert (!Str.IsNullOrEmpty(alias));
        SQLSubSelectStatement sq = this.sqlContext.parseSubQuery(subQuery);
        try {
            SQLWithClauseItem sQLWithClauseItem;
            AstTokenIdentifier id = this.sqlContext.parseIdentifierQuoteIfNeed(alias);
            try {
                sQLWithClauseItem = this.insertNewCTE(index, sq, id);
            }
            catch (Throwable throwable) {
                id.dispose();
                throw throwable;
            }
            id.dispose();
            return sQLWithClauseItem;
        }
        finally {
            sq.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWithClauseItem insertNewCTE(int index, SQLSubSelectStatement subQuery, AstTokenIdentifier alias) {
        SQLWithClauseItem result;
        assert (alias != null);
        assert (!alias.isEmpty());
        SQLSubSelectStatement astSubQuery = this.getASTSubQuery();
        assert (astSubQuery.withClause == null && index == 0 || astSubQuery.withClause != null && astSubQuery.withClause.getCount() >= index);
        this.beginUpdate();
        try {
            result = new SQLWithClauseItem(this.sqlContext);
            result.name = alias.clone(this.sqlContext);
            if (subQuery != null) {
                result.subQuery = (SQLSubSelectStatement)subQuery.clone(this.sqlContext);
            } else {
                SQLSubSelectStatement sq = new SQLSubSelectStatement(this.sqlContext);
                SQLSubQuerySelectExpression usq = new SQLSubQuerySelectExpression(this.sqlContext);
                sq.add(usq);
                usq.from = new SQLFromClause(this.sqlContext);
                usq.selectItems = new SQLSelectItems(this.sqlContext);
                result.subQuery = sq;
            }
            if (astSubQuery.withClause == null) {
                astSubQuery.withClause = new SQLWithClause(this.sqlContext);
            }
            astSubQuery.withClause.insert(index, result);
            this.loadSubQueries(result);
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public SQLWithClause getSubQueryCTEClauseAST() {
        SQLWithClause result = null;
        if (this.isSubQueryCTE()) {
            result = this.queryBuilder.getQuery().getASTSubQuery().withClause;
            assert (result != null);
        }
        return result;
    }

    public SQLWithClauseItem getSubQueryCTEItemAST() {
        return this.withClauseItem;
    }

    private boolean canRenameCTEFromUnionGroup(UnionGroup unionGroup, AstTokenIdentifier newName) {
        boolean result = true;
        for (int i = 0; i < unionGroup.getCount(); ++i) {
            QueryBase base = unionGroup.get(i);
            if (base instanceof UnionSubQuery) {
                result = this.canRenameCTEFromUnionSubQuery((UnionSubQuery)base, newName);
            } else {
                assert (base instanceof UnionGroup);
                result = this.canRenameCTEFromUnionGroup((UnionGroup)base, newName);
            }
            if (!result) break;
        }
        return result;
    }

    private boolean canRenameCTEFromUnionSubQuery(UnionSubQuery unionSubQuery, AstTokenIdentifier newName) {
        ArrayList dsl = new ArrayList();
        boolean haveReferencesFlag = false;
        unionSubQuery.getFromClause().getDatasources(dsl);
        for (int i = 0; i < dsl.size(); ++i) {
            DataSource ds = (DataSource)dsl.get(i);
            if (!(ds instanceof DataSourceObject)) continue;
            DataSourceObject dso = (DataSourceObject)ds;
            boolean bl = haveReferencesFlag = dso.getSubQueryCTE() == this && dso.getAliasAST() == null;
            if (haveReferencesFlag) break;
        }
        if (!haveReferencesFlag) {
            return true;
        }
        return unionSubQuery.isUniqueAlias(newName);
    }

    private void renameCTEInUnionGroup(UnionGroup unionGroup, AstTokenIdentifier newName) {
        for (int i = 0; i < unionGroup.getCount(); ++i) {
            QueryBase base = unionGroup.get(i);
            if (base instanceof UnionSubQuery) {
                this.renameCTEInUnionSubQuery((UnionSubQuery)base, newName);
                continue;
            }
            assert (base instanceof UnionGroup);
            this.renameCTEInUnionGroup((UnionGroup)base, newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameCTEInUnionSubQuery(UnionSubQuery unionSubQuery, AstTokenIdentifier newName) {
        ArrayList dsl = new ArrayList();
        unionSubQuery.getFromClause().getDatasources(dsl);
        for (int i = 0; i < dsl.size(); ++i) {
            DataSourceObject dso;
            DataSource ds = (DataSource)dsl.get(i);
            if (!(ds instanceof DataSourceObject) || (dso = (DataSourceObject)ds).getSubQueryCTE() != this) continue;
            dso.beginUpdate();
            try {
                assert (dso.astFromSource instanceof SQLFromObject);
                SQLFromObject fso = (SQLFromObject)dso.astFromSource;
                fso.fromObj.clear();
                fso.fromObj.add(newName.clone(this.sqlContext));
                dso.notifySQLUpdated();
                continue;
            }
            finally {
                dso.endUpdate();
            }
        }
    }

    public boolean canRenameCTETo(AstTokenIdentifier newName) {
        int i;
        SQLWithClause withClause = this.getSubQueryCTEClauseAST();
        for (i = 0; i < withClause.getCount(); ++i) {
            SQLWithClauseItem wcItem = (SQLWithClauseItem)withClause.get(i);
            if (this.sqlContext.compareIdentifiers(newName, this.withClauseItem.name) != 0) continue;
            return false;
        }
        for (i = 0; i < this.queryBuilder.getSubQueries().size(); ++i) {
            SubQuery sq = this.queryBuilder.getSubQueries().get(i);
            if (this.canRenameCTEFromUnionGroup(sq, newName)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameCTE(AstTokenIdentifier newName) {
        assert (this.isSubQueryCTE());
        this.queryBuilder.beginUpdate();
        try {
            this.getSubQueryCTEItemAST().name.assign(newName);
            for (int i = 0; i < this.queryBuilder.getSubQueries().size(); ++i) {
                SubQuery sq = this.queryBuilder.getSubQueries().get(i);
                this.renameCTEInUnionGroup(sq, newName);
            }
            this.queryBuilder.getQuery().notifySQLUpdatedRecursive();
        }
        finally {
            this.queryBuilder.endUpdate();
        }
    }

    public boolean isSubQueryDerivedTable() {
        return this.derivedTable != null;
    }

    public DataSourceQuery getSubQueryDerivedTable() {
        return this.derivedTable;
    }

    public boolean isQueryWithUnions() {
        return this.getCount() > 1 || !(this.get(0) instanceof UnionSubQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSQL() {
        AstNode ast = this.getResultAST();
        try {
            String string = ast.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
            return string;
        }
        finally {
            ast.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSQL(String value) {
        SQLSubSelectStatement sqAst = this.sqlContext.parseSubQuery(value);
        try {
            ArrayList listFrom = new ArrayList();
            ArrayList listCte = new ArrayList();
            try {
                this.gatherPrepareAndFixupContext(listCte, listFrom, false);
                sqAst.prepareAndFixupRecursive(listCte, listFrom);
            }
            finally {
                listCte.clear();
                listFrom.clear();
            }
            this.beginUpdate();
            try {
                this.clear();
                this.loadFromAST(sqAst);
                sqAst = null;
                this.notifySQLUpdatedRecursive();
            }
            finally {
                this.endUpdate();
            }
        }
        finally {
            sqAst.dispose();
        }
    }

    private void registerSubQuery(SubQuery subQuery) {
        this.subQueries.registerSubQuery(subQuery);
    }

    private void unregisterSubQuery(SubQuery subQuery) {
        this.subQueries.unregisterSubQuery(subQuery);
    }

    @Override
    public void collectVisibleCTE(List<SQLWithClauseItem> cteList) {
        if (((SQLSubSelectStatement)this.astUnionGroup).withClause != null) {
            for (int i = ((SQLSubSelectStatement)this.astUnionGroup).withClause.getCount() - 1; i >= 0; --i) {
                cteList.add(0, (SQLWithClauseItem)((SQLSubSelectStatement)this.astUnionGroup).withClause.get(i));
            }
        }
    }
}

