/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLExpressionColumn;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLFromGroup;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLObjectColumn;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectItemAllColumns;
import com.adbs.ast.SQLSelectItemAllTableColumns;
import com.adbs.ast.SQLSelectItemExpression;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQueryExpression;
import com.adbs.ast.SQLSubQueryExpressions;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.StatisticsBase;
import com.adbs.querybuilder.StatisticsOutputColumn;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatisticsOutputColumnList
extends StatisticsBase {
    final ArrayList<StatisticsOutputColumn> items = new ArrayList();

    public StatisticsOutputColumnList(QueryBuilder queryBuilder, BaseSQLContext sqlContext) {
        super(queryBuilder, sqlContext);
    }

    public StatisticsOutputColumn get(int index) {
        if (!this.isStatisticsValid()) {
            try {
                this.getQueryBuilder().generateResultQueryAST();
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(StatisticsOutputColumnList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.items.get(index);
    }

    public int getCount() {
        if (!this.isStatisticsValid()) {
            try {
                this.getQueryBuilder().generateResultQueryAST();
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(StatisticsOutputColumnList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.items.size();
    }

    @Override
    public void dispose() {
        for (StatisticsOutputColumn c : this.items) {
            c.dispose();
        }
        super.dispose();
    }

    private SQLSubQuerySelectExpression getFirstUnionSubQuery(SQLSubQueryExpressions group) {
        SQLSubQuerySelectExpression result = null;
        for (int i = 0; i < group.getCount(); ++i) {
            SQLSubQueryExpression qe = group.get(i);
            if (qe instanceof SQLSubQuerySelectExpression) {
                return (SQLSubQuerySelectExpression)qe;
            }
            if (!(qe instanceof SQLSubQueryExpressions) || (result = this.getFirstUnionSubQuery((SQLSubQueryExpressions)qe)) == null) continue;
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectItemExpression(SQLSelectItemExpression si) {
        String expr = si.expression.getSimpleSQL(this.getSQLContext().getSQLBuilderExpressionForServer());
        String alias = si.alias != null ? si.alias.alias.getSimpleSQL(this.getSQLContext().getSQLBuilderExpressionForServer()) : "";
        String col = "";
        String objAlias = "";
        String objName = "";
        MetadataField mf = null;
        MetadataObject mo = null;
        SQLExpressionItem ei = si.expression;
        if ((ei = Helpers.expressionRemoveBrackets(ei)) instanceof SQLExpressionColumn) {
            SQLObjectColumn c = ((SQLExpressionColumn)ei).column;
            SQLBuilder builder = this.sqlContext.getSQLBuilderExpressionForServerWithoutQuotes();
            builder.beginBuild();
            try {
                c.buildNonQualifiedNameNames(builder, this.sqlContext.getSQLBuilderExpression().getMainQueryFormat());
            }
            finally {
                builder.endBuild();
            }
            col = builder.getResult();
            SQLFromSource ds = c.datasource;
            if (ds != null) {
                MetadataFieldList fl;
                int i;
                if (ds.alias != null) {
                    objAlias = ds.alias.alias.getToken();
                }
                if ((mo = ds.getMetadataObject()) != null) {
                    objName = mo.getFullNameStr();
                }
                if ((i = (fl = c.datasource.getFieldList()).findFieldByName(col)) != -1) {
                    mf = fl.get(i);
                }
            }
        }
        this.items.add(new StatisticsOutputColumn(this.getQueryBuilder(), this.getSQLContext(), si.expression.getSimpleSQL(this.getSQLContext().getSQLBuilderExpressionForServer()), alias, col, objAlias, objName, mf, mo));
    }

    private void loadAllColumnsOfObject(SQLFromSource obj) {
        MetadataFieldList fl;
        MetadataObject mo;
        String objAlias = "";
        String objName = "";
        if (obj.alias != null && obj.alias.alias != null) {
            objAlias = obj.alias.alias.getToken();
        }
        if ((mo = obj instanceof SQLFromObject ? ((SQLFromObject)obj).getMetadataObject() : null) != null) {
            objName = ((SQLFromObject)obj).getMetadataObject().getFullNameStr();
            fl = mo.getFields();
            if (!mo.getFields().isLoaded()) {
                try {
                    mo.loadFields();
                }
                catch (QueryBuilderException ex) {
                    Logger.getLogger(StatisticsOutputColumnList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            fl = obj.getFieldList();
        }
        for (int i = 0; i < fl.getCount(); ++i) {
            MetadataField mf = fl.get(i);
            String col = mf.getName().getSimpleSQL(this.sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
            String objNameD = !Str.IsNullOrEmpty(objAlias) ? objAlias + "." : (!Str.IsNullOrEmpty(objName) ? objName + "." : "");
            this.items.add(new StatisticsOutputColumn(this.getQueryBuilder(), this.getSQLContext(), objNameD + mf.getNameStr(), "", col, objAlias, objName, mf, mo));
        }
    }

    private void addSelectItemAllFromObject(SQLSelectItemAllTableColumns si) {
        if (si.databaseObject.datasource != null) {
            this.loadAllColumnsOfObject(si.databaseObject.datasource);
        }
    }

    private void loadAllColumnsOfGroup(SQLFromGroup group) {
        for (int i = 0; i < group.getCount(); ++i) {
            SQLFromSource fs = group.get(i);
            if (fs instanceof SQLFromGroup) {
                this.loadAllColumnsOfGroup((SQLFromGroup)fs);
                continue;
            }
            this.loadAllColumnsOfObject(fs);
        }
    }

    private void addSelectItemAll(SQLSubQuerySelectExpression se) {
        if (se.from != null) {
            this.loadAllColumnsOfGroup(se.from);
        }
    }

    public void reloadStatistics(SQLSelectStatement query) {
        for (StatisticsOutputColumn c : this.items) {
            c.dispose();
        }
        this.items.clear();
        SQLSubQuerySelectExpression se = this.getFirstUnionSubQuery(query);
        if (se != null) {
            for (int i = 0; i < se.selectItems.getCount(); ++i) {
                SQLSelectItem si = se.selectItems.get(i);
                if (si instanceof SQLSelectItemExpression) {
                    this.addSelectItemExpression((SQLSelectItemExpression)si);
                    continue;
                }
                if (si instanceof SQLSelectItemAllTableColumns) {
                    this.addSelectItemAllFromObject((SQLSelectItemAllTableColumns)si);
                    continue;
                }
                if (!(si instanceof SQLSelectItemAllColumns)) continue;
                this.addSelectItemAll(se);
            }
        }
        this.setStatisticsValid();
    }
}

