/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.SQLBuilder;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.CriteriaItem;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.CustomTree;
import com.adbs.querybuilder.CustomTreeCellRenderer;
import com.adbs.querybuilder.CustomTreeNode;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryStructureTreeOptions;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Str;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class QueryStructureTree
extends CustomTree
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    int updating;
    private CustomTreeNode root = null;
    DefaultTreeModel model = null;

    public QueryStructureTree(QueryBuilder queryBuilder) {
        super(queryBuilder);
        this.setRootVisible(false);
        this.root = new CustomTreeNode("root");
        this.model = new DefaultTreeModel(this.root);
        this.root.removeAllChildren();
        this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 1));
        this.setCellRenderer(new CustomTreeCellRenderer());
        this.setModel(this.model);
        this.expandPath(new TreePath(this.root.getPath()));
        this.addTreeSelectionListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2 && QueryStructureTree.this.updating == 0 && QueryStructureTree.this.getSelectionCount() != 0 && ((CustomTreeNode)QueryStructureTree.this.getSelectionPath().getLastPathComponent()).tag != null) {
                    ControlOwner o = (ControlOwner)((CustomTreeNode)QueryStructureTree.this.getSelectionPath().getLastPathComponent()).tag;
                    o.editProps(SwingUtilities.getWindowAncestor(QueryStructureTree.this));
                }
            }
        });
    }

    public void beginUpdate() {
        ++this.updating;
    }

    public void endUpdate() {
        --this.updating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CustomTreeNode findTreePosition(ControlOwner obj, Enumeration nodes) {
        this.beginUpdate();
        try {
            if (obj == null) {
                CustomTreeNode customTreeNode = null;
                return customTreeNode;
            }
            CustomTreeNode target = null;
            while (nodes.hasMoreElements()) {
                CustomTreeNode n = (CustomTreeNode)nodes.nextElement();
                if ((ControlOwner)n.tag == obj) {
                    CustomTreeNode customTreeNode = n;
                    return customTreeNode;
                }
                if (n.getChildCount() <= 0 || (target = this.findTreePosition(obj, n.children())) == null) continue;
                CustomTreeNode customTreeNode = target;
                return customTreeNode;
            }
        }
        finally {
            this.endUpdate();
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.updating == 0 && this.getSelectionCount() != 0 && ((CustomTreeNode)this.getSelectionPath().getLastPathComponent()).tag != null) {
            ControlOwner o = (ControlOwner)((CustomTreeNode)this.getSelectionPath().getLastPathComponent()).tag;
            QueryBuilder qb = this.getQueryBuilder();
            if (o instanceof SubQuery) {
                qb.setActiveSubquery((SubQuery)o);
            } else if (o instanceof UnionSubQuery) {
                qb.setActiveSubquery(((UnionSubQuery)o).getRootQuery());
                qb.getActiveSubquery().setActiveUnionSubquery((UnionSubQuery)o);
            } else if (o instanceof DataSource) {
                qb.setActiveSubquery(((DataSource)o).getQuery().getRootQuery());
                qb.getActiveSubquery().setActiveUnionSubquery(((DataSource)o).getQuery());
            } else if (o instanceof DatasourceGroup) {
                qb.setActiveSubquery(((DatasourceGroup)o).getQuery().getRootQuery());
                qb.getActiveSubquery().setActiveUnionSubquery(((DatasourceGroup)o).getQuery());
            } else if (o instanceof CriteriaItem) {
                qb.setActiveSubquery(((CriteriaItem)o).criteriaList.getUnionSubQuery().getRootQuery());
                qb.getActiveSubquery().setActiveUnionSubquery(((CriteriaItem)o).criteriaList.getUnionSubQuery());
                CriteriaList cl = qb.getActiveSubquery().getActiveUnionSubquery().getCriteriaList();
                if (cl.isControlsCreated()) {
                    int x = ((CriteriaItem)o).criteriaList.indexOf((CriteriaItem)o);
                    cl.getCriteriaListControl().setRowSelectionInterval(x, x);
                }
            } else if (o instanceof CriteriaList) {
                SubQuery rootQuery = ((CriteriaList)o).getUnionSubQuery().getRootQuery();
                qb.setActiveSubquery(rootQuery);
                rootQuery.setActiveUnionSubquery(((CriteriaList)o).getUnionSubQuery());
            }
        }
    }

    private CustomTreeNode findNodeForData(Enumeration nodes, TreeNodeData d) {
        CustomTreeNode result = null;
        while (nodes.hasMoreElements() && result == null) {
            CustomTreeNode n = (CustomTreeNode)nodes.nextElement();
            if (n.tag == d.obj && (!d.unions && !n.text.equals(this.getQueryBuilder().getQueryStructureTreeOptions().getUnionsNodeText()) || d.unions && n.text.equals(this.getQueryBuilder().getQueryStructureTreeOptions().getUnionsNodeText()))) {
                result = n;
                continue;
            }
            result = this.findNodeForData(n.children(), d);
        }
        return result;
    }

    private void saveTreeData(Enumeration nodes, List<TreeNodeData> treeData) {
        while (nodes.hasMoreElements()) {
            CustomTreeNode n = (CustomTreeNode)nodes.nextElement();
            TreeNodeData data = new TreeNodeData();
            data.expanded = n.getChildCount() > 0 ? this.isExpanded(new TreePath(n)) : false;
            data.focused = this.getSelectionPath() != null && this.getSelectionPath().getLastPathComponent() == n;
            data.obj = (ControlOwner)n.tag;
            data.unions = n.text.equals(this.getQueryBuilder().getQueryStructureTreeOptions().getUnionsNodeText());
            treeData.add(data);
            this.saveTreeData(n.children(), treeData);
        }
    }

    private void loadTreeData(List<TreeNodeData> treeData) {
        for (int i = 0; i < treeData.size(); ++i) {
            TreePath parentPath;
            CustomTreeNode n = this.findNodeForData(this.root.children(), treeData.get(i));
            if (n == null) continue;
            TreePath nodePath = new TreePath(n.getPath());
            if (treeData.get((int)i).expanded) {
                this.expandPath(nodePath);
            }
            if (!treeData.get((int)i).focused || n.getParent() == null || !this.isVisible(parentPath = new TreePath(((DefaultMutableTreeNode)n.getParent()).getPath())) || !this.isExpanded(parentPath)) continue;
            this.setSelectionPath(nodePath);
        }
    }

    private CustomTreeNode addNode(CustomTreeNode parent, String text, ControlOwner obj, Icon icon) {
        CustomTreeNode result = new CustomTreeNode(text, obj, icon);
        if (parent == null) {
            this.root.add(result);
        } else {
            parent.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromGroup(CustomTreeNode parent, DatasourceGroup f) {
        for (int i = 0; i < f.getCount(); ++i) {
            if (f.get(i) instanceof DatasourceGroup) {
                this.loadFromGroup(parent, (DatasourceGroup)f.get(i));
                continue;
            }
            DataSource ds = (DataSource)f.get(i);
            SQLBuilder builderExpression = ds.sqlContext.getSQLBuilderExpression();
            builderExpression.beginBuild();
            try {
                ds.astFromSource.buildExpression(builderExpression, builderExpression.getMainQueryFormat());
            }
            finally {
                builderExpression.endBuild();
            }
            String s = builderExpression.getResult();
            if (!Str.IsNullOrEmpty(ds.getAlias())) {
                this.addNode(parent, ds.getAlias() + " " + s, ds, this.queryBuilder.getQueryStructureTreeOptions().getFromObjIcon());
                continue;
            }
            this.addNode(parent, s, ds, this.queryBuilder.getQueryStructureTreeOptions().getFromObjIcon());
        }
    }

    private void loadUnionSubQuery(CustomTreeNode parent, UnionSubQuery u) {
        CustomTreeNode listNode;
        QueryStructureTreeOptions options = this.getQueryBuilder().getQueryStructureTreeOptions();
        if (options.isShowFields()) {
            listNode = this.addNode(parent, options.getFieldsNodeText(), u.getCriteriaList(), options.getFieldsIcon());
            for (int i = 0; i < u.getCriteriaList().getCount(); ++i) {
                if (!u.getCriteriaList().get(i).isSelected()) continue;
                this.addNode(listNode, u.getCriteriaList().get(i).getExpressionString(), u.getCriteriaList().get(i), options.getFieldIcon());
            }
            if (options.isExpandFieldsNodes()) {
                this.expandPath(new TreePath(listNode.getPath()));
            }
        }
        if (u.getFromClause() != null && options.isShowFrom()) {
            listNode = this.addNode(parent, options.getFromNodeText(), u.getFromClause(), options.getFromIcon());
            this.loadFromGroup(listNode, u.getFromClause());
            if (options.isExpandFromNodes()) {
                this.expandPath(new TreePath(listNode.getPath()));
            }
        }
    }

    private void loadUnionGroup(CustomTreeNode parent, UnionGroup g, String caption) {
        DefaultMutableTreeNode usqn = null;
        QueryStructureTreeOptions options = this.getQueryBuilder().getQueryStructureTreeOptions();
        CustomTreeNode un = this.addNode(parent, caption, g, options.getQueriesIcon());
        for (int i = 0; i < g.getCount(); ++i) {
            if (g.get(i) instanceof UnionGroup) {
                this.loadUnionGroup(un, (UnionGroup)g.get(i), "()");
            } else if (g.get(i) instanceof UnionSubQuery) {
                UnionSubQuery usq = (UnionSubQuery)g.get(i);
                usqn = this.addNode(un, usq.getResultSQL(usq.getSQLContext().getSQLBuilderExpression()), usq, options.getQueriesIcon());
                this.loadUnionSubQuery((CustomTreeNode)usqn, usq);
            }
            if (!options.isExpandUnionsNodes() || usqn == null) continue;
            this.expandPath(new TreePath(usqn.getPath()));
        }
        if (options.isExpandUnionsNodes() && un != null) {
            this.expandPath(new TreePath(un.getPath()));
        }
    }

    private CustomTreeNode loadQuery(CustomTreeNode parent, SubQuery q) {
        QueryStructureTreeOptions options = this.getQueryBuilder().getQueryStructureTreeOptions();
        CustomTreeNode result = this.addNode(parent, q.getCaption(), q, options.getQueriesIcon());
        if (q.getCount() == 1 && q.get(0) instanceof UnionSubQuery) {
            this.loadUnionSubQuery(result, (UnionSubQuery)q.get(0));
        } else {
            this.loadUnionGroup(result, q, options.getUnionsNodeText());
        }
        for (int i = 0; i < q.getSubQueryCount(); ++i) {
            this.loadQuery(result, q.getSubQueries().get(i));
        }
        if (options.isExpandQueryNodes()) {
            this.expandPath(new TreePath(result.getPath()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTree() {
        if (this.getQueryBuilder().isDisposing() || !this.getQueryBuilder().getQueryStructureTreeOptions().isTreeVisible()) {
            return;
        }
        ArrayList<TreeNodeData> treeData = new ArrayList<TreeNodeData>();
        treeData.ensureCapacity(this.getRowCount());
        this.beginUpdate();
        try {
            this.saveTreeData(this.root.children(), treeData);
            this.root.removeAllChildren();
            CustomTreeNode queryNode = this.loadQuery(this.root, this.getQueryBuilder().getQuery());
            this.loadTreeData(treeData);
            this.model.reload();
            this.expandPath(new TreePath(this.root.getPath()));
            this.expandPath(new TreePath(queryNode.getPath()));
            if (this.root.getChildCount() > 0) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    this.expandRow(i);
                }
                this.scrollRowToVisible(0);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    private class TreeNodeData {
        public boolean expanded;
        public boolean focused;
        public boolean unions;
        public ControlOwner obj;

        private TreeNodeData() {
        }
    }
}

