/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.DataSourceBase;
import com.adbs.querybuilder.DataSourceControl;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.Extender;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkControl;
import com.adbs.querybuilder.LinkDeletingEvent;
import com.adbs.querybuilder.LinkManipulations;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.UnionButton;
import com.adbs.querybuilder.UnionSubQueryPanel;
import com.adbs.utils.Helpers;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DiagramPane
extends JDesktopPane
implements DropTargetListener {
    private static final long serialVersionUID = 1L;
    private QueryBuilder queryBuilder;
    private Component focusedControl;
    private UnionSubQueryPanel unionSubQueryPanel;
    private LinkLabelInternal freeVersionLink;
    private Object fvbi;
    private DropTarget dropTarget;
    private Extender extender = null;
    private final int horzMargin = 50;
    private final int vertMargin = 20;

    public DiagramPane(UnionSubQueryPanel tab) {
        this.unionSubQueryPanel = tab;
        this.queryBuilder = tab.getQueryBuilder();
        this.setDoubleBuffered(true);
        this.setAutoscrolls(false);
        this.setBackground(Color.WHITE);
        this.setLayout(null);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.dropTarget = new DropTarget(this, this);
        this.updateDropTarget();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DiagramPane.this.onMousePressed(e);
                super.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DiagramPane.this.onMouseReleased(e);
                super.mouseReleased(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                DiagramPane.this.onMouseClicked(e);
                super.mouseClicked(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DiagramPane.this.onKeyPressed(e);
                super.keyPressed(e);
            }
        });
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public Component getFocusedControl() {
        return this.focusedControl;
    }

    public void setFocusedControl(Component value) {
        if (this.focusedControl != value) {
            if (this.focusedControl != null) {
                this.focusedControl.repaint();
            }
            Component old = this.focusedControl;
            this.focusedControl = value;
            if (this.focusedControl != null) {
                // empty if block
            }
            if (old != null) {
                old.repaint();
            }
        }
    }

    private void paintLinksOfDatasourceGroup(Graphics g, DatasourceGroup dg) {
        for (Link l : dg.links) {
            if (!l.isControlsCreated()) continue;
            l.getLinkControl().paintLink(g);
        }
        for (DataSourceBase db : dg.items) {
            if (!(db instanceof DatasourceGroup)) continue;
            this.paintLinksOfDatasourceGroup(g, (DatasourceGroup)db);
        }
    }

    private Link hitTestDatasourceLinks(Point p, DatasourceGroup dg) {
        Link result = null;
        for (Link l : dg.links) {
            if (!l.getLinkControl().hitTest(p)) continue;
            result = l;
            break;
        }
        if (result == null) {
            for (DataSourceBase db : dg.items) {
                if (!(db instanceof DatasourceGroup)) continue;
                result = this.hitTestDatasourceLinks(p, (DatasourceGroup)db);
            }
        }
        return result;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintLinksOfDatasourceGroup(g, this.unionSubQueryPanel.getUnionSubQuery().getFromClause());
        UnionButton unionButton = this.unionSubQueryPanel.getUnionSubQuery().getUnionButton();
        if (unionButton != null) {
            unionButton.getParent().repaint();
        }
        if (this.extender != null) {
            this.extender.extendPaintComponent(g);
        }
    }

    public Point findEmptyPlace(DataSourceControl newDataSourceControl) {
        int containerWidth = this.getWidth();
        int containerHeight = Integer.MAX_VALUE;
        if (containerWidth == 0) {
            containerWidth = this.getQueryBuilder().getWidth();
        }
        if (containerWidth == 0) {
            containerWidth = 800;
        }
        if (containerWidth < 300) {
            containerWidth = 500;
        }
        int w = newDataSourceControl.getWidth() + 100;
        int h = newDataSourceControl.getHeight() + 40;
        ArrayList<Integer> xx = new ArrayList<Integer>(Arrays.asList(0, containerWidth));
        ArrayList<Integer> yy = new ArrayList<Integer>(Arrays.asList(0, containerHeight));
        ArrayList<List<Integer>> markedCells = new ArrayList<List<Integer>>();
        this.fillMatrix(xx, yy, markedCells, newDataSourceControl);
        return this.getNextEmptyPlace(xx, yy, markedCells, w, h);
    }

    private void fillMatrix(List<Integer> xx, List<Integer> yy, List<List<Integer>> markedCells, DataSourceControl newDataSourceControl) {
        for (Component component : this.getComponents()) {
            if (component == newDataSourceControl || !(component instanceof DataSourceControl)) continue;
            xx.add(component.getX());
            xx.add(component.getX() + component.getWidth());
            yy.add(component.getY());
            yy.add(component.getY() + component.getHeight());
        }
        Collections.sort(xx);
        Collections.sort(yy);
        for (int xi = 0; xi < xx.size(); ++xi) {
            ArrayList<Integer> row = new ArrayList<Integer>();
            for (int yi = 0; yi < yy.size(); ++yi) {
                row.add(xi == xx.size() - 1 || yi == yy.size() - 1 ? 1 : 0);
            }
            markedCells.add(row);
        }
        for (Component component : this.getComponents()) {
            if (component == newDataSourceControl || !(component instanceof DataSourceControl)) continue;
            int objX1 = component.getX();
            int objX2 = component.getX() + component.getWidth();
            int objY1 = component.getY();
            int objY2 = component.getY() + component.getHeight();
            int freeX1 = 0;
            int freeX2 = 0;
            for (int xi = 0; xi < xx.size(); ++xi) {
                if (xx.get(xi) <= objX1) {
                    freeX1 = xi;
                }
                if (objX2 > xx.get(xi)) continue;
                freeX2 = xi;
                break;
            }
            int freeY1 = 0;
            int freeY2 = 0;
            for (int yi = 0; yi < yy.size(); ++yi) {
                if (yy.get(yi) <= objY1) {
                    freeY1 = yi;
                }
                if (objY2 > yy.get(yi)) continue;
                freeY2 = yi;
                break;
            }
            for (int xi = freeX1; xi < freeX2; ++xi) {
                for (int yi = freeY1; yi < freeY2; ++yi) {
                    markedCells.get(xi).set(yi, 1);
                }
            }
        }
    }

    private Point getNextEmptyPlace(List<Integer> xx, List<Integer> yy, List<List<Integer>> markedCells, int w, int h) {
        for (int yi = 0; yi < yy.size(); ++yi) {
            for (int xi = 0; xi < xx.size(); ++xi) {
                if (markedCells.get(xi).get(yi) != 0 || !this.doesItFit(xx, yy, markedCells, xi, yi, w, h)) continue;
                return new Point(xx.get(xi) + 50, yy.get(yi) + 20);
            }
        }
        return new Point(50, 20);
    }

    private boolean doesItFit(List<Integer> xx, List<Integer> yy, List<List<Integer>> markedCells, int xi, int yi, int w, int h) {
        for (int j = yi; j <= yy.size() && yy.get(j) - yy.get(yi) < h; ++j) {
            for (int i = xi; i < xx.size() && xx.get(i) - xx.get(xi) < w; ++i) {
                if (markedCells.get(i).get(j) != 1) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        int maxX = 0;
        int maxY = 0;
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataSourceControl)) continue;
            maxX = Math.max(maxX, c.getX() + c.getWidth());
            maxY = Math.max(maxY, c.getY() + c.getHeight());
        }
        return new Dimension(maxX += 10, maxY += 10);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        for (Component c : this.getComponents()) {
            if (!(c instanceof LinkControl) || !c.isVisible()) continue;
            ((LinkControl)c).alignLink();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        if (!event.getTransferable().isDataFlavorSupported(DataFlavor.stringFlavor)) {
            event.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent event) {
        event.acceptDrop(0x40000000);
        Transferable transferable = event.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                String data = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                String[] ss = data.split("\n");
                Point pos = ss.length > 1 ? new Point(0, 0) : event.getLocation();
                for (String s : ss) {
                    if ((s = s.trim()).length() <= 0) continue;
                    this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().addObjectWithFKAt(s, pos, "");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(DiagramPane.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void onMousePressed(MouseEvent e) {
        Link l = this.hitTestDatasourceLinks(e.getPoint(), this.unionSubQueryPanel.getUnionSubQuery().getFromClause());
        this.setFocusedControl(l != null ? l.getLinkControl() : null);
        this.requestFocus();
        this.repaint();
    }

    private void onMouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            Link l = this.hitTestDatasourceLinks(e.getPoint(), this.unionSubQueryPanel.getUnionSubQuery().getFromClause());
            if (l != null) {
                this.queryBuilder.popupMenuPopup(l.getLinkControl().getPopupMenu(), (JComponent)e.getSource(), l, e.getPoint());
            } else {
                this.queryBuilder.popupMenuPopup(this.unionSubQueryPanel.getUnionSubQuery().getPopupMenuWA(), (JComponent)e.getSource(), this.unionSubQueryPanel.getUnionSubQuery(), e.getPoint());
            }
        }
    }

    private void onMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (this.focusedControl != null && this.focusedControl instanceof LinkControl) {
                Link l = ((LinkControl)this.focusedControl).getLink();
                if (l.getQueryBuilder().getLinkOptions().getLinkManipulations() != LinkManipulations.Deny) {
                    l.editProps(SwingUtilities.getWindowAncestor(this));
                    if (l.getLinkExpression() == null) {
                        l.dispose();
                    }
                    this.repaint();
                }
            } else {
                this.unionSubQueryPanel.getUnionSubQuery().editProps(SwingUtilities.getWindowAncestor(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.focusedControl != null && this.focusedControl instanceof LinkControl) {
            Link link = ((LinkControl)this.focusedControl).getLink();
            if (link.isDisposing()) {
                return;
            }
            if (link.getQueryBuilder().getLinkOptions().getLinkManipulations() == LinkManipulations.Deny) {
                return;
            }
            LinkDeletingEvent linkDeletingEvent = new LinkDeletingEvent(this.queryBuilder, link.getDatasourceGroup().getQuery(), link);
            this.queryBuilder.fireLinkDeletingEvent(linkDeletingEvent);
            if (!linkDeletingEvent.abort) {
                this.queryBuilder.getQuery().beginUpdate();
                try {
                    ((LinkControl)this.focusedControl).getLink().dispose();
                }
                finally {
                    this.queryBuilder.getQuery().endUpdate();
                }
            }
            this.repaint();
            return;
        }
    }

    final void updateDropTarget() {
        DropTarget customDropTarget = this.queryBuilder.getCustomDiagramPaneDropTarget();
        if (this.dropTarget != customDropTarget) {
            if (customDropTarget != null) {
                this.setDropTarget(customDropTarget);
            } else {
                this.setDropTarget(this.dropTarget);
            }
        }
    }

    @Override
    public void updateUI() {
        if ("Nimbus".equals(UIManager.getLookAndFeel().getName())) {
            return;
        }
        super.updateUI();
    }

    public Extender getExtender() {
        return this.extender;
    }

    public void setExtender(Extender extender) {
        this.extender = extender;
    }

    private class LinkLabelInternal
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private String url;
        private Color unvisitedURL;
        private Color visitedURL;

        public LinkLabelInternal(String text, String url) {
            super(text);
            this.unvisitedURL = Color.blue;
            this.visitedURL = new Color(0, 0, 128);
            this.setForeground(this.unvisitedURL);
            try {
                this.url = url;
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        LinkLabelInternal.this.setForeground(LinkLabelInternal.this.visitedURL);
                        Helpers.openURL(LinkLabelInternal.this.url);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    LinkLabelInternal.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    LinkLabelInternal.this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Rectangle r = g.getClipBounds();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            g.drawLine(0, r.height - fontMetrics.getDescent() + 1, fontMetrics.stringWidth(this.getText()), r.height - fontMetrics.getDescent() + 1);
        }
    }
}

