/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.ObjectPrefixSkipping;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNamesComparator;
import com.adbs.ast.SortByNameComparator;
import com.adbs.ast.SortBySchemaTypeNameComparator;
import com.adbs.ast.SortByTypeNameComparator;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.AddObjectDialogOptions;
import com.adbs.querybuilder.DataSourceObject;
import com.adbs.querybuilder.MetadataTreeOptions;
import com.adbs.querybuilder.ObjectsSortingType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class AddObjectDialog
extends JDialog
implements UpdatedEventListener,
ListSelectionListener,
ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private QueryBuilder queryBuilder;
    private MetadataContainer metadataContainer;
    private ArrayList schemaList = new ArrayList();
    private JButton buttonAdd;
    private JButton buttonCancel;
    private JComboBox comboSchemas;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel label1;
    private JLabel label2;
    private JList listProcedures;
    private JList listSynonyms;
    private JList listTables;
    private JList listViews;
    private JScrollPane pageProcedures;
    private JScrollPane pageSynonyms;
    private JScrollPane pageTables;
    private JScrollPane pageViews;
    private JTabbedPane tabObjects;

    public AddObjectDialog(Window parent, QueryBuilder owner, MetadataContainer metadataContainer) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.queryBuilder = owner;
        this.metadataContainer = metadataContainer;
        this.initComponents();
        this.setIconImage(Helpers.createImageIcon("images/qb.png").getImage());
        this.loadOptions();
        this.tabObjects.addChangeListener(this);
        this.tabObjects.setSelectedIndex(0);
        Helpers.localizer.localizeDialog(this);
        this.setLocationRelativeTo(parent);
        this.listTables.setModel(new DefaultListModel());
        this.listViews.setModel(new DefaultListModel());
        this.listProcedures.setModel(new DefaultListModel());
        this.listSynonyms.setModel(new DefaultListModel());
        this.listTables.setCellRenderer(new CustomCellRenderer());
        this.listViews.setCellRenderer(new CustomCellRenderer());
        this.listProcedures.setCellRenderer(new CustomCellRenderer());
        this.listSynonyms.setCellRenderer(new CustomCellRenderer());
        this.listTables.addListSelectionListener(this);
        this.listViews.addListSelectionListener(this);
        this.listProcedures.addListSelectionListener(this);
        this.listSynonyms.addListSelectionListener(this);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2 && ((JList)e.getSource()).getSelectedIndex() != -1) {
                    AddObjectDialog.this.buttonAddActionPerformed(null);
                }
            }
        };
        this.listTables.addMouseListener(ma);
        this.listViews.addMouseListener(ma);
        this.listProcedures.addMouseListener(ma);
        this.listSynonyms.addMouseListener(ma);
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentHidden(ComponentEvent e) {
                AddObjectDialogOptions o = AddObjectDialog.this.queryBuilder.getAddObjectDialogOptions();
                o.beginUpdate();
                try {
                    if (o.getWidth() != AddObjectDialog.this.getWidth()) {
                        o.setWidth(AddObjectDialog.this.getWidth());
                    }
                    if (o.getHeight() != AddObjectDialog.this.getHeight()) {
                        o.setHeight(AddObjectDialog.this.getHeight());
                    }
                }
                finally {
                    o.endUpdate();
                }
                super.componentHidden(e);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                super.componentShown(e);
                AddObjectDialog.this.loadOptions();
                AddObjectDialog.this.loadSchemas();
                AddObjectDialog.this.loadMetadata();
            }
        });
        this.comboSchemas.addActionListener(this);
    }

    public MetadataContainer getMetadataContainer() {
        return this.metadataContainer;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateAddObjectButtonState();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateAddObjectButtonState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadMetadata();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.buttonCancel = new JButton();
        this.buttonAdd = new JButton();
        this.jPanel2 = new JPanel();
        this.comboSchemas = new JComboBox();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.tabObjects = new JTabbedPane();
        this.pageTables = new JScrollPane();
        this.listTables = new JList();
        this.pageViews = new JScrollPane();
        this.listViews = new JList();
        this.pageProcedures = new JScrollPane();
        this.listProcedures = new JList();
        this.pageSynonyms = new JScrollPane();
        this.listSynonyms = new JList();
        this.setTitle("Add new object");
        this.setFont(new Font("Dialog", 0, 11));
        this.setIconImage(null);
        this.setMinimumSize(new Dimension(100, 100));
        this.setModal(true);
        this.setName("AddObjectDialog");
        this.jPanel1.setFont(this.jPanel1.getFont());
        this.buttonCancel.setText("Close");
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddObjectDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonAdd.setText("Add Object");
        this.buttonAdd.setName("buttonAdd");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddObjectDialog.this.buttonAddActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.buttonAdd, -2, 135, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 203, Short.MAX_VALUE).addComponent(this.buttonCancel, -2, 90, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonAdd)).addContainerGap()));
        this.jPanel2.setFont(this.jPanel2.getFont());
        this.comboSchemas.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"}));
        this.label1.setBackground(null);
        this.label1.setFont(this.label1.getFont());
        this.label1.setText("<html>Select an object and press the \"Add Object\" button to add new object to the query</html>");
        this.label1.setName("label1");
        this.label2.setBackground(null);
        this.label2.setFont(this.label2.getFont());
        this.label2.setText("<html>Filter objects by Schema name:<html>");
        this.label2.setName("label2");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label1, -1, 428, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.label2, -1, 219, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboSchemas, -2, 199, -2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.label1, -1, 14, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboSchemas, -2, -1, -2).addComponent(this.label2, -1, 20, Short.MAX_VALUE)).addContainerGap()));
        this.tabObjects.setName("");
        this.pageTables.setBorder(null);
        this.pageTables.setName("pageTables");
        this.listTables.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.listTables.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.pageTables.setViewportView(this.listTables);
        this.tabObjects.addTab("Tables", this.pageTables);
        this.pageViews.setBorder(null);
        this.pageViews.setName("pageViews");
        this.listViews.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.listViews.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.pageViews.setViewportView(this.listViews);
        this.tabObjects.addTab("Views", this.pageViews);
        this.pageProcedures.setBorder(null);
        this.pageProcedures.setName("pageProcedures");
        this.listProcedures.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.listProcedures.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.pageProcedures.setViewportView(this.listProcedures);
        this.tabObjects.addTab("Procedures", this.pageProcedures);
        this.pageSynonyms.setBorder(null);
        this.pageSynonyms.setName("pageSynonyms");
        this.listSynonyms.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.listSynonyms.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.pageSynonyms.setViewportView(this.listSynonyms);
        this.tabObjects.addTab("Synonyms", this.pageSynonyms);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabObjects, -1, 428, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabObjects, -1, 337, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        block14: {
            block16: {
                block15: {
                    block13: {
                        if (this.tabObjects.getSelectedComponent() != this.pageTables) break block13;
                        if (this.queryBuilder.getActiveSubquery() == null || this.queryBuilder.getActiveSubquery().getActiveUnionSubquery() == null) break block14;
                        for (Object o : this.listTables.getSelectedValues()) {
                            DataSourceObject dataSource = null;
                            ListItem item = (ListItem)o;
                            MetadataObject mo = (MetadataObject)item.tag;
                            try {
                                dataSource = (DataSourceObject)this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().addObject(mo.getFullName());
                            }
                            catch (QueryBuilderException ex) {
                                Logger.getLogger(AddObjectDialog.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            if (dataSource == null || !this.queryBuilder.getLinkOptions().isCreateLinksFromRelations()) continue;
                            this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().addFKLinksForObject(dataSource);
                        }
                        break block14;
                    }
                    if (this.tabObjects.getSelectedComponent() != this.pageViews) break block15;
                    if (this.queryBuilder.getActiveSubquery() == null || this.queryBuilder.getActiveSubquery().getActiveUnionSubquery() == null) break block14;
                    for (Object o : this.listViews.getSelectedValues()) {
                        ListItem item = (ListItem)o;
                        MetadataObject mo = (MetadataObject)item.tag;
                        try {
                            this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().addObject(mo.getFullName());
                        }
                        catch (QueryBuilderException ex) {
                            Logger.getLogger(AddObjectDialog.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    break block14;
                }
                if (this.tabObjects.getSelectedComponent() != this.pageProcedures) break block16;
                if (this.queryBuilder.getActiveSubquery() == null || this.queryBuilder.getActiveSubquery().getActiveUnionSubquery() == null) break block14;
                for (Object o : this.listProcedures.getSelectedValues()) {
                    ListItem item = (ListItem)o;
                    MetadataObject mo = (MetadataObject)item.tag;
                    try {
                        this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().addStoredProc(mo.getFullName().getQualifiedName(), item.text + "_");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(AddObjectDialog.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                break block14;
            }
            if (this.tabObjects.getSelectedComponent() == this.pageSynonyms && this.queryBuilder.getActiveSubquery() != null && this.queryBuilder.getActiveSubquery().getActiveUnionSubquery() != null) {
                for (Object o : this.listSynonyms.getSelectedValues()) {
                    ListItem item = (ListItem)o;
                    MetadataObject mo = (MetadataObject)item.tag;
                    try {
                        this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().addObject(mo.getFullName());
                    }
                    catch (QueryBuilderException ex) {
                        Logger.getLogger(AddObjectDialog.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    @Override
    public void updatedEventOccurred(UpdatedEvent event) {
        this.loadOptions();
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private void loadOptions() {
        AddObjectDialogOptions o = this.queryBuilder.getAddObjectDialogOptions();
        this.setMinimumSize(o.getMinimumSize());
        this.setSize(new Dimension(o.getWidth(), o.getHeight()));
        Component[] components = this.tabObjects.getComponents();
        if (o.isShowTables()) {
            if (!Helpers.arrayContains(components, this.pageTables)) {
                this.tabObjects.add(this.pageTables);
            }
        } else {
            this.tabObjects.remove(this.pageTables);
        }
        if (o.isShowViews()) {
            if (!Helpers.arrayContains(components, this.pageViews)) {
                this.tabObjects.add(this.pageViews);
            }
        } else {
            this.tabObjects.remove(this.pageViews);
        }
        if (o.isShowProcedures()) {
            if (!Helpers.arrayContains(components, this.pageProcedures)) {
                this.tabObjects.add(this.pageProcedures);
            }
        } else {
            this.tabObjects.remove(this.pageProcedures);
        }
        if (o.isShowSynonyms()) {
            if (!Helpers.arrayContains(components, this.pageSynonyms)) {
                this.tabObjects.add(this.pageSynonyms);
            }
        } else {
            this.tabObjects.remove(this.pageSynonyms);
        }
    }

    private void updateAddObjectButtonState() {
        JList l;
        if (this.tabObjects.getSelectedComponent() == this.pageTables) {
            l = this.listTables;
        } else if (this.tabObjects.getSelectedComponent() == this.pageViews) {
            l = this.listViews;
        } else if (this.tabObjects.getSelectedComponent() == this.pageProcedures) {
            l = this.listProcedures;
        } else if (this.tabObjects.getSelectedComponent() == this.pageSynonyms) {
            l = this.listSynonyms;
        } else {
            this.buttonAdd.setEnabled(false);
            return;
        }
        this.buttonAdd.setEnabled(l.getSelectedIndex() != -1);
    }

    private int findSchemaName(List schemas, SQLQualifiedName schemaName) {
        for (int i = 0; i < schemas.size(); ++i) {
            if (!schemaName.getSQLContext().isQualifiedNamesEqual(schemaName, (SQLQualifiedName)schemas.get(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchemas() {
        this.comboSchemas.removeActionListener(this);
        try {
            int i;
            SQLQualifiedName oldSchema = this.getCurrentSchema();
            if (oldSchema != null) {
                this.schemaList.remove(oldSchema);
            }
            this.schemaList.clear();
            SQLQualifiedName qn = new SQLQualifiedName(this.queryBuilder.getSQLContext());
            for (i = 0; i < this.metadataContainer.getCount(); ++i) {
                MetadataObject mo = this.metadataContainer.get(i);
                qn.clear();
                qn.assign(mo.getDatabase());
                qn.dbLink = null;
                if (mo.getDBLink().getCount() > 0) {
                    qn.dbLink = mo.getDBLink().clone(qn.getSQLContext());
                }
                if (qn.getCount() > 0 && this.findSchemaName(this.schemaList, qn) == -1) {
                    this.schemaList.add(qn.clone(this.queryBuilder.getSQLContext()));
                }
                if (!Str.IsNullOrEmpty(mo.getSchema().getToken())) {
                    qn.addName(mo.getSchema().clone(this.queryBuilder.getSQLContext()));
                }
                if (qn.getCount() <= 0 || this.findSchemaName(this.schemaList, qn) != -1) continue;
                this.schemaList.add(qn.clone(this.queryBuilder.getSQLContext()));
            }
            Collections.sort(this.schemaList, new SQLQualifiedNamesComparator());
            this.comboSchemas.removeAllItems();
            this.comboSchemas.addItem(Helpers.localizer.getString("strAllObjects", "(All objects)"));
            for (i = 0; i < this.schemaList.size(); ++i) {
                this.comboSchemas.addItem(((SQLQualifiedName)this.schemaList.get(i)).getQualifiedNameWithoutQuotes());
            }
            this.comboSchemas.setEnabled(this.canFilterObjects());
            int x = 0;
            if (oldSchema != null) {
                x = this.findSchemaName(this.schemaList, oldSchema);
                x = x == -1 ? 0 : ++x;
            }
            if (x < this.comboSchemas.getItemCount()) {
                this.comboSchemas.setSelectedIndex(x);
            }
        }
        finally {
            this.comboSchemas.addActionListener(this);
        }
    }

    private boolean isFilterActive() {
        return this.comboSchemas.getSelectedIndex() != 0;
    }

    private boolean isObjectFiltered(SQLQualifiedName dbobj) {
        boolean result = false;
        if (this.isFilterActive()) {
            SQLQualifiedName schema = this.getCurrentSchema();
            if (schema == null) {
                result = dbobj.getCount() == 1 && dbobj.dbLink == null;
            } else if (schema.dbLink != null && dbobj.dbLink == null || schema.dbLink == null && dbobj.dbLink != null) {
                result = false;
            } else if (schema.dbLink != null && dbobj.dbLink != null) {
                boolean bl = result = schema.getSQLContext().compareQualifiedNames(schema.dbLink, dbobj.dbLink) == 0;
                if (result) {
                    result = dbobj.startsWith(schema);
                }
            } else {
                result = dbobj.startsWith(schema);
            }
        } else {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadItems(List<MetadataObject> objects, JList list, Class objectsClass, Icon icon) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        MetadataTreeOptions o = this.queryBuilder.getMetadataTreeOptions();
        list.removeListSelectionListener(this);
        try {
            boolean showSystem;
            boolean showUser;
            model.clear();
            SQLQualifiedName schema = this.getCurrentSchema();
            if (objectsClass == MetadataTable.class) {
                showUser = o.isShowUserTables();
                showSystem = o.isShowSystemTables();
            } else if (objectsClass == MetadataView.class) {
                showUser = o.isShowUserViews();
                showSystem = o.isShowSystemViews();
            } else if (objectsClass == MetadataProcedure.class) {
                showUser = o.isShowUserProcedures();
                showSystem = o.isShowSystemProcedures();
            } else if (objectsClass == MetadataSynonym.class) {
                showUser = o.isShowUserSynonyms();
                showSystem = o.isShowSystemSynonyms();
            } else {
                showUser = o.isShowUserTables();
                showSystem = o.isShowSystemTables();
            }
            for (int i = 0; i < objects.size(); ++i) {
                MetadataObject mo = objects.get(i);
                if (!mo.isVisible() || (mo.isSystem() || !showUser) && (!mo.isSystem() || !showSystem) || mo.getClass() != objectsClass && !objectsClass.isAssignableFrom(mo.getClass()) || !this.isObjectFiltered(mo.getFullName())) continue;
                SQLQualifiedName namedef = mo.getNameAsObject(true, true, true, this.queryBuilder.getObjectPrefixSkipping());
                try {
                    SQLQualifiedName name = mo.getNameAsObject(true, true, true, ObjectPrefixSkipping.SkipNothing);
                    try {
                        if (schema != null) {
                            for (int j = 0; j < schema.getCount(); ++j) {
                                name.removeFirstPrefix();
                            }
                            if (schema.dbLink != null) {
                                name.dbLink = null;
                            }
                        }
                        ListItem item = new ListItem();
                        model.addElement(item);
                        item.tag = mo;
                        item.icon = icon;
                        if (!Str.IsNullOrEmpty(mo.getAltName())) {
                            item.text = mo.getAltName();
                            continue;
                        }
                        if (namedef.getCount() <= name.getCount()) {
                            item.text = namedef.getQualifiedNameWithoutQuotes();
                            continue;
                        }
                        item.text = name.getQualifiedNameWithoutQuotes();
                        continue;
                    }
                    finally {
                        name.dispose();
                    }
                }
                finally {
                    namedef.dispose();
                }
            }
        }
        finally {
            list.addListSelectionListener(this);
        }
    }

    private void loadListFromMetadataContainer(Vector<MetadataObject> list, MetadataContainer metadataContainer) {
        list.ensureCapacity(metadataContainer.getCount());
        for (int i = 0; i < metadataContainer.getCount(); ++i) {
            list.add(metadataContainer.get(i));
        }
    }

    private void sortObjects(List<MetadataObject> list, ObjectsSortingType sortType) {
        switch (sortType) {
            case Name: {
                Collections.sort(list, new SortByNameComparator());
                break;
            }
            case TypeName: {
                Collections.sort(list, new SortByTypeNameComparator());
                break;
            }
            case SchemaTypeName: {
                Collections.sort(list, new SortBySchemaTypeNameComparator());
            }
        }
    }

    private void loadMetadata() {
        Vector<MetadataObject> l = new Vector<MetadataObject>();
        Component[] components = this.tabObjects.getComponents();
        this.loadListFromMetadataContainer(l, this.metadataContainer);
        this.sortObjects(l, this.queryBuilder.getMetadataTreeOptions().getSortingType());
        if (Helpers.arrayContains(components, this.pageTables)) {
            this.loadItems(l, this.listTables, MetadataTable.class, this.queryBuilder.getAddObjectDialogOptions().getTablesIcon());
        }
        if (Helpers.arrayContains(components, this.pageViews)) {
            this.loadItems(l, this.listViews, MetadataView.class, this.queryBuilder.getAddObjectDialogOptions().getViewsIcon());
        }
        if (Helpers.arrayContains(components, this.pageProcedures)) {
            this.loadItems(l, this.listProcedures, MetadataProcedure.class, this.queryBuilder.getAddObjectDialogOptions().getProceduresIcon());
        }
        if (Helpers.arrayContains(components, this.pageSynonyms)) {
            this.loadItems(l, this.listSynonyms, MetadataSynonym.class, this.queryBuilder.getAddObjectDialogOptions().getSynonymsIcon());
        }
        this.updateAddObjectButtonState();
    }

    private boolean canFilterObjects() {
        return this.comboSchemas.getItemCount() >= 2 && !Str.IsNullOrEmpty((String)this.comboSchemas.getItemAt(1));
    }

    private SQLQualifiedName getCurrentSchema() {
        if (this.comboSchemas.getItemCount() > 0 && this.comboSchemas.getSelectedIndex() > 0 && this.schemaList.size() >= this.comboSchemas.getSelectedIndex()) {
            return (SQLQualifiedName)this.schemaList.get(this.comboSchemas.getSelectedIndex() - 1);
        }
        return null;
    }

    private class CustomCellRenderer
    extends DefaultListCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ListItem item = (ListItem)value;
            if (item.icon != null) {
                ((JLabel)c).setIcon(item.icon);
            }
            return c;
        }
    }

    private class ListItem {
        String text;
        Object tag;
        Icon icon;

        private ListItem() {
        }

        public String toString() {
            return this.text;
        }
    }
}

