/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResultSetWrapper {
    private ResultSet resultSet = null;
    private int columnCount = 0;
    private Object[] cachedRow = null;

    private void checkBounds(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.cachedRow.length) {
            throw new IndexOutOfBoundsException("Invalid field index specified.");
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        if (resultSet == null) {
            this.cachedRow = null;
            this.columnCount = 0;
        } else {
            try {
                this.columnCount = resultSet.getMetaData().getColumnCount();
            }
            catch (SQLException ex) {
                Logger.getLogger(ResultSetWrapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getString(int fieldIndex) {
        this.checkBounds(fieldIndex - 1);
        return String.valueOf(this.cachedRow[fieldIndex - 1]);
    }

    public int getInt(int fieldIndex) {
        this.checkBounds(fieldIndex - 1);
        return (Integer)this.cachedRow[fieldIndex - 1];
    }

    public Object getObject(int fieldIndex) {
        return this.cachedRow[fieldIndex - 1];
    }

    public int findColumn(String fieldName) throws SQLException {
        return this.resultSet.findColumn(fieldName);
    }

    public boolean next() throws SQLException {
        this.cachedRow = null;
        boolean result = this.resultSet.next();
        if (result) {
            this.cachedRow = new Object[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                this.cachedRow[i] = this.resultSet.getString(i + 1);
            }
        }
        return result;
    }

    public Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.getStatement().close();
                this.resultSet.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.resultSet = null;
            }
        }
        this.resultSet = null;
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }
}

