/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.metadata.BaseMetadataObjectsFetcherVariants;
import com.adbs.metadata.ResultSetWrapper;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Str;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetadataObjectFetcherFromResultSet
extends BaseMetadataObjectsFetcherVariants {
    protected ResultSetWrapper resultSet = new ResultSetWrapper();
    protected int schemaField;
    protected int nameField;
    protected int typeField;
    protected int systemField;
    protected int userField;
    protected int shortDescriptionField;
    protected int longDescriptionField;
    protected int referencedObjectNameField;
    protected int referencedNameField;
    protected int referencedSchemaField;
    protected int referencedDatabaseField;
    protected String schemaFieldName;
    protected String nameFieldName;
    protected String typeFieldName;
    protected String systemFieldName;
    protected String userFieldName;
    protected String shortDescriptionFieldName;
    protected String longDescriptionFieldName;
    protected String referencedObjectNameFieldName;
    protected String referencedDatabaseFieldName;
    protected String referencedSchemaFieldName;
    protected String referencedNameFieldName;

    public MetadataObjectFetcherFromResultSet(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public String getNameFieldName() {
        return this.nameFieldName;
    }

    public void setNameFieldName(String nameFieldName) {
        this.nameFieldName = nameFieldName;
    }

    public String getReferencedDatabaseFieldName() {
        return this.referencedDatabaseFieldName;
    }

    public void setReferencedDatabaseFieldName(String referencedDatabaseFieldName) {
        this.referencedDatabaseFieldName = referencedDatabaseFieldName;
    }

    public String getReferencedNameFieldName() {
        return this.referencedNameFieldName;
    }

    public void setReferencedNameFieldName(String referencedNameFieldName) {
        this.referencedNameFieldName = referencedNameFieldName;
    }

    public String getReferencedSchemaFieldName() {
        return this.referencedSchemaFieldName;
    }

    public void setReferencedSchemaFieldName(String referencedSchemaFieldName) {
        this.referencedSchemaFieldName = referencedSchemaFieldName;
    }

    public ResultSet getResultSet() {
        return this.resultSet.getResultSet();
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet.setResultSet(resultSet);
    }

    public String getSchemaFieldName() {
        return this.schemaFieldName;
    }

    public void setSchemaFieldName(String schemaFieldName) {
        this.schemaFieldName = schemaFieldName;
    }

    public String getSystemFieldName() {
        return this.systemFieldName;
    }

    public void setSystemFieldName(String systemFieldName) {
        this.systemFieldName = systemFieldName;
    }

    public String getTypeFieldName() {
        return this.typeFieldName;
    }

    public void setTypeFieldName(String typeFieldName) {
        this.typeFieldName = typeFieldName;
    }

    public String getUserFieldName() {
        return this.userFieldName;
    }

    public void setUserFieldName(String userFieldName) {
        this.userFieldName = userFieldName;
    }

    public String getReferencedObjectNameFieldName() {
        return this.referencedObjectNameFieldName;
    }

    public void setReferencedObjectNameFieldName(String referencedObjectNameFieldName) {
        this.referencedObjectNameFieldName = referencedObjectNameFieldName;
    }

    @Override
    protected Object getKind() {
        if (this.typeField != -1) {
            try {
                return this.resultSet.getString(this.typeField);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return super.getKind();
    }

    @Override
    protected Object getSystem() {
        if (this.systemField != -1) {
            try {
                return this.resultSet.getString(this.systemField);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return super.getSystem();
    }

    @Override
    protected Object getUser() {
        if (this.userField != -1) {
            try {
                return this.resultSet.getString(this.userField);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return super.getUser();
    }

    @Override
    protected void calcObjectName(AstTokenIdentifier schema, AstTokenIdentifier name) {
        if (this.nameField != -1) {
            try {
                name.setToken(this.trimName(this.resultSet.getString(this.nameField)));
                name.setCaseSensitive(this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
                String s = this.resultSet.getString(this.schemaField);
                if (this.schemaField != -1 && s != null) {
                    schema.setToken(this.trimName(s));
                    schema.setCaseSensitive(this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MetadataObjectFetcherFromResultSet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calcReferencedObjectName(SQLQualifiedName database, AstTokenIdentifier schema, AstTokenIdentifier name) {
        if (this.referencedNameField != -1) {
            try {
                name.setToken(this.trimName(this.resultSet.getString(this.referencedNameField)));
                name.setCaseSensitive(this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
                String s = this.resultSet.getString(this.referencedSchemaField);
                if (this.referencedSchemaField != -1 && s != null) {
                    schema.setToken(this.trimName(s));
                    schema.setCaseSensitive(this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
                }
                s = this.resultSet.getString(this.referencedDatabaseField);
                if (this.referencedDatabaseField != -1 && s != null) {
                    AstTokenIdentifier t = new AstTokenIdentifier(this.sqlContext);
                    t.setToken(this.trimName(s));
                    t.setCaseSensitive(this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
                    database.add(t);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MetadataObjectFetcherFromResultSet.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.referencedObjectNameField != -1) {
            try {
                String str = this.trimName(this.resultSet.getString(this.referencedObjectNameField));
                SQLQualifiedName db = this.sqlContext.parseQualifiedNameQuoteIfNeed(str);
                try {
                    if (db.getCount() > 0) {
                        name.assign(db.get(0));
                        db.delete(0);
                    }
                    if (this.sqlContext.getSyntaxProvider().isSupportSchemas() && db.getCount() > 0) {
                        schema.assign(db.get(0));
                        db.delete(0);
                    }
                    database.assign(db);
                }
                finally {
                    db.dispose();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MetadataObjectFetcherFromResultSet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    protected void init() throws QueryBuilderException {
        if (!Str.IsNullOrEmpty(this.schemaFieldName)) {
            try {
                this.schemaField = this.resultSet.findColumn(this.schemaFieldName);
            }
            catch (Exception ex) {
                this.schemaField = -1;
            }
        } else {
            this.schemaField = -1;
        }
        if (!Str.IsNullOrEmpty(this.nameFieldName)) {
            try {
                this.nameField = this.resultSet.findColumn(this.nameFieldName);
            }
            catch (Exception ex) {
                this.nameField = -1;
            }
        } else {
            this.nameField = -1;
        }
        if (!Str.IsNullOrEmpty(this.typeFieldName)) {
            try {
                this.typeField = this.resultSet.findColumn(this.typeFieldName);
            }
            catch (Exception ex) {
                this.typeField = -1;
            }
        } else {
            this.typeField = -1;
        }
        if (!Str.IsNullOrEmpty(this.systemFieldName)) {
            try {
                this.systemField = this.resultSet.findColumn(this.systemFieldName);
            }
            catch (Exception ex) {
                this.systemField = -1;
            }
        } else {
            this.systemField = -1;
        }
        if (!Str.IsNullOrEmpty(this.userFieldName)) {
            try {
                this.userField = this.resultSet.findColumn(this.userFieldName);
            }
            catch (Exception ex) {
                this.userField = -1;
            }
        } else {
            this.userField = -1;
        }
        if (!Str.IsNullOrEmpty(this.shortDescriptionFieldName)) {
            try {
                this.shortDescriptionField = this.resultSet.findColumn(this.shortDescriptionFieldName);
            }
            catch (Exception ex) {
                this.shortDescriptionField = -1;
            }
        } else {
            this.shortDescriptionField = -1;
        }
        if (!Str.IsNullOrEmpty(this.longDescriptionFieldName)) {
            try {
                this.longDescriptionField = this.resultSet.findColumn(this.longDescriptionFieldName);
            }
            catch (Exception ex) {
                this.longDescriptionField = -1;
            }
        } else {
            this.longDescriptionField = -1;
        }
        if (!Str.IsNullOrEmpty(this.referencedObjectNameFieldName)) {
            try {
                this.referencedObjectNameField = this.resultSet.findColumn(this.referencedObjectNameFieldName);
            }
            catch (Exception ex) {
                this.referencedObjectNameField = -1;
            }
        } else {
            this.referencedDatabaseField = -1;
        }
        if (!Str.IsNullOrEmpty(this.referencedDatabaseFieldName)) {
            try {
                this.referencedDatabaseField = this.resultSet.findColumn(this.referencedDatabaseFieldName);
            }
            catch (Exception ex) {
                this.referencedDatabaseField = -1;
            }
        } else {
            this.referencedDatabaseField = -1;
        }
        if (!Str.IsNullOrEmpty(this.referencedSchemaFieldName)) {
            try {
                this.referencedSchemaField = this.resultSet.findColumn(this.referencedSchemaFieldName);
            }
            catch (Exception ex) {
                this.referencedSchemaField = -1;
            }
        } else {
            this.referencedSchemaField = -1;
        }
        if (!Str.IsNullOrEmpty(this.referencedNameFieldName)) {
            try {
                this.referencedNameField = this.resultSet.findColumn(this.referencedNameFieldName);
            }
            catch (Exception ex) {
                this.referencedNameField = -1;
            }
        } else {
            this.referencedNameField = -1;
        }
    }

    @Override
    protected boolean next() throws QueryBuilderException {
        try {
            return this.resultSet.next();
        }
        catch (SQLException ex) {
            throw new QueryBuilderException("MetadataObjectFetcherFromResultSet.nextIteration() failed.\n" + ex.getMessage(), ex);
        }
    }

    @Override
    protected void close() {
        this.resultSet.close();
    }

    @Override
    public String getShortDescription() {
        if (this.shortDescriptionField != -1) {
            try {
                return this.resultSet.getString(this.shortDescriptionField);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return super.getShortDescription();
    }

    @Override
    public String getLongDescription() {
        if (this.longDescriptionField != -1) {
            try {
                return this.resultSet.getString(this.longDescriptionField);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return super.getLongDescription();
    }

    public String getLongDescriptionFieldName() {
        return this.longDescriptionFieldName;
    }

    public void setLongDescriptionFieldName(String longDescriptionFieldName) {
        this.longDescriptionFieldName = longDescriptionFieldName;
    }

    public String getShortDescriptionFieldName() {
        return this.shortDescriptionFieldName;
    }

    public void setShortDescriptionFieldName(String shortDescriptionFieldName) {
        this.shortDescriptionFieldName = shortDescriptionFieldName;
    }
}

