/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.metadata.MetadataDatabasesFetcherFromResultSet;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MetadataDatabasesFetcherFromQuery
extends MetadataDatabasesFetcherFromResultSet {
    protected String query;

    public MetadataDatabasesFetcherFromQuery(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public void dispose() {
        this.destroyResultSet();
        super.dispose();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    protected void init() throws QueryBuilderException {
        if (!this.isResultSetCreated()) {
            this.createResultSet();
        }
        super.init();
    }

    @Override
    protected void close() {
        this.destroyResultSet();
        super.close();
    }

    public void createResultSet() throws QueryBuilderException {
        this.destroyResultSet();
        if (this.sqlContext.getMetadataProvider().canExecSQL()) {
            if (!Str.IsNullOrEmpty(this.query)) {
                this.resultSet.setResultSet(this.sqlContext.getMetadataProvider().execSQL(this.query, false));
            } else {
                this.resultSet = null;
            }
        } else {
            throw new QueryBuilderException(Helpers.localizer.getString("strMetadataProviderCantExecSQL", "Used metadata provider cannot execute SQL queries."));
        }
    }

    public void destroyResultSet() {
        this.resultSet.close();
    }

    public boolean isResultSetCreated() {
        return this.resultSet.getResultSet() != null;
    }

    private void loadDefaults() {
        MetadataContainer metadataContainer = this.sqlContext.getMetadataContainer();
        if (this.sqlContext.getSyntaxProvider().isSupportDatabases() && Helpers.isQualifiedNameEmpty(metadataContainer.getDefaultDatabaseName())) {
            try {
                metadataContainer.setDefaultDatabaseName(this.sqlContext.getSyntaxProvider().getDefaultDatabaseName(this.sqlContext));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sqlContext.getSyntaxProvider().isSupportSchemas() && metadataContainer.getDefaultSchemaNames().getCount() == 0) {
            this.sqlContext.getSyntaxProvider().getDefaultSchemaNames(this.sqlContext, metadataContainer.getDefaultSchemaNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateQuery() {
        assert (!Str.IsNullOrEmpty(this.query));
        boolean result = true;
        ResultSet rs = null;
        try {
            this.loadDefaults();
            rs = this.sqlContext.getMetadataProvider().execSQL(this.query, true);
        }
        catch (Exception ex) {
            result = false;
        }
        finally {
            try {
                if (rs != null) {
                    rs.getStatement().close();
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return result;
    }
}

