/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataRelation;
import com.adbs.ast.MetadataRelationList;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;

public class BaseMetadataRelationsFetcher
implements Disposable {
    BaseSQLContext sqlContext;
    private MetadataFilter metadataFilter;
    private MetadataContainer metadataContainer;
    boolean trimSpaces;
    private String defaultPrimaryObjectName;
    private String defaultPrimaryObjectSchema;
    private String defaultPrimaryObjectDatabase;
    private AstTokenIdentifier defaultPrimaryObjectNameParsed;
    private AstTokenIdentifier defaultPrimaryObjectSchemaParsed;
    private SQLQualifiedName defaultPrimaryObjectDatabaseParsed;
    private String defaultChildObjectName;
    private String defaultChildObjectSchema;
    private String defaultChildObjectDatabase;
    private AstTokenIdentifier defaultChildObjectNameParsed;
    private AstTokenIdentifier defaultChildObjectSchemaParsed;
    private SQLQualifiedName defaultChildObjectDatabaseParsed;

    public BaseMetadataRelationsFetcher(BaseSQLContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    @Override
    public void dispose() {
    }

    public BaseSQLContext getSqlContext() {
        return this.sqlContext;
    }

    public MetadataFilter getMetadataFilter() {
        return this.metadataFilter;
    }

    public void setMetadataFilter(MetadataFilter metadataFilter) {
        this.metadataFilter = metadataFilter;
    }

    public MetadataContainer getMetadataContainer() {
        return this.metadataContainer;
    }

    public void setMetadataContainer(MetadataContainer metadataContainer) {
        this.metadataContainer = metadataContainer;
    }

    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(boolean trimSpaces) {
        this.trimSpaces = trimSpaces;
    }

    public String getDefaultChildObjectDatabase() {
        return this.defaultChildObjectDatabase;
    }

    public void setDefaultChildObjectDatabase(String value) {
        this.defaultChildObjectDatabase = value;
    }

    public String getDefaultChildObjectName() {
        return this.defaultChildObjectName;
    }

    public void setDefaultChildObjectName(String value) {
        this.defaultChildObjectName = value;
    }

    public String getDefaultChildObjectSchema() {
        return this.defaultChildObjectSchema;
    }

    public void setDefaultChildObjectSchema(String value) {
        this.defaultChildObjectSchema = value;
    }

    public String getDefaultPrimaryObjectDatabase() {
        return this.defaultPrimaryObjectDatabase;
    }

    public void setDefaultPrimaryObjectDatabase(String value) {
        this.defaultPrimaryObjectDatabase = value;
    }

    public String getDefaultPrimaryObjectName() {
        return this.defaultPrimaryObjectName;
    }

    public void setDefaultPrimaryObjectName(String value) {
        this.defaultPrimaryObjectName = value;
    }

    public String getDefaultPrimaryObjectSchema() {
        return this.defaultPrimaryObjectSchema;
    }

    public void setDefaultPrimaryObjectSchema(String value) {
        this.defaultPrimaryObjectSchema = value;
    }

    protected void init() throws QueryBuilderException {
    }

    protected void initDefault() {
        if (!Str.IsNullOrEmpty(this.defaultPrimaryObjectName)) {
            this.defaultPrimaryObjectNameParsed = this.sqlContext.parseIdentifierQuoteIfNeed(this.trimName(this.defaultPrimaryObjectName));
        }
        if (!Str.IsNullOrEmpty(this.defaultPrimaryObjectSchema)) {
            this.defaultPrimaryObjectSchemaParsed = this.sqlContext.parseIdentifierQuoteIfNeed(this.trimName(this.defaultPrimaryObjectSchema));
        }
        if (!Str.IsNullOrEmpty(this.defaultPrimaryObjectDatabase)) {
            this.defaultPrimaryObjectDatabaseParsed = this.sqlContext.parseQualifiedNameQuoteIfNeed(this.trimName(this.defaultPrimaryObjectDatabase));
        }
        if (!Str.IsNullOrEmpty(this.defaultChildObjectName)) {
            this.defaultChildObjectNameParsed = this.sqlContext.parseIdentifierQuoteIfNeed(this.trimName(this.defaultChildObjectName));
        }
        if (!Str.IsNullOrEmpty(this.defaultChildObjectSchema)) {
            this.defaultChildObjectSchemaParsed = this.sqlContext.parseIdentifierQuoteIfNeed(this.trimName(this.defaultChildObjectSchema));
        }
        if (!Str.IsNullOrEmpty(this.defaultChildObjectDatabase)) {
            this.defaultChildObjectDatabaseParsed = this.sqlContext.parseQualifiedNameQuoteIfNeed(this.trimName(this.defaultChildObjectDatabase));
        }
    }

    protected boolean next() throws QueryBuilderException {
        return false;
    }

    protected void close() {
    }

    protected void calcPrimaryObjectName(SQLQualifiedName database, AstTokenIdentifier schema, AstTokenIdentifier name) {
    }

    protected void calcPrimaryObjectNameDefault(SQLQualifiedName database, AstTokenIdentifier schema, AstTokenIdentifier name) {
        if (this.defaultPrimaryObjectNameParsed != null) {
            name.assign(this.defaultPrimaryObjectNameParsed);
        }
        if (this.defaultPrimaryObjectSchemaParsed != null) {
            schema.assign(this.defaultPrimaryObjectSchemaParsed);
        }
        if (this.defaultPrimaryObjectDatabaseParsed != null) {
            database.assign(this.defaultPrimaryObjectDatabaseParsed);
        }
    }

    protected void calcChildObjectName(SQLQualifiedName database, AstTokenIdentifier schema, AstTokenIdentifier name) {
    }

    protected void calcChildObjectNameDefault(SQLQualifiedName database, AstTokenIdentifier schema, AstTokenIdentifier name) {
        if (this.defaultChildObjectNameParsed != null) {
            name.assign(this.defaultChildObjectNameParsed);
        }
        if (this.defaultChildObjectSchemaParsed != null) {
            schema.assign(this.defaultChildObjectSchemaParsed);
        }
        if (this.defaultChildObjectDatabaseParsed != null) {
            database.assign(this.defaultChildObjectDatabaseParsed);
        }
    }

    protected void beginRelation(MetadataObject metadataObject, MetadataRelation relation) {
    }

    protected void beginCalcFields(MetadataObject metadataObject, MetadataRelation relation) {
    }

    protected void calcRelationFieldNames(MetadataObject metadataObject, MetadataRelation relation, SQLQualifiedName parentField, SQLQualifiedName childField) {
    }

    protected boolean isEndOfRelation(MetadataObject metadataObject, MetadataRelation relation) {
        return true;
    }

    protected void nextRelationFields(MetadataObject metadataObject, MetadataRelation relation) throws QueryBuilderException {
    }

    protected void endCalcFields(MetadataObject metadataObject, MetadataRelation relation) {
    }

    protected void endRelation(MetadataObject metadataObject, MetadataRelation relation) {
    }

    protected String trimName(String name) {
        if (this.trimSpaces) {
            return name.trim();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipRelation() throws QueryBuilderException {
        this.beginCalcFields(null, null);
        try {
            do {
                this.nextRelationFields(null, null);
            } while (!this.isEndOfRelation(null, null));
        }
        finally {
            this.endCalcFields(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadata(MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        BaseSyntaxProvider syntaxProvider = this.sqlContext.getSyntaxProvider();
        SQLQualifiedName pkDatabase = new SQLQualifiedName(this.sqlContext);
        SQLQualifiedName fkDatabase = new SQLQualifiedName(this.sqlContext);
        AstTokenIdentifier pkSchema = new AstTokenIdentifier(this.sqlContext);
        AstTokenIdentifier fkSchema = new AstTokenIdentifier(this.sqlContext);
        AstTokenIdentifier pkName = new AstTokenIdentifier(this.sqlContext);
        AstTokenIdentifier fkName = new AstTokenIdentifier(this.sqlContext);
        SQLQualifiedName parentField = new SQLQualifiedName(this.sqlContext);
        SQLQualifiedName childField = new SQLQualifiedName(this.sqlContext);
        MetadataRelation mr = null;
        AstNode defaultDatabase = null;
        this.metadataFilter = metadataFilter;
        this.metadataContainer = metadataContainer;
        metadataContainer.beginUpdate();
        try {
            defaultDatabase = syntaxProvider.isSupportDatabases() && Helpers.isQualifiedNameEmpty(database) ? metadataContainer.getDefaultDatabaseName().clone(this.sqlContext) : null;
            this.init();
            while (this.next()) {
                MetadataObject mt;
                pkName.setToken("");
                pkName.setCaseSensitive(syntaxProvider.isIdentifiersCaseSensitive());
                pkSchema.setToken("");
                pkSchema.setCaseSensitive(syntaxProvider.isIdentifiersCaseSensitive());
                pkDatabase.clear();
                fkDatabase.clear();
                this.calcPrimaryObjectName(pkDatabase, pkSchema, pkName);
                if (syntaxProvider.isSupportDatabases() && Helpers.isQualifiedNameEmpty(pkDatabase)) {
                    if (!Helpers.isQualifiedNameEmpty(database)) {
                        pkDatabase.assign(database);
                    } else if (!Helpers.isQualifiedNameEmpty((SQLQualifiedName)defaultDatabase)) {
                        pkDatabase.assign(defaultDatabase);
                    }
                }
                if (!pkName.isEmpty() && (mt = metadataContainer.findObjectByName(pkName, pkSchema, pkDatabase)) != null) {
                    fkName.setToken("");
                    fkName.setCaseSensitive(true);
                    fkSchema.setToken("");
                    fkSchema.setCaseSensitive(true);
                    this.calcChildObjectName(fkDatabase, fkSchema, fkName);
                    if (syntaxProvider.isSupportDatabases() && Helpers.isQualifiedNameEmpty(fkDatabase)) {
                        if (!Helpers.isQualifiedNameEmpty(database)) {
                            fkDatabase.assign(database);
                        } else if (!Helpers.isQualifiedNameEmpty((SQLQualifiedName)defaultDatabase)) {
                            fkDatabase.assign(defaultDatabase);
                        }
                    }
                    if (!fkName.isEmpty()) {
                        mr = mt.getRelations().add();
                        mr.setChildSchema(fkSchema);
                        mr.setChildName(fkName);
                        mr.setChildDatabase(fkDatabase);
                        this.beginRelation(mt, mr);
                        try {
                            this.beginCalcFields(mt, mr);
                            boolean flagUsePrimaryKey = false;
                            try {
                                parentField.clear();
                                childField.clear();
                                this.calcRelationFieldNames(mt, mr, parentField, childField);
                                flagUsePrimaryKey = flagUsePrimaryKey || Helpers.isQualifiedNameEmpty(parentField);
                                mr.getKeyFields().add(parentField);
                                mr.getChildFields().add(childField);
                                if (flagUsePrimaryKey) {
                                    mr.getKeyFields().clear();
                                }
                            }
                            finally {
                                this.endCalcFields(mt, mr);
                            }
                        }
                        finally {
                            this.endRelation(mt, mr);
                        }
                    }
                }
                if (mr == null) continue;
                MetadataRelationList rl = mr.getRelations();
                int i1 = rl.indexOf(mr);
                int i2 = rl.findRelation(mr.getKeyFields(), mr.getChildSchema(), mr.getChildName(), mr.getChildFields(), mr.getChildDatabase());
                if (i1 == -1 || i2 == -1 || i2 >= i1) continue;
                rl.delete(i2);
            }
            if (this.defaultChildObjectDatabaseParsed != null) {
                this.defaultChildObjectDatabaseParsed.dispose();
            }
            if (this.defaultChildObjectSchemaParsed != null) {
                this.defaultChildObjectSchemaParsed.dispose();
            }
            if (this.defaultChildObjectNameParsed != null) {
                this.defaultChildObjectNameParsed.dispose();
            }
            if (this.defaultPrimaryObjectDatabaseParsed != null) {
                this.defaultPrimaryObjectDatabaseParsed.dispose();
            }
            if (this.defaultPrimaryObjectSchemaParsed != null) {
                this.defaultPrimaryObjectSchemaParsed.dispose();
            }
            if (this.defaultPrimaryObjectNameParsed != null) {
                this.defaultPrimaryObjectNameParsed.dispose();
            }
        }
        finally {
            this.close();
            if (defaultDatabase != null) {
                defaultDatabase.dispose();
            }
            if (childField != null) {
                childField.dispose();
            }
            if (parentField != null) {
                parentField.dispose();
            }
            if (fkName != null) {
                fkName.dispose();
            }
            if (pkName != null) {
                pkName.dispose();
            }
            if (fkSchema != null) {
                fkSchema.dispose();
            }
            if (pkSchema != null) {
                pkSchema.dispose();
            }
            if (fkDatabase != null) {
                fkDatabase.dispose();
            }
            if (pkDatabase != null) {
                pkDatabase.dispose();
            }
            metadataContainer.endUpdate();
        }
    }
}

