/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;

public class BaseMetadataFieldsFetcher
implements Disposable {
    BaseSQLContext sqlContext;
    private boolean trimSpaces;

    public BaseMetadataFieldsFetcher(BaseSQLContext sqlContext) {
        this.sqlContext = sqlContext;
        assert (sqlContext != null);
    }

    @Override
    public void dispose() {
    }

    public BaseSQLContext getSqlContext() {
        return this.sqlContext;
    }

    protected void init() throws QueryBuilderException {
    }

    protected void close() {
    }

    protected boolean next() throws QueryBuilderException {
        return false;
    }

    protected void calcFieldName(SQLQualifiedName name) {
        name.clear();
    }

    protected boolean canCalcPrimaryKey() {
        return false;
    }

    protected boolean calcIsPrimaryKey() {
        return false;
    }

    protected boolean canCalcIsNullable() {
        return false;
    }

    protected boolean calcIsNullable() {
        return true;
    }

    protected boolean canCalcIsReadOnly() {
        return false;
    }

    protected boolean calcIsReadOnly() {
        return false;
    }

    protected boolean canCalcTypeOnServer() {
        return false;
    }

    protected String calcTypeOnServer() {
        return "";
    }

    protected boolean canCalcSize() {
        return false;
    }

    protected int calcSize() {
        return 0;
    }

    protected boolean canCalcPrecision() {
        return false;
    }

    protected boolean canCalcScale() {
        return false;
    }

    protected int calcPrecision() {
        return 0;
    }

    protected int calcScale() {
        return 0;
    }

    protected boolean canCalcDefaultValue() {
        return false;
    }

    protected String calcDefaultValue() {
        return "";
    }

    protected boolean canCalcShortDescription() {
        return false;
    }

    protected String calcShortDescription() {
        return "";
    }

    protected boolean canCalcLongDescription() {
        return false;
    }

    protected String calcLongDescription() {
        return "";
    }

    protected String trimName(String name) {
        if (this.getTrimSpaces()) {
            return name.trim();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFields(MetadataFieldList fields) throws QueryBuilderException {
        this.init();
        fields.beginUpdate();
        try {
            SQLQualifiedName fieldName = new SQLQualifiedName(this.sqlContext);
            try {
                while (this.next()) {
                    fieldName.clear();
                    this.calcFieldName(fieldName);
                    if (Helpers.isQualifiedNameEmpty(fieldName)) continue;
                    int i = fields.findFieldByName(fieldName);
                    MetadataField field = i == -1 ? fields.add() : fields.get(i);
                    field.beginUpdate();
                    try {
                        if (i == -1) {
                            field.setName(fieldName);
                        }
                        if (Str.IsNullOrEmpty(field.getShortDescription()) && this.canCalcShortDescription()) {
                            field.setShortDescription(this.calcShortDescription());
                        }
                        if (Str.IsNullOrEmpty(field.getLongDescription()) && this.canCalcLongDescription()) {
                            field.setLongDescription(this.calcLongDescription());
                        }
                        if (this.canCalcTypeOnServer()) {
                            String fieldType = this.calcTypeOnServer();
                            i = fieldType.indexOf(40);
                            if (i != -1) {
                                fieldType = fieldType.substring(0, i);
                            }
                            field.setFieldTypeName(fieldType.trim());
                        }
                        if (this.canCalcSize()) {
                            field.setSize(this.calcSize());
                        }
                        if (this.canCalcPrecision()) {
                            field.setPrecision(this.calcPrecision());
                        }
                        if (this.canCalcScale()) {
                            field.setScale(this.calcScale());
                        }
                        if (this.canCalcPrimaryKey()) {
                            field.setPrimaryKey(this.calcIsPrimaryKey());
                        }
                        if (this.canCalcIsNullable()) {
                            field.setNullable(this.calcIsNullable());
                        }
                        if (!this.canCalcIsReadOnly()) continue;
                        field.setReadOnly(this.calcIsReadOnly());
                    }
                    finally {
                        field.endUpdate();
                    }
                }
            }
            finally {
                fieldName.dispose();
            }
        }
        finally {
            fields.endUpdate();
            this.close();
        }
    }

    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(boolean trimSpaces) {
        this.trimSpaces = trimSpaces;
    }
}

