/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.Disposable;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import java.util.ArrayList;
import java.util.Iterator;

public class UpdatablePersistent
implements Disposable {
    private UpdatablePersistent parent;
    private int update;
    private boolean updated;
    protected ArrayList<UpdatedEventListener> updatedEventListenerList = new ArrayList();

    public UpdatablePersistent(UpdatablePersistent parent) {
        this.parent = parent;
    }

    @Override
    public void dispose() {
    }

    public UpdatablePersistent getParent() {
        return this.parent;
    }

    public boolean isUpdating() {
        return this.update > 0;
    }

    public void assign(Object source) {
    }

    protected void doUpdated() {
        if (this.parent != null) {
            this.parent.notifyUpdated();
        }
        this.fireUpdatedEvent(new UpdatedEvent(this));
    }

    protected void notifyUpdated() {
        if (this.isUpdating()) {
            this.updated = true;
        } else {
            this.beginUpdate();
            this.updated = true;
            this.endUpdate();
        }
    }

    public void beginUpdate() {
        ++this.update;
    }

    public void endUpdate() {
        if (this.update == 1 && this.updated) {
            this.doUpdated();
            this.updated = false;
        }
        --this.update;
    }

    public void addUpdatedEventListener(UpdatedEventListener listener) {
        this.updatedEventListenerList.add(listener);
    }

    public void removeUpdatedEventListener(UpdatedEventListener listener) {
        this.updatedEventListenerList.remove(listener);
    }

    protected void fireUpdatedEvent(UpdatedEvent evt) {
        Iterator<UpdatedEventListener> listeners = this.updatedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().updatedEventOccurred(evt);
        }
    }
}

