/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNodeWithCollection;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SQLIdentifiersCollection
extends AstNodeWithCollection {
    public SQLIdentifiersCollection(BaseSQLContext sqlContext) {
        super(sqlContext, AstTokenIdentifier.class);
    }

    @Override
    public AstTokenIdentifier get(int index) {
        return (AstTokenIdentifier)super.get(index);
    }

    Element getXMLNode(Document doc, String nodeName, String itemsName) {
        Element result = doc.createElement(nodeName);
        for (int i = 0; i < this.getCount(); ++i) {
            result.appendChild(this.get(i).getXMLNode(doc, itemsName));
        }
        return result;
    }

    void loadFromXMLNode(Node node, String itemsName) {
        this.clear();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (child == null || !child.getNodeName().equals(itemsName)) continue;
            AstTokenIdentifier id = this.add();
            id.loadFromXMLNode((Element)child);
        }
    }

    @Override
    public AstTokenIdentifier add() {
        return (AstTokenIdentifier)super.add();
    }

    public AstTokenIdentifier addIdentifier(String identifier) {
        AstTokenIdentifier result = this.add();
        result.setTokenStr(identifier);
        return result;
    }

    @Override
    public AstTokenIdentifier insert(int index) {
        return (AstTokenIdentifier)super.insert(index);
    }

    public boolean containsSameId(AstTokenIdentifier identifier) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        for (int i = 0; i < this.getCount(); ++i) {
            if (!this.sqlContext.isIdentifiersEqual(this.get(i), identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSameIdStr(String identifier) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        AstTokenIdentifier id = null;
        try {
            id = this.sqlContext.parseIdentifierQuoteIfNeed(identifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean result = this.containsSameId(id);
        id.dispose();
        return result;
    }
}

