/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentQuotation;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLAliasObjectAlias;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLFromObject
extends SQLFromSource {
    private SQLWithClauseItem cteObject;
    public SQLDatabaseObject fromObj;

    public SQLFromObject(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public SQLWithClauseItem getCTEObject() {
        return this.cteObject;
    }

    public void setCTEObject(SQLWithClauseItem value) {
        this.cteObject = value;
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(SQLFromObject.class.getField("fromObj"));
        }
        catch (Exception ex) {
            Logger.getLogger(SQLFromObject.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        this.cteObject = null;
    }

    @Override
    public void buildExpression(SQLBuilder builder, SQLBuilderSelectFormat format) {
        assert (this.fromObj != null);
        if (this.getMetadataObject() != null && builder.isExpandVirtualObjects() && this.getMetadataObject().isVirtualCalculatedObject()) {
            this.getMetadataObject().getExpressionAST().buildExpression(builder, format);
        } else if (this.getMetadataObject() != null && builder.isUseAltNames() && !Str.IsNullOrEmpty(this.getMetadataObject().getAltName())) {
            String altName = this.getMetadataObject().getAltName();
            if (builder.getQuoteIdentifiers() == IdentQuotation.None || this.sqlContext.isValidIdent(altName) && builder.getQuoteIdentifiers() != IdentQuotation.All) {
                builder.writeIdentifier(altName);
            } else {
                builder.writeIdentifier(this.sqlContext.getSyntaxProvider().getQuoteBegin() + altName + this.sqlContext.getSyntaxProvider().getQuoteEnd());
            }
        } else {
            this.fromObj.buildQualifiedNameNamesFull(builder, format);
            this.fromObj.buildQualifiedNameDBLink(builder, format);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void calcFieldList(List cteList, List fromSourceList, boolean calcFieldUsageStats) throws QueryBuilderException {
        MetadataObject mo = this.getMetadataObject();
        MetadataFieldList fields = this.getFieldList();
        if (this.cteObject == null) {
            if (mo != null) {
                assert (this.sqlContext.getMetadataContainer() != null);
                MetadataFieldList mo_fields = mo.getFields();
                if (!mo_fields.isLoaded()) {
                    mo.loadFieldsOnDemand();
                }
                fields.assign(mo_fields);
                if (!calcFieldUsageStats) return;
                for (int i = 0; i < fields.getCount(); ++i) {
                    MetadataField f1 = fields.get(i);
                    MetadataField f2 = mo_fields.get(i);
                    f1.prepareStatsCollections();
                    f1.getUsedDatabaseObjects().addObject(mo, mo.getFullName());
                    f1.getUsedDatabaseObjectColumns().addColumn(mo, mo.getFullName(), f2, f2.getName());
                }
                return;
            } else {
                try {
                    super.calcFieldList(cteList, fromSourceList, calcFieldUsageStats);
                    if (!calcFieldUsageStats) return;
                    for (int i = 0; i < fields.getCount(); ++i) {
                        MetadataField f1 = fields.get(i);
                        f1.prepareStatsCollections();
                        f1.getUsedDatabaseObjects().addObject(null, this.fromObj);
                        f1.getUsedDatabaseObjectColumns().addColumn(null, this.fromObj, null, f1.getName());
                    }
                    return;
                }
                catch (Exception e) {
                    fields.clear();
                    return;
                }
            }
        } else {
            fields.assign(this.cteObject.fieldList);
        }
    }

    @Override
    public void restoreColumnPrefixRecursive(boolean restore) {
        if (restore) {
            this.restoreColumnPrefix();
        }
        ArrayList ml = new ArrayList();
        this.getMyChildren(ml);
        for (int i = 0; i < ml.size(); ++i) {
            ((AstNodeBase)ml.get(i)).restoreColumnPrefixRecursive(ml.get(i) != this.fromObj);
        }
    }

    @Override
    public boolean buildColumnPrefix(SQLBuilder builder, SQLBuilderSelectFormat format) {
        assert (this.fromObj != null);
        if (this.alias != null) {
            this.alias.buildAliasName(builder, format);
        } else if (this.getMetadataObject() != null && builder.isUseAltNames() && !Str.IsNullOrEmpty(this.getMetadataObject().getAltName())) {
            String altName = this.getMetadataObject().getAltName();
            if (builder.getQuoteIdentifiers() == IdentQuotation.None || this.sqlContext.isValidIdent(altName) && builder.getQuoteIdentifiers() != IdentQuotation.All) {
                builder.writeIdentifier(altName);
            } else {
                BaseSyntaxProvider sp = this.sqlContext.getSyntaxProvider();
                builder.writeIdentifier(sp.getQuoteBegin() + altName + sp.getQuoteEnd());
            }
        } else {
            this.fromObj.buildQualifiedNameNamesFull(builder, format);
        }
        return true;
    }

    @Override
    public void buildColumnSuffix(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.alias == null && (!builder.isUseAltNames() || this.getMetadataObject() == null || Str.IsNullOrEmpty(this.getMetadataObject().getAltName()))) {
            this.fromObj.buildQualifiedNameDBLink(builder, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildAlias(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.alias != null) {
            super.buildAlias(builder, format);
        } else if (builder.isExpandVirtualObjects() && this.getMetadataObject() != null && this.getMetadataObject().isVirtualCalculatedObject()) {
            builder.space();
            SQLAliasObjectAlias tmpAlias = new SQLAliasObjectAlias(this.sqlContext);
            try {
                tmpAlias.alias = builder.isUseAltNames() && !Str.IsNullOrEmpty(this.getMetadataObject().getAltName()) ? new AstTokenIdentifier(this.sqlContext, this.getMetadataObject().getAltName()) : this.getMetadataObject().getName().clone(this.sqlContext);
                tmpAlias.buildSQL(builder, format);
            }
            finally {
                tmpAlias.dispose();
            }
        }
    }
}

