/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderConditionFormat;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionExpressionItem;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.utils.Wrapper;

public class SQLExpressionBrackets
extends SQLExpressionExpressionItem {
    public SQLExpressionBrackets(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public SQLExpressionBrackets(BaseSQLContext sqlContext, SQLExpressionItem lExpression) {
        super(sqlContext, lExpression);
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeSymbol("(");
        super.buildSQLDirect(builder, format);
        builder.writeSymbol(")");
    }

    @Override
    public void removeLExpression(SQLExpressionItem e) {
        if (this.lExpression != null) {
            this.lExpression.removeLExpression(e);
        }
    }

    @Override
    public void restoreLExpression(SQLExpressionItem e) {
        if (this.lExpression != null) {
            this.lExpression.restoreLExpression(e);
        }
    }

    @Override
    public SQLExpressionItem findExpressionItem(Wrapper<SQLExpressionItem> ei) {
        if (this.lExpression != null) {
            this.lExpression = this.lExpression.findExpressionItem(ei);
        } else {
            ei.value = null;
        }
        return this;
    }

    @Override
    public void buildSQLCosmetic(SQLBuilder builder, SQLBuilderSelectFormat selectFormat, SQLBuilderConditionFormat format, int level) {
        builder.writeSymbol("(");
        if (format.getIndentNestedConditions() > 0) {
            builder.addIndent(format.getIndentNestedConditions());
        }
        if (this.lExpression != null) {
            this.lExpression.buildSQLCosmetic(builder, selectFormat, format, level + 1);
        }
        if (format.getIndentNestedConditions() > 0) {
            builder.endIndent();
        }
        builder.writeSymbol(")");
    }

    @Override
    public boolean isLogical() {
        if (this.lExpression != null) {
            return this.lExpression.isLogical();
        }
        return false;
    }
}

