/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataParametersList;
import com.adbs.querybuilder.QueryBuilderException;

public class MetadataProcedure
extends MetadataObject {
    private MetadataParametersList parameters;

    public MetadataProcedure(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext);
        this.parameters = new MetadataParametersList(this, sqlContext);
    }

    @Override
    public void dispose() {
        this.parameters.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            if (source instanceof MetadataProcedure) {
                this.setParameters(((MetadataProcedure)source).getParameters());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public MetadataParametersList getParameters() {
        return this.parameters;
    }

    public void setParameters(MetadataParametersList value) {
        if (this.parameters != value) {
            this.parameters.assign(value);
        }
    }

    @Override
    public String getQueryToLoadFields(String fieldName) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        if (this.parameters.isLoaded()) {
            StringBuilder _params = new StringBuilder();
            for (int i = 0; i < this.parameters.getCount(); ++i) {
                if (_params.length() > 0) {
                    _params.append(",");
                }
                _params.append("null");
            }
            return this.sqlContext.getSyntaxProvider().getQueryToLoadFieldsForProcedure(fieldName, this.getFullName().getQualifiedNameForServer(), _params.toString());
        }
        return this.sqlContext.getSyntaxProvider().getQueryToLoadFieldsForProcedure(fieldName, this.getFullName().getQualifiedNameForServer(), "");
    }

    @Override
    String getXMLItemName() {
        return "procedure";
    }

    @Override
    protected void loadFieldsInternal() throws QueryBuilderException {
        this.sqlContext.loadMetadataForProcedure(this);
    }
}

