/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataCollectionItemBase;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataParameter
extends MetadataCollectionItemBase {
    private AstTokenIdentifier name;
    private String altName;
    private int fieldType;
    private int precision;
    private int scale;
    private int paramType;
    private int size;
    private String shortDescription;
    private String longDescription;

    public MetadataParameter(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext);
        this.name = new AstTokenIdentifier(sqlContext);
        this.fieldType = 1111;
        this.precision = 0;
        this.scale = 0;
        this.paramType = 1;
        this.size = 0;
    }

    public AstTokenIdentifier getName() {
        return this.name;
    }

    public void setName(AstTokenIdentifier value) {
        this.name = value;
    }

    public String getAltName() {
        return this.altName;
    }

    public void setAltName(String value) {
        this.altName = value;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int fieldType) {
        this.fieldType = fieldType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getParamType() {
        return this.paramType;
    }

    public void setParamType(int paramType) {
        this.paramType = paramType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            this.name.assign(((MetadataParameter)source).getName());
            this.altName = ((MetadataParameter)source).getAltName();
            this.fieldType = ((MetadataParameter)source).getFieldType();
            this.size = ((MetadataParameter)source).getSize();
            this.precision = ((MetadataParameter)source).getPrecision();
            this.scale = ((MetadataParameter)source).getScale();
            this.paramType = ((MetadataParameter)source).getParamType();
            this.shortDescription = ((MetadataParameter)source).getShortDescription();
            this.longDescription = ((MetadataParameter)source).getLongDescription();
            this.notifyUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    Element getXMLNode(Document doc, String nodeName) {
        Element result = super.getXMLNode(doc, nodeName);
        result.appendChild(this.name.getXMLNode(doc, "name"));
        if (!Str.IsNullOrEmpty(this.altName)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "alt_name", this.altName));
        }
        result.appendChild(Helpers.createNodeWithValue(doc, "type", this.fieldType));
        if (this.size != 0) {
            result.appendChild(Helpers.createNodeWithValue(doc, "size", this.size));
        }
        if (this.precision != 0) {
            result.appendChild(Helpers.createNodeWithValue(doc, "precision", this.precision));
        }
        if (this.scale != 0) {
            result.appendChild(Helpers.createNodeWithValue(doc, "scale", this.scale));
        }
        result.appendChild(Helpers.createNodeWithValue(doc, "param_type", this.paramType));
        if (!Str.IsNullOrEmpty(this.shortDescription)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "descr", this.shortDescription));
        }
        if (!Str.IsNullOrEmpty(this.longDescription)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "long_descr", this.longDescription));
        }
        return result;
    }

    @Override
    void loadFromXMLNode(Element node) {
        String s;
        super.loadFromXMLNode(node);
        Element child = Helpers.findChildElByName("name", node);
        if (child != null) {
            this.name.loadFromXMLNode(child);
        }
        this.altName = !Str.IsNullOrEmpty(s = Helpers.getValueFromChildNode(node, "alt_name")) ? s : "";
        s = Helpers.getValueFromChildNode(node, "type");
        this.fieldType = !Str.IsNullOrEmpty(s) ? Integer.parseInt(s) : 1111;
        s = Helpers.getValueFromChildNode(node, "size");
        this.size = !Str.IsNullOrEmpty(s) ? Integer.parseInt(s) : 0;
        s = Helpers.getValueFromChildNode(node, "precision");
        this.precision = !Str.IsNullOrEmpty(s) ? Integer.parseInt(s) : 0;
        s = Helpers.getValueFromChildNode(node, "scale");
        this.scale = !Str.IsNullOrEmpty(s) ? Integer.parseInt(s) : 0;
        s = Helpers.getValueFromChildNode(node, "param_type");
        this.paramType = !Str.IsNullOrEmpty(s) ? Integer.parseInt(s) : 1;
        s = Helpers.getValueFromChildNode(node, "descr");
        this.shortDescription = s != null ? s : "";
        s = Helpers.getValueFromChildNode(node, "long_descr");
        this.longDescription = s != null ? s : "";
    }
}

