/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataObjectHashBucket;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class MetadataObjectHash {
    private int bucketsCount;
    private ArrayList<MetadataObjectHashBucket> buckets = new ArrayList();

    public MetadataObjectHash(int bucketsCount) {
        this.bucketsCount = bucketsCount;
        try {
            Helpers.listSetSize(this.buckets, bucketsCount, false);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int hashOfString(String str) {
        String s = str.toUpperCase();
        int result = 0;
        for (int i = 1; i < s.length(); ++i) {
            result = (result << 2 | result >> 30) ^ s.charAt(i);
        }
        return result;
    }

    private int hashOfFullName(SQLQualifiedName fullName) {
        if (fullName.getCount() != 0) {
            return this.hashOfString(fullName.get(0).getToken());
        }
        return this.bucketsCount - 1;
    }

    private int hashOfName(SQLQualifiedName database, AstTokenIdentifier schema, AstTokenIdentifier name) {
        if (!name.isEmpty()) {
            return this.hashOfString(name.getToken());
        }
        return this.bucketsCount - 1;
    }

    private MetadataObjectHashBucket getBucketByHash(int hashCode) {
        int key = Math.abs(hashCode % this.bucketsCount);
        if (this.buckets.get(key) == null) {
            this.buckets.set(key, new MetadataObjectHashBucket(this));
        }
        return this.buckets.get(key);
    }

    private MetadataObjectHashBucket findBucketByFullName(SQLQualifiedName fullName) {
        return this.getBucketByHash(this.hashOfFullName(fullName));
    }

    private MetadataObjectHashBucket findBucketByName(SQLQualifiedName database, AstTokenIdentifier schema, AstTokenIdentifier name) {
        return this.getBucketByHash(this.hashOfName(database, schema, name));
    }

    private MetadataObjectHashBucket findBucketByAltName(String altName) {
        return this.getBucketByHash(this.hashOfString(altName.toUpperCase()));
    }

    public MetadataObject findByNameAndClass(AstTokenIdentifier name, AstTokenIdentifier schema, SQLQualifiedName database, Class objectClass) {
        MetadataObjectHashBucket b = this.findBucketByName(database, schema, name);
        for (int i = 0; i < b.getCount(); ++i) {
            MetadataObject mo = b.get(i);
            if (mo.getClass() != objectClass && !objectClass.isAssignableFrom(mo.getClass()) || !mo.isNameEqual(name, schema, database)) continue;
            return mo;
        }
        return null;
    }

    public MetadataObject findByName(AstTokenIdentifier name, AstTokenIdentifier schema, SQLQualifiedName database) {
        MetadataObjectHashBucket b = this.findBucketByName(database, schema, name);
        for (int i = 0; i < b.getCount(); ++i) {
            MetadataObject mo = b.get(i);
            if (!mo.isNameEqual(name, schema, database)) continue;
            return mo;
        }
        return null;
    }

    public MetadataObject findByFullNameAndClass(SQLQualifiedName fullName, Class objectClass) {
        MetadataObjectHashBucket b = this.findBucketByFullName(fullName);
        for (int i = 0; i < b.getCount(); ++i) {
            MetadataObject mo = b.get(i);
            if (mo.getClass() != objectClass && !objectClass.isAssignableFrom(mo.getClass()) || !mo.isFullNameEqual(fullName)) continue;
            return mo;
        }
        return null;
    }

    public MetadataObject findByFullName(SQLQualifiedName fullName) {
        MetadataObjectHashBucket b = this.findBucketByFullName(fullName);
        for (int i = 0; i < b.getCount(); ++i) {
            MetadataObject mo = b.get(i);
            if (!mo.isFullNameEqual(fullName)) continue;
            return mo;
        }
        return null;
    }

    public MetadataObject findByAltNameAndClass(String altName, Class objectClass) {
        MetadataObjectHashBucket b = this.findBucketByAltName(altName);
        String s = altName.toUpperCase();
        for (int i = 0; i < b.getCount(); ++i) {
            MetadataObject mo = b.get(i);
            if (mo.getClass() != objectClass && !objectClass.isAssignableFrom(mo.getClass()) || !mo.getAltName().toUpperCase().equals(s)) continue;
            return mo;
        }
        return null;
    }

    public MetadataObject findByAltName(String altName) {
        MetadataObjectHashBucket b = this.findBucketByAltName(altName);
        String s = altName.toUpperCase();
        for (int i = 0; i < b.getCount(); ++i) {
            MetadataObject mo = b.get(i);
            if (!mo.getAltName().toUpperCase().equals(s)) continue;
            return mo;
        }
        return null;
    }

    public void addByName(MetadataObject metadataObject) {
        if (metadataObject.getMetadataContainer().indexOf(metadataObject) != -1) {
            MetadataObjectHashBucket bucket = this.findBucketByFullName(metadataObject.getFullName());
            bucket.add(metadataObject);
            metadataObject.metadataContainerHashBucketName = bucket;
        }
    }

    public void removeByName(MetadataObject metadataObject) {
        assert (metadataObject != null);
        MetadataObjectHashBucket b = metadataObject.metadataContainerHashBucketName;
        if (b != null) {
            b.remove(metadataObject);
            metadataObject.metadataContainerHashBucketName = null;
        }
    }

    public void reHashByName(MetadataObject metadataObject) {
        this.removeByName(metadataObject);
        this.addByName(metadataObject);
    }

    public void addByAltName(MetadataObject metadataObject) {
        if (!Str.IsNullOrEmpty(metadataObject.getAltName()) && metadataObject.getMetadataContainer().indexOf(metadataObject) != -1) {
            MetadataObjectHashBucket b = this.findBucketByAltName(metadataObject.getAltName());
            b.add(metadataObject);
            metadataObject.metadataContainerHashBucketAltName = b;
        }
    }

    public void removeByAltName(MetadataObject metadataObject) {
        assert (metadataObject != null);
        MetadataObjectHashBucket b = metadataObject.metadataContainerHashBucketAltName;
        if (b != null) {
            b.remove(metadataObject);
            metadataObject.metadataContainerHashBucketAltName = null;
        }
    }

    public void reHashByAltName(MetadataObject metadataObject) {
        this.removeByAltName(metadataObject);
        this.addByAltName(metadataObject);
    }

    public void clear() {
        for (int i = 0; i < this.buckets.size(); ++i) {
            MetadataObjectHashBucket b = this.buckets.get(i);
            if (b == null) continue;
            b.clear();
        }
    }
}

