/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataCollectionItemBase;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.SQLAliasExpression;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.StatsColumns;
import com.adbs.ast.StatsObjects;
import com.adbs.ast.UpdatablePersistent;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataField
extends MetadataCollectionItemBase {
    private SQLQualifiedName name;
    private String altName;
    private String expression;
    private SQLExpressionItem expressionAST;
    private String shortDescription;
    private String longDescription;
    private String fieldTypeName;
    private int fieldType;
    private int size;
    private int precision;
    private int scale;
    private boolean primaryKey;
    private boolean nullable;
    private boolean readOnly;
    private StatsObjects usedDatabaseObjects;
    private StatsColumns usedDatabaseObjectColumns;

    public MetadataField(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext);
        assert (parent == null || parent instanceof MetadataFieldList);
        this.name = new SQLQualifiedName(sqlContext);
        this.fieldType = 1111;
        this.fieldTypeName = "";
        this.size = 0;
        this.primaryKey = false;
        this.nullable = true;
        this.readOnly = false;
        this.shortDescription = "";
        this.longDescription = "";
        this.altName = "";
    }

    @Override
    public void dispose() {
        this.name.dispose();
        if (this.usedDatabaseObjects != null) {
            this.usedDatabaseObjects.dispose();
        }
        if (this.usedDatabaseObjectColumns != null) {
            this.usedDatabaseObjectColumns.dispose();
        }
        super.dispose();
    }

    public SQLQualifiedName getName() {
        return this.name;
    }

    public void setName(SQLQualifiedName value) {
        if (this.name != value) {
            this.name.assign(value);
        }
    }

    public String getNameStr() {
        return this.name.getQualifiedName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNameStr(String name) throws QueryBuilderException {
        SQLQualifiedName qn = null;
        if (name.equals(this.getNameStr())) return;
        if (!Str.IsNullOrEmpty(name)) {
            try {
                qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (qn == null) throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
            this.name.assign(qn);
            qn.dispose();
        } else {
            this.name.clear();
        }
        this.notifyUpdated();
    }

    public String getNameStrNotQuoted() {
        return this.name.getQualifiedNameWithoutQuotes();
    }

    public String getAltName() {
        return this.altName;
    }

    public void setAltName(String value) {
        this.altName = value;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String value) {
        this.shortDescription = value;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String value) {
        this.longDescription = value;
    }

    public String getFieldTypeName() {
        return this.fieldTypeName;
    }

    public void setFieldTypeName(String value) {
        this.fieldTypeName = value;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int value) {
        this.fieldType = value;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int value) {
        this.size = value;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int value) {
        this.precision = value;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int value) {
        this.scale = value;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean value) {
        this.primaryKey = value;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean value) {
        this.nullable = value;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    @Override
    Element getXMLNode(Document doc, String nodeName) {
        Element result = super.getXMLNode(doc, nodeName);
        result.appendChild(this.name.getXMLNode(doc, "name", "item"));
        if (this.isVirtualCalculatedField()) {
            result.appendChild(Helpers.createNodeWithValue(doc, "expression", this.getExpression()));
        }
        if (!Str.IsNullOrEmpty(this.fieldTypeName)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "type_name", this.fieldTypeName));
        }
        Element t = (Element)result.appendChild(Helpers.createNodeWithValue(doc, "type", this.fieldType));
        t.setAttribute("platform", "java");
        if (this.size != 0) {
            result.appendChild(Helpers.createNodeWithValue(doc, "size", this.size));
        }
        if (this.precision != 0) {
            result.appendChild(Helpers.createNodeWithValue(doc, "precision", this.precision));
        }
        if (this.scale != 0) {
            result.appendChild(Helpers.createNodeWithValue(doc, "scale", this.scale));
        }
        if (this.primaryKey) {
            result.appendChild(Helpers.createNodeWithValue(doc, "primary_key", this.primaryKey));
        }
        if (!this.nullable) {
            result.appendChild(Helpers.createNodeWithValue(doc, "nullable", this.nullable));
        }
        if (this.readOnly) {
            result.appendChild(Helpers.createNodeWithValue(doc, "readonly", this.readOnly));
        }
        if (!Str.IsNullOrEmpty(this.altName)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "alt_name", this.altName));
        }
        if (!Str.IsNullOrEmpty(this.shortDescription)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "descr", this.shortDescription));
        }
        if (!Str.IsNullOrEmpty(this.longDescription)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "long_descr", this.longDescription));
        }
        return result;
    }

    @Override
    void loadFromXMLNode(Element node) {
        String v;
        super.loadFromXMLNode(node);
        Element child = Helpers.findChildElByName("name", node);
        if (child != null) {
            this.name.loadFromXMLNode(child, "item");
        }
        if (!Str.IsNullOrEmpty(v = Helpers.getValueFromChildNode(node, "expression"))) {
            this.setExpression(v);
        }
        if ((child = Helpers.findChildElByName("type", node)) != null) {
            String platform = child.getAttribute("platform");
            v = Helpers.getValueFromChildNode(node, "type");
            if (!Str.IsNullOrEmpty(platform)) {
                Integer type;
                if (platform.compareToIgnoreCase("java") == 0) {
                    try {
                        this.fieldType = Integer.parseInt(v);
                    }
                    catch (NumberFormatException e) {
                        this.fieldType = 1111;
                    }
                } else if (platform.compareToIgnoreCase("delphi") == 0) {
                    int tFieldType = Integer.parseInt(v);
                    this.fieldType = tFieldType > 0 && tFieldType < Helpers.TFieldTypeConversionHelper.length ? Helpers.TFieldTypeConversionHelper[tFieldType] : 1111;
                }
                this.fieldType = platform.compareToIgnoreCase("net") == 0 ? ((type = Helpers.DbTypeConversionHelper.get(v)) != null ? type : 1111) : Helpers.guessTypeFromXMLValue(v);
            } else {
                this.fieldType = Helpers.guessTypeFromXMLValue(v);
            }
        }
        this.fieldTypeName = !Str.IsNullOrEmpty(v = Helpers.getValueFromChildNode(node, "type_name")) ? v : "";
        v = Helpers.getValueFromChildNode(node, "size");
        this.size = !Str.IsNullOrEmpty(v) ? Integer.parseInt(v) : 0;
        v = Helpers.getValueFromChildNode(node, "precision");
        this.precision = !Str.IsNullOrEmpty(v) ? Integer.parseInt(v) : 0;
        v = Helpers.getValueFromChildNode(node, "scale");
        this.scale = !Str.IsNullOrEmpty(v) ? Integer.parseInt(v) : 0;
        v = Helpers.getValueFromChildNode(node, "primary_key");
        this.primaryKey = !Str.IsNullOrEmpty(v) ? Integer.parseInt(v) > 0 : false;
        v = Helpers.getValueFromChildNode(node, "nullable");
        this.nullable = !Str.IsNullOrEmpty(v) ? Integer.parseInt(v) > 0 : true;
        v = Helpers.getValueFromChildNode(node, "readonly");
        this.readOnly = !Str.IsNullOrEmpty(v) ? Integer.parseInt(v) > 0 : false;
        v = Helpers.getValueFromChildNode(node, "descr");
        if (!Str.IsNullOrEmpty(v)) {
            this.shortDescription = v;
        }
        if (!Str.IsNullOrEmpty(v = Helpers.getValueFromChildNode(node, "long_descr"))) {
            this.longDescription = v;
        }
        this.altName = !Str.IsNullOrEmpty(v = Helpers.getValueFromChildNode(node, "alt_name")) ? v : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            if (source instanceof UpdatablePersistent) {
                super.assign(source);
                if (source instanceof MetadataField) {
                    this.usedDatabaseObjects = ((MetadataField)source).usedDatabaseObjects;
                    this.usedDatabaseObjectColumns = ((MetadataField)source).usedDatabaseObjectColumns;
                    this.name.assign(((MetadataField)source).getName());
                    this.fieldTypeName = ((MetadataField)source).getFieldTypeName();
                    this.fieldType = ((MetadataField)source).getFieldType();
                    this.size = ((MetadataField)source).getSize();
                    this.precision = ((MetadataField)source).getPrecision();
                    this.scale = ((MetadataField)source).getScale();
                    this.primaryKey = ((MetadataField)source).isPrimaryKey();
                    this.nullable = ((MetadataField)source).isNullable();
                    this.readOnly = ((MetadataField)source).isReadOnly();
                    this.shortDescription = ((MetadataField)source).getShortDescription();
                    this.longDescription = ((MetadataField)source).getLongDescription();
                    this.altName = ((MetadataField)source).getAltName();
                    this.expression = ((MetadataField)source).getExpression();
                    if (this.expressionAST != null) {
                        this.expressionAST.dispose();
                        this.expressionAST = null;
                    }
                    this.expressionAST = ((MetadataField)source).isVirtualCalculatedField() ? ((MetadataField)source).getExpressionAST().clone(this.sqlContext) : null;
                    this.notifyUpdated();
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setNameAlias(SQLAliasExpression name) throws QueryBuilderException {
        this.name.clear();
        if (name.alias != null) {
            if (name.alias instanceof AstTokenIdentifier) {
                this.setNameToken((AstTokenIdentifier)name.alias);
            } else {
                this.setNameStr(name.alias.getToken());
            }
        }
    }

    public void setNameToken(AstToken token) {
        this.name.clear();
        this.name.addName(token.clone(this.sqlContext));
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expr) {
        if (!expr.equals(this.getExpression())) {
            if (Str.IsNullOrEmpty(expr)) {
                this.expression = "";
                if (this.expressionAST != null) {
                    this.expressionAST.dispose();
                    this.expressionAST = null;
                }
            } else {
                SQLExpressionItem ei = this.sqlContext.parseExpression(expr);
                this.expression = expr;
                if (this.expressionAST != null) {
                    this.expressionAST.dispose();
                    this.expressionAST = null;
                }
                this.expressionAST = ei;
            }
        }
    }

    public SQLExpressionItem getExpressionAST() {
        return this.expressionAST;
    }

    public boolean isVirtualCalculatedField() {
        return this.getExpressionAST() != null;
    }

    StatsColumns getUsedDatabaseObjectColumns() {
        return this.usedDatabaseObjectColumns;
    }

    void setUsedDatabaseObjectColumns(StatsColumns value) {
        if (this.usedDatabaseObjectColumns != value) {
            if (value != null) {
                if (this.usedDatabaseObjectColumns == null) {
                    this.usedDatabaseObjectColumns = new StatsColumns(this.sqlContext);
                }
                this.usedDatabaseObjectColumns.assign(value);
            } else if (this.usedDatabaseObjectColumns != null) {
                this.usedDatabaseObjectColumns.dispose();
                this.usedDatabaseObjectColumns = null;
            }
        }
    }

    StatsObjects getUsedDatabaseObjects() {
        return this.usedDatabaseObjects;
    }

    void setUsedDatabaseObjects(StatsObjects value) {
        if (this.usedDatabaseObjects != value) {
            if (value != null) {
                if (this.usedDatabaseObjects == null) {
                    this.usedDatabaseObjects = new StatsObjects(this.sqlContext);
                }
                this.usedDatabaseObjects.assign(value);
            } else if (this.usedDatabaseObjects != null) {
                this.usedDatabaseObjects.dispose();
                this.usedDatabaseObjects = null;
            }
        }
    }

    public void prepareStatsCollections() {
        if (this.usedDatabaseObjects == null) {
            this.usedDatabaseObjects = new StatsObjects(this.sqlContext);
        }
        if (this.usedDatabaseObjectColumns == null) {
            this.usedDatabaseObjectColumns = new StatsColumns(this.sqlContext);
        }
    }
}

