/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataCollectionItemBase;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataCollectionBase
extends MetadataBase {
    private Class itemClass;
    private Vector<MetadataCollectionItemBase> items = new Vector();

    public MetadataCollectionBase(MetadataBase parent, BaseSQLContext sqlContext, Class itemClass) {
        super(parent, sqlContext);
        this.itemClass = itemClass;
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }

    public int getCount() {
        return this.items.size();
    }

    public int getCapacity() {
        return this.items.capacity();
    }

    public void setCapacity(int value) {
        this.items.ensureCapacity(value);
    }

    public MetadataCollectionItemBase get(int index) {
        return this.items.get(index);
    }

    public void set(int index, MetadataCollectionItemBase value) {
        this.items.set(index, value);
        this.notifyUpdated();
    }

    protected String getXMLItemName() {
        return "item";
    }

    @Override
    Element getXMLNode(Document doc, String nodeName) {
        String itemName;
        Element result = super.getXMLNode(doc, nodeName);
        if (result != null && !Str.IsNullOrEmpty(itemName = this.getXMLItemName())) {
            for (int i = 0; i < this.getCount(); ++i) {
                Element item = this.get(i).getXMLNode(doc, itemName);
                if (item == null) continue;
                result.appendChild(item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromXMLNode(Element node) {
        this.beginUpdate();
        try {
            this.clear();
            String itemName = this.getXMLItemName();
            if (!Str.IsNullOrEmpty(itemName)) {
                this.setCapacity(node.getChildNodes().getLength());
                for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                    Node child = node.getChildNodes().item(i);
                    if (child == null || !child.getNodeName().equals(itemName)) continue;
                    MetadataCollectionItemBase obj = this.add();
                    obj.loadFromXMLNode((Element)child);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            if (source instanceof MetadataCollectionBase) {
                this.clear();
                for (int i = 0; i < ((MetadataCollectionBase)source).getCount(); ++i) {
                    this.items.add((MetadataCollectionItemBase)((MetadataCollectionBase)source).get(i).clone(this, this.sqlContext));
                }
                this.notifyUpdated();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public MetadataCollectionItemBase add() {
        MetadataCollectionItemBase result = null;
        try {
            Constructor c = this.itemClass.getConstructor(MetadataBase.class, BaseSQLContext.class);
            result = (MetadataCollectionItemBase)c.newInstance(this, this.sqlContext);
            this.items.add(result);
            this.notifyUpdated();
        }
        catch (Exception ex) {
            Logger.getLogger(MetadataCollectionBase.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public void clear() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).dispose();
        }
        this.items.clear();
        this.notifyUpdated();
    }

    public void delete(int index) {
        this.items.remove(index);
        this.notifyUpdated();
    }

    public int indexOf(MetadataCollectionItemBase item) {
        return this.items.indexOf(item);
    }

    public MetadataBase insert(int index) {
        MetadataCollectionItemBase result = null;
        try {
            Constructor c = this.itemClass.getConstructor(MetadataBase.class, BaseSQLContext.class);
            result = (MetadataCollectionItemBase)c.newInstance(this, this.sqlContext);
            this.items.add(index, result);
            this.notifyUpdated();
        }
        catch (Exception ex) {
            Logger.getLogger(MetadataCollectionBase.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public void move(int curIndex, int newIndex) {
        Helpers.listMove(this.items, curIndex, newIndex);
        this.notifyUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(MetadataCollectionItemBase item) {
        try {
            int i = this.items.indexOf(item);
            if (i != -1) {
                MetadataCollectionItemBase mci = this.get(i);
                if (mci != null) {
                    mci.dispose();
                }
                this.items.remove(i);
            }
            int n = i;
            return n;
        }
        finally {
            this.notifyUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator<MetadataCollectionItemBase> comparator) {
        this.beginUpdate();
        try {
            Collections.sort(this.items, comparator);
            this.notifyUpdated();
        }
        finally {
            this.endUpdate();
        }
    }
}

