/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.beans.PropertyEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.xml.gui.base.inspector.editors.AbstractSimplePropretyEditor;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;

public class XmlTextAreaEditor
extends AbstractXmlPropertyEditorDecorator<String> {
    private TextAreaPanel _textAreaPanel;

    public XmlTextAreaEditor() {
        super((PropertyEditor)new AbstractSimplePropretyEditor<String>(String.class){

            protected String getValueForString(String string) {
                return string;
            }

            protected String getStringForValue(String value) {
                return value;
            }
        });
    }

    public Component getXmlComponent() {
        if (this._textAreaPanel == null) {
            this._textAreaPanel = new TextAreaPanel();
        }
        this.updateXmlComponentFromPropertyValue();
        return this._textAreaPanel;
    }

    public void updateXmlComponentFromPropertyValue() {
        this.getTextArea().setText(this.getAsText());
    }

    public void updatePropertyValueFromXmlComponent() {
        String value;
        Document document = this.getTextArea().getDocument();
        try {
            value = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
        this.setValue(value);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.getTextArea().addFocusListener(focusListener);
    }

    public void removeChildFocusListener(FocusListener focusListener) {
        this.getTextArea().removeFocusListener(focusListener);
    }

    public JTextArea getTextArea() {
        return this._textAreaPanel.getTextArea();
    }

    public XmlTextAreaEditor setEnabled(boolean enabled) {
        this.getTextArea().setEnabled(enabled);
        this._textAreaPanel.setEnabled(enabled);
        return this;
    }

    class TextAreaPanel
    extends JPanel {
        private JTextArea _jTextArea;
        private JScrollPane _textAreaScrollPane;

        public TextAreaPanel() {
            super(new BorderLayout());
            this._jTextArea = new JTextArea();
            this._jTextArea.setRows(5);
            this._jTextArea.setWrapStyleWord(true);
            this._jTextArea.setLineWrap(true);
            this._textAreaScrollPane = new JScrollPane(this._jTextArea);
            this.add((Component)this._textAreaScrollPane, "Center");
        }

        public JTextArea getTextArea() {
            return this._jTextArea;
        }

        @Override
        public void setToolTipText(String text) {
            this._jTextArea.setToolTipText(text);
        }
    }
}

