/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;

public class XmlNiceTableAdapter
extends AbstractXmlTableAdapter {
    private JButton _addButton;
    private JButton _deleteButton;

    public XmlNiceTableAdapter(XmlTableEditor xmlTableEditor) {
        super(xmlTableEditor);
    }

    @Override
    protected DefaultTableModel createTableModel() {
        return new ElementTableModel();
    }

    @Override
    protected JTable createTable() {
        return new ElementTable(this.getTableModel());
    }

    @Override
    protected JPanel createTablePanel() {
        JScrollPane tableScrollPane = new JScrollPane(this.getTable());
        HeaderPanel headerPanel = this.buildHeaderPanel(tableScrollPane, Header.Level.SUB, this.getXmlTableEditor().getXmlComponentModel().getShortDisplayName(), false, false, true, null);
        this._addButton = new JButton(this.getXmlTableEditor().createAddAction());
        this._deleteButton = new JButton(this.getXmlTableEditor().createDeleteAction());
        headerPanel.getHeader().addActionControl((Component)this._addButton);
        headerPanel.getHeader().addActionControl((Component)this._deleteButton);
        return headerPanel;
    }

    @Override
    public void updateAddDeleteButtons() {
        this._addButton.setEnabled(true);
        this._deleteButton.setEnabled(this.getTableModel().getRowCount() > 0 && this.getTable().getSelectedRow() > -1);
    }

    private HeaderPanel buildHeaderPanel(Component component, Header.Level level, String title, boolean displayBorder, boolean indent, boolean expanded, Icon icon) {
        JPanel wrappedComponent = new JPanel(new BorderLayout());
        wrappedComponent.add(component, "Center");
        HeaderPanel headerPanel = new HeaderPanel((JComponent)wrappedComponent);
        headerPanel.setComponentBorderPainted(displayBorder);
        headerPanel.setComponentIndented(indent);
        Header header = headerPanel.getHeader();
        if (title != null) {
            header.setText(title);
        }
        if (icon != null) {
            header.setIcon(icon);
        }
        header.setLevel(level);
        header.setExpanded(expanded);
        return headerPanel;
    }

    protected class ElementTableModel
    extends AbstractXmlTableAdapter.AbstractXmlTableModel {
    }

    protected class ElementTable
    extends NiceTable {
        private int mMinVisibleRowCount;
        private int mMaxVisibleRowCount;
        private int mVisibleRowCount;

        public ElementTable(TableModel tableModel) {
            super(tableModel);
            this.mMinVisibleRowCount = 1;
            this.mMaxVisibleRowCount = 6;
            this.mVisibleRowCount = -1;
            tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (ElementTable.this.getRowCount() != ElementTable.this.mVisibleRowCount) {
                        ElementTable.this.resizeViewport();
                    }
                    if (tableModelEvent.getType() == 1) {
                        int firstRow = tableModelEvent.getFirstRow();
                        int columnCount = ElementTable.this.getColumnCount();
                        for (int column = 0; column < columnCount; ++column) {
                            if (!ElementTable.this.isCellEditable(firstRow, column)) continue;
                            ElementTable.this.editCellAt(firstRow, column);
                            break;
                        }
                    }
                }
            });
            this.setRowHeight(new JTextField().getPreferredSize().height);
        }

        public int getMinVisibleRowCount() {
            return this.mMinVisibleRowCount;
        }

        public void setMinVisibleRowCount(int minVisibleRowCount) {
            this.mMinVisibleRowCount = minVisibleRowCount;
        }

        public int getMaxVisibleRowCount() {
            return this.mMaxVisibleRowCount;
        }

        public void setMaxVisibleRowCount(int maxVisibleRowCount) {
            this.mMaxVisibleRowCount = maxVisibleRowCount;
        }

        public boolean isFocusable() {
            return this.getRowCount() > 0;
        }

        public void addNotify() {
            super.addNotify();
            this.resizeViewport();
        }

        public void resizeViewport() {
            int currentRowCount = this.getRowCount();
            this.mVisibleRowCount = Math.min(currentRowCount, this.mMaxVisibleRowCount);
            this.mVisibleRowCount = Math.max(this.mVisibleRowCount, this.mMinVisibleRowCount);
            Dimension preferredScrollableViewportSize = this.getPreferredScrollableViewportSize();
            preferredScrollableViewportSize.height = this.getRowHeight() * this.mVisibleRowCount;
            this.setPreferredScrollableViewportSize(preferredScrollableViewportSize);
        }

        public void stopCellEditing() {
            TableCellEditor cellEditor = this.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
        }
    }
}

