/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.table.EditableTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.ui.table.TableToolbar;

public class XmlGenericTableAdapter
extends AbstractXmlTableAdapter {
    private TableToolbar _toolBar;

    public XmlGenericTableAdapter(XmlTableEditor xmlTableEditor) {
        super(xmlTableEditor);
    }

    @Override
    protected DefaultTableModel createTableModel() {
        return new ElementTableModel();
    }

    @Override
    protected JTable createTable() {
        return new ElementTable(this.getXmlTableEditor().getTableModel());
    }

    @Override
    protected JPanel createTablePanel() {
        JScrollPane tableScrollPane = new JScrollPane(this.getTable());
        ResizeComponent rc = new ResizeComponent((JComponent)tableScrollPane);
        ReorderableTableWithTitleBar tablePanel = new ReorderableTableWithTitleBar(this.getXmlTableEditor().getTable(), (JComponent)rc, true, true);
        this.configureGenericTable();
        this.configureToolbar(tablePanel);
        return tablePanel;
    }

    protected void configureGenericTable() {
        GenericTable genericTable = (GenericTable)this.getXmlTableEditor().getTable();
        TableHelper.installTableTransferHandler((JTable)genericTable, (boolean)true);
        genericTable.setRowHeader(genericTable.createDefaultRowHeader());
        genericTable.setSelectAllEnabled(true);
        genericTable.setColumnSelectorAvailable(true);
        genericTable.setSelectColumnsAction((Action)new AbstractAction("Select Columns...", OracleIcons.getIcon((String)"table.png")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JEWTDialog d = new JEWTDialog(WindowUtils.parentFrame((Component)XmlGenericTableAdapter.this.getTable()), "Customize Table Columns");
                d.setContent((Component)new JLabel("Client Specific Option. This is just a demo"));
                d.pack();
                d.runDialog();
            }
        });
        genericTable.setPreferredVisibleRowCount(this.getTable().getRowCount());
        this.getTable().setPreferredScrollableViewportSize(new Dimension(320, this.getTable().getPreferredScrollableViewportSize().height));
    }

    protected void configureToolbar(ReorderableTableWithTitleBar tablePanel) {
        this._toolBar = tablePanel.getTableToolbar();
        this._toolBar.setLabel(this.getXmlTableEditor().getXmlComponentModel().getShortDisplayName());
        this._toolBar.setAddVisible(true);
        this._toolBar.setDefaultAddAction(this.getXmlTableEditor().createAddAction());
        this._toolBar.setEditVisible(false);
        this._toolBar.setDefaultEditAction((Action)new EditAction());
        this._toolBar.setDeleteVisible(true);
        this._toolBar.setDefaultDeleteAction(this.getXmlTableEditor().createDeleteAction());
        this._toolBar.setClearVisible(false);
        this._toolBar.setDefaultClearAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.CLEAR));
        this._toolBar.setCopyVisible(false);
        this._toolBar.setDefaultCopyAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.COPY));
        this._toolBar.setPasteVisible(false);
        this._toolBar.setDefaultPasteAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.PASTE));
        this._toolBar.setDuplicateVisible(false);
        this._toolBar.setDefaultDuplicateAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.DUPLICATE_ROW));
    }

    public TableToolbar getToolbar() {
        return this._toolBar;
    }

    @Override
    public void updateAddDeleteButtons() {
        this._toolBar.setAddVisible(true);
        this._toolBar.setDeleteVisible(this.getTableModel().getRowCount() > 0 && this.getTable().getSelectedRow() > -1);
    }

    protected class ElementTableModel
    extends AbstractXmlTableAdapter.AbstractXmlTableModel
    implements EditableTableModel,
    GenericTableModel {
        public void insertColumn(int column, Object columnName, Object[] columnData) {
        }

        public void removeColumn(int column) {
        }

        public int duplicateRow(int row, int nCopy) {
            Object[] rowData = new Object[this.getColumnCount()];
            for (int i = 0; i < rowData.length; ++i) {
                rowData[i] = i == 0 ? "Copy of " + this.getValueAt(row, i) : this.getValueAt(row, i);
            }
            this.insertRow(row + 1, rowData);
            return row + 1;
        }

        public int duplicateColumn(int col, int nCopy) {
            return -1;
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public boolean canHide(int column) {
            return column != 2;
        }
    }

    protected class ElementTable
    extends GenericTable {
        private int mMinVisibleRowCount;
        private int mMaxVisibleRowCount;
        private int mVisibleRowCount;

        public ElementTable(TableModel tableModel) {
            super(tableModel);
            this.mMinVisibleRowCount = 1;
            this.mMaxVisibleRowCount = 6;
            this.mVisibleRowCount = -1;
            tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (ElementTable.this.getRowCount() != ElementTable.this.mVisibleRowCount) {
                        ElementTable.this.resizeViewport();
                    }
                    if (tableModelEvent.getType() == 1) {
                        int firstRow = tableModelEvent.getFirstRow();
                        int columnCount = ElementTable.this.getColumnCount();
                        for (int column = 0; column < columnCount; ++column) {
                            if (!ElementTable.this.isCellEditable(firstRow, column)) continue;
                            ElementTable.this.editCellAt(firstRow, column);
                            break;
                        }
                    }
                }
            });
            this.setRowHeight(new JTextField().getPreferredSize().height);
        }

        public int getMinVisibleRowCount() {
            return this.mMinVisibleRowCount;
        }

        public void setMinVisibleRowCount(int minVisibleRowCount) {
            this.mMinVisibleRowCount = minVisibleRowCount;
        }

        public int getMaxVisibleRowCount() {
            return this.mMaxVisibleRowCount;
        }

        public void setMaxVisibleRowCount(int maxVisibleRowCount) {
            this.mMaxVisibleRowCount = maxVisibleRowCount;
        }

        public boolean isFocusable() {
            return this.getRowCount() > 0;
        }

        public void addNotify() {
            super.addNotify();
            this.resizeViewport();
        }

        public void resizeViewport() {
            int currentRowCount = this.getRowCount();
            this.mVisibleRowCount = Math.min(currentRowCount, this.mMaxVisibleRowCount);
            this.mVisibleRowCount = Math.max(this.mVisibleRowCount, this.mMinVisibleRowCount);
            Dimension preferredScrollableViewportSize = this.getPreferredScrollableViewportSize();
            preferredScrollableViewportSize.height = this.getRowHeight() * this.mVisibleRowCount;
            this.setPreferredScrollableViewportSize(preferredScrollableViewportSize);
        }

        public void stopCellEditing() {
            TableCellEditor cellEditor = this.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (XmlGenericTableAdapter.this.getTable().getRowSelectionAllowed() || XmlGenericTableAdapter.this.getTable().getColumnSelectionAllowed()) {
                int row = XmlGenericTableAdapter.this.getTable().getSelectedRow();
                int col = XmlGenericTableAdapter.this.getTable().getSelectedColumn();
                if (row != -1 && col != -1) {
                    TableHelper.stopCellEditing((JTable)XmlGenericTableAdapter.this.getTable());
                    JEWTDialog d = new JEWTDialog(WindowUtils.parentFrame((Component)XmlGenericTableAdapter.this._toolBar), "Edit Cell/Row (Use Case Specific)");
                    JLabel label = new JLabel("Enter the data for the new row or column");
                    JTextField jt = new JTextField(20);
                    JPanel p = new JPanel(new BorderLayout());
                    p.add((Component)label, "North");
                    p.add((Component)jt, "Center");
                    d.setContent((Component)p);
                    Object value = XmlGenericTableAdapter.this.getTable().getModel().getValueAt(row, col);
                    if (value != null) {
                        jt.setText(value.toString());
                    }
                    if (d.runDialog()) {
                        XmlGenericTableAdapter.this.getTable().getModel().setValueAt(jt.getText(), row, col);
                    }
                }
            }
        }
    }
}

