/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.beans.VetoableChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlContextualActionProvider;
import oracle.bali.xml.gui.swing.xmlComponent.XmlContextualActionContext;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableCellEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.ContextualActionProvider2;

public class XmlCustomEditorActionProvider
extends AbstractXmlContextualActionProvider {
    private static final String EDIT_ACTION_NAME = "Edit...";
    private static final String EDIT_DIALOG_TITLE = "Edit Property - {0}";

    public List<? extends Action> getContextualActions(ContextualActionProvider2.Param param) {
        if (this.getContextualActionContext() != null) {
            XmlPropertyEditorAction customEditorAction;
            XmlComponentWrapper xmlComponentWrapper = this.getContextualActionContext().getXmlComponentWrapper();
            if (xmlComponentWrapper.getXmlComponentModel().isReadOnly()) {
                return Collections.emptyList();
            }
            XmlKey key = param.getKey();
            if (key != null && (customEditorAction = this.createXmlPropertyEditorAction(param)) != null) {
                XmlContextualActionContext.updateContextIn(customEditorAction, this.getContextualActionContext());
                return Collections.singletonList(customEditorAction);
            }
        }
        return Collections.emptyList();
    }

    public XmlPropertyEditorAction createXmlPropertyEditorAction(ContextualActionProvider2.Param param) {
        AbstractAction action = null;
        boolean supportsCustomEditor = ((PropertyEditor)this.getContextualActionContext().getXmlComponentWrapper().getPropertyEditor()).supportsCustomEditor();
        if (supportsCustomEditor) {
            action = new XmlPropertyEditorAction(EDIT_ACTION_NAME, EDIT_DIALOG_TITLE, param);
        }
        if (action != null) {
            action.putValue("show-in-xmlcomponent", true);
            action.putValue("show-in-pi", false);
            action.putValue("show-in-context-menu", false);
            action.putValue("show-in-context-menu-even-when-inline-editing-disabled", Boolean.FALSE);
        }
        return action;
    }

    public class XmlPropertyEditorAction
    extends AbstractAction {
        private static final int EDIT_DIALOG_BUTTON_MASK = 3;
        private static final String EMPTY_STRING = "";
        private String _dialogTitle;

        protected XmlPropertyEditorAction(String name, String dialogTitle, ContextualActionProvider2.Param param) {
            super(name);
            this._dialogTitle = dialogTitle;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XmlContextualActionContext actionContext = XmlContextualActionContext.contextFrom(this);
            XmlComponentWrapper xmlComponentWrapper = actionContext.getXmlComponentWrapper();
            if (xmlComponentWrapper != null) {
                boolean result;
                XmlTableCellEditor xmlTableCellEditor = actionContext.getXmlTableCellEditor();
                XmlComponentPropertyEditor propertyEditor = xmlComponentWrapper.getPropertyEditor();
                propertyEditor.updatePropertyValueFromXmlComponent();
                Component customEditor = ((PropertyEditor)propertyEditor).getCustomEditor();
                String editDialogTitle = FastMessageFormat.formatMessage((String)this._dialogTitle, (String)xmlComponentWrapper.getXmlComponentModel().getXmlKey().getLocalName());
                int buttonMask = 7;
                String helpId = HelpUtils.getHelpID((Component)customEditor);
                if (helpId == null || helpId.equals(HelpUtils.getDefaultHelpID())) {
                    buttonMask = 3;
                }
                JEWTDialog editDialog = JEWTDialog.createDialog(null, (String)editDialogTitle, (int)buttonMask);
                editDialog.setContent(customEditor);
                if (customEditor instanceof VetoableChangeListener) {
                    editDialog.addVetoableChangeListener((VetoableChangeListener)((Object)customEditor));
                }
                if (result = editDialog.runDialog()) {
                    Object propertyValue = ((PropertyEditor)propertyEditor).getValue();
                    if (propertyValue != null) {
                        xmlComponentWrapper.setXmlComponentValue(propertyValue.toString());
                    } else {
                        xmlComponentWrapper.setXmlComponentValue(EMPTY_STRING);
                    }
                    propertyEditor.updateXmlComponentFromPropertyValue();
                    if (xmlTableCellEditor != null) {
                        xmlTableCellEditor.stopCellEditing();
                    }
                }
            }
        }
    }
}

