/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableCellEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableCellRenderer;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.javatools.icons.OracleIcons;
import org.w3c.dom.Node;
import sun.beans.editors.StringEditor;

public abstract class AbstractXmlTableEditor
extends AbstractXmlPropertyEditorDecorator<String> {
    private JTable _table;
    private DefaultTableModel _tableModel;
    private ArrayList<XmlComponentWrapper> _columnXmlComponentWrapperList = new ArrayList();
    private int _columnCount = 0;
    private int _selectedIndex = -1;
    private int _prevSelectedIndex = -1;
    private JPanel _tablePanel;
    private boolean _safeDelete = true;

    public AbstractXmlTableEditor() {
        super((PropertyEditor)new StringEditor());
    }

    public Component getXmlComponent() {
        if (this._tablePanel != null) {
            this.getTableModel().fireTableDataChanged();
            this.updateAddDeleteButtons();
            if (this._selectedIndex < 0 && this._prevSelectedIndex > -1) {
                this._selectedIndex = this._prevSelectedIndex;
            }
            if (this._selectedIndex > -1) {
                if (this._selectedIndex >= this._table.getRowCount()) {
                    this._table.changeSelection(this._table.getRowCount() - 1, 0, false, false);
                } else {
                    this._table.changeSelection(this._selectedIndex, 0, false, false);
                }
            }
            return this._tablePanel;
        }
        this.getXmlComponentWrapper().setAddFocusTracker(false);
        this._tableModel = this.createTableModel();
        this._table = this.createTable();
        this.setupTable();
        this.setTableCellEditors();
        this._tablePanel = this.createTablePanel();
        if (this.getXmlComponentWrapper().getParent() != null) {
            this.getTablePanel().setEnabled(false);
            this.getTable().setEnabled(false);
        }
        return this._tablePanel;
    }

    protected abstract JPanel createTablePanel();

    public JPanel getTablePanel() {
        return this._tablePanel;
    }

    public JTable getTable() {
        return this._table;
    }

    public DefaultTableModel getTableModel() {
        return this._tableModel;
    }

    public void updateXmlComponentFromPropertyValue() {
    }

    public void updatePropertyValueFromXmlComponent() {
    }

    public boolean updatePropertyValue() {
        return false;
    }

    protected abstract DefaultTableModel createTableModel();

    protected abstract JTable createTable();

    protected void setupTable() {
        this.getTable().setSelectionMode(0);
        this.getTable().setShowGrid(true);
        this.getTable().setGridColor(Color.LIGHT_GRAY);
        this.getTable().setIntercellSpacing(new Dimension(1, 1));
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    AbstractXmlTableEditor.this._prevSelectedIndex = AbstractXmlTableEditor.this._selectedIndex;
                    AbstractXmlTableEditor.this._selectedIndex = AbstractXmlTableEditor.this.getTable().getSelectedRow();
                    AbstractXmlTableEditor.this.getXmlComponentModel().invalidateNode();
                    AbstractXmlTableEditor.this.getXmlComponentModel().setSelectedIndex(-1);
                    if (AbstractXmlTableEditor.this._selectedIndex < 0) {
                        if (AbstractXmlTableEditor.this.getXmlComponentWrapper().getChildHeaderComponent() != null) {
                            AbstractXmlTableEditor.this.getXmlComponentWrapper().getChildHeaderComponent().setEnabled(false);
                        }
                        AbstractXmlTableEditor.this.getXmlComponentWrapper().updateChildXmlComponents();
                        return;
                    }
                    new NonDomMutationTransactionTask(){

                        protected void performTask(AbstractModel model) {
                            Node selection = (Node)AbstractXmlTableEditor.this.getXmlComponentModel().getChild((Object)AbstractXmlTableEditor.this.getXmlComponentModel().getParentNode(), AbstractXmlTableEditor.this._selectedIndex);
                            if (selection != null) {
                                model.getSelection().set(selection);
                                AbstractXmlTableEditor.this.getXmlComponentModel().setNode(selection);
                                AbstractXmlTableEditor.this.getXmlComponentModel().setSelectedIndex(AbstractXmlTableEditor.this._selectedIndex);
                                AbstractXmlTableEditor.this.updateAddDeleteButtons();
                            }
                        }
                    }.run((AbstractModel)AbstractXmlTableEditor.this.getXmlComponentModel().getView());
                }
                if (AbstractXmlTableEditor.this.getXmlComponentWrapper().getChildHeaderComponent() != null) {
                    AbstractXmlTableEditor.this.getXmlComponentWrapper().getChildHeaderComponent().setEnabled(true);
                }
                AbstractXmlTableEditor.this.getXmlComponentWrapper().updateChildXmlComponents();
            }
        });
    }

    public AbstractXmlTableEditor add(XmlComponentWrapper xmlComponentWrapper) {
        xmlComponentWrapper.setAddFocusTracker(false);
        this._columnXmlComponentWrapperList.add(xmlComponentWrapper);
        ++this._columnCount;
        return this;
    }

    public String getTableColumnName(int columnIndex) {
        return this._columnXmlComponentWrapperList.get(columnIndex).getXmlComponentModel().getXmlKey().getLocalName();
    }

    public XmlComponentWrapper getTableColumnComponentWrapper(int columnIndex) {
        return this._columnXmlComponentWrapperList.get(columnIndex);
    }

    public String getTableColumnTitle(int columnIndex) {
        XmlComponentWrapper columnXmlComponentWrapper = this._columnXmlComponentWrapperList.get(columnIndex);
        String columnTitle = columnXmlComponentWrapper.getXmlComponentModel().getShortDisplayName();
        if (columnXmlComponentWrapper.getXmlComponentModel().isRequired().booleanValue()) {
            columnTitle = columnTitle + "*";
        }
        return columnTitle;
    }

    protected abstract void updateAddDeleteButtons();

    protected Action createAddAction() {
        AbstractAction addAction = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractXmlTableEditor.this.getXmlComponentModel().insertChildNode();
                AbstractXmlTableEditor.this._tableModel.fireTableDataChanged();
                AbstractXmlTableEditor.this.updateAddDeleteButtons();
                int row = AbstractXmlTableEditor.this._table.getRowCount() - 1;
                AbstractXmlTableEditor.this._table.changeSelection(row, 0, false, false);
                AbstractXmlTableEditor.this._table.requestFocusInWindow();
                AbstractXmlTableEditor.this._table.scrollRectToVisible(AbstractXmlTableEditor.this._table.getCellRect(row, 0, true));
            }
        };
        return addAction;
    }

    protected Action createDeleteAction() {
        final AbstractAction instantDeleteAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node selectedNode;
                int row = AbstractXmlTableEditor.this._table.getSelectedRow();
                if (row != -1 && (selectedNode = (Node)AbstractXmlTableEditor.this.getXmlComponentModel().getChild((Object)AbstractXmlTableEditor.this.getXmlComponentModel().getParentNode(), row)) != null) {
                    AbstractXmlTableEditor.this.getXmlComponentModel().deleteNode(selectedNode);
                    AbstractXmlTableEditor.this.getXmlComponentModel().invalidateNode();
                    AbstractXmlTableEditor.this._tableModel.fireTableDataChanged();
                    AbstractXmlTableEditor.this.updateAddDeleteButtons();
                    if (row >= AbstractXmlTableEditor.this._table.getRowCount()) {
                        AbstractXmlTableEditor.this._table.changeSelection(AbstractXmlTableEditor.this._table.getRowCount() - 1, 0, false, false);
                    } else {
                        AbstractXmlTableEditor.this._table.changeSelection(row, 0, false, false);
                    }
                }
            }
        };
        XmlContext xmlContext = this.getXmlComponentModel().getView().getContext();
        final Action safeDeleteAction = xmlContext.getAction("clear");
        AbstractAction parentDeleteAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractXmlTableEditor.this.getTable().getCellEditor() != null) {
                    AbstractXmlTableEditor.this.getTable().getCellEditor().cancelCellEditing();
                }
                if (AbstractXmlTableEditor.this.getSafeDelete()) {
                    safeDeleteAction.actionPerformed(e);
                } else {
                    instantDeleteAction.actionPerformed(e);
                }
            }
        };
        return parentDeleteAction;
    }

    public Object getCellValueAt(final int rowIndex, int columnIndex) {
        final XmlComponentWrapper columnXmlComponentWrapper = this.getColumnXmlComponentWrapperList().get(columnIndex);
        return new ReadOnlyTask<Object>(){

            protected Object runImpl(AbstractModel model) {
                XmlComponentModel cellXmlComponentModel = AbstractXmlTableEditor.getCellXmlComponentModel(AbstractXmlTableEditor.this.getXmlComponentModel(), columnXmlComponentWrapper, rowIndex);
                if (cellXmlComponentModel == null) {
                    return null;
                }
                return cellXmlComponentModel.getModelValue();
            }
        }.run((AbstractModel)columnXmlComponentWrapper.getXmlComponentModel().getView());
    }

    public void setCellValueAt(final Object value, final int rowIndex, int columnIndex) {
        final XmlComponentWrapper columnXmlComponentWrapper = this.getColumnXmlComponentWrapperList().get(columnIndex);
        new FixedNameTransactionTask("setValueAt row=" + rowIndex + " " + this.getTableColumnName(columnIndex) + "=" + (String)value){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                XmlComponentModel cellXmlComponentModel = AbstractXmlTableEditor.getCellXmlComponentModel(AbstractXmlTableEditor.this.getXmlComponentModel(), columnXmlComponentWrapper, rowIndex);
                if (cellXmlComponentModel == null) {
                    return;
                }
                cellXmlComponentModel.updateModelValue((String)value);
            }
        }.run((AbstractModel)columnXmlComponentWrapper.getXmlComponentModel().getView());
    }

    public ArrayList<XmlComponentWrapper> getColumnXmlComponentWrapperList() {
        return this._columnXmlComponentWrapperList;
    }

    public int getTableColumnCount() {
        return this._columnCount;
    }

    protected void setTableCellEditors() {
        for (int i = 0; i < this._columnCount; ++i) {
            TableColumn tc = this._table.getColumnModel().getColumn(i);
            Node node = this.getXmlComponentModel().getNode();
            XmlKey xmlKey = this.getXmlComponentModel().getXmlKey();
            Node ownerNode = node != null && xmlKey.getNodeType() == 2 ? this.getXmlComponentModel().getParentAttrNode() : node;
            tc.setCellEditor(this.createXmlTableCellEditor(this.getXmlComponentModel().getView().getContext(), ImmutableXmlKey.createAttributeKey((List)xmlKey.getElementQNamePath(), (String)this.getTableColumnName(i)), node, ownerNode, FocusLostBehavior.DO_NOTHING, this.getTableColumnComponentWrapper(i)));
            tc.setCellRenderer(this.createXmlTableCellRenderer(this.getTableColumnComponentWrapper(i)));
        }
    }

    protected XmlTableCellEditor createXmlTableCellEditor(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, FocusLostBehavior focusLostBehaviour, XmlComponentWrapper xmlComponentWrapper) {
        return new XmlTableCellEditor(xmlContext, xmlKey, node, ownerNode, focusLostBehaviour, xmlComponentWrapper);
    }

    protected XmlTableCellRenderer createXmlTableCellRenderer(XmlComponentWrapper xmlComponentWrapper) {
        return new XmlTableCellRenderer(xmlComponentWrapper, this.getColumnXmlComponentWrapperList());
    }

    public XmlComponentLayoutOption getXmlComponentLayoutOption() {
        XmlLayoutOption elementTableLayoutOption = new XmlLayoutOption().setAddLabel(false).setSpanEntireRow(true).setShowContextualActionButton(false).setLeftMargin(0);
        return elementTableLayoutOption;
    }

    public AbstractXmlTableEditor setEnabled(boolean enabled) {
        this.getTablePanel().setEnabled(enabled);
        this.getTable().setEnabled(enabled);
        return this;
    }

    public boolean getSafeDelete() {
        return this._safeDelete;
    }

    public AbstractXmlTableEditor setSafeDelete(boolean safeDelete) {
        this._safeDelete = safeDelete;
        return this;
    }

    static XmlComponentModel getCellXmlComponentModel(XmlComponentModel tableXmlComponentModel, XmlComponentWrapper columnXmlComponentWrapper, int rowIndex) {
        XmlComponentModel xmlComponentModel = null;
        Node parentNode = tableXmlComponentModel.getParentNode();
        Node foundNode = (Node)tableXmlComponentModel.getChild((Object)parentNode, rowIndex);
        if (foundNode != null) {
            XmlComponentWrapper parentXmlComponentWrapper = columnXmlComponentWrapper.getParent();
            xmlComponentModel = columnXmlComponentWrapper.getXmlComponentModel();
            if (parentXmlComponentWrapper == null) {
                xmlComponentModel.setParentXmlComponentModel(null);
            } else {
                xmlComponentModel.setParentXmlComponentModel(parentXmlComponentWrapper.getXmlComponentModel());
            }
            xmlComponentModel.setStartNode(foundNode);
            xmlComponentModel.invalidateNode();
        }
        return xmlComponentModel;
    }

    public static enum FocusLostBehavior {
        DO_NOTHING,
        STOP_CELL_EDITING,
        CANCEL_CELL_EDITING;

    }
}

