/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.wizard;

import java.awt.Component;
import javax.swing.JComponent;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.gui.swing.nodeComponent.DomNodeComponent;
import oracle.bali.xml.gui.swing.nodeComponent.SwingDomNodeComponentGui;
import oracle.bali.xml.gui.swing.wizard.NodeWizardPageAdapter;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlUsage;

public class DefaultNodeWizardPageProvider
extends NodeWizardPageAdapter {
    private DomPosition _position;
    private WizardPage _defaultPage;
    private SwingDomNodeComponentGui _nodeGui;
    private DomNodeComponent _defaultDomNodeComponent;

    @Override
    public int getWizardPageCount() {
        if (this._defaultPage == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public WizardPage getWizardPage(int i) {
        return this._defaultPage;
    }

    @Override
    public void dispose(boolean finished) {
        if (this._defaultDomNodeComponent != null) {
            this._defaultDomNodeComponent.dispose();
        }
        this._defaultDomNodeComponent = null;
        this._nodeGui = null;
        super.dispose(finished);
    }

    public boolean doFinish(BaseWizard wizard) {
        if (this._defaultPage != null && this._defaultDomNodeComponent != null && !this._defaultDomNodeComponent.validate()) {
            wizard.selectPage(this._defaultPage);
            return false;
        }
        try {
            this.validateCommonPage();
        }
        catch (Exception ex) {
            this._getSwingContext().showErrorMessage(ex.getLocalizedMessage(), this._getSwingContext().getTranslatedString("ERROR_DIALOG_TITLE"), null, this._defaultDomNodeComponent.getComponent());
            return false;
        }
        return true;
    }

    public boolean doFinish() {
        if (this._defaultPage != null && this._defaultDomNodeComponent != null && !this._defaultDomNodeComponent.validate()) {
            return false;
        }
        try {
            this.validateCommonPage();
        }
        catch (Exception ex) {
            this._getSwingContext().showErrorMessage(ex.getLocalizedMessage(), this._getSwingContext().getTranslatedString("ERROR_DIALOG_TITLE"), null, this._defaultDomNodeComponent.getComponent());
            return false;
        }
        return true;
    }

    @Override
    public void wizardValidatePage(WizardEvent e) {
    }

    protected boolean showCommonPage() {
        return true;
    }

    protected void validateCommonPage() throws Exception {
    }

    @Override
    protected void initializePages() {
        XmlContext c = this.getContext();
        if (this.isCreation() && !this.getNode().hasAttributes()) {
            c.getModel().initializeNewNode(this.getNode(), this.getXmlKey());
        }
        if (c instanceof GuiXmlContext) {
            GuiXmlContext context = (GuiXmlContext)c;
            XmlGui nodeGui = context.getGui(XmlUsage.DOM_NODE_COMPONENT);
            if (nodeGui instanceof SwingDomNodeComponentGui) {
                this._nodeGui = (SwingDomNodeComponentGui)nodeGui;
            }
            String commonTitleKey = this.isCreation() ? "NODE_WIZARD.ENTER_COMMON_PROPERTIES_TITLE" : "NODE_WIZARD.COMMON_PROPERTIES_TITLE";
            commonTitleKey = "NODE_WIZARD.ENTER_COMMON_PROPERTIES_TITLE";
            String commonTitle = context.getTranslatedString(commonTitleKey);
            WizardPage wizardPage = this._defaultPage = this.showCommonPage() ? this._createPage(commonTitle) : null;
            if (this._defaultPage != null) {
                this.setCanFinish(true);
                this._defaultPage.setCanAdvance(true);
            } else {
                this.setCanFinish(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHelpID(boolean commonPage) {
        XmlContext context = this.getContext();
        if (context != null) {
            XmlUsage usage = this.isCreation() ? XmlUsage.NODE_CREATOR : XmlUsage.NODE_CUSTOMIZER;
            XmlGui gui = ((GuiXmlContext)context).getGui(usage);
            context.getModel().acquireReadLock();
            try {
                String string = gui.getHelpTopic(this.getNode(), this.getXmlKey());
                return string;
            }
            finally {
                context.getModel().releaseReadLock();
            }
        }
        return null;
    }

    protected final DomPosition getDomPosition() {
        return this._position;
    }

    void __setDomPosition(DomPosition position) {
        this._position = position;
    }

    private SwingXmlContext _getSwingContext() {
        return (SwingXmlContext)this.getContext();
    }

    private WizardPage _createPage(String title) {
        this._defaultDomNodeComponent = this._nodeGui.createPropertyComponent(this.getNode(), this.getXmlKey());
        if (this._defaultDomNodeComponent.getComponent() == null) {
            return null;
        }
        Component c = this._defaultDomNodeComponent.getComponent();
        this.addHelp(c);
        WizardPage page = new WizardPage(c, title);
        return page;
    }

    void addHelp(Component c) {
        if (c instanceof JComponent) {
            final JComponent jComponent = (JComponent)c;
            HelpProvider helpProvider = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpUtils.setHelpID((JComponent)jComponent, (String)DefaultNodeWizardPageProvider.this.getHelpID(true));
                    HelpUtils.setHelpProvider((JComponent)jComponent, null);
                    HelpUtils.getHelpProvider((Component)component).showHelp(component);
                }
            };
            HelpUtils.setHelpProvider((JComponent)jComponent, (HelpProvider)helpProvider);
        }
    }
}

