/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ReentrantWizard;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.gui.swing.wizard.DefaultNodeWizardPageProvider;
import oracle.bali.xml.gui.swing.wizard.NodeWizardPageProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import org.w3c.dom.Node;

public abstract class AbstractNodeWizard
implements NodeCreator,
NodeCustomizer {
    public static final int NO_DIALOG_RUNNING = 0;
    public static final int CREATOR_DIALOG_RUNNING = 1;
    public static final int CUSTOMIZER_DIALOG_RUNNING = 2;
    private BaseWizard _wizard;
    private Node _node;
    private XmlContext _context;
    private XmlKey _key;
    private DomPosition _position;
    private static int _DialogRunning = 0;
    private static int MIN_DIALOG_WIDTH = 371;

    public abstract NodeWizardPageProvider getWizardPageProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode(XmlContext context, XmlKey key, DomPosition position, Node prototypeNode) {
        AbstractNodeWizard.setDialogRunning(1);
        try {
            this._node = null;
            this._context = context;
            this._key = key;
            this._position = position;
            NodeWizardPageProvider provider = this.getWizardPageProvider();
            if (provider == null) {
                Node node = null;
                return node;
            }
            if (prototypeNode == null) {
                QualifiedName elementQName = key.getElementQName();
                this._node = context.getModel().getDocument().createElementNS(elementQName.getNamespace(), elementQName.getName());
            } else {
                this._node = prototypeNode;
            }
            provider.setContext(this._context, this._key, this._node, true);
            if (provider.getWizardPageCount() == 0) {
                this._node = null;
            } else if (provider.getWizardPageCount() == 1) {
                Dialog dialog = new Dialog(this.getParentFrame(), provider.getWizardTitle(), 7);
                Component content = provider.getWizardPage(0).getContent();
                Dimension dim = content.getPreferredSize();
                int width = (int)dim.getWidth();
                int diff = MIN_DIALOG_WIDTH - width;
                if (diff > 0) {
                    width += diff;
                }
                Dimension newDim = new Dimension(width, (int)dim.getHeight());
                content.setPreferredSize(newDim);
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add(content, "Center");
                if (provider instanceof DefaultNodeWizardPageProvider) {
                    ((DefaultNodeWizardPageProvider)provider).addHelp(panel);
                }
                dialog.setContent(panel);
                boolean ok = dialog.runDialog();
                if (!ok) {
                    this._node = null;
                }
            } else if (provider.getWizardPageCount() > 0) {
                Listener l = new Listener();
                BaseWizard wizard = this.createWizard(true);
                WizardDialog d = this._initializeWizard(wizard, provider, l);
                boolean ok = d.runDialog();
                if (!ok) {
                    this._node = null;
                }
                this._disposeWizard(d, wizard, provider, l, ok);
            }
            Node node = this._node;
            return node;
        }
        finally {
            AbstractNodeWizard.setDialogRunning(0);
        }
    }

    public static int getDialogRunning() {
        return _DialogRunning;
    }

    protected static void setDialogRunning(int dialogRunning) {
        _DialogRunning = dialogRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean customizeNode(XmlContext context, Node n, XmlKey key) {
        AbstractNodeWizard.setDialogRunning(2);
        try {
            boolean commit = false;
            this._node = n;
            this._context = context;
            this._key = key;
            this._position = null;
            NodeWizardPageProvider provider = this.getWizardPageProvider();
            if (provider == null) {
                boolean bl = false;
                return bl;
            }
            provider.setContext(this._context, this._key, this._node, false);
            if (provider.getWizardPageCount() > 0) {
                Listener l = new Listener();
                BaseWizard wizard = this.createWizard(false);
                WizardDialog d = this._initializeWizard(wizard, provider, l);
                commit = d.runDialog();
                this._disposeWizard(d, wizard, provider, l, commit);
            }
            boolean bl = commit;
            return bl;
        }
        finally {
            AbstractNodeWizard.setDialogRunning(0);
        }
    }

    public boolean isNodeCustomizable(XmlContext context, Node n, XmlKey key) {
        return true;
    }

    protected BaseWizard createWizard(boolean create) {
        if (create) {
            return new Wizard();
        }
        return new ReentrantWizard();
    }

    protected WizardDialog createDialog(BaseWizard wizard, Frame parentFrame) {
        return new WizardDialog(wizard, parentFrame);
    }

    protected Node getNode() {
        return this._node;
    }

    protected XmlContext getContext() {
        return this._context;
    }

    protected XmlKey getXmlKey() {
        return this._key;
    }

    protected DomPosition getDomPosition() {
        return this._position;
    }

    protected Frame getParentFrame() {
        Frame f;
        SwingXmlContext sxc;
        Component c;
        if (this.getContext() instanceof SwingXmlContext && (c = (sxc = (SwingXmlContext)this.getContext()).getRootDocumentUIComponent()) != null && (f = WindowUtils.parentFrame((Component)c)) != null) {
            return f;
        }
        return new JFrame();
    }

    private WizardDialog _initializeWizard(BaseWizard wizard, NodeWizardPageProvider provider, Listener listener) {
        WizardValidateListener wvl = provider.getWizardValidateListener();
        boolean help = false;
        for (int i = 0; i < provider.getWizardPageCount(); ++i) {
            WizardPage wp = provider.getWizardPage(i);
            help |= HelpUtils.getHelpID((Component)wp.getContent()) != null;
            if (wvl != null) {
                wp.addWizardValidateListener(wvl);
            }
            wizard.addPage(wp);
        }
        if (provider.getWizardListener() != null) {
            wizard.addWizardListener(provider.getWizardListener());
        }
        provider.addPropertyChangeListener(listener);
        WizardDialog d = this.createDialog(wizard, this.getParentFrame());
        wizard.setHelpAvailable(help);
        d.setWizardTitle(provider.getWizardTitle());
        d.setFinishPageIncluded(provider.isFinishPageIncluded());
        d.setWelcomeWizardPage(provider.getWelcomePage());
        if (wizard instanceof Wizard) {
            ((Wizard)wizard).setMustFinish(!provider.getCanFinish());
        }
        this._wizard = wizard;
        return d;
    }

    private void _disposeWizard(final WizardDialog d, final BaseWizard wizard, NodeWizardPageProvider provider, Listener listener, boolean finished) {
        WizardValidateListener wvl;
        if (provider.getWizardListener() != null) {
            wizard.removeWizardListener(provider.getWizardListener());
        }
        if ((wvl = provider.getWizardValidateListener()) != null) {
            for (int i = 0; i < provider.getWizardPageCount(); ++i) {
                WizardPage wp = provider.getWizardPage(i);
                if (wvl == null) continue;
                wp.removeWizardValidateListener(wvl);
            }
        }
        provider.removePropertyChangeListener(listener);
        provider.dispose(finished);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                d.dispose();
                wizard.dispose();
                wizard.removeAll();
            }
        };
        SwingUtilities.invokeLater(r);
        this._wizard = null;
    }

    private class Dialog
    extends JEWTDialog {
        public Dialog(Frame owner, String title, int buttonMask) {
            super(owner, title, buttonMask);
        }

        protected void dismissDialog(boolean cancelled) {
            if (!cancelled) {
                if (this._isFinished()) {
                    Dialog.super.dismissDialog(cancelled);
                }
            } else {
                Dialog.super.dismissDialog(cancelled);
            }
        }

        private boolean _isFinished() {
            NodeWizardPageProvider provider = AbstractNodeWizard.this.getWizardPageProvider();
            boolean finished = ((DefaultNodeWizardPageProvider)provider).doFinish();
            return finished;
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            WizardPage selected;
            String name = e.getPropertyName();
            if ("canFinish".equals(name)) {
                if (AbstractNodeWizard.this._wizard instanceof Wizard) {
                    ((Wizard)AbstractNodeWizard.this._wizard).setMustFinish(!AbstractNodeWizard.this.getWizardPageProvider().getCanFinish());
                }
            } else if ("nextEnabled".equals(name) && (selected = AbstractNodeWizard.this._wizard.getSelectedPage()) != null) {
                selected.setCanAdvance(AbstractNodeWizard.this.getWizardPageProvider().isNextEnabled());
            }
        }
    }
}

