/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.gui.swing.util.XmlKeyPicker;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlMetadataUtils;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.ImmutableFilteredCollection;
import oracle.bali.xml.util.XmlCreationAction;
import org.w3c.dom.Node;

public class InsertionMenuGenerator {
    private static final int _MAX_NAMESPACES_IN_MENU = 15;
    private static final int _MAX_ITEMS_IN_NAMESPACE_MENU = 20;
    private static final int _MAX_ITEMS_PROMOTED_TO_ROOT_MENU = 20;

    private InsertionMenuGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List generateInsertionMenus(XmlView view, DomPosition position) {
        if (position == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Component> insertionSubmenus = new LinkedList<Component>();
        XmlMetadataResolver resolver = view.getXmlMetadataResolver();
        view.acquireReadLock();
        try {
            Collection insertionPositions = resolver.getPotentialInsertionPositions(position);
            for (DomPosition insertionPosition : insertionPositions) {
                Component subMenu;
                if (!resolver.canAddChild(insertionPosition) || (subMenu = InsertionMenuGenerator._generateInsertionSubmenu(view, insertionPosition)) == null) continue;
                insertionSubmenus.add(subMenu);
            }
            LinkedList<Component> linkedList = insertionSubmenus;
            return linkedList;
        }
        finally {
            view.releaseReadLock();
        }
    }

    private static Component _generateInsertionSubmenu(final XmlView view, final DomPosition insertionPosition) {
        String titleKey;
        boolean hasMenu = InsertionMenuGenerator._getCreatableKeys(view, insertionPosition).iterator().hasNext();
        if (!hasMenu) {
            return null;
        }
        switch (insertionPosition.getRelativePosition()) {
            case 2: {
                titleKey = "InsertAfter";
                break;
            }
            case 1: {
                titleKey = "InsertBefore";
                break;
            }
            case 0: {
                titleKey = "InsertInside";
                break;
            }
            default: {
                throw new IllegalStateException("invalid position: " + insertionPosition);
            }
        }
        XmlMetadataResolver resolver = view.getXmlMetadataResolver();
        Node targetNode = insertionPosition.getTargetNode();
        String menuTitle = view.getTranslatedString(titleKey, resolver.getMediumDisplayName(targetNode));
        int mnemonic = StringUtils.getMnemonicKeyCode((String)menuTitle);
        menuTitle = StringUtils.stripMnemonic((String)menuTitle);
        Iterator lazyItor = new Iterator(){
            private Iterator _realItor;

            @Override
            public boolean hasNext() {
                this._populate();
                return this._realItor.hasNext();
            }

            public Object next() {
                this._populate();
                return this._realItor.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void _populate() {
                if (this._realItor == null) {
                    LinkedList list = new LinkedList();
                    InsertionMenuGenerator._populateInsertionMenusForPosition(view, list, insertionPosition);
                    this._realItor = list.iterator();
                }
            }
        };
        JMenu menu = InsertionMenuGenerator._createMenu(view, menuTitle, lazyItor);
        menu.setMnemonic(mnemonic);
        menu.putClientProperty("XmlContext.CONTEXT_SECTION_ID_ACTION_PROPERTY", XmlContext.INSERTION_SECTION_ID_VALUE);
        return menu;
    }

    private static JMenu _createMenu(XmlView view, String menuTitle, Iterator items) {
        JMenu menu = ((SwingXmlContext)view.getContext()).createMenu(menuTitle, items);
        menu.putClientProperty(SwingXmlContext.MENU_PROPERTY_REQUEST_AUTO_MNEUMONICS, Boolean.TRUE);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _populateInsertionMenusForPosition(XmlView view, Collection topLevelItems, DomPosition insertionPosition) {
        view.acquireReadLock();
        try {
            XmlMetadataResolver resolver = view.getXmlMetadataResolver();
            List preferredChildren = resolver.getCreatablePreferredXmlKeys(insertionPosition);
            if (!preferredChildren.isEmpty()) {
                topLevelItems.addAll(XmlCreationAction.createLazyActionCollectionFromKeyCollection((AbstractModel)view, (DomPosition)insertionPosition, (Collection)preferredChildren));
            }
            Collection lazyKeys = InsertionMenuGenerator._getCreatableKeys(view, insertionPosition);
            ArrayList creationKeys = new ArrayList(200);
            Iterator lazyItor = lazyKeys.iterator();
            while (lazyItor.hasNext()) {
                creationKeys.add(lazyItor.next());
            }
            Map creatableChildMap = XmlMetadataUtils.groupKeysByNamespace((AbstractModel)view, creationKeys);
            if (creatableChildMap.isEmpty()) {
                return;
            }
            int creationMapSize = creatableChildMap.size();
            if (creationMapSize + creationKeys.size() - preferredChildren.size() < 20) {
                Iterator itor = creatableChildMap.entrySet().iterator();
                boolean noSeparatorBefore = preferredChildren.isEmpty();
                while (itor.hasNext()) {
                    boolean firstInCurGroup = true;
                    Map.Entry entry = itor.next();
                    Collection keys = (Collection)entry.getValue();
                    for (XmlKey key : keys) {
                        if (preferredChildren.contains(key)) continue;
                        if (firstInCurGroup) {
                            firstInCurGroup = false;
                            if (noSeparatorBefore) {
                                noSeparatorBefore = false;
                            } else {
                                topLevelItems.add(new JPopupMenu.Separator());
                            }
                        }
                        topLevelItems.add(new XmlCreationAction((AbstractModel)view, insertionPosition, key));
                    }
                }
            } else if (creationMapSize <= 15) {
                if (!topLevelItems.isEmpty()) {
                    topLevelItems.add(new JPopupMenu.Separator());
                }
                for (Map.Entry entry : creatableChildMap.entrySet()) {
                    InsertionMenuGenerator._addSubmenuForKeys(view, insertionPosition, topLevelItems, entry);
                }
            }
            if (!creatableChildMap.isEmpty()) {
                if (!topLevelItems.isEmpty()) {
                    topLevelItems.add(new JPopupMenu.Separator());
                }
                String browseString = view.getTranslatedString("BROWSE");
                topLevelItems.add(new ShowDialogAction(browseString, creatableChildMap, view, insertionPosition));
            }
        }
        finally {
            view.releaseReadLock();
        }
    }

    private static Collection _getCreatableKeys(XmlView view, DomPosition insertionPosition) {
        final XmlMetadataResolver res = view.getXmlMetadataResolver();
        final Node containerNode = insertionPosition.getContainerNode(view.getTreeTraversal());
        final XmlKey containerKey = view.getNodeXmlKey(containerNode);
        return new ImmutableFilteredCollection(res.getCreateableChildrenXmlKeys(insertionPosition), new ImmutableFilteredCollection.Filter(){

            public boolean accept(Object o) {
                return res.isXmlKeyCreatableInMenu(containerNode, containerKey, (XmlKey)o);
            }
        });
    }

    private static void _addSubmenuForKeys(XmlView view, DomPosition position, Collection baseCreationCollection, Map.Entry entry) {
        Collection keys = (Collection)entry.getValue();
        String menuName = (String)entry.getKey();
        if (keys.size() <= 20) {
            Collection actions = XmlCreationAction.createLazyActionCollectionFromKeyCollection((AbstractModel)view, (DomPosition)position, (Collection)keys);
            baseCreationCollection.add(InsertionMenuGenerator._createMenu(view, menuName, actions.iterator()));
        } else {
            String actionName = view.getTranslatedString("INSERT_MENU.OVERFLOW_FORMAT", menuName);
            baseCreationCollection.add(new ShowDialogAction(actionName, Collections.singletonMap(menuName, keys), view, position));
        }
    }

    private static void _insertXmlKey(XmlKey selectedKey, AbstractModel model, DomPosition position) {
        try {
            model.insertXmlKey(selectedKey, position);
        }
        catch (XmlCommitException e) {
            model.getLogger().log(Level.SEVERE, "unable to create " + selectedKey + " at position " + position, e);
        }
    }

    private static Component _getParentComponent(AbstractModel model, ActionEvent ae) {
        if (model.getContext() instanceof SwingXmlContext) {
            return ((SwingXmlContext)model.getContext()).getRootDocumentUIComponent();
        }
        return null;
    }

    private static class ShowDialogAction
    extends AbstractAction {
        private final Map _xmlKeyMap;
        private final XmlView _view;
        private final DomPosition _position;

        public ShowDialogAction(String name, Map xmlKeyMap, XmlView view, DomPosition position) {
            if (xmlKeyMap.isEmpty()) {
                throw new IllegalArgumentException("empty map");
            }
            this.putValue("Name", name);
            this._xmlKeyMap = xmlKeyMap;
            this._view = view;
            this._position = position;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Component parentComponent = InsertionMenuGenerator._getParentComponent((AbstractModel)this._view, ae);
            String ns = this._position.getContainerNode().getNamespaceURI();
            XmlKey suggestedNsKey = ImmutableXmlKey.createNamespaceKey((String)ns);
            String initialSelection = this._view.getXmlMetadataResolver().getShortDisplayName(suggestedNsKey);
            Set categoriesSet = this._xmlKeyMap.keySet();
            Object[] categories = categoriesSet.toArray();
            Arrays.sort(categories);
            String strTitle = categories.length == 1 ? this._view.getTranslatedString("XML_INSERT_ITEM_FORMAT_KEY", (String)categories[0]) : this._view.getTranslatedString("XML_INSERT_ITEM_KEY");
            XmlKey selectedKey = XmlKeyPicker.runDialog(parentComponent, strTitle, "f1_editorcreate_html", this._xmlKeyMap, (AbstractModel)this._view, initialSelection);
            if (selectedKey != null && this._position != null) {
                InsertionMenuGenerator._insertXmlKey(selectedKey, (AbstractModel)this._view, this._position);
            }
        }
    }
}

