/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.gui.swing.util.AbstractAddAttributeAction;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GrammarBasedAddAttributeAction
extends AbstractAddAttributeAction {
    private JTextField _value;
    private JComboBox _namespace;
    private JComboBox _localName;
    private JComboBox _prefix;
    private List _namespaces;

    public GrammarBasedAddAttributeAction(XmlContext context, XmlKey key, Element element) {
        super(context, key, element);
    }

    @Override
    protected Component createContent() {
        Container content = UIUtils.createLabelFieldContainer();
        String ns = this.getContext().getTranslatedString("ADDATTRIBUTE.NAMESPACE");
        JLabel namespaceLabel = new JLabel(StringUtils.stripMnemonic((String)ns));
        namespaceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ns));
        String ps = this.getContext().getTranslatedString("ADDATTRIBUTE.PREFIX");
        JLabel prefixLabel = new JLabel(StringUtils.stripMnemonic((String)ps));
        prefixLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ps));
        String lns = this.getContext().getTranslatedString("ADDATTRIBUTE.LOCALNAME");
        JLabel localNameLabel = new JLabel(StringUtils.stripMnemonic((String)lns));
        localNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)lns));
        String vs = this.getContext().getTranslatedString("ADDATTRIBUTE.VALUE");
        JLabel valueLabel = new JLabel(StringUtils.stripMnemonic((String)vs));
        valueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)vs));
        JComboBox namespace = new JComboBox();
        namespace.setEditable(true);
        namespaceLabel.setLabelFor(namespace);
        JComboBox prefix = new JComboBox();
        prefix.setEditable(true);
        prefixLabel.setLabelFor(prefix);
        JComboBox localName = new JComboBox();
        localName.setEditable(true);
        localNameLabel.setLabelFor(localName);
        JTextField value = new JTextField();
        valueLabel.setLabelFor(value);
        content.add(namespaceLabel);
        content.add(namespace);
        content.add(prefixLabel);
        content.add(prefix);
        content.add(localNameLabel);
        content.add(localName);
        content.add(valueLabel);
        content.add(value);
        this._namespace = namespace;
        this._namespace.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GrammarBasedAddAttributeAction.this._namespaceChanged(GrammarBasedAddAttributeAction.this._namespace.getSelectedIndex());
                }
            }
        });
        this._localName = localName;
        this._prefix = prefix;
        this._value = value;
        this._setNamespaceContents();
        return content;
    }

    @Override
    protected String getNamespace() {
        int index = this._namespace.getSelectedIndex();
        if (index == -1) {
            return (String)this._namespace.getSelectedItem();
        }
        return (String)this._namespaces.get(index);
    }

    @Override
    protected String getPrefix() {
        return (String)this._prefix.getSelectedItem();
    }

    @Override
    protected String getLocalName() {
        Object selectedItem = this._localName.getSelectedItem();
        if (selectedItem instanceof LocalDisplayName) {
            return ((LocalDisplayName)selectedItem).getLocalName();
        }
        return selectedItem.toString();
    }

    @Override
    protected String getValue() {
        return this._value.getText();
    }

    @Override
    protected void validateContent() throws Exception {
        String namespace = this.getNamespace();
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException(this.getContext().getTranslatedString("ADDATTRIBUTE.NAMESPACE_ERROR"));
        }
        String localName = this.getLocalName();
        if (localName == null || "".equals(localName)) {
            throw new IllegalArgumentException(this.getContext().getTranslatedString("ADDATTRIBUTE.LOCALNAME_ERROR"));
        }
        XmlKey key = ImmutableXmlKey.createAttributeKey((String)namespace, (String)localName);
        this.getContext().getModel().getXmlMetadataResolver().validateValue(key, (Node)this.getElement(), (Object)this.getValue());
    }

    @Override
    protected String getHelpID() {
        return "f1_xsdaddattribute_html";
    }

    private void _setNamespaceContents() {
        List namespaces;
        Wildcard w = this._getWildCard();
        this._namespaces = namespaces = GrammarBasedAddAttributeAction.getNamespaces(w, this.getContext(), this.getElement());
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(this._getDisplayNames(this._namespaces).toArray());
        this._namespace.setModel(model);
        this._namespaceChanged(this._namespace.getSelectedIndex());
        if (w.getProcessingRule() == 0 || w.getProcessingRule() == 1 && w.getVariety() == 2) {
            this._namespace.setEditable(false);
        } else {
            this._namespace.setEditable(true);
        }
        if (w.getProcessingRule() == 0) {
            this._localName.setEditable(false);
        } else {
            this._localName.setEditable(true);
        }
    }

    private Wildcard _getWildCard() {
        ElementDef ed;
        Type type;
        GrammarComponent gc = this.getContext().getModel().getXmlMetadataResolver().getGrammarComponent(this.getKey());
        if (gc instanceof ElementDef && (type = (ed = (ElementDef)gc).getType()) instanceof ComplexType) {
            ComplexType ct = (ComplexType)type;
            return ct.getAttributeWildcard();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getNamespaces(Wildcard w, XmlContext context, Element element) {
        context.getModel().acquireReadLock();
        try {
            if (w != null) {
                List namespaces = Collections.EMPTY_LIST;
                switch (w.getVariety()) {
                    case 2: {
                        namespaces = GrammarBasedAddAttributeAction._filterNamespaces(w.getNamespaceConstraintList(), context, element);
                        break;
                    }
                    case 0: 
                    case 1: {
                        namespaces = GrammarBasedAddAttributeAction._findNamespaces(context, element);
                        if (w.getVariety() != 1 || !namespaces.contains(w.getTargetNamespace())) break;
                        namespaces.remove(w.getTargetNamespace());
                    }
                }
                List list = namespaces;
                return list;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            context.getModel().releaseReadLock();
        }
    }

    private static List _filterNamespaces(List list, XmlContext context, Element element) {
        ArrayList<String> l = new ArrayList<String>();
        block0: for (int i = 0; i < list.size(); ++i) {
            String namespace = (String)list.get(i);
            GrammarProvider gp = context.getGrammarProvider();
            Grammar g = gp.getGrammarForNamespace(namespace);
            if (g == null) continue;
            Collection attributes = g.getAttributeDefs();
            for (AttributeDef attr : attributes) {
                if (element.hasAttributeNS(attr.getTargetNamespace(), attr.getName())) continue;
                l.add(namespace);
                continue block0;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _namespaceChanged(int index) {
        this.getContext().getModel().acquireReadLock();
        try {
            String namespace = index == -1 ? null : (String)this._namespaces.get(index);
            ArrayList<AttributeDef> localNameList = Collections.EMPTY_LIST;
            ArrayList<String> prefixList = Collections.EMPTY_LIST;
            GrammarProvider gp = this.getContext().getGrammarProvider();
            Grammar g = gp.getGrammarForNamespace(namespace);
            if (g != null) {
                boolean foundPrefixInFile;
                Collection attributes = g.getAttributeDefs();
                for (AttributeDef attr : attributes) {
                    if (localNameList == Collections.EMPTY_LIST) {
                        localNameList = new ArrayList<AttributeDef>(attributes.size());
                    }
                    if (this.getElement().hasAttributeNS(attr.getTargetNamespace(), attr.getName())) continue;
                    localNameList.add(attr);
                }
                String filePrefix = DomUtils.lookupPrefix((String)g.getTargetNamespace(), (Node)this.getElement());
                boolean bl = foundPrefixInFile = filePrefix != null && !"".equals(filePrefix);
                if (foundPrefixInFile) {
                    if (prefixList == Collections.EMPTY_LIST) {
                        prefixList = new ArrayList<String>();
                    }
                    prefixList.add(filePrefix);
                }
                if (!foundPrefixInFile) {
                    XmlKey namespaceKey = ImmutableXmlKey.createNamespaceKey((String)g.getTargetNamespace());
                    String preferredPrefix = this.getContext().getModel().getXmlMetadataResolver().getPreferredPrefix(namespaceKey);
                    if (preferredPrefix != null && !"".equals(preferredPrefix)) {
                        if (prefixList == Collections.EMPTY_LIST) {
                            prefixList = new ArrayList();
                        }
                        if (!prefixList.contains(preferredPrefix)) {
                            prefixList.add(preferredPrefix);
                        }
                    }
                }
                this._prefix.setEditable(!foundPrefixInFile);
            }
            List localDisplayNamesList = this._getLocalDisplayNames(localNameList);
            DefaultComboBoxModel<Object> localNameModel = new DefaultComboBoxModel<Object>(localDisplayNamesList.toArray());
            this._localName.setModel(localNameModel);
            DefaultComboBoxModel<Object> prefixModel = new DefaultComboBoxModel<Object>(prefixList.toArray());
            this._prefix.setModel(prefixModel);
        }
        finally {
            this.getContext().getModel().releaseReadLock();
        }
    }

    private List _getLocalDisplayNames(List list) {
        XmlMetadataResolver resolver = this.getContext().getModel().getXmlMetadataResolver();
        ArrayList<LocalDisplayName> l = new ArrayList<LocalDisplayName>(list.size());
        for (AttributeDef attr : list) {
            XmlKey key = ImmutableXmlKey.createAttributeKey((QualifiedName)attr.getQualifiedName());
            l.add(new LocalDisplayName(resolver.getShortDisplayName(key), attr.getName()));
        }
        Collections.sort(l, new LocalDisplayName("", ""));
        return l;
    }

    private List _getDisplayNames(List list) {
        XmlMetadataResolver resolver = this.getContext().getModel().getXmlMetadataResolver();
        ArrayList<String> l = new ArrayList<String>(list.size());
        for (String ns : list) {
            XmlKey key = ImmutableXmlKey.createNamespaceKey((String)ns);
            l.add(resolver.getShortDisplayName(key));
        }
        return l;
    }

    private static List _findNamespaces(XmlContext context, Element element) {
        ArrayList<String> namespaces = new ArrayList<String>();
        GrammarProvider gp = context.getGrammarProvider();
        Collection grammars = gp.getGrammars();
        block0: for (Grammar g : grammars) {
            Collection defs = g.getAttributeDefs();
            for (AttributeDef ad : defs) {
                if (element.hasAttributeNS(ad.getTargetNamespace(), ad.getName())) continue;
                namespaces.add(g.getTargetNamespace());
                continue block0;
            }
        }
        return namespaces;
    }

    private static class LocalDisplayName
    implements Comparator {
        private final String _displayName;
        private final String _localName;
        private Collator _collator;

        public LocalDisplayName(String displayName, String localName) {
            this._displayName = displayName;
            this._localName = localName;
        }

        public String getDisplayName() {
            return this._displayName;
        }

        public String getLocalName() {
            return this._localName;
        }

        public String toString() {
            return this._displayName;
        }

        public int compare(Object o1, Object o2) {
            if (this._collator == null) {
                this._collator = Collator.getInstance();
            }
            return this._collator.compare(((LocalDisplayName)o1).getDisplayName(), ((LocalDisplayName)o2).getDisplayName());
        }
    }
}

