/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.swing.inspector.SwingInspectorGui;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;

class DatabindingButtonListeners
implements ItemListener,
ListSelectionListener,
TableModelListener,
PropertyChangeListener,
AncestorListener {
    private boolean _attached = false;
    private final PropertyInspector _inspector;
    private final SwingInspectorGui _gui;
    private final JToggleButton _button;
    private static final String _BUTTON_PROPERTY = DatabindingButtonListeners.class.getName() + " button";

    public static JToggleButton createButton(SwingInspectorGui gui, PropertyInspector inspector) {
        JToggleButton button = gui.createDatabindingButton();
        button.setEnabled(false);
        DatabindingButtonListeners dbl = new DatabindingButtonListeners(button, gui, inspector);
        button.addAncestorListener(dbl);
        return button;
    }

    public static Component getDataBindingButton(PropertyInspector inspector) {
        return (Component)inspector.getClientProperty((Object)_BUTTON_PROPERTY);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        final PropertyModel propModel = this._inspector.getPropertyModel();
        final boolean bound = e.getStateChange() == 1;
        final int row = this._inspector.getPropertyTable().getSelectionModel().getLeadSelectionIndex();
        if (row < 0 || row >= propModel.getRowCount()) {
            return;
        }
        try {
            TableCellEditor editor = this._inspector.getPropertyTable().getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
        }
        catch (Exception exep) {
            // empty catch block
        }
        XmlView view = this._gui.getView();
        String attrDisplayName = (String)propModel.getData(PropertyModel.COLUMN_DISPLAY_NAME, row);
        String transactionFormat = this._gui.getTranslatedString(bound ? "INSPECTOR.BIND_ACTION_FORMAT" : "INSPECTOR.UNBIND_ACTION_FORMAT");
        String transactionText = FastMessageFormat.formatMessage((String)transactionFormat, (String)attrDisplayName);
        try {
            new FixedNameTransactionTask(transactionText){

                protected void performTask(AbstractModel model) {
                    int column = propModel.getColumnIndex(XmlDomPropertyModel.COLUMN_IS_DATABOUND);
                    propModel.setValueAt((Object)(bound ? Boolean.TRUE : Boolean.FALSE), row, column);
                    if (bound && !DatabindingButtonListeners.this._inspector.showAdvancedEditor(row)) {
                        DatabindingButtonListeners.this._inspector.getPropertyModel().setValueAt((Object)Boolean.FALSE, row, column);
                    }
                }
            }.runThrowingXCE((AbstractModel)view);
        }
        catch (Throwable t) {
            view.getContext().showErrorMessage(t.getMessage());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this._updateDatabindingButton();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this._updateDatabindingButton();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pe) {
        String name = pe.getPropertyName();
        if ("selectionModel".equals(name)) {
            ListSelectionModel newModel;
            ListSelectionModel old = (ListSelectionModel)pe.getOldValue();
            if (old != null) {
                old.removeListSelectionListener(this);
            }
            if ((newModel = (ListSelectionModel)pe.getNewValue()) != null) {
                newModel.addListSelectionListener(this);
            }
        } else if ("model".equals(name)) {
            TableModel newModel;
            TableModel old = (TableModel)pe.getOldValue();
            if (old != null) {
                old.removeTableModelListener(this);
            }
            if ((newModel = (TableModel)pe.getNewValue()) != null) {
                newModel.addTableModelListener(this);
            }
        } else if ("categorized".equals(name) || "intersection".equals(name)) {
            this._updateDatabindingButton();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this._attachListeners();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this._detachListeners();
    }

    private void _updateDatabindingButton() {
        ListSelectionModel selection = this._inspector.getPropertyTable().getSelectionModel();
        boolean multi = selection.getLeadSelectionIndex() != selection.getAnchorSelectionIndex();
        PropertyModel model = this._inspector.getPropertyModel();
        int row = selection.getLeadSelectionIndex();
        boolean validRow = row >= 0 && row < model.getRowCount();
        boolean enabled = false;
        if (validRow) {
            Object supportsDatabinding = model.getData(XmlDomPropertyModel.COLUMN_SUPPORTS_DATABINDING, row);
            enabled = Boolean.TRUE.equals(supportsDatabinding) && !multi && model.getBooleanData(XmlDomPropertyModel.COLUMN_IS_WRITABLE, row) && model.isCellEditable(row, model.getColumnIndex(XmlDomPropertyModel.COLUMN_IS_DATABOUND));
        }
        this._button.setEnabled(enabled);
        boolean set = false;
        if (validRow) {
            Object isBound = model.getData(XmlDomPropertyModel.COLUMN_IS_DATABOUND, row);
            set = Boolean.TRUE.equals(isBound);
        }
        this._button.removeItemListener(this);
        this._button.setSelected(set);
        this._button.addItemListener(this);
    }

    private synchronized void _detachListeners() {
        if (this._attached) {
            this._inspector.putClientProperty((Object)_BUTTON_PROPERTY, null);
            this._button.removeItemListener(this);
            this._inspector.getPropertyTable().getSelectionModel().removeListSelectionListener(this);
            this._inspector.getPropertyTable().getModel().removeTableModelListener(this);
            this._inspector.removePropertyChangeListener((PropertyChangeListener)this);
            this._inspector.getPropertyTable().removePropertyChangeListener(this);
            this._attached = false;
        }
    }

    private synchronized void _attachListeners() {
        if (!this._attached) {
            this._attached = true;
            this._inspector.putClientProperty((Object)_BUTTON_PROPERTY, (Object)this._button);
            this._inspector.addPropertyChangeListener((PropertyChangeListener)this);
            this._inspector.getPropertyTable().addPropertyChangeListener(this);
            this._inspector.getPropertyTable().getSelectionModel().addListSelectionListener(this);
            this._inspector.getPropertyTable().getModel().addTableModelListener(this);
            this._button.addItemListener(this);
        }
        this._updateDatabindingButton();
    }

    private DatabindingButtonListeners(JToggleButton tb, SwingInspectorGui gui, PropertyInspector inspector) {
        this._button = tb;
        this._gui = gui;
        this._inspector = inspector;
    }
}

