/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.util.XmlModelUtils;

public class XmlTreeCellRenderer
implements TreeCellRenderer {
    private final TreeCellRenderer _delegate;
    private final SwingExplorerGui _gui;

    public XmlTreeCellRenderer(SwingExplorerGui gui, TreeCellRenderer delegate) {
        if (gui == null || delegate == null) {
            throw new IllegalArgumentException("No explorer gui or delegate");
        }
        this._gui = gui;
        this._delegate = delegate;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
        Icon smallIcon = null;
        String tooltip = null;
        String text = "";
        if (value != null && !this._gui.isNodeToEvade(value)) {
            smallIcon = this._gui.getIcon(value);
            tooltip = this._gui.getTooltip(value);
            text = this._gui.getTitle(value);
        }
        if (tree != null && row > -1 && text != null && text != "") {
            text = this.truncateLongText(tree, row, text);
        }
        Component treeCellRenderer = this._delegate.getTreeCellRendererComponent(tree, text, sel, expanded, leaf, row, hasFocus);
        if (tooltip != null && treeCellRenderer instanceof JComponent) {
            ((JComponent)treeCellRenderer).setToolTipText(tooltip);
        }
        if (smallIcon != null && treeCellRenderer instanceof JLabel) {
            ((JLabel)treeCellRenderer).setIcon(smallIcon);
        }
        return treeCellRenderer;
    }

    private String truncateLongText(JTree tree, int row, String text) {
        FontMetrics treeFontMetrics;
        Font treeFont;
        String truncatedText = null;
        int viewPortWidth = 0;
        Container parent = tree.getParent();
        if (parent != null) {
            viewPortWidth = parent.getWidth();
        }
        if (viewPortWidth > 0 && (treeFont = tree.getFont()) != null && (treeFontMetrics = tree.getFontMetrics(treeFont)) != null) {
            int textWidth = treeFontMetrics.stringWidth(text);
            int suffixWidth = treeFontMetrics.stringWidth("...");
            TreePath treePath = tree.getPathForRow(row);
            if (treePath != null) {
                int maxWidth;
                int childIndent = 20;
                int depth = treePath.getPathCount() - 1;
                int depthOffset = 0;
                int nodeXOffset = 0;
                if (depth > 0) {
                    nodeXOffset = childIndent * (depth + depthOffset);
                }
                if (textWidth > (maxWidth = 2 * viewPortWidth - nodeXOffset)) {
                    int charIdx = 0;
                    for (int textLen = treeFontMetrics.charWidth(text.charAt(charIdx)); charIdx < text.length() && textLen < maxWidth - suffixWidth; textLen += treeFontMetrics.charWidth(text.charAt(++charIdx))) {
                    }
                    if (charIdx < 20) {
                        charIdx = text.length() > 20 ? 20 : text.length();
                    }
                    if (charIdx < text.length()) {
                        truncatedText = new String(text.substring(0, charIdx) + "...");
                    }
                }
            }
        }
        if (truncatedText == null) {
            return text;
        }
        return truncatedText;
    }
}

