/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.explorer.BaseExplorerGui;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.gui.swing.ContextMenuListener;
import oracle.bali.xml.gui.swing.explorer.ExplorerDropHandler;
import oracle.bali.xml.gui.swing.explorer.SavedExpansionState;
import oracle.bali.xml.gui.swing.explorer.TreeHelper;
import oracle.bali.xml.gui.swing.explorer.XmlJTree;
import oracle.bali.xml.gui.swing.explorer.XmlTreeCellRenderer;
import oracle.bali.xml.gui.swing.util.ActionUtils;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.share.PropertyChange;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.status.Issue;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SwingExplorerGui
extends BaseExplorerGui
implements ComponentXmlGui<JTree> {
    private ArrayList _trees = new ArrayList(1);
    private final TreeHelper _treeHelper = new TreeHelper(this);
    private final TreePropChangeListener _treePropertyChangeListener = new TreePropChangeListener();
    private boolean _ignoreLeadSelectionPathChange = false;
    private boolean _ignoreXmlCursorChange = false;
    private static final String _DROP_HANDLER_PROPERTY = "SwingExplorerGui.DROP_HANDLER";
    private static final String[] _EXPLORER_COMMANDS = new String[]{"cut", "copy", "paste", "clear", "customizeNode"};
    private static final String[] _FOLDER_ICON_KEYS = new String[]{"/oracle/bali/xml/gui/swing/icons/folder.png"};
    private static final Icon[] _FOLDER_ICONS = new Icon[_FOLDER_ICON_KEYS.length];
    private static final Object _WAS_ERROR_FOLDER_EXPANDED_KEY = "was-error-folder-expanded";

    public SwingExplorerGui(XmlView view) {
        super(view);
    }

    @Override
    public JTree getComponent() {
        return this.getJTree();
    }

    public final JTree getJTree() {
        if (this._trees.size() == 0) {
            JTree tree = this.createJTree();
            this._setupTree(tree);
        }
        return (JTree)this._trees.get(0);
    }

    public final JTree getNewJTree() {
        JTree tree = this.createJTree();
        this._setupTree(tree);
        return tree;
    }

    public void disposeJTree(JTree tree) {
        int index = this._trees.indexOf(tree);
        if (index != -1) {
            this._trees.remove(index);
            this.__getHelper().disposeComponent(tree);
            tree.setCellRenderer(null);
            if (tree instanceof XmlJTree) {
                ((XmlJTree)tree).dispose();
            }
            tree.removePropertyChangeListener(this._treePropertyChangeListener);
            this.disposeTreeSelectionModel(tree.getSelectionModel());
            tree.setSelectionModel(new DefaultTreeSelectionModel());
            tree.setModel(null);
            DropTarget dt = tree.getDropTarget();
            ExplorerDropHandler edh = (ExplorerDropHandler)tree.getClientProperty(_DROP_HANDLER_PROPERTY);
            tree.putClientProperty(_DROP_HANDLER_PROPERTY, null);
            dt.setComponent(null);
            dt.removeDropTargetListener(edh);
        }
    }

    public void paintSelection(JTree tree, Graphics g) {
        this._treeHelper.paintCursorOrDropPosition(tree, g);
    }

    public void paintBackground(JTree tree, Graphics g) {
    }

    public Node getNodeForValue(Object value) {
        if (value instanceof Node) {
            return (Node)value;
        }
        return null;
    }

    public DomPosition getNearestSiblingPosition(Component component, Node nearNode, int y) {
        Rectangle nodeBounds = this._getNodeBounds(component, nearNode);
        if (nodeBounds == null) {
            return null;
        }
        if (nearNode.getNodeType() == 9) {
            return null;
        }
        int middleY = nodeBounds.y + nodeBounds.height / 2;
        if (y < middleY) {
            return DomPositionFactory.before((Node)nearNode);
        }
        return DomPositionFactory.after((Node)nearNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle(Object value) {
        if (value instanceof Node) {
            XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
            this.getView().acquireReadLock();
            try {
                String string = resolver.getMediumDisplayName((Node)value);
                return string;
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
        if (value instanceof Issue) {
            return ((Issue)value).getMessage();
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(Object value) {
        if (value instanceof Node) {
            XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
            this.getView().acquireReadLock();
            try {
                Icon icon = resolver.getSmallIcon((Node)value);
                return icon;
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
        if (value instanceof Issue) {
            return ((Issue)value).getSeverity().getIcon();
        }
        if (value instanceof XmlTreeModel.ErrorsFolder) {
            return this._getErrorsFolderIcon(((XmlTreeModel.ErrorsFolder)value).isWarningsMode());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTooltip(Object value) {
        if (value instanceof Node) {
            XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
            this.getView().acquireReadLock();
            try {
                String string = resolver.getLongDisplayName((Node)value);
                return string;
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
        if (value instanceof Issue) {
            return ((Issue)value).getMessage();
        }
        return null;
    }

    protected final Set getLeadSelectionNodes() {
        int numTrees = this._trees.size();
        if (numTrees == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < this._trees.size(); ++i) {
            TreePath path = ((JTree)this._trees.get(i)).getLeadSelectionPath();
            if (path == null) continue;
            set.add(path.getLastPathComponent());
        }
        return set;
    }

    protected JTree createJTree() {
        return new XmlJTree(this);
    }

    protected TreeCellRenderer createTreeCellRenderer(JTree tree) {
        TreeCellRenderer baseRenderer = tree.getCellRenderer();
        if (!(baseRenderer instanceof JLabel)) {
            baseRenderer = new DefaultTreeCellRenderer();
        }
        return new XmlTreeCellRenderer(this, baseRenderer);
    }

    protected void handleModelChangeEventImpl(XmlModelEvent event) {
        XmlJTree tree;
        int i;
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Explorer GUI called off the event thread!\ngui=" + this + "\n" + "event=" + event);
        }
        Boolean validityChangedValue = null;
        PropertyChange validityChange = event.getDomDocumentValidPropertyChange();
        if (validityChange != null) {
            validityChangedValue = (Boolean)validityChange.getNewValue();
        }
        TreePath oldErrorFolderPath = this.getTreeModel().getErrorsFolderTreePathIfVisible();
        int treeCount = this._trees.size();
        SavedExpansionState[] savedExpansion = new SavedExpansionState[treeCount];
        Rectangle[] oldScroll = new Rectangle[treeCount];
        for (i = 0; i < treeCount; ++i) {
            tree = (XmlJTree)this._trees.get(i);
            savedExpansion[i] = SavedExpansionState.saveState(this, tree);
            oldScroll[i] = this.shouldRestoreOldScrollPosition(event) ? tree.getVisibleRect() : null;
            this._setWasErrorsFolderExpanded(tree, oldErrorFolderPath);
        }
        this._ignoreLeadSelectionPathChange = true;
        for (i = 0; i < treeCount; ++i) {
            Node node;
            Object lastComp;
            tree = (XmlJTree)this._trees.get(i);
            TreePath path = tree.getLeadSelectionPath();
            if (path == null || !((lastComp = path.getLastPathComponent()) instanceof Node) || (node = this.getTreeModel().pathToSourceDom(path)) != null && this.getView().isInModelDocumentHierarchy(node)) continue;
            this.addNodeToEvade((Node)lastComp);
            tree.setLeadSelectionPath(null);
        }
        super.handleModelChangeEventImpl(event);
        this._ignoreLeadSelectionPathChange = false;
        boolean shouldScrollToPaths = this.shouldScrollNewlySelectedPathsToVisible(event);
        List scrollToPaths = shouldScrollToPaths ? this._getNewlySelectedPaths(event) : Collections.EMPTY_LIST;
        TreePath newErrorFolderPath = this.getTreeModel().getErrorsFolderTreePathIfVisible();
        for (int j = 0; j < treeCount; ++j) {
            XmlJTree tree2 = (XmlJTree)this._trees.get(j);
            if (validityChangedValue != null) {
                this._setEnabledStatus(tree2, validityChangedValue);
            }
            savedExpansion[j].restore();
            if (newErrorFolderPath != null && this._wasErrorsFolderExpanded(tree2)) {
                tree2.expandPath(newErrorFolderPath);
            }
            if (oldScroll[j] != null) {
                tree2.scrollRectToVisible(oldScroll[j]);
            }
            if (!scrollToPaths.isEmpty()) {
                this._scrollPathsToVisible(scrollToPaths, tree2);
            }
            this._handleDropAndCursorChange(event, tree2, shouldScrollToPaths);
            if (event.isDomTreeChanged()) {
                tree2.invalidate();
            }
            tree2.repaint();
        }
    }

    protected void showPopupMenu(MouseEvent me, TreePath clickedPath) {
        if (clickedPath != null) {
            if (this.getTreeModel().pathToSourceDom(clickedPath) != null) {
                ContextMenuListener cml = new ContextMenuListener((Component)me.getSource(), (XmlGui)this);
                cml.mouseReleased(me);
            } else {
                Issue issue;
                Object last = clickedPath.getLastPathComponent();
                if (last instanceof Issue && (issue = (Issue)ModelUtil.as((Object)last, Issue.class)).hasTransforms() && me.isPopupTrigger()) {
                    JPopupMenu issueTransformsMenu = new JPopupMenu();
                    for (Action action : issue.getTransforms()) {
                        issueTransformsMenu.add(UIUtils.createMenuItem(action));
                    }
                    issueTransformsMenu.show((Component)me.getSource(), me.getX() + 3, me.getY() + 3);
                }
            }
        }
    }

    protected boolean invokeDefaultAction(InputEvent e, TreePath eventPath) {
        return false;
    }

    protected Action translateViewAction(Action viewAction) {
        if (viewAction != null && "copy".equals(viewAction.getValue("ActionCommandKey"))) {
            return new CopyActionProxy(viewAction);
        }
        return super.translateViewAction(viewAction);
    }

    protected boolean shouldRestoreOldScrollPosition(XmlModelEvent event) {
        return true;
    }

    protected boolean shouldScrollNewlySelectedPathsToVisible(XmlModelEvent event) {
        return event.getDomDocumentPropertyChange() == null;
    }

    protected boolean shouldUseLargeModel() {
        return true;
    }

    TreeHelper __getHelper() {
        return this._treeHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setupTree(JTree tree) {
        TreeCellRenderer cellRenderer = this.createTreeCellRenderer(tree);
        tree.setCellRenderer(cellRenderer);
        Component bogus = cellRenderer.getTreeCellRendererComponent(tree, "bogus", false, false, true, 0, false);
        bogus.setFont(tree.getFont());
        int rendererHeight = bogus.getPreferredSize().height;
        int uiHeight = UIManager.getInt("Tree.rowHeight");
        tree.setRowHeight(Math.max(rendererHeight, uiHeight));
        tree.setLargeModel(this.shouldUseLargeModel());
        this.getView().acquireReadLock();
        try {
            tree.setModel((TreeModel)this.getTreeModel());
        }
        finally {
            this.getView().releaseReadLock();
        }
        tree.setExpandsSelectedPaths(true);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setSelectionModel(this.createTreeSelectionModel());
        tree.setToggleClickCount(-1);
        tree.addPropertyChangeListener(this._treePropertyChangeListener);
        ExplorerDropHandler edh = new ExplorerDropHandler(this._treeHelper);
        tree.putClientProperty(_DROP_HANDLER_PROPERTY, edh);
        tree.setDropTarget(new DropTarget(tree, 3, edh, true));
        ActionUtils.addInputMappings(tree, _EXPLORER_COMMANDS, (XmlGui)this);
        TreePath[] selectedPaths = tree.getSelectionModel().getSelectionPaths();
        if (selectedPaths != null) {
            for (int i = 0; i < selectedPaths.length; ++i) {
                tree.expandPath(selectedPaths[i].getParentPath());
            }
        }
        this.getView().acquireReadLock();
        try {
            TreeTraversal traversal = this.getView().getTreeTraversal();
            Document doc = this.getView().getDocument();
            if (doc != null) {
                XmlTreeModel model = this.getTreeModel();
                Node child = traversal.getFirstChild((Node)doc);
                while (child != null) {
                    tree.expandPath(model.getPathForDomElement(child));
                    child = traversal.getNextSibling(child);
                }
            }
        }
        finally {
            this.getView().releaseReadLock();
        }
        this._trees.add(tree);
        this._setEnabledStatus(tree, this.getView().getBaseModel().isDocumentValid());
    }

    private void _setEnabledStatus(JTree tree, boolean modelValidity) {
        boolean newEnabled = modelValidity || !this.getView().requiresValidModel();
        Logger log = this.getLogger();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Set tree enabled status from {0} to {1}", new Object[]{String.valueOf(tree.isEnabled()), String.valueOf(newEnabled)});
        }
        tree.setEnabled(newEnabled);
    }

    private Rectangle _getNodeBounds(Component component, Node node) {
        TreePath nodePath = this.getTreeModel().getPathForDomElement(node);
        return ((JTree)component).getPathBounds(nodePath);
    }

    private List _getNewlySelectedPaths(XmlModelEvent event) {
        ArrayList<TreePath> ret;
        Set addedSelectionNodes = event.getSelectionsAdded();
        if (addedSelectionNodes.isEmpty()) {
            ret = Collections.EMPTY_LIST;
        } else {
            ret = new ArrayList<TreePath>(addedSelectionNodes.size());
            for (Node node : addedSelectionNodes) {
                TreePath path = this.getTreeModel().getPathForDomElement(node);
                if (path == null) continue;
                ret.add(path);
            }
        }
        return ret;
    }

    private void _scrollPathsToVisible(List pathList, JTree tree) {
        Rectangle union = null;
        int count = 0;
        Iterator itor = pathList.iterator();
        while (itor.hasNext() && ++count < 5) {
            TreePath path = (TreePath)itor.next();
            Rectangle one = tree.getPathBounds(path);
            if (union == null) {
                union = one;
                continue;
            }
            union = union.union(one);
        }
        if (union != null) {
            tree.scrollRectToVisible(union);
        }
    }

    private void _handleDropAndCursorChange(XmlModelEvent event, JTree tree, boolean shouldScrollToPaths) {
        if (event.isPropertyChanged()) {
            Selection selection = this.getView().getSelection();
            PropertyChange dropChange = null;
            if (this.getGuiContext().getDropTargetGui() == this) {
                dropChange = event.getDropLocationPropertyChange();
            }
            PropertyChange cursorChange = event.getCursorLocationPropertyChange();
            if (dropChange != null || cursorChange != null) {
                TreePath path;
                DomPosition currentDropLocation;
                if (cursorChange != null) {
                    TreePath newLeadSelection = null;
                    DomPosition currentCursorLocation = selection.getCursorLocation();
                    if (currentCursorLocation != null) {
                        newLeadSelection = this.getTreeModel().getPathForDomElement(currentCursorLocation.getTargetNode());
                    }
                    TreePath currLeadSelectionPath = tree.getLeadSelectionPath();
                    if (!this._ignoreXmlCursorChange && newLeadSelection != null && newLeadSelection != currLeadSelectionPath) {
                        this._ignoreLeadSelectionPathChange = true;
                        tree.setLeadSelectionPath(newLeadSelection);
                        this._ignoreLeadSelectionPathChange = false;
                        if (newLeadSelection != null) {
                            tree.expandPath(newLeadSelection.getParentPath());
                            if (shouldScrollToPaths) {
                                tree.scrollPathToVisible(newLeadSelection);
                            }
                        }
                    }
                }
                if (dropChange != null && (currentDropLocation = selection.getDropLocation()) != null && (path = this.getTreeModel().getPathForDomElement(currentDropLocation.getTargetNode())) != null) {
                    tree.expandPath(path.getParentPath());
                    if (shouldScrollToPaths) {
                        tree.scrollPathToVisible(path);
                    }
                }
            }
        }
    }

    private Icon _getIcon(String[] keys, Icon[] icons, int idx) {
        if (icons[idx] == null) {
            Image image = ImageUtils.getImageResource(this.getClass(), (String)keys[idx]);
            icons[idx] = new ImageIcon(image);
        }
        return icons[idx];
    }

    private Icon _getErrorsFolderIcon(boolean isWarningsMode) {
        int idx = 0;
        return this._getIcon(_FOLDER_ICON_KEYS, _FOLDER_ICONS, idx);
    }

    private boolean _wasErrorsFolderExpanded(XmlJTree tree) {
        Object obj = tree.getClientProperty(_WAS_ERROR_FOLDER_EXPANDED_KEY);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    private void _setWasErrorsFolderExpanded(XmlJTree tree, TreePath folderPath) {
        if (folderPath != null) {
            boolean val = tree.isExpanded(folderPath);
            tree.putClientProperty(_WAS_ERROR_FOLDER_EXPANDED_KEY, val);
        }
    }

    private JTree _getSingleOrFocusedJTree() {
        int numTrees = this._trees.size();
        if (numTrees == 1) {
            return (JTree)this._trees.get(0);
        }
        if (numTrees > 1) {
            for (int i = 0; i < numTrees; ++i) {
                JTree tree = (JTree)this._trees.get(i);
                if (!tree.hasFocus()) continue;
                return tree;
            }
        }
        return null;
    }

    private class CopyActionProxy
    extends XmlGui.GuiActionProxy {
        public CopyActionProxy(Action base) {
            super((XmlGui)SwingExplorerGui.this, base);
        }

        public boolean isEnabled() {
            if (super.isEnabled()) {
                return true;
            }
            return this._getPathsIfAllErrors() != null;
        }

        public void actionPerformed(ActionEvent event) {
            if (this.isEnabled()) {
                TreePath[] paths = this._getPathsIfAllErrors();
                if (paths == null) {
                    super.actionPerformed(event);
                } else {
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < paths.length; ++i) {
                        if (i > 0) {
                            buf.append('\n');
                        }
                        Issue issue = (Issue)paths[i].getLastPathComponent();
                        buf.append(issue.getMessage());
                    }
                    AugmentableTransferable trans = TransferUtils.createTransferable();
                    trans.augment(DataFlavor.stringFlavor, (Object)buf.toString(), 1.0f, null);
                    SwingExplorerGui.this.getGuiContext().getClipboardManager().setContents((Transferable)trans);
                }
            }
        }

        private TreePath[] _getPathsIfAllErrors() {
            TreePath[] paths;
            JTree tree = SwingExplorerGui.this._getSingleOrFocusedJTree();
            if (tree != null && (paths = tree.getSelectionPaths()) != null && paths.length > 0) {
                for (int i = 0; i < paths.length; ++i) {
                    if (paths[i].getLastPathComponent() instanceof XmlModelMessage) continue;
                    return null;
                }
                return paths;
            }
            return null;
        }
    }

    private class TreePropChangeListener
    implements PropertyChangeListener {
        private TreePropChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!SwingExplorerGui.this._ignoreLeadSelectionPathChange && "leadSelectionPath".equals(e.getPropertyName())) {
                JTree tree = (JTree)e.getSource();
                SwingExplorerGui.this._treeHelper.handleLeadSelectionRowChanged(tree, tree.getLeadSelectionRow());
            }
        }
    }
}

