/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.creator;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import org.w3c.dom.Node;

public abstract class XmlElementCreator
extends PropertyEditorSupport
implements NodeCreator,
NodeCustomizer,
ContextualPropertyEditor {
    private Node _node;
    private XmlContext _context;
    private XmlKey _key;
    private DomPosition _position;
    private Component _component;
    private String _helpTopic;

    public Node createNode(XmlContext context, XmlKey key, DomPosition position, Node prototypeNode) {
        this._context = context;
        this._key = key;
        this._position = position;
        this._node = null;
        JEWTDialog d = this._createDialog(true);
        boolean ok = d.runDialog();
        Node n = null;
        if (ok) {
            this._node = this.createNode(key, prototypeNode);
            this.updateNode();
            n = this.getNode();
        }
        d.dispose();
        this._dispose();
        return n;
    }

    public boolean customizeNode(XmlContext context, Node n, XmlKey key) {
        this._node = n;
        this._context = context;
        this._key = key;
        this._position = null;
        JEWTDialog d = this._createDialog(false);
        boolean ok = false;
        if (d.runDialog()) {
            this.updateNode();
            ok = true;
        }
        d.dispose();
        this._dispose();
        return ok;
    }

    public boolean isNodeCustomizable(XmlContext context, Node n, XmlKey key) {
        return true;
    }

    public void clearContext() {
        this._setContext(null, null, null, null);
    }

    public void setContext(PropertyEditorContext context) {
        this._setContext(context.getXmlContext(), context.getKey(), context.getNode(), context.getOwnerNode());
    }

    private void _setContext(XmlContext context, XmlKey key, Node node, Node ownerNode) {
        this._context = context;
        this._key = key;
        this._node = node;
        this._component = null;
        this._position = null;
    }

    public void setHelpTopic(String topic) {
        this._helpTopic = topic;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this._component == null && this._context != null) {
            this._component = this.createCustomEditor();
        }
        return this._component;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    protected abstract Component createContent(boolean var1);

    protected abstract String getTitle(XmlKey var1);

    protected abstract Node createNode(XmlKey var1, Node var2);

    protected abstract void updateNode();

    protected Component createCustomEditor() {
        return this.createContent(false);
    }

    protected void dialogClosing(PropertyChangeEvent e) throws PropertyVetoException {
    }

    protected String getHelpTopic() {
        return this._helpTopic;
    }

    protected Node getNode() {
        return this._node;
    }

    protected XmlContext getContext() {
        return this._context;
    }

    protected XmlKey getXmlKey() {
        return this._key;
    }

    protected DomPosition getDomPosition() {
        return this._position;
    }

    protected Frame getParentFrame() {
        Frame f;
        SwingXmlContext sxc;
        Component c;
        if (this.getContext() instanceof SwingXmlContext && (c = (sxc = (SwingXmlContext)this.getContext()).getRootDocumentUIComponent()) != null && (f = WindowUtils.parentFrame((Component)c)) != null) {
            return f;
        }
        return new JFrame();
    }

    private void _dispose() {
        this.clearContext();
    }

    private JEWTDialog _createDialog(boolean create) {
        Component content = this.createContent(create);
        String helpTopic = this.getHelpTopic();
        int mask = 3;
        if (helpTopic != null) {
            mask |= 4;
            HelpUtils.setHelpID((JComponent)((JComponent)content), (String)helpTopic);
        }
        String titleFormatKey = create ? "XML_CREATOR_CREATE_FORMAT_KEY" : "XML_CREATOR_EDIT_FORMAT_KEY";
        String titleFormat = this.getContext().getTranslatedString(titleFormatKey);
        String title = FastMessageFormat.formatMessage((String)titleFormat, (String)this.getTitle(this._key));
        JEWTDialog d = JEWTDialog.createDialog((Component)this.getParentFrame(), (String)title, (int)mask);
        d.setContent(content);
        d.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                if ("closed".equals(e.getPropertyName()) && Boolean.TRUE.equals(e.getNewValue())) {
                    try {
                        XmlElementCreator.this.dialogClosing(e);
                    }
                    catch (PropertyVetoException pve) {
                        XmlElementCreator.this.getContext().showErrorMessage(pve.getLocalizedMessage());
                        throw pve;
                    }
                }
            }
        });
        return d;
    }
}

