/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.ceditor.folding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelEvent;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.FilteredTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.swing.ceditor.SwingXmlCodeEditorGui;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlCodeFoldingModel
implements CodeFoldingModel {
    private final LinkedHashSet<Node> _collapsedNodes = new LinkedHashSet(16);
    private final Map<Node, int[]> _collapsedNodeFormerOffsets = new HashMap<Node, int[]>(16);
    private final List<CodeFoldingModelListener> _listeners = new CopyOnWriteArrayList<CodeFoldingModelListener>();
    private final Map<Node, Boolean> _isBlockCache = new HashMap<Node, Boolean>();
    private final Map<Node, String> _abbrevTextCache = new HashMap<Node, String>();
    private final int[] _TEMP_TEXTOFFSET_RESULTS = new int[2];
    private final DomModel _domModel;
    private final SwingXmlCodeEditorGui _gui;
    private final BasicDocument _basicDocument;
    private final TreeTraversal _traversal = new Traversal();
    private final List<int[]> _offsetAdjustments = new ArrayList<int[]>();
    private static final int _MAX_TOOLTIP_LENGTH = 100;
    private static final int _MAX_ABBREV_LENGTH = 45;
    private static final String _ABBREV_INBETWEEN_TEXT = " ... ";
    private static final Iterator _EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private static final Logger _LOGGER = Logger.getLogger(XmlCodeFoldingModel.class.getName());

    public XmlCodeFoldingModel(SwingXmlCodeEditorGui gui, BasicDocument document) {
        this._gui = gui;
        this._basicDocument = document;
        XmlView view = this._gui.getView();
        this._domModel = view.getDomModel();
        view.addModelListener((XmlModelListener)new ModelListener());
        this._domModel.addDomChangeListener((DomModelListener)new DomListener());
    }

    public void readLock() {
        this._lock();
    }

    public void readUnlock() {
        this._unlock();
    }

    public Object getRoot() {
        return this._domModel.getDocument();
    }

    public Iterator getChildren(Object block) {
        Node node = this._requireNodeParam(block);
        if (node == null) {
            return _EMPTY_ITERATOR;
        }
        Node child = this._traversal.getFirstChild(node);
        if (child == null) {
            return _EMPTY_ITERATOR;
        }
        LinkedList<Node> children = new LinkedList<Node>();
        do {
            children.add(child);
        } while ((child = this._traversal.getNextSibling(child)) != null);
        return children.iterator();
    }

    public Object getParent(Object block) {
        Node node = this._requireNodeParam(block);
        if (node == null) {
            return null;
        }
        return this._traversal.getParentNode(node);
    }

    public synchronized boolean isExpanded(Object block) {
        return !this._collapsedNodes.contains(block);
    }

    public synchronized void setExpanded(Object block, boolean isExpanded) {
        Node node = this._requireNodeParam(block);
        if (node == null) {
            return;
        }
        if (isExpanded) {
            this._collapsedNodes.remove(node);
            _LOGGER.log(Level.FINER, "expanded: {0}", node);
        } else {
            this._collapsedNodes.add(node);
            _LOGGER.log(Level.FINER, "collapsed: {0}", node);
        }
    }

    public int[] getTextOffsets(Object block, int[] offsets) {
        Node node;
        if (offsets == null) {
            offsets = new int[2];
        }
        if ((node = this._requireNodeParam(block)) == null) {
            offsets[1] = -1;
            offsets[0] = -1;
        } else {
            this._getTextOffsets(node, offsets);
        }
        return offsets;
    }

    public Object getSmallestEnclosingBlock(int offset) {
        Node node = this._domModel.getNodeAtOffset(offset);
        if (node == null) {
            return this._domModel.getDocument();
        }
        while (!this._isNodeAFoldingBlock(node)) {
            node = DocumentTreeTraversal.INSTANCE.getPreviousNode(node);
        }
        if (!DomUtils.isDocument((Node)node) && this._getStartOffsetDirectly(node) == offset) {
            node = this._traversal.getParentNode(node);
        }
        return node;
    }

    public Object getFirstBlockAtLine(int line) {
        int lineStart = this._basicDocument.getLineStartOffset(line);
        int lineEnd = this._basicDocument.getLineEndOffset(line);
        Node node = this._domModel.getNodeAtOffset(lineStart);
        if (node == null) {
            return null;
        }
        if (this._isNodeAFoldingBlock(node) && this._getStartOffsetDirectly(node) == lineStart) {
            return node;
        }
        node = this._traversal.getNextNode(node);
        while (node != null) {
            int nextStart = this._getStartOffsetDirectly(node);
            if (nextStart >= lineEnd) {
                return null;
            }
            if (nextStart >= lineStart) {
                return node;
            }
            node = this._traversal.getNextNode(node);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getCollapsedBlocks() {
        LinkedHashSet<Node> linkedHashSet = this._collapsedNodes;
        synchronized (linkedHashSet) {
            Collection rationalized = DomUtils.rationalizeCollectionOfNodes((TreeTraversal)DocumentTreeTraversal.INSTANCE, this._collapsedNodes);
            return rationalized.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(Object block) {
        Node node = this._requireNodeParam(block);
        if (node == null) {
            return null;
        }
        int[] nArray = this._TEMP_TEXTOFFSET_RESULTS;
        synchronized (this._TEMP_TEXTOFFSET_RESULTS) {
            this._getTextOffsets(node, this._TEMP_TEXTOFFSET_RESULTS);
            int start = this._TEMP_TEXTOFFSET_RESULTS[0];
            int end = this._TEMP_TEXTOFFSET_RESULTS[1];
            // ** MonitorExit[var5_3] (shouldn't be in output)
            int length = Math.min(end - start, 100);
            return this._getText(start, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAbbreviatedText(Object block) {
        Node node = this._requireNodeParam(block);
        if (node == null) {
            return null;
        }
        String cached = this._abbrevTextCache.get(block);
        if (cached != null) {
            return cached;
        }
        int[] nArray = this._TEMP_TEXTOFFSET_RESULTS;
        synchronized (this._TEMP_TEXTOFFSET_RESULTS) {
            String ret;
            this._getTextOffsets(node, this._TEMP_TEXTOFFSET_RESULTS);
            int start = this._TEMP_TEXTOFFSET_RESULTS[0];
            int end = this._TEMP_TEXTOFFSET_RESULTS[1];
            // ** MonitorExit[var6_4] (shouldn't be in output)
            int length = end - start;
            String text = this._getText(start, length);
            text = text.replaceAll("\\s+", " ");
            int totalLength = text.length();
            if (totalLength <= 45) {
                ret = text;
            } else {
                int eachSideLength = (45 - _ABBREV_INBETWEEN_TEXT.length()) / 2;
                StringBuffer buf = new StringBuffer(45);
                buf.append(text.substring(0, eachSideLength));
                buf.append(_ABBREV_INBETWEEN_TEXT);
                buf.append(text.substring(totalLength - eachSideLength, totalLength));
                ret = buf.toString();
            }
            this._abbrevTextCache.put(node, ret);
            return ret;
        }
    }

    public void addCodeFoldingModelListener(CodeFoldingModelListener listener) {
        this._listeners.add(listener);
    }

    public void removeCodeFoldingModelListener(CodeFoldingModelListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __preNotify(DocumentEvent event) {
        if (this._domModel.needsReparse()) {
            long before = System.currentTimeMillis();
            int length = event.getLength();
            if (length > 0) {
                int[] adj = new int[]{event.getOffset(), event.getType() == DocumentEvent.EventType.INSERT ? length : (event.getType() == DocumentEvent.EventType.REMOVE ? -length : 0)};
                if (adj[1] != 0) {
                    XmlCodeFoldingModel xmlCodeFoldingModel = this;
                    synchronized (xmlCodeFoldingModel) {
                        this._offsetAdjustments.add(adj);
                    }
                }
                long after = System.currentTimeMillis();
                if (_LOGGER.isLoggable(Level.FINER)) {
                    _LOGGER.log(Level.FINER, "__preNotify: @{0}, #{1}; {2}ms", new Object[]{String.valueOf(adj[0]), String.valueOf(adj[1]), String.valueOf(after - before)});
                }
            }
        }
    }

    private Node _requireNodeParam(Object block) {
        if (block instanceof Node) {
            return (Node)block;
        }
        _LOGGER.log(Level.WARNING, "called with non-Node block: {0}", block);
        return null;
    }

    private synchronized void _aboutToReparse() {
        long before = System.currentTimeMillis();
        this._collapsedNodeFormerOffsets.clear();
        for (Node node : this._collapsedNodes) {
            int[] formers = new int[2];
            this._domModel.getTextOffsets(node, formers);
            if (formers[0] < 0 || formers[1] < 0) continue;
            this._collapsedNodeFormerOffsets.put(node, formers);
        }
        long after = System.currentTimeMillis();
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "_aboutToReparse: {0} ms", String.valueOf(after - before));
        }
    }

    private void _getTextOffsets(Node node, int[] offsets) {
        if (DomUtils.isDocument((Node)node)) {
            offsets[0] = 0;
            offsets[1] = this._basicDocument.getLength();
        } else {
            this._domModel.getTextOffsets(node, offsets);
            this._adjustOffsets(offsets);
        }
    }

    private void _adjustOffsets(int[] offsets) {
        offsets[0] = this._adjustOffset(offsets[0]);
        offsets[1] = this._adjustOffset(offsets[1]);
    }

    private int _getStartOffsetDirectly(Node node) {
        if (DomUtils.isDocument((Node)node)) {
            return 0;
        }
        return this._adjustOffset(this._domModel.getTextOffset(DomPositionFactory.before((Node)node)));
    }

    private String _getText(int start, int length) {
        try {
            int docLength = this._basicDocument.getLength();
            start = Math.min(start, docLength);
            if (start + length > docLength) {
                length = docLength - start;
            }
            return this._basicDocument.getText(start, length);
        }
        catch (BadLocationException ble) {
            _LOGGER.log(Level.SEVERE, "exception tooltip text", ble);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _spansMultipleLines(Node node) {
        int[] nArray = this._TEMP_TEXTOFFSET_RESULTS;
        synchronized (this._TEMP_TEXTOFFSET_RESULTS) {
            this._domModel.getTextOffsets(node, this._TEMP_TEXTOFFSET_RESULTS);
            int start = this._TEMP_TEXTOFFSET_RESULTS[0];
            int end = this._TEMP_TEXTOFFSET_RESULTS[1];
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (start < 0 || end < 0) {
                return false;
            }
            return this._getLine(start) < this._getLine(end);
        }
    }

    private int _getLine(int offset) {
        return this._basicDocument.getLineFromOffset(offset);
    }

    private void _lock() {
        this._domModel.acquireStaleDataLock();
    }

    private void _unlock() {
        this._domModel.releaseStaleDataLock();
    }

    private List<Node> _add(List<Node> in, Node o) {
        if (in == null) {
            in = new LinkedList<Node>();
        }
        in.add(o);
        return in;
    }

    private boolean _isNodeAFoldingBlock(Node node) {
        Boolean cached = this._isBlockCache.get(node);
        if (cached != null) {
            return cached;
        }
        boolean isBlock = DomUtils.isDocument((Node)node) || this._spansMultipleLines(node);
        this._isBlockCache.put(node, isBlock);
        return isBlock;
    }

    private synchronized int _adjustOffset(int origOffset) {
        int offset = origOffset;
        for (int[] adj : this._offsetAdjustments) {
            int adjOffset = adj[0];
            int adjDelta = adj[1];
            if (offset < adjOffset) continue;
            if (adjDelta < 0 && adjOffset + -adjDelta > offset) {
                offset = adjOffset;
                continue;
            }
            offset += adj[1];
        }
        return offset;
    }

    private boolean _areNodesSimilar(Node a, Node b) {
        return a != null && b != null && a.getNodeType() == b.getNodeType() && DomUtils.isSameName((Node)a, (Node)b);
    }

    private synchronized Node _remapNode(Node oldNode, Document newDoc) {
        if (DomUtils.isDocument((Node)oldNode)) {
            return newDoc;
        }
        int[] oldOffsets = this._collapsedNodeFormerOffsets.get(oldNode);
        if (oldOffsets == null) {
            return null;
        }
        int adjustedStart = this._adjustOffset(oldOffsets[0]);
        int adjustedEnd = this._adjustOffset(oldOffsets[1]);
        if (oldOffsets[1] - oldOffsets[0] != adjustedEnd - adjustedStart) {
            return null;
        }
        if (adjustedEnd <= adjustedStart) {
            return null;
        }
        if (adjustedStart > this._basicDocument.getLength()) {
            return null;
        }
        Node atOffset = this._domModel.getNodeAtOffset(adjustedStart);
        if (this._areNodesSimilar(oldNode, atOffset) && this._isNodeAFoldingBlock(atOffset)) {
            return atOffset;
        }
        return null;
    }

    private class Traversal
    extends FilteredTreeTraversal {
        private Traversal() {
        }

        protected short acceptNode(Node node) {
            if (XmlCodeFoldingModel.this._isNodeAFoldingBlock(node)) {
                return 1;
            }
            return 2;
        }
    }

    private class DomListener
    implements DomModelListener {
        private DomListener() {
        }

        public void modelChanged(DomModelEvent event) {
            if (event.containsPropertyChange("textBufferModified")) {
                XmlCodeFoldingModel.this._aboutToReparse();
            }
        }
    }

    private class ModelListener
    extends XmlModelAdapter {
        private ModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(XmlModelEvent event) {
            Object node;
            if (!event.isDomTreeChanged()) {
                return;
            }
            XmlCodeFoldingModel.this._isBlockCache.clear();
            XmlCodeFoldingModel.this._abbrevTextCache.clear();
            AbstractModel model = event.getModel();
            Node changeRoot = event.getChangeRoot();
            List toAdd = null;
            Iterator collapsed = XmlCodeFoldingModel.this._collapsedNodes.iterator();
            while (collapsed.hasNext()) {
                node = (Node)collapsed.next();
                if (model.isInModelDocumentHierarchy(node)) continue;
                collapsed.remove();
                Node remapped = XmlCodeFoldingModel.this._remapNode(node, XmlCodeFoldingModel.this._domModel.getDocument());
                if (remapped == null) continue;
                toAdd = XmlCodeFoldingModel.this._add(toAdd, remapped);
            }
            if (toAdd != null) {
                XmlCodeFoldingModel.this._collapsedNodes.addAll(toAdd);
            }
            node = this;
            synchronized (node) {
                XmlCodeFoldingModel.this._offsetAdjustments.clear();
            }
            if (!XmlCodeFoldingModel.this._listeners.isEmpty()) {
                CodeFoldingModelEvent cfEvent = new CodeFoldingModelEvent((CodeFoldingModel)XmlCodeFoldingModel.this, (Object)changeRoot);
                for (CodeFoldingModelListener listener : XmlCodeFoldingModel.this._listeners) {
                    listener.structureChanged(cfEvent);
                }
            }
        }
    }
}

