/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.xml.gui.base.BaseStatusBarGui;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.PropertyChange;

public class SwingStatusBarGui
extends BaseStatusBarGui
implements ComponentXmlGui {
    private boolean _showNormalStatus = true;
    private final JLabel _errorCell = new JLabel();
    private final JLabel _feedbackCell = new JLabel();
    private final JLabel _selectionCell = new JLabel();
    private final JPanel _panel = new JPanel(new BorderLayout());
    private final StatusBar _statusBar = new StatusBar(2);
    private final StatusBar _errorBar = new StatusBar(1);

    public SwingStatusBarGui(XmlView view) {
        super(view);
        this._createPanel(null);
        this.updateFeedbackText(false);
        this.updateSelectionText(false);
    }

    public Component getComponent() {
        return this._panel;
    }

    protected void updateSelectionText(boolean remapSelection) {
        this._selectionCell.setText(this.getSelectionText(remapSelection));
    }

    protected void updateFeedbackText(boolean remapSelection) {
        String txt = this.getFeedbackText(remapSelection);
        this._feedbackCell.setText(txt);
        this._errorCell.setText(txt);
    }

    protected void updateInsertionPositionText() {
        this._feedbackCell.setText(this.getInsertionPositionText());
    }

    protected JComponent getFeedbackCell() {
        return this._feedbackCell;
    }

    protected JComponent getSelectionCell() {
        return this._selectionCell;
    }

    private void _createPanel(Font font) {
        this._selectionCell.setMinimumSize(new Dimension(400, 10));
        this._selectionCell.setHorizontalAlignment(2);
        this._feedbackCell.setMinimumSize(new Dimension(400, 10));
        if (font != null) {
            this._feedbackCell.setFont(font);
            this._selectionCell.setFont(font);
        }
        this._statusBar.add((Component)this._feedbackCell);
        this._statusBar.add((Component)this._selectionCell);
        this._errorBar.add((Component)this._errorCell);
        this._showNormalStatus = this.getView().getBaseModel().isDocumentValid();
        this._restoreComponents();
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        boolean isValid;
        PropertyChange validityChange;
        if (event.isPropertyChanged() && (validityChange = event.getDomDocumentValidPropertyChange()) != null && (isValid = validityChange.getNewBooleanValue()) != this._showNormalStatus) {
            this._showNormalStatus = isValid;
            this._restoreComponents();
        }
        super.handleModelChangeEvent(event);
    }

    private void _restoreComponents() {
        this._panel.removeAll();
        if (this._showNormalStatus) {
            this._panel.add((Component)this._statusBar, "Center");
        } else {
            this._panel.add((Component)this._errorBar, "Center");
        }
        this._panel.revalidate();
    }
}

